/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Bin8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 8;
    private static final long defaultValue = 0L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 8;
    }

    public Object getDefaultValue() {
        return new Long(0L);
    }

    public int getInstanceType() {
        return 3;
    }

    public Class getJavaType() {
        return Long.class;
    }

    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[8];
        BinaryConverter.longToByteArray((Long)javaValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(long longValue) {
        byte[] as400Value = new byte[8];
        BinaryConverter.longToByteArray(longValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        BinaryConverter.longToByteArray((Long)javaValue, as400Value, 0);
        return 8;
    }

    public int toBytes(long longValue, byte[] as400Value) {
        BinaryConverter.longToByteArray(longValue, as400Value, 0);
        return 8;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BinaryConverter.longToByteArray((Long)javaValue, as400Value, offset);
        return 8;
    }

    public int toBytes(long longValue, byte[] as400Value, int offset) {
        BinaryConverter.longToByteArray(longValue, as400Value, offset);
        return 8;
    }

    public long toLong(byte[] as400Value) {
        return BinaryConverter.byteArrayToLong(as400Value, 0);
    }

    public long toLong(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToLong(as400Value, offset);
    }

    public Object toObject(byte[] as400Value) {
        return new Long(BinaryConverter.byteArrayToLong(as400Value, 0));
    }

    public Object toObject(byte[] as400Value, int offset) {
        return new Long(BinaryConverter.byteArrayToLong(as400Value, offset));
    }
}

