/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClobOutputStream;
import com.ibm.as400.access.AS400JDBCWriter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class AS400JDBCClob
implements Clob,
Serializable {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    protected char[] data_;
    protected int maxLength_;
    static final int MAX_LOB_SIZE = Integer.MAX_VALUE;
    private boolean isXML_ = false;

    AS400JDBCClob(String data, int maxLength) {
        this.data_ = data.toCharArray();
        this.maxLength_ = maxLength;
    }

    AS400JDBCClob(String data) {
        this.data_ = data.toCharArray();
        this.maxLength_ = Integer.MAX_VALUE;
    }

    AS400JDBCClob(char[] data) {
        this.data_ = data;
        this.maxLength_ = Integer.MAX_VALUE;
    }

    AS400JDBCClob(String data, int maxLength, boolean isXML) {
        this.data_ = data.toCharArray();
        this.maxLength_ = maxLength;
        this.isXML_ = isXML;
    }

    AS400JDBCClob(char[] data, boolean isXML) {
        this.data_ = data;
        this.isXML_ = isXML;
    }

    public synchronized InputStream getAsciiStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        try {
            if (this.isXML_) {
                return new ByteArrayInputStream(JDUtilities.stripXMLDeclaration(new String(this.data_)).getBytes("ISO8859_1"));
            }
            return new ByteArrayInputStream(new String(this.data_).getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (this.isXML_) {
            return new CharArrayReader(JDUtilities.stripXMLDeclaration(new String(this.data_)).toCharArray());
        }
        return new CharArrayReader(this.data_);
    }

    public synchronized String getSubString(long position, int length) throws SQLException {
        int lengthToUse;
        int offset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((offset = (int)position - 1) < 0 || length < 0 || offset > this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        if (this.isXML_) {
            this.data_ = JDUtilities.stripXMLDeclaration(new String(this.data_)).toCharArray();
        }
        if ((lengthToUse = this.data_.length - offset) <= 0) {
            return "";
        }
        if (lengthToUse > length) {
            lengthToUse = length;
        }
        char[] result = new char[lengthToUse];
        System.arraycopy(this.data_, offset, result, 0, lengthToUse);
        return new String(result);
    }

    public synchronized long length() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.data_.length;
    }

    public synchronized long position(String pattern, long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        int offset = (int)position - 1;
        if (pattern == null || offset < 0 || offset >= this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        } else {
            char[] charPattern = pattern.toCharArray();
            int end = this.data_.length - charPattern.length;
            for (int i = offset; i <= end; ++i) {
                int j;
                for (j = 0; j < charPattern.length && this.data_[i + j] == charPattern[j]; ++j) {
                }
                if (j != charPattern.length) continue;
                return i + 1;
            }
        }
        return -1L;
    }

    public synchronized long position(Clob pattern, long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        int offset = (int)position - 1;
        if (pattern == null || offset < 0 || offset >= this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        } else {
            int patternLength = (int)pattern.length();
            if (patternLength > this.data_.length || patternLength < 0) {
                return -1L;
            }
            int end = this.data_.length - patternLength;
            char[] charPattern = pattern.getSubString(1L, patternLength).toCharArray();
            for (int i = offset; i <= end; ++i) {
                int j;
                for (j = 0; j < charPattern.length && this.data_[i + j] == charPattern[j]; ++j) {
                }
                if (j != charPattern.length) continue;
                return i + 1;
            }
        }
        return -1L;
    }

    public OutputStream setAsciiStream(long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        try {
            return new AS400JDBCClobOutputStream(this, position, ConvTable.getTable(819, null));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException("HY000", e);
            return null;
        }
    }

    public synchronized Writer setCharacterStream(long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return new AS400JDBCWriter(this, position);
    }

    public synchronized int setString(long position, String stringToWrite) throws SQLException {
        int offset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((offset = (int)position - 1) < 0 || offset >= this.maxLength_ || stringToWrite == null) {
            throw JDError.throwSQLException((Object)this, "HY024");
        }
        char[] charsToWrite = stringToWrite.toCharArray();
        int newSize = offset + charsToWrite.length;
        if (newSize < 0) {
            newSize = Integer.MAX_VALUE;
        }
        if (newSize > this.data_.length) {
            char[] temp = this.data_;
            this.data_ = new char[newSize];
            System.arraycopy(temp, 0, this.data_, 0, temp.length);
            int numPad = offset - temp.length;
            for (int i = 0; i < numPad; ++i) {
                this.data_[i + temp.length] = 32;
            }
        }
        int numChars = newSize - offset;
        System.arraycopy(charsToWrite, 0, this.data_, offset, numChars);
        return numChars;
    }

    public synchronized int setString(long position, String string, int offset, int lengthOfWrite) throws SQLException {
        int clobOffset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((clobOffset = (int)position - 1) < 0 || clobOffset >= this.maxLength_ || string == null || offset < 0 || lengthOfWrite < 0 || offset + lengthOfWrite > string.length() || clobOffset + lengthOfWrite > this.maxLength_) {
            throw JDError.throwSQLException((Object)this, "HY024");
        }
        char[] charsToWrite = string.toCharArray();
        int newSize = clobOffset + lengthOfWrite;
        if (newSize < 0) {
            newSize = Integer.MAX_VALUE;
        }
        if (newSize > this.data_.length) {
            char[] temp = this.data_;
            this.data_ = new char[newSize];
            System.arraycopy(temp, 0, this.data_, 0, temp.length);
            int numPad = offset - temp.length;
            for (int i = 0; i < numPad; ++i) {
                this.data_[i + temp.length] = 32;
            }
        }
        int numChars = newSize - clobOffset;
        System.arraycopy(charsToWrite, offset, this.data_, clobOffset, numChars);
        return numChars;
    }

    public synchronized void truncate(long lengthOfCLOB) throws SQLException {
        int length;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((length = (int)lengthOfCLOB) < 0 || length > this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        char[] temp = this.data_;
        this.data_ = new char[length];
        int numToCopy = length < temp.length ? length : temp.length;
        System.arraycopy(temp, 0, this.data_, 0, numToCopy);
    }

    public synchronized void free() throws SQLException {
        this.data_ = null;
    }

    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (this.isXML_) {
            return new CharArrayReader(JDUtilities.stripXMLDeclaration(new String(this.data_)).toCharArray(), (int)pos - 1, (int)length);
        }
        return new CharArrayReader(this.data_, (int)pos - 1, (int)length);
    }
}

