/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClobLocatorOutputStream;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCWriter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class AS400JDBCClobLocator
implements Clob {
    protected ConvTable converter_;
    JDLobLocator locator_;
    Object savedObject_;
    int savedScale_;
    private char[] cache_;
    private int cacheOffset_;
    private static final char[] INIT_CACHE = new char[0];
    protected int maxLength_;
    private boolean isXML_ = false;

    AS400JDBCClobLocator(JDLobLocator locator, ConvTable converter, Object savedObject, int savedScale) {
        this.locator_ = locator;
        this.converter_ = converter;
        this.savedObject_ = savedObject;
        this.savedScale_ = savedScale;
        this.maxLength_ = this.locator_.getMaxLength();
    }

    AS400JDBCClobLocator(JDLobLocator locator, ConvTable converter, Object savedObject, int savedScale, boolean isXML) {
        this(locator, converter, savedObject, savedScale);
        this.isXML_ = isXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            try {
                return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_), 819);
            }
            catch (UnsupportedEncodingException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            try {
                return new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_);
            }
            catch (UnsupportedEncodingException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
                return null;
            }
        }
    }

    int getHandle() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.locator_.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubString(long position, int length) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            int lengthToUse;
            int offset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((offset = (int)position - 1) < 0 || length < 0 || (long)offset > this.length()) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if ((lengthToUse = (int)this.length() - offset) < 0) {
                return "";
            }
            if (lengthToUse > length) {
                lengthToUse = length;
            }
            if (!this.isXML_) {
                DBLobData data = this.locator_.retrieveData(offset, lengthToUse);
                int actualLength = data.getLength();
                return this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), actualLength);
            }
            ConvTableReader r = null;
            try {
                r = new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_);
                r.skip(offset);
                String string = r.read(lengthToUse);
                return string;
            }
            catch (Exception e) {
                JDError.throwSQLException((Object)this, "HY000", e);
                String string = null;
                return string;
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception ee) {
                    JDTrace.logException(this, "getSubString r.close() threw exception", ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            return this.locator_.getLength();
        }
    }

    private void initCache() {
        this.cacheOffset_ = 0;
        this.cache_ = INIT_CACHE;
    }

    private int getCachedChar(int index) throws SQLException {
        int realIndex = index - this.cacheOffset_;
        if (realIndex >= this.cache_.length) {
            int blockSize = 1000000;
            int len = (int)this.length();
            if (len < 0) {
                len = Integer.MAX_VALUE;
            }
            if (blockSize + index > len) {
                blockSize = len - index;
            }
            this.cache_ = this.getSubString(index + 1, blockSize).toCharArray();
            this.cacheOffset_ = index;
            realIndex = 0;
        }
        if (this.cache_.length == 0) {
            return -1;
        }
        return this.cache_[realIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String pattern, long position) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            int offset = (int)position - 1;
            if (pattern == null || offset < 0 || (long)offset >= this.length()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            char[] charPattern = pattern.toCharArray();
            int end = (int)this.length() - charPattern.length;
            this.initCache();
            for (int i = offset; i <= end; ++i) {
                int j = 0;
                int cachedChar = this.getCachedChar(i + j);
                while (j < charPattern.length && cachedChar != -1 && charPattern[j] == cachedChar) {
                    cachedChar = this.getCachedChar(i + ++j);
                }
                if (j != charPattern.length) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Clob pattern, long position) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            int locatorLength;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            int offset = (int)position - 1;
            if (pattern == null || offset < 0 || (long)offset >= this.length()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int patternLength = (int)pattern.length();
            if (patternLength > (locatorLength = (int)this.length()) || patternLength < 0) {
                return -1L;
            }
            int end = locatorLength - patternLength;
            char[] charPattern = pattern.getSubString(1L, patternLength).toCharArray();
            this.initCache();
            for (int i = offset; i <= end; ++i) {
                int j = 0;
                int cachedChar = this.getCachedChar(i + j);
                while (j < patternLength && cachedChar != -1 && charPattern[j] == cachedChar) {
                    cachedChar = this.getCachedChar(i + ++j);
                }
                if (j != patternLength) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    public OutputStream setAsciiStream(long position) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        try {
            return new AS400JDBCClobLocatorOutputStream(this, position, ConvTable.getTable(819, null));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException("HY000", e);
            return null;
        }
    }

    public Writer setCharacterStream(long position) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return new AS400JDBCWriter(this, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long position, String stringToWrite) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            int numChars;
            int offset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((offset = (int)position - 1) < 0 || offset >= this.maxLength_ || stringToWrite == null) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            char[] charsToWrite = stringToWrite.toCharArray();
            int newSize = offset + charsToWrite.length;
            if (newSize < 0) {
                newSize = Integer.MAX_VALUE;
            }
            if ((numChars = newSize - offset) != charsToWrite.length) {
                char[] temp = charsToWrite;
                charsToWrite = new char[newSize];
                System.arraycopy(temp, 0, charsToWrite, 0, numChars);
            }
            byte[] bytesToWrite = this.converter_.stringToByteArray(charsToWrite, 0, charsToWrite.length);
            this.locator_.writeData((long)offset, bytesToWrite, false);
            return charsToWrite.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long position, String string, int offset, int lengthOfWrite) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            int numChars;
            int clobOffset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((clobOffset = (int)position - 1) < 0 || clobOffset >= this.maxLength_ || string == null || offset < 0 || lengthOfWrite < 0 || offset + lengthOfWrite > string.length() || clobOffset + lengthOfWrite > this.maxLength_) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int newSize = clobOffset + lengthOfWrite;
            if (newSize < 0) {
                newSize = Integer.MAX_VALUE;
            }
            int realLength = (numChars = newSize - clobOffset) < lengthOfWrite ? numChars : lengthOfWrite;
            char[] charsToWrite = new char[realLength];
            string.getChars(offset, offset + numChars, charsToWrite, 0);
            byte[] bytesToWrite = this.converter_.stringToByteArray(charsToWrite, 0, charsToWrite.length);
            this.locator_.writeData((long)clobOffset, bytesToWrite, false);
            return charsToWrite.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long lengthOfCLOB) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            int length;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((length = (int)lengthOfCLOB) < 0 || length > this.maxLength_) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            this.locator_.writeData(length, new byte[0], 0, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                return;
            }
            this.locator_.free();
            this.locator_ = null;
            this.converter_ = null;
            this.savedObject_ = null;
            this.cache_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        AS400JDBCClobLocator aS400JDBCClobLocator = this;
        synchronized (aS400JDBCClobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if (pos < 1L || pos - 1L + length > (long)this.locator_.getMaxLength() || length < 0L) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            ConvTableReader r = null;
            try {
                r = new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_);
                ((Reader)r).skip(pos);
                return r;
            }
            catch (UnsupportedEncodingException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
                return null;
            }
            catch (IOException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
                return null;
            }
        }
    }

    public int getLocator() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.locator_.getHandle();
    }
}

