/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ToolboxWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;

public class AS400JDBCConnectionHandle
extends ToolboxWrapper
implements Connection {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCPooledConnection pooledConnection_ = null;
    private AS400JDBCConnection connection_ = null;

    AS400JDBCConnectionHandle(AS400JDBCPooledConnection pooledConnection, AS400JDBCConnection connection) {
        if (pooledConnection == null) {
            throw new NullPointerException("pooledConnection");
        }
        this.pooledConnection_ = pooledConnection;
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = connection;
    }

    void invalidate() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "invalidate()");
        }
        this.connection_ = null;
        this.pooledConnection_ = null;
    }

    void checkAccess(JDSQLStatement sqlStatement) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkAccess(sqlStatement);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void checkOpen() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkOpen();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        this.validateConnection();
        this.connection_.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close()");
        }
        if (this.connection_ == null) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() returning because connection_ is null");
            }
            return;
        }
        try {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling connection_.pseudoClosed " + this.connection_.getServerJobIdentifier());
            }
            this.connection_.pseudoClose();
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling fireEventIfErrorFatal");
            }
            this.fireEventIfErrorFatal(e);
            throw e;
        }
        finally {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling pooledConnection_.fireConnectionCloseEvent ");
            }
            this.pooledConnection_.fireConnectionCloseEvent(new ConnectionEvent(this.pooledConnection_));
            this.connection_ = null;
            this.pooledConnection_ = null;
        }
    }

    public void commit() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.commit();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public Statement createStatement() throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected void finalize() throws Throwable {
        block2: {
            try {
                this.close();
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) break block2;
                JDTrace.logInformation(this, "Finalize on a connection handle threw exception: " + e.getMessage());
            }
        }
    }

    private final void fireEventIfErrorFatal(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState.equals("42505") || sqlState.equals("08003") || sqlState.equals("08004") || sqlState.equals("08001") || sqlState.equals("08S01") || sqlState.equals("HY000") || sqlState.equals("HY001") || sqlState.equals("42705")) {
            this.pooledConnection_.fatalConnectionErrorOccurred_ = true;
            this.pooledConnection_.fireConnectionErrorEvent(new ConnectionEvent(this.pooledConnection_, e));
        }
    }

    AS400Impl getAS400() throws SQLException {
        this.validateConnection();
        return this.connection_.getAS400();
    }

    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        return this.connection_.getAutoCommit();
    }

    public int getConcurrentAccessResolution() throws SQLException {
        this.validateConnection();
        return this.connection_.getConcurrentAccessResolution();
    }

    public String getCatalog() throws SQLException {
        this.validateConnection();
        return this.connection_.getCatalog();
    }

    ConvTable getConverter() throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter();
    }

    ConvTable getConverter(int ccsid) throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter(ccsid);
    }

    String getDefaultSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getDefaultSchema();
    }

    public int getHoldability() throws SQLException {
        this.validateConnection();
        return this.connection_.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateConnection();
        return this.connection_.getMetaData();
    }

    JDProperties getProperties() throws SQLException {
        this.validateConnection();
        return this.connection_.getProperties();
    }

    public String getServerJobIdentifier() throws SQLException {
        this.validateConnection();
        return this.connection_.getServerJobIdentifier();
    }

    public AS400 getSystem() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Warning: returning pooled connection's AS400 object directly to user.");
        }
        return this.connection_.getSystem();
    }

    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        return this.connection_.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.validateConnection();
        return this.connection_.getTypeMap();
    }

    String getURL() throws SQLException {
        this.validateConnection();
        return this.connection_.getURL();
    }

    String getUserName() throws SQLException {
        this.validateConnection();
        return this.connection_.getUserName();
    }

    int getVRM() throws SQLException {
        this.validateConnection();
        return this.connection_.getVRM();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        return this.connection_.getWarnings();
    }

    boolean isCursorNameUsed(String cursorName) throws SQLException {
        this.validateConnection();
        return this.connection_.isCursorNameUsed(cursorName);
    }

    public boolean isClosed() throws SQLException {
        return this.connection_ == null;
    }

    public boolean isReadOnly() throws SQLException {
        this.validateConnection();
        return this.connection_.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.nativeSQL(sql);
    }

    void notifyClose(AS400JDBCStatement statement, int id) throws SQLException {
        this.validateConnection();
        this.connection_.notifyClose(statement, id);
    }

    void postWarning(SQLWarning sqlWarning) throws SQLException {
        this.validateConnection();
        this.connection_.postWarning(sqlWarning);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, columnNames);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback(savepoint);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request, int id) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request, id);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request, int id, boolean leavePending) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request, id, leavePending);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(request);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request, int id) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(request, id);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) throws SQLException {
        this.validateConnection();
        this.connection_.setConcurrentAccessResolution(concurrentAccessResolution);
    }

    public void setDB2eWLMCorrelator(byte[] bytes) throws SQLException {
        this.validateConnection();
        this.connection_.setDB2eWLMCorrelator(bytes);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.validateConnection();
        this.connection_.setCatalog(catalog);
    }

    void setDRDA(boolean drda) throws SQLException {
        this.validateConnection();
        this.connection_.setDRDA(drda);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.validateConnection();
        this.connection_.setHoldability(holdability);
    }

    void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400 as400, Properties info) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(dataSourceUrl, properties, as400, info);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(dataSourceUrl, properties, as400);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnection();
        this.connection_.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint(name);
    }

    void setSystem(AS400 as400) throws SQLException {
        this.validateConnection();
        this.connection_.setSystem(as400);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnection();
        this.connection_.setTransactionIsolation(level);
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.validateConnection();
        this.connection_.setTypeMap(typeMap);
    }

    public String toString() {
        if (this.connection_ != null) {
            return this.connection_.toString();
        }
        return super.toString();
    }

    boolean useExtendedFormats() throws SQLException {
        this.validateConnection();
        return this.connection_.useExtendedFormats();
    }

    private void validateConnection() throws SQLException {
        if (this.connection_ == null) {
            JDTrace.logInformation(this, "The connection is closed.");
            JDError.throwSQLException("08003");
        }
    }

    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Connection"};
    }

    public boolean isValid(int timeout) throws SQLException {
        this.validateConnection();
        return this.connection_.isValid(timeout);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setClientInfo(properties);
    }

    public String getClientInfo(String name) throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo(name);
    }

    public Properties getClientInfo() throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo();
    }

    public Clob createClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createClob();
    }

    public Blob createBlob() throws SQLException {
        this.validateConnection();
        return this.connection_.createBlob();
    }

    public NClob createNClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createNClob();
    }

    public SQLXML createSQLXML() throws SQLException {
        this.validateConnection();
        return this.connection_.createSQLXML();
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.validateConnection();
        return this.connection_.createArrayOf(typeName, elements);
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.validateConnection();
        return this.connection_.createStruct(typeName, attributes);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setClientInfo(name, value);
    }

    public void setDBHostServerTrace(boolean trace) throws SQLException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setDBHostServerTrace(trace);
    }

    public void abort(Executor executor) throws SQLException {
        this.validateConnection();
        this.connection_.abort(executor);
    }

    public int getNetworkTimeout() throws SQLException {
        this.validateConnection();
        return this.connection_.getNetworkTimeout();
    }

    public String getSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getSchema();
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.validateConnection();
        this.connection_.setNetworkTimeout(executor, milliseconds);
    }

    public void setSchema(String schema) throws SQLException {
        this.validateConnection();
        this.connection_.setSchema(schema);
    }
}

