/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCRowSetEventSupport;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ToolboxWrapper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class AS400JDBCRowSet
extends ToolboxWrapper
implements RowSet,
Serializable {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final String className_ = "AS400JDBCRowSet";
    private String command_;
    private String dataSourceName_;
    private boolean useDataSource_ = true;
    private String url_;
    private String username_;
    private String password_;
    private Connection connection_;
    private DataSource dataSource_;
    private AS400JDBCPreparedStatement statement_;
    private transient AS400JDBCResultSet resultSet_;
    private transient AS400JDBCRowSetEventSupport eventSupport_;
    private Context context_ = null;
    private Hashtable environment_ = null;
    private boolean isReadOnly_ = false;
    private int transactionIsolation_ = 1;
    private Map typeMap_;
    private boolean createNewStatement_ = true;
    private int concurrency_ = 1007;
    private boolean escapeProcessing_ = true;
    private int type_ = 1003;
    private transient PropertyChangeSupport changes_;

    public AS400JDBCRowSet() {
        this.initializeTransient();
    }

    public AS400JDBCRowSet(String dataSourceName) {
        this();
        this.setDataSourceName(dataSourceName);
    }

    public AS400JDBCRowSet(String url, String username, String password) {
        this();
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public boolean absolute(int rowNumber) throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.absolute(rowNumber);
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addRowSetListener(RowSetListener listener) {
        this.eventSupport_.addRowSetListener(listener);
    }

    public void afterLast() throws SQLException {
        this.validateResultSet();
        this.resultSet_.afterLast();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void beforeFirst() throws SQLException {
        this.validateResultSet();
        this.resultSet_.beforeFirst();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void cancelRowUpdates() throws SQLException {
        this.validateResultSet();
        this.resultSet_.cancelRowUpdates();
    }

    public void clearParameters() throws SQLException {
        if (this.statement_ != null) {
            this.statement_.clearParameters();
        }
    }

    public void clearWarnings() throws SQLException {
        this.validateResultSet();
        this.resultSet_.clearWarnings();
    }

    public void close() throws SQLException {
        block8: {
            block7: {
                try {
                    if (this.resultSet_ != null) {
                        this.resultSet_.close();
                    }
                }
                catch (SQLException e) {
                    if (!JDTrace.isTraceOn()) break block7;
                    JDTrace.logInformation(this, "Closing result set while closing the row set failed: " + e.getMessage());
                }
            }
            try {
                if (this.statement_ != null) {
                    this.statement_.close();
                }
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) break block8;
                JDTrace.logInformation(this, "Closing statement set while closing the row set failed: " + e.getMessage());
            }
        }
        if (this.connection_ != null) {
            this.connection_.close();
        }
    }

    private void connect() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "connect()");
        }
        if (this.isUseDataSource()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "using JDBC DataSource");
            }
            if (this.dataSourceName_ == null) {
                throw new ExtendedIllegalStateException("dataSourceName", 4);
            }
            try {
                if (this.context_ == null) {
                    this.context_ = this.environment_ == null ? new InitialContext() : new InitialContext(this.environment_);
                }
                this.dataSource_ = (DataSource)this.context_.lookup(this.dataSourceName_);
            }
            catch (NamingException ne) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(this, "Cannot find JNDI data source.", ne);
                }
                ExtendedIllegalStateException eise = new ExtendedIllegalStateException("dataSourceName", 13);
                eise.initCause(ne);
                throw eise;
            }
            this.connection_ = this.dataSource_.getConnection(this.username_, this.password_);
        } else {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "using JDBC url");
            }
            if (this.url_ == null) {
                throw new ExtendedIllegalStateException("url", 4);
            }
            this.connection_ = this.username_ != null && this.password_ != null ? DriverManager.getConnection(this.url_, this.username_, this.password_) : DriverManager.getConnection(this.url_);
        }
        this.connection_.setReadOnly(this.isReadOnly_);
        if (this.transactionIsolation_ != 1) {
            this.connection_.setTransactionIsolation(this.transactionIsolation_);
        }
    }

    private void createStatement() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "createStatement()");
        }
        if (this.command_ == null) {
            throw new ExtendedIllegalStateException("command", 4);
        }
        if (this.connection_ == null) {
            this.connect();
        }
        int fetchDirection = 0;
        int fetchSize = 0;
        int maxFieldSize = 0;
        int maxRows = 0;
        int queryTimeout = 0;
        boolean setParameters = false;
        if (this.statement_ != null) {
            fetchDirection = this.statement_.getFetchDirection();
            fetchSize = this.statement_.getFetchSize();
            maxFieldSize = this.statement_.getMaxFieldSize();
            maxRows = this.statement_.getMaxRows();
            queryTimeout = this.statement_.getQueryTimeout();
            setParameters = true;
        }
        this.statement_ = (AS400JDBCPreparedStatement)this.connection_.prepareStatement(this.command_, this.type_, this.concurrency_);
        if (setParameters) {
            this.statement_.setFetchDirection(fetchDirection);
            this.statement_.setFetchSize(fetchSize);
            this.statement_.setMaxFieldSize(maxFieldSize);
            this.statement_.setMaxRows(maxRows);
            this.statement_.setQueryTimeout(queryTimeout);
        }
        this.createNewStatement_ = false;
    }

    public void deleteRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.deleteRow();
    }

    public void execute() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "execute()");
        }
        if (this.createNewStatement_) {
            this.createStatement();
        }
        if (this.command_.toUpperCase().indexOf("SELECT") != -1) {
            this.resultSet_ = (AS400JDBCResultSet)this.statement_.executeQuery();
            this.eventSupport_.fireRowSetChanged(new RowSetEvent(this));
        } else {
            this.statement_.executeUpdate();
        }
    }

    protected void finalize() throws SQLException {
        try {
            this.close();
        }
        catch (SQLException e) {
            JDError.throwSQLException("HY001");
        }
    }

    public int findColumn(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.findColumn(columnName);
    }

    public boolean first() throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.first();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    public Array getArray(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getArray(columnIndex);
    }

    public Array getArray(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getArray(columnName);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getAsciiStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getAsciiStream(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(columnIndex, scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(columnName, scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBinaryStream(columnName);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBlob(columnIndex);
    }

    public Blob getBlob(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBlob(columnName);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBoolean(columnName);
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getByte(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getByte(columnName);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBytes(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBytes(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCharacterStream(columnName);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getClob(columnIndex);
    }

    public Clob getClob(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getClob(columnName);
    }

    public String getCommand() {
        return this.command_;
    }

    public int getConcurrency() throws SQLException {
        if (this.resultSet_ != null) {
            this.concurrency_ = this.resultSet_.getConcurrency();
        }
        return this.concurrency_;
    }

    public Context getContext() {
        return this.context_;
    }

    public String getCursorName() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCursorName();
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(columnIndex);
    }

    public Date getDate(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(columnName);
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(columnIndex, calendar);
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(columnName, calendar);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDouble(columnName);
    }

    public Hashtable getEnvironment() {
        return this.environment_;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing_;
    }

    public int getFetchDirection() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getFetchDirection();
        }
        if (this.statement_ == null) {
            return 1000;
        }
        return this.statement_.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getFetchSize();
        }
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getFetchSize();
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getFloat(columnName);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getInt(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getInt(columnName);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getLong(columnName);
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnName);
    }

    public Object getObject(int columnIndex, Map typeMap) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnIndex, typeMap);
    }

    public Object getObject(String columnName, Map typeMap) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnName, typeMap);
    }

    public String getPassword() {
        return "";
    }

    public int getQueryTimeout() throws SQLException {
        this.validateStatement();
        return this.statement_.getQueryTimeout();
    }

    public Ref getRef(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRef(columnIndex);
    }

    public Ref getRef(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRef(columnName);
    }

    public int getRow() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRow();
    }

    public short getShort(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getShort(columnName);
    }

    public Statement getStatement() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getStatement();
    }

    public String getString(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getString(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getString(columnName);
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(columnIndex);
    }

    public Time getTime(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(columnName);
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(columnIndex, calendar);
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(columnName, calendar);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(columnName);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(columnIndex, calendar);
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(columnName, calendar);
    }

    public int getTransactionIsolation() {
        try {
            if (this.connection_ != null) {
                return this.connection_.getTransactionIsolation();
            }
            return this.transactionIsolation_;
        }
        catch (SQLException e) {
            JDTrace.logInformation(this, "getTransactionIsolation() database error");
            return this.transactionIsolation_;
        }
    }

    public int getType() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getType();
        }
        return this.type_;
    }

    public Map getTypeMap() throws SQLException {
        if (this.connection_ != null) {
            return this.connection_.getTypeMap();
        }
        return this.typeMap_;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getUnicodeStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getUnicodeStream(columnName);
    }

    public String getUrl() {
        return this.url_;
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getURL(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getURL(columnName);
    }

    public String getUsername() {
        return this.username_;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getWarnings();
    }

    private void initializeTransient() {
        this.eventSupport_ = new AS400JDBCRowSetEventSupport();
        this.changes_ = new PropertyChangeSupport(this);
        this.resultSet_ = null;
    }

    public void insertRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isLast();
    }

    public boolean isReadOnly() {
        if (this.connection_ != null) {
            try {
                return this.connection_.isReadOnly();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.isReadOnly_;
    }

    public boolean isUseDataSource() {
        return this.useDataSource_;
    }

    public boolean last() throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.last();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    public void moveToCurrentRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.moveToCurrentRow();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void moveToInsertRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.moveToInsertRow();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public boolean next() throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.next();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    public boolean previous() throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.previous();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.refreshRow();
    }

    public boolean relative(int rowNumber) throws SQLException {
        this.validateResultSet();
        boolean status = this.resultSet_.relative(rowNumber);
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return status;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeRowSetListener(RowSetListener listener) {
        this.eventSupport_.removeRowSetListener(listener);
    }

    public boolean rowDeleted() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowUpdated();
    }

    public void setArray(int parameterIndex, Array value) throws SQLException {
        this.validateStatement();
        this.statement_.setArray(parameterIndex, value);
    }

    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(parameterIndex, inputStream, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.validateStatement();
        this.statement_.setBigDecimal(parameterIndex, value);
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(parameterIndex, inputStream, length);
    }

    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(parameterIndex, value);
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.validateStatement();
        this.statement_.setBoolean(parameterIndex, value);
    }

    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.validateStatement();
        this.statement_.setByte(parameterIndex, value);
    }

    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.validateStatement();
        this.statement_.setBytes(parameterIndex, value);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int parameterIndex, Clob value) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(parameterIndex, value);
    }

    public void setCommand(String command) throws SQLException {
        String property = "command";
        if (command == null) {
            throw new NullPointerException(property);
        }
        String old = this.command_;
        this.command_ = command;
        this.changes_.firePropertyChange(property, old, command);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setCommand", property, command);
        }
    }

    public void setConcurrency(int concurrency) {
        String property = "concurrency";
        switch (concurrency) {
            case 1007: {
                break;
            }
            case 1008: {
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(property, 4);
            }
        }
        Integer oldValue = new Integer(this.concurrency_);
        Integer newValue = new Integer(concurrency);
        this.concurrency_ = concurrency;
        this.changes_.firePropertyChange(property, oldValue, newValue);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setConcurrency", "concurrency", concurrency);
        }
    }

    public void setContext(Context context) {
        String property = "context";
        if (context == null) {
            throw new NullPointerException(property);
        }
        Context oldValue = this.getContext();
        Context newValue = context;
        this.context_ = context;
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setDataSourceName(String dataSourceName) {
        String property = "dataSourceName";
        if (dataSourceName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getDataSourceName();
        this.dataSourceName_ = dataSourceName;
        this.changes_.firePropertyChange(property, old, dataSourceName);
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(parameterIndex, value);
    }

    public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(parameterIndex, value, calendar);
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.validateStatement();
        this.statement_.setDouble(parameterIndex, value);
    }

    public void setEnvironment(Hashtable environment) {
        String property = "enviroment";
        if (environment == null) {
            throw new NullPointerException(property);
        }
        Hashtable oldValue = this.getEnvironment();
        Hashtable newValue = environment;
        this.environment_ = environment;
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        Boolean old = new Boolean(this.getEscapeProcessing());
        this.validateStatement();
        this.statement_.setEscapeProcessing(enable);
        this.escapeProcessing_ = enable;
        this.changes_.firePropertyChange("escapeProcessing", old, new Boolean(enable));
    }

    public void setFetchDirection(int fetchDirection) throws SQLException {
        Integer old = new Integer(this.getFetchDirection());
        if (this.resultSet_ != null) {
            this.resultSet_.setFetchDirection(fetchDirection);
        }
        this.validateStatement();
        this.statement_.setFetchDirection(fetchDirection);
        this.changes_.firePropertyChange("fetchDirection", old, new Integer(fetchDirection));
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        Integer old = new Integer(this.getFetchSize());
        if (this.resultSet_ != null) {
            this.resultSet_.setFetchSize(fetchSize);
        }
        this.validateStatement();
        this.statement_.setFetchSize(fetchSize);
        this.changes_.firePropertyChange("fetchSize", old, new Integer(fetchSize));
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.validateStatement();
        this.statement_.setFloat(parameterIndex, value);
    }

    public void setInt(int parameterIndex, int value) throws SQLException {
        this.validateStatement();
        this.statement_.setInt(parameterIndex, value);
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        this.validateStatement();
        this.statement_.setLong(parameterIndex, value);
    }

    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        String property = "maxFieldSize";
        this.validateStatement();
        Integer oldValue = new Integer(this.getMaxFieldSize());
        Integer newValue = new Integer(maxFieldSize);
        this.statement_.setMaxFieldSize(maxFieldSize);
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setMaxRows(int maxRows) throws SQLException {
        String property = "maxRows";
        this.validateStatement();
        Integer oldValue = new Integer(this.getMaxRows());
        Integer newValue = new Integer(maxRows);
        this.statement_.setMaxRows(maxRows);
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(parameterIndex, sqlType);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(parameterIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(parameterIndex, value);
    }

    public void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(parameterIndex, value, targetSqlType);
    }

    public void setObject(int parameterIndex, Object value, int targetSqlType, int scale) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(parameterIndex, value, targetSqlType, scale);
    }

    public void setPassword(String password) {
        String property = "password";
        if (password == null) {
            throw new NullPointerException(property);
        }
        this.validateConnection();
        this.password_ = password;
        this.changes_.firePropertyChange(property, "", password);
    }

    public void setQueryTimeout(int timeout) throws SQLException {
        String property = "timeout";
        this.validateStatement();
        Integer oldValue = new Integer(this.getQueryTimeout());
        Integer newValue = new Integer(timeout);
        this.statement_.setQueryTimeout(timeout);
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        String property = "readOnly";
        Boolean oldValue = new Boolean(this.isReadOnly());
        Boolean newValue = new Boolean(readOnly);
        if (this.connection_ != null) {
            this.connection_.setReadOnly(readOnly);
        }
        this.isReadOnly_ = readOnly;
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setRef(int parameterIndex, Ref value) throws SQLException {
        this.validateStatement();
        this.statement_.setRef(parameterIndex, value);
    }

    public void setShort(int parameterIndex, short value) throws SQLException {
        this.validateStatement();
        this.statement_.setShort(parameterIndex, value);
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        this.validateStatement();
        this.statement_.setString(parameterIndex, value);
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(parameterIndex, value);
    }

    public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(parameterIndex, value, calendar);
    }

    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(parameterIndex, value);
    }

    public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(parameterIndex, value, calendar);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String property = "transactionIsolation";
        Integer oldValue = new Integer(this.getTransactionIsolation());
        Integer newValue = new Integer(level);
        if (this.connection_ != null) {
            this.connection_.setTransactionIsolation(level);
        }
        this.transactionIsolation_ = level;
        this.changes_.firePropertyChange(property, oldValue, newValue);
    }

    public void setType(int type) throws SQLException {
        String property = "type";
        switch (type) {
            case 1003: {
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(property, 4);
            }
        }
        Integer oldValue = new Integer(this.getType());
        Integer newValue = new Integer(this.type_);
        this.type_ = type;
        this.changes_.firePropertyChange(property, oldValue, newValue);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setType", property, type);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (this.connection_ != null) {
            this.connection_.setTypeMap(map);
        }
        this.typeMap_ = map;
    }

    public void setUrl(String url) {
        String property = "url";
        if (url == null) {
            throw new NullPointerException(property);
        }
        this.validateConnection();
        String old = this.getUrl();
        this.url_ = url;
        this.changes_.firePropertyChange(property, old, url);
        this.useDataSource_ = false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setUrl", property, url);
        }
    }

    public void setUseDataSource(boolean useDataSource) {
        String property = "useDataSource";
        this.validateConnection();
        Boolean oldValue = new Boolean(this.isUseDataSource());
        this.useDataSource_ = useDataSource;
        this.changes_.firePropertyChange(property, oldValue, new Boolean(useDataSource));
    }

    public void setUsername(String username) {
        String property = "username";
        if (username == null) {
            throw new NullPointerException(property);
        }
        this.validateConnection();
        String old = this.getUsername();
        this.username_ = username;
        this.changes_.firePropertyChange(property, old, username);
    }

    public String toString() {
        if (this.resultSet_ != null) {
            return this.resultSet_.toString();
        }
        return "";
    }

    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateArray(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateArray(String columnName, Array columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateArray(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnIndex, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnName, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBigDecimal(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBigDecimal(String columnName, BigDecimal columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBigDecimal(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnIndex, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnName, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String columnName, Blob columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBoolean(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBoolean(String columnName, boolean columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBoolean(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateByte(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateByte(String columnName, byte columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateByte(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBytes(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBytes(String columnName, byte[] columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBytes(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnIndex, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String columnName, Reader columnValue, int length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnName, columnValue, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String columnName, Clob columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDate(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDate(String columnName, Date columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDate(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDouble(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDouble(String columnName, double columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDouble(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateFloat(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateFloat(String columnName, float columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateFloat(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateInt(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateInt(String columnName, int columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateInt(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateLong(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateLong(String columnName, long columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateLong(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNull(columnIndex);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNull(String columnName) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNull(columnName);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(String columnName, Object columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(columnIndex, columnValue, scale);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(String columnName, Object columnValue, int scale) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(columnName, columnValue, scale);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRow();
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRef(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRef(String columnName, Ref columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRef(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateShort(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateShort(String columnName, short columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateShort(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateString(int columnIndex, String columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateString(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateString(String columnName, String columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateString(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTime(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTime(String columnName, Time columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTime(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTimestamp(columnIndex, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTimestamp(String columnName, Timestamp columnValue) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTimestamp(columnName, columnValue);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    private void validateConnection() {
        if (this.connection_ != null) {
            throw new ExtendedIllegalStateException("connection", 5);
        }
    }

    private void validateResultSet() {
        if (this.resultSet_ == null) {
            throw new ExtendedIllegalStateException("resultSet", 3);
        }
    }

    private void validateStatement() throws SQLException {
        if (this.statement_ == null) {
            this.createStatement();
        }
    }

    public boolean wasNull() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.wasNull();
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(parameterIndex, value, length);
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(this.statement_.findParameterIndex(parameterName), value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(parameterIndex, value);
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(this.statement_.findParameterIndex(parameterName), value);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.validateStatement();
        this.statement_.setNString(parameterIndex, value);
    }

    public void setNString(String parameterName, String value) throws SQLException {
        this.validateStatement();
        this.statement_.setNString(this.statement_.findParameterIndex(parameterName), value);
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.validateStatement();
        this.statement_.setRowId(parameterIndex, x);
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.validateStatement();
        this.statement_.setRowId(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.validateStatement();
        this.statement_.setSQLXML(parameterIndex, xmlObject);
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.validateStatement();
        this.statement_.setSQLXML(this.statement_.findParameterIndex(parameterName), xmlObject);
    }

    public int getHoldability() throws SQLException {
        return this.resultSet_.getHoldability();
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNCharacterStream(columnIndex);
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNCharacterStream(columnLabel);
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNClob(columnIndex);
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNClob(columnLabel);
    }

    public String getNString(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNString(columnIndex);
    }

    public String getNString(String columnLabel) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNString(columnLabel);
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRowId(columnIndex);
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRowId(columnLabel);
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getSQLXML(columnIndex);
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getSQLXML(columnLabel);
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet_.isClosed();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnIndex, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnLabel, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnIndex, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnLabel, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnIndex, inputStream, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnLabel, inputStream, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnIndex, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnLabel, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnIndex, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnLabel, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(columnIndex, x, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(columnLabel, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnIndex, nClob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnLabel, nClob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnIndex, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnLabel, reader, length);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNString(columnIndex, nString);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNString(columnLabel, nString);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRowId(columnIndex, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRowId(columnLabel, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateSQLXML(columnIndex, xmlObject);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateSQLXML(columnLabel, xmlObject);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCRowSet", "javax.sql.RowSet"};
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(parameterIndex, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(this.statement_.findParameterIndex(parameterName), x, length);
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.validateStatement();
        this.statement_.setBigDecimal(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(parameterIndex, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(this.statement_.findParameterIndex(parameterName), x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(parameterIndex, inputStream, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(parameterIndex, inputStream);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(parameterName), inputStream, length);
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(parameterName), inputStream);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.validateStatement();
        this.statement_.setBoolean(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.validateStatement();
        this.statement_.setByte(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.validateStatement();
        this.statement_.setBytes(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(parameterIndex, reader);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(this.statement_.findParameterIndex(parameterName), reader, length);
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(this.statement_.findParameterIndex(parameterName), reader);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(parameterIndex, reader, length);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(parameterIndex, reader);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(parameterName), reader, length);
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(parameterName), reader);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(this.statement_.findParameterIndex(parameterName), x, cal);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.validateStatement();
        this.statement_.setDouble(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.validateStatement();
        this.statement_.setFloat(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.validateStatement();
        this.statement_.setInt(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.validateStatement();
        this.statement_.setLong(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(parameterIndex, value);
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(this.statement_.findParameterIndex(parameterName), value);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(parameterIndex, reader, length);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(parameterIndex, reader);
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(this.statement_.findParameterIndex(parameterName), reader, length);
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(this.statement_.findParameterIndex(parameterName), reader);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(this.statement_.findParameterIndex(parameterName), sqlType, typeName);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(this.statement_.findParameterIndex(parameterName), sqlType);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(parameterName), x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(parameterName), x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.validateStatement();
        this.statement_.setShort(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.validateStatement();
        this.statement_.setString(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(this.statement_.findParameterIndex(parameterName), x, cal);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(this.statement_.findParameterIndex(parameterName), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(this.statement_.findParameterIndex(parameterName), x);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.validateStatement();
        this.statement_.setURL(parameterIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnIndex, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(columnLabel, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnIndex, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(columnLabel, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnIndex, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(columnLabel, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnIndex, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(columnLabel, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnIndex, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(columnLabel, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(columnIndex, x);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(columnLabel, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnIndex, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(columnLabel, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnIndex, type);
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(columnLabel, type);
    }
}

