/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCCallableStatement;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.AS400JDBCQueryCancelThread;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLRPBDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDSimpleRowCache;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDecimal;
import com.ibm.as400.access.ToolboxWrapper;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class AS400JDBCStatement
extends ToolboxWrapper
implements Statement {
    static final String copyright = "Copyright (C) 1997-2018 International Business Machines Corporation and others.";
    static final int MAX_CURSOR_NAME_LENGTH_PRE_V6R1 = 18;
    static final int MAX_CURSOR_NAME_LENGTH = 128;
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;
    static final int GENERATED_KEYS_NOT_SPECIFIED = -9999;
    boolean allowImmediate_;
    private int autoGeneratedKeys_;
    Vector batch_;
    private String blockCriteria_;
    private int blockSize_;
    boolean cancelled_;
    private boolean closed_;
    private boolean closeOnCompletion_;
    AS400JDBCConnection connection_;
    boolean connectionReset_;
    JDCursor cursor_;
    private String cursorDefaultName_;
    private boolean escapeProcessing_;
    protected DBExtendedColumnDescriptors extendedColumnDescriptors_;
    private int fetchDirection_;
    private int fetchSize_;
    private AS400JDBCResultSet generatedKeys_;
    int id_;
    AS400JDBCStatementLock internalLock_;
    private int maxFieldSize_;
    private int maxRows_;
    private long longMaxRows_;
    int rowsInserted_;
    private String name_;
    private String nameOverride_;
    private int numberOfResults_;
    private int positionOfSyntaxError_;
    private boolean prefetch_;
    int queryTimeout_;
    private boolean queryTimeoutSet_ = false;
    AS400JDBCResultSet resultSet_;
    private int rowCountEstimate_;
    private boolean rpbCreated_;
    private boolean rpbQueryTimeoutChanged_;
    private boolean rpbSyncNeeded_;
    JDPackageManager packageManager_;
    int resultSetConcurrency_;
    private int resultSetHoldability_;
    private int resultSetType_;
    SQLConversionSettings settings_;
    private SQLWarning sqlWarning_;
    JDTransactionManager transactionManager_;
    int updateCount_;
    private String packageCriteria_;
    int behaviorOverride_ = 0;
    private boolean associatedWithLocators_ = false;
    private boolean holdStatement_ = false;
    boolean useVariableFieldCompression_ = false;
    boolean useVariableFieldInsertCompression_ = false;
    private boolean isPoolable_ = false;
    JDServerRow parameterRow_;
    private boolean threadInterrupted = false;
    private DBReplyRequestedDS commonExecuteReply = null;
    private DBReplyRequestedDS connectReply = null;
    private DBReplyRequestedDS execImmediateReply = null;
    private DBReplyRequestedDS normalPrepareReply = null;
    private DBReplyRequestedDS getMoreResultsReply = null;
    private boolean queryRunning_;
    private AS400JDBCQueryCancelThread cancelThread_;
    boolean disableRllCompression_ = false;
    JDSQLStatement currentJDSQLStatement_ = null;
    Exception creationLocation_;

    AS400JDBCStatement(AS400JDBCConnection connection, int id, JDTransactionManager transactionManager, JDPackageManager packageManager, String blockCriteria, int blockSize, boolean prefetch, String packageCriteria, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        this.allowImmediate_ = true;
        this.autoGeneratedKeys_ = autoGeneratedKeys;
        this.blockCriteria_ = blockCriteria;
        this.blockSize_ = blockSize;
        this.cancelled_ = false;
        this.closed_ = false;
        this.connection_ = connection;
        this.escapeProcessing_ = true;
        this.fetchDirection_ = 1000;
        this.fetchSize_ = 0;
        this.id_ = id;
        this.internalLock_ = new AS400JDBCStatementLock();
        this.maxFieldSize_ = 0;
        this.maxRows_ = 0;
        this.longMaxRows_ = 0L;
        this.numberOfResults_ = 0;
        this.prefetch_ = prefetch;
        this.queryTimeout_ = 0;
        this.resultSet_ = null;
        this.transactionManager_ = transactionManager;
        this.updateCount_ = -1;
        this.packageManager_ = packageManager;
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.resultSetType_ = resultSetType;
        this.rpbCreated_ = false;
        this.rpbQueryTimeoutChanged_ = false;
        this.rpbSyncNeeded_ = true;
        this.settings_ = SQLConversionSettings.getConversionSettings(this.connection_);
        this.sqlWarning_ = null;
        this.packageCriteria_ = packageCriteria;
        String idString = "0000" + id;
        String idString4 = idString.substring(idString.length() - 4);
        this.name_ = "STMT" + idString4;
        this.useVariableFieldInsertCompression_ = this.connection_.useVariableFieldInsertCompression();
        if (this.resultSetType_ == 1003) {
            this.cursorDefaultName_ = "CRSR" + idString4;
            if (this.connection_.useVariableFieldCompression()) {
                this.useVariableFieldCompression_ = true;
            }
        } else {
            this.cursorDefaultName_ = "SCRSR" + idString4;
        }
        this.cursor_ = new JDCursor(this.connection_, this.id_, this.cursorDefaultName_, this.resultSetConcurrency_);
        if (resultSetHoldability != -9999) {
            connection.setCheckStatementHoldability(true);
        }
        try {
            this.behaviorOverride_ = this.connection_.getProperties().getInt(50);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.connection_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Escape processing", this.escapeProcessing_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Max field size", this.maxFieldSize_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Query timeout", this.queryTimeout_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Result set concurrency", this.resultSetConcurrency_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Result set holdability", this.resultSetHoldability_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Result set type", this.resultSetType_);
            JDTrace.logProperty((Object)this, "AS400JDBCStatement.init", "Behavior Override", this.behaviorOverride_);
            String cursorAsString = JDTrace.objectToString(this.cursor_);
            JDTrace.logInformation(this, "Data to correlate statement with cursor " + cursorAsString);
            this.creationLocation_ = new Exception("creationLocation_");
        }
    }

    protected AS400JDBCStatement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String sql) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            JDSQLStatement sqlStatement;
            this.checkOpen();
            this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (sqlStatement.countParameters() > 0) {
                JDError.throwSQLException("07001");
            }
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            this.batch_.addElement(sqlStatement);
        }
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this.connection_.cancel(this.id_);
        this.cancelled_ = true;
        this.closeResultSet(241);
    }

    void checkOpen() throws SQLException {
        this.connection_.checkOpen();
        if (this.closed_) {
            JDError.throwSQLException("HY010");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            this.batch_.removeAllElements();
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        AS400JDBCConnection aS400JDBCConnection = this.connection_;
        synchronized (aS400JDBCConnection) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                if (this.isClosed()) {
                    return;
                }
                this.closeResultSet(240);
                if (this.numberOfResults_ > 1) {
                    this.getMoreResults();
                    this.cursor_.close(240);
                }
                if (this.generatedKeys_ != null) {
                    this.generatedKeys_.close();
                    this.generatedKeys_ = null;
                }
                if (this.isAssociatedWithLocators() && this.connection_.getProperties().getBoolean(63) && !this.connection_.getAutoCommit()) {
                    this.setHoldStatement(true);
                    this.closed_ = true;
                    if (this.commonExecuteReply != null) {
                        this.commonExecuteReply.returnToPool();
                        this.commonExecuteReply = null;
                    }
                    if (this.connectReply != null) {
                        this.connectReply.returnToPool();
                        this.connectReply = null;
                    }
                    if (this.execImmediateReply != null) {
                        this.execImmediateReply.returnToPool();
                        this.execImmediateReply = null;
                    }
                    if (this.normalPrepareReply != null) {
                        this.normalPrepareReply.returnToPool();
                        this.normalPrepareReply = null;
                    }
                    if (this.getMoreResultsReply != null) {
                        this.getMoreResultsReply.returnToPool();
                        this.getMoreResultsReply = null;
                    }
                    return;
                }
                SQLException e = null;
                if (this.rpbCreated_ && !this.connectionReset_) {
                    DBBaseRequestDS request3 = null;
                    DBReplyRequestedDS closeReply = null;
                    try {
                        request3 = DBDSPool.getDBSQLRPBDS(7426, this.id_, Integer.MIN_VALUE, 0);
                        closeReply = this.connection_.sendAndReceive(request3, this.id_);
                        int errorClass = closeReply.getErrorClass();
                        int returnCode = closeReply.getReturnCode();
                        if (errorClass != 0) {
                            if (returnCode < 0) {
                                try {
                                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                                }
                                catch (SQLException e2) {
                                    e = e2;
                                }
                            } else {
                                this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                            }
                        }
                    }
                    finally {
                        if (request3 != null) {
                            request3.returnToPool();
                            request3 = null;
                        }
                        if (closeReply != null) {
                            closeReply.returnToPool();
                            closeReply = null;
                        }
                    }
                }
                DBBaseRequestDS request2 = null;
                try {
                    request2 = DBDSPool.getDBSQLResultSetDS(7937, this.id_, 0, 0);
                    if (!this.connectionReset_) {
                        this.connection_.send(request2, this.id_, false);
                    }
                }
                finally {
                    if (request2 != null) {
                        request2.returnToPool();
                        request2 = null;
                    }
                }
                if (this.commonExecuteReply != null) {
                    this.commonExecuteReply.returnToPool();
                    this.commonExecuteReply = null;
                }
                if (this.connectReply != null) {
                    this.connectReply.returnToPool();
                    this.connectReply = null;
                }
                if (this.execImmediateReply != null) {
                    this.execImmediateReply.returnToPool();
                    this.execImmediateReply = null;
                }
                if (this.normalPrepareReply != null) {
                    this.normalPrepareReply.returnToPool();
                    this.normalPrepareReply = null;
                }
                if (this.getMoreResultsReply != null) {
                    this.getMoreResultsReply.returnToPool();
                    this.getMoreResultsReply = null;
                }
                this.closed_ = true;
                this.connection_.notifyClose(this, this.id_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logClose(this);
                }
                if (e != null) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishClosing() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLException e = null;
            if (this.rpbCreated_) {
                DBBaseRequestDS request3 = null;
                DBReplyRequestedDS finishClosingReply = null;
                try {
                    request3 = DBDSPool.getDBSQLRPBDS(7426, this.id_, Integer.MIN_VALUE, 0);
                    finishClosingReply = this.connection_.sendAndReceive(request3, this.id_);
                    int errorClass = finishClosingReply.getErrorClass();
                    int returnCode = finishClosingReply.getReturnCode();
                    if (errorClass != 0) {
                        if (returnCode < 0) {
                            try {
                                JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                            }
                            catch (SQLException e2) {
                                e = e2;
                            }
                        } else {
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                        }
                    }
                }
                finally {
                    if (request3 != null) {
                        request3.returnToPool();
                        request3 = null;
                    }
                    if (finishClosingReply != null) {
                        finishClosingReply.returnToPool();
                        finishClosingReply = null;
                    }
                }
            }
            DBBaseRequestDS request2 = null;
            try {
                request2 = DBDSPool.getDBSQLResultSetDS(7937, this.id_, 0, 0);
                this.connection_.send(request2, this.id_, false);
            }
            finally {
                if (request2 != null) {
                    request2.returnToPool();
                    request2 = null;
                }
            }
            this.closed_ = true;
            this.setHoldStatement(false);
            this.connection_.notifyClose(this, this.id_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logClose(this);
            }
            if (e != null) {
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResultSet(int reuseFlag) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.resultSet_ != null) {
                if (!this.resultSet_.isClosed()) {
                    this.resultSet_.close();
                }
                this.resultSet_ = null;
            }
        }
        if (this.threadInterrupted) {
            try {
                this.cursor_.setState(false);
                this.cursor_.close(reuseFlag);
            }
            catch (Exception exception) {}
        } else if (!this.cursor_.isClosed()) {
            this.cursor_.close(reuseFlag);
        }
        this.updateCount_ = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commonExecute(JDSQLStatement sqlStatement, JDServerRow resultRow) throws SQLException {
        block82: {
            SQLException savedException = null;
            this.currentJDSQLStatement_ = sqlStatement;
            try {
                this.cancelled_ = false;
                if (this.connection_.isQueryTimeoutMechanismCancel()) {
                    this.startCancelThread();
                }
                if (sqlStatement.getNativeType() == 6 && !this.allowImmediate_) {
                    this.executeConnectStatement(sqlStatement);
                    break block82;
                }
                if (this.allowImmediate_ && sqlStatement.isImmediatelyExecutable()) break block82;
                if (this.autoGeneratedKeys_ == 1 && this.prefetch_) {
                    this.prefetch_ = false;
                }
                if (this.generatedKeys_ != null && !this.generatedKeys_.isClosed()) {
                    try {
                        this.generatedKeys_.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.syncRPB();
                boolean usedNameOverride = false;
                boolean openNeeded = resultRow != null;
                boolean fetchFirstBlock = this.prefetch_ && openNeeded;
                try {
                    int functionId = openNeeded ? (fetchFirstBlock ? 6158 : 6148) : 6149;
                    DBBaseRequestDS request = null;
                    int openAttributes = 0;
                    try {
                        String sqlState;
                        boolean isCall = sqlStatement.getNativeType() == 3;
                        int requestedORS = -2113929216;
                        boolean extendedMetaData = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540 && isCall && (extendedMetaData = this.connection_.getProperties().getBoolean(48))) {
                            requestedORS += 131072;
                        }
                        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
                            requestedORS += 32768;
                        }
                        request = DBDSPool.getDBSQLRequestDS(functionId, this.id_, requestedORS, 0);
                        openAttributes = this.cursor_.getOpenAttributes(sqlStatement, this.blockCriteria_);
                        if (openNeeded) {
                            if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm610) {
                                ((DBSQLRequestDS)request).setOpenAttributes(128);
                            } else {
                                ((DBSQLRequestDS)request).setOpenAttributes(openAttributes);
                            }
                        } else if (extendedMetaData) {
                            ((DBSQLRequestDS)request).setExtendedColumnDescriptorOption(-15);
                        }
                        ConvTable converter = this.connection_.getConverter();
                        if (this.nameOverride_.length() != 0) {
                            ((DBSQLRequestDS)request).setPrepareStatementName(this.nameOverride_, converter);
                            usedNameOverride = true;
                        }
                        if (this.packageManager_.isEnabled() && sqlStatement.isPackaged()) {
                            ((DBSQLRequestDS)request).setPackageName(this.packageManager_.getName(), converter);
                        }
                        String cursorSensitivity = this.connection_.getProperties().getString(49);
                        if (fetchFirstBlock) {
                            request.addOperationResultBitmap(0x4000000);
                            if (functionId == 6158 && this.useVariableFieldCompression_) {
                                ((DBSQLRequestDS)request).setVariableFieldCompression(true);
                                ((DBSQLRequestDS)request).setBufferSize(this.blockSize_ * 1024);
                            } else if (resultRow != null) {
                                ((DBSQLRequestDS)request).setBlockingFactor(this.getBlockingFactor(cursorSensitivity, sqlStatement, resultRow.getRowLength()));
                            } else {
                                ((DBSQLRequestDS)request).setBlockingFactor(this.getBlockingFactor(cursorSensitivity, sqlStatement, 0));
                            }
                        }
                        if (this.connection_.getVRM() < JDUtilities.vrm520) {
                            if (this.resultSetType_ == 1003) {
                                ((DBSQLRequestDS)request).setScrollableCursorFlag(0);
                            } else {
                                ((DBSQLRequestDS)request).setScrollableCursorFlag(1);
                            }
                        } else if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm610) {
                            ((DBSQLRequestDS)request).setScrollableCursorFlag(2);
                        } else {
                            ((DBSQLRequestDS)request).setScrollableCursorFlag(AS400JDBCResultSet.getDBSQLRequestDSCursorType(cursorSensitivity, this.resultSetType_, this.resultSetConcurrency_));
                        }
                        if (this.connection_.getVRM() >= JDUtilities.vrm520) {
                            if (this.resultSetHoldability_ == 2) {
                                ((DBSQLRequestDS)request).setResultSetHoldabilityOption((byte)-43);
                            } else if (this.resultSetHoldability_ == 1) {
                                ((DBSQLRequestDS)request).setResultSetHoldabilityOption((byte)-24);
                            }
                        }
                        this.disableRllCompression_ = false;
                        this.commonExecuteBefore(sqlStatement, (DBSQLRequestDS)request);
                        if (this.commonExecuteReply != null) {
                            this.commonExecuteReply.returnToPool();
                            this.commonExecuteReply = null;
                        }
                        if (this.disableRllCompression_) {
                            this.connection_.setDisableCompression(true);
                        }
                        this.commonExecuteReply = this.connection_.sendAndReceive(request, this.id_);
                        if (this.disableRllCompression_) {
                            this.connection_.setDisableCompression(false);
                        }
                        this.cursor_.processConcurrencyOverride(openAttributes, this.commonExecuteReply);
                        this.cursor_.processCursorAttributes(this.commonExecuteReply);
                        this.transactionManager_.processCommitOnReturn(this.commonExecuteReply);
                        Vector SQLCAs = this.commonExecuteReply.getSQLCAs();
                        DBReplySQLCA firstSqlca = null;
                        if (SQLCAs != null) {
                            firstSqlca = (DBReplySQLCA)SQLCAs.elementAt(0);
                        }
                        DBData resultData = null;
                        if (fetchFirstBlock) {
                            resultData = this.commonExecuteReply.getResultData();
                        }
                        if (firstSqlca != null) {
                            this.rowsInserted_ = firstSqlca.getErrd(3);
                        }
                        int errorClass = this.commonExecuteReply.getErrorClass();
                        int returnCode = this.commonExecuteReply.getReturnCode();
                        if (errorClass == 0) {
                            Enumeration enumeration = SQLCAs.elements();
                            while (enumeration.hasMoreElements()) {
                                DBReplySQLCA thisSqlca = (DBReplySQLCA)enumeration.nextElement();
                                String sqlState2 = thisSqlca.getSQLState(converter);
                                if (!"01004".equals(sqlState2)) continue;
                                errorClass = 2;
                            }
                        }
                        if (openNeeded && (errorClass != 1 || returnCode != -666)) {
                            this.cursor_.setState(false);
                        }
                        boolean lastBlock = false;
                        if ((errorClass == 1 && returnCode == 100 || errorClass == 2 && returnCode == 701) && functionId == 6158) {
                            lastBlock = true;
                            returnCode = firstSqlca.getSQLCode();
                            sqlState = firstSqlca.getSQLState(converter);
                        } else if (errorClass == 2 && returnCode == 700 && functionId == 6158) {
                            lastBlock = true;
                            this.cursor_.setState(true);
                            returnCode = firstSqlca.getSQLCode();
                            sqlState = firstSqlca.getSQLState(converter);
                        }
                        if (errorClass != 0) {
                            this.positionOfSyntaxError_ = firstSqlca.getErrd(5);
                            if (returnCode < 0) {
                                int errd6 = firstSqlca.getErrd(6);
                                String errp = firstSqlca.getErrp(converter);
                                if (errd6 == 1 || "QSQFETCH".equals(errp) && functionId == 6158) {
                                    try {
                                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                                    }
                                    catch (SQLException e) {
                                        savedException = e;
                                    }
                                } else {
                                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                                }
                            } else {
                                Enumeration enumeration = SQLCAs.elements();
                                while (enumeration.hasMoreElements()) {
                                    DBReplySQLCA thisSqlca = (DBReplySQLCA)enumeration.nextElement();
                                    String sqlState3 = thisSqlca.getSQLState(converter);
                                    if (sqlState3.startsWith("00") || sqlState3.startsWith("02")) continue;
                                    this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                                }
                            }
                        }
                        if (!(this.autoGeneratedKeys_ != 1 || this.connection_.getVRM() < JDUtilities.vrm520 || this.connection_.getVRM() >= JDUtilities.vrm610 && sqlStatement.isSelectFromInsert())) {
                            this.makeGeneratedKeyResultSet(returnCode, firstSqlca);
                        } else if (this.generatedKeys_ != null) {
                            this.generatedKeys_.close();
                            this.generatedKeys_ = null;
                        }
                        if (extendedMetaData) {
                            this.extendedColumnDescriptors_ = this.commonExecuteReply.getExtendedColumnDescriptors();
                        }
                        if (openNeeded) {
                            int actualConcurrency;
                            int rowLength = 0;
                            if (resultRow != null) {
                                rowLength = resultRow.getRowLength();
                            }
                            JDServerRowCache rowCache = fetchFirstBlock && resultData != null ? new JDServerRowCache(resultRow, this.connection_, this.id_, this.getBlockingFactor(cursorSensitivity, sqlStatement, rowLength), resultData, lastBlock, this.resultSetType_, this.cursor_) : new JDServerRowCache(resultRow, this.connection_, this.id_, this.getBlockingFactor(cursorSensitivity, sqlStatement, rowLength), lastBlock, this.resultSetType_, this.cursor_);
                            int n = actualConcurrency = this.resultSetConcurrency_ == 1008 ? this.cursor_.getConcurrency() : this.resultSetConcurrency_;
                            if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm610 && sqlStatement.isSelectFromInsert()) {
                                this.updateCount_ = firstSqlca.getErrd(3);
                                this.rowCountEstimate_ = -1;
                                this.generatedKeys_ = new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, 1004, 1007, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_);
                            } else {
                                this.updateCount_ = -1;
                                this.rowCountEstimate_ = firstSqlca.getErrd(3);
                                this.resultSet_ = new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, actualConcurrency, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_);
                                if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_ && this.resultSetConcurrency_ == 1008) {
                                    this.postWarning(JDError.getSQLWarning("01S02"));
                                }
                                if (savedException != null) {
                                    this.resultSet_.addSavedException(savedException);
                                }
                            }
                        } else {
                            this.updateCount_ = firstSqlca.getErrd(3);
                            this.rowCountEstimate_ = -1;
                        }
                        this.numberOfResults_ = isCall ? firstSqlca.getErrd(2) : 0;
                        if (extendedMetaData) {
                            this.extendedColumnDescriptors_ = this.commonExecuteReply.getExtendedColumnDescriptors();
                            this.cursor_.setExtendedMetaData(extendedMetaData);
                        }
                        if (sqlStatement != null && isCall && this.numberOfResults_ > 0 && this.resultSet_ == null) {
                            DBExtendedColumnDescriptors newExtendedColumnDescriptors;
                            boolean preV5R3;
                            boolean bl = preV5R3 = this.connection_.getVRM() < JDUtilities.vrm530;
                            int callResultSetType = this.resultSetType_ == 1003 ? 1003 : (this.cursor_.getCursorAttributeScrollable() == 0 ? 1003 : (this.cursor_.getCursorAttributeSensitive() == 0 ? 1004 : (this.cursor_.getCursorAttributeSensitive() == 1 ? 1005 : this.resultSetType_)));
                            JDServerRow row = new JDServerRow(this.connection_, this.id_, this.cursor_.openDescribe(openAttributes, callResultSetType), this.settings_);
                            JDServerRowCache rowCache = new JDServerRowCache(row, this.connection_, this.id_, this.getBlockingFactor(cursorSensitivity, sqlStatement, row.getRowLength()), false, preV5R3 ? 1003 : this.resultSetType_, this.cursor_);
                            if (extendedMetaData && (newExtendedColumnDescriptors = this.cursor_.getExtendedColumnDescriptors()) != null) {
                                this.extendedColumnDescriptors_ = newExtendedColumnDescriptors;
                            }
                            this.resultSet_ = preV5R3 ? new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, 1003, 1007, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_) : new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, callResultSetType, 1007, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_);
                            if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                                this.postWarning(JDError.getSQLWarning("01S02"));
                            }
                        }
                        this.commonExecuteAfter(sqlStatement, this.commonExecuteReply);
                    }
                    catch (SQLException sqlex) {
                        String messageText = sqlex.getMessage();
                        messageText = messageText.toLowerCase();
                        if (messageText.indexOf("internal driver error") >= 0 && messageText.indexOf("interrupted") > 0) {
                            this.threadInterrupted = true;
                        }
                        throw sqlex;
                    }
                    finally {
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (this.commonExecuteReply != null) {
                            this.commonExecuteReply.returnToPool();
                            this.commonExecuteReply = null;
                        }
                    }
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException("HY000", e);
                }
                this.transactionManager_.statementExecuted();
                if (this.cancelled_) {
                    JDError.throwSQLException("HY008");
                }
                if (sqlStatement.isSetSpecialRegister() && this.connection_ instanceof AS400JDBCConnectionRedirect) {
                    ((AS400JDBCConnectionRedirect)this.connection_).addSetCommand(sqlStatement.toString());
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executed " + (usedNameOverride ? this.nameOverride_ : this.name_ + "*") + ", SQL Statement --> [" + sqlStatement + "]");
                    JDTrace.logInformation(this, "Update count = " + this.updateCount_);
                    JDTrace.logInformation(this, "Result set = " + (this.resultSet_ != null));
                    JDTrace.logInformation(this, "Number of result sets = " + this.numberOfResults_);
                    JDTrace.logInformation(this, "Row count estimate = " + this.rowCountEstimate_);
                }
            }
            finally {
                if (this.connection_.isQueryTimeoutMechanismCancel()) {
                    this.endCancelThread();
                }
            }
        }
    }

    void commonExecuteAfter(JDSQLStatement sqlStatement, DBReplyRequestedDS reply) throws SQLException {
        this.currentJDSQLStatement_ = null;
    }

    void commonExecuteBefore(JDSQLStatement sqlStatement, DBSQLRequestDS request) throws SQLException {
        this.currentJDSQLStatement_ = sqlStatement;
        this.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDServerRow commonPrepare(JDSQLStatement sqlStatement) throws SQLException {
        JDServerRow resultRow = null;
        this.currentJDSQLStatement_ = sqlStatement;
        try {
            int i;
            if (this.connection_.isQueryTimeoutMechanismCancel()) {
                this.startCancelThread();
            }
            this.cancelled_ = false;
            this.connection_.checkAccess(sqlStatement);
            this.nameOverride_ = "";
            if (sqlStatement.isDRDAConnect()) {
                this.connection_.setDRDA(true);
            } else if (sqlStatement.isDRDADisconnect()) {
                this.connection_.setDRDA(false);
            }
            if (!this.packageManager_.isCreated()) {
                this.packageManager_.create();
            }
            if (this.packageManager_.isCached() && sqlStatement.isPackaged() && (i = this.packageManager_.getCachedStatementIndex(sqlStatement)) != -1) {
                DBDataFormat dataFormat = this.packageManager_.getCachedDataFormat(i);
                resultRow = dataFormat == null ? null : new JDServerRow(this.connection_, this.id_, dataFormat, this.settings_);
                if (resultRow != null && resultRow.containsLob_) {
                    resultRow = null;
                }
                this.commonPrepareBypass(sqlStatement, i);
                if (this.parameterRow_ != null && this.parameterRow_.containsLob_) {
                    this.nameOverride_ = "";
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Statement [" + sqlStatement + "] was found " + "in the cached package " + " but must be re-prepared since it contains a lob or locator");
                    }
                } else {
                    this.nameOverride_ = this.packageManager_.getCachedStatementName(i);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Statement [" + sqlStatement + "] was found " + "in the cached package as " + this.nameOverride_);
                    }
                }
            }
            if (this.nameOverride_.length() == 0) {
                if (sqlStatement.getNativeType() == 6) {
                    if (this.allowImmediate_) {
                        this.executeConnectStatement(sqlStatement);
                    }
                } else if (this.allowImmediate_ && sqlStatement.isImmediatelyExecutable()) {
                    this.syncRPB();
                    DBBaseRequestDS request = null;
                    try {
                        boolean isCall;
                        int requestedORS = -2113929216;
                        boolean bl = isCall = sqlStatement.getNativeType() == 3;
                        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
                            requestedORS += 32768;
                        }
                        boolean extendedMetaData = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm520 && (extendedMetaData = this.connection_.getProperties().getBoolean(48))) {
                            requestedORS += 131072;
                        }
                        request = DBDSPool.getDBSQLRequestDS(6150, this.id_, requestedORS, 0);
                        boolean extended = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            extended = true;
                        }
                        ((DBSQLRequestDS)request).setStatementText(sqlStatement.toString(), this.connection_.getPackageCCSID_Converter(), extended);
                        ((DBSQLRequestDS)request).setStatementType(sqlStatement.getNativeType());
                        int openAttributes = this.cursor_.getOpenAttributes(sqlStatement, this.blockCriteria_);
                        ((DBSQLRequestDS)request).setOpenAttributes(openAttributes);
                        ConvTable converter = this.connection_.getConverter();
                        if (this.packageManager_.isEnabled()) {
                            if (sqlStatement.isPackaged()) {
                                ((DBSQLRequestDS)request).setPrepareOption(1);
                                ((DBSQLRequestDS)request).setPackageName(this.packageManager_.getName(), converter);
                            } else {
                                ((DBSQLRequestDS)request).setPrepareOption(0);
                                ((DBSQLRequestDS)request).setPackageName(null, converter);
                            }
                        } else {
                            ((DBSQLRequestDS)request).setPrepareOption(0);
                        }
                        if (extendedMetaData) {
                            ((DBSQLRequestDS)request).setExtendedColumnDescriptorOption(-15);
                        }
                        this.commonPrepareBefore(sqlStatement, (DBSQLRequestDS)request);
                        this.commonExecuteBefore(sqlStatement, (DBSQLRequestDS)request);
                        if (this.connectReply != null) {
                            this.connectReply.returnToPool();
                            this.connectReply = null;
                        }
                        if (this.normalPrepareReply != null) {
                            this.normalPrepareReply.returnToPool();
                            this.normalPrepareReply = null;
                        }
                        if (this.execImmediateReply != null) {
                            this.execImmediateReply.returnToPool();
                            this.execImmediateReply = null;
                        }
                        this.execImmediateReply = this.connection_.sendAndReceive(request, this.id_);
                        int errorClass = this.execImmediateReply.getErrorClass();
                        int returnCode = this.execImmediateReply.getReturnCode();
                        Vector sqlcas = this.execImmediateReply.getSQLCAs();
                        DBReplySQLCA firstSqlca = (DBReplySQLCA)sqlcas.firstElement();
                        Enumeration elements = sqlcas.elements();
                        while (elements.hasMoreElements()) {
                            DBReplySQLCA sqlca = (DBReplySQLCA)elements.nextElement();
                            if (errorClass == 0) continue;
                            this.positionOfSyntaxError_ = sqlca.getErrd(5);
                            if (returnCode < 0) {
                                JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                                continue;
                            }
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                        }
                        this.transactionManager_.processCommitOnReturn(this.execImmediateReply);
                        this.cursor_.processCursorAttributes(this.execImmediateReply);
                        this.updateCount_ = firstSqlca.getErrd(3);
                        this.rowCountEstimate_ = -1;
                        if (extendedMetaData) {
                            this.extendedColumnDescriptors_ = this.execImmediateReply.getExtendedColumnDescriptors();
                        }
                        if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm520) {
                            this.makeGeneratedKeyResultSet(returnCode, firstSqlca);
                        } else if (this.generatedKeys_ != null) {
                            this.generatedKeys_.close();
                            this.generatedKeys_ = null;
                        }
                        this.numberOfResults_ = isCall ? firstSqlca.getErrd(2) : 0;
                        if (isCall && this.numberOfResults_ > 0) {
                            boolean preV5R3;
                            boolean bl2 = preV5R3 = this.connection_.getVRM() < JDUtilities.vrm530;
                            if (extendedMetaData) {
                                this.cursor_.setExtendedMetaData(extendedMetaData);
                            }
                            JDServerRow row = new JDServerRow(this.connection_, this.id_, this.cursor_.openDescribe(openAttributes, this.resultSetType_), this.settings_);
                            String cursorSensitivity = this.connection_.getProperties().getString(49);
                            JDServerRowCache rowCache = new JDServerRowCache(row, this.connection_, this.id_, this.getBlockingFactor(cursorSensitivity, sqlStatement, row.getRowLength()), false, preV5R3 ? 1003 : this.resultSetType_, this.cursor_);
                            this.resultSet_ = preV5R3 ? new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, 1003, 1007, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_) : new AS400JDBCResultSet(this, sqlStatement, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, 1007, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_);
                            if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                                this.postWarning(JDError.getSQLWarning("01S02"));
                            }
                        }
                        this.commonPrepareAfter(sqlStatement, this.execImmediateReply);
                        this.commonExecuteAfter(sqlStatement, this.execImmediateReply);
                    }
                    catch (DBDataStreamException e) {
                        JDError.throwSQLException("HY000", e);
                    }
                    finally {
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (this.execImmediateReply != null) {
                            this.execImmediateReply.returnToPool();
                            this.execImmediateReply = null;
                        }
                    }
                    this.transactionManager_.statementExecuted();
                    if (sqlStatement.isSetSpecialRegister() && this.connection_ instanceof AS400JDBCConnectionRedirect) {
                        ((AS400JDBCConnectionRedirect)this.connection_).addSetCommand(sqlStatement.toString());
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Executed immediately " + this.name_ + "*, SQL Statement -->[" + sqlStatement + "]");
                        JDTrace.logInformation(this, "Update count = " + this.updateCount_);
                        JDTrace.logInformation(this, "Result set = " + (this.resultSet_ != null));
                        JDTrace.logInformation(this, "Number of result sets = " + this.numberOfResults_);
                    }
                } else {
                    this.syncRPB();
                    DBBaseRequestDS request = null;
                    if (this.normalPrepareReply != null) {
                        this.normalPrepareReply.returnToPool();
                        this.normalPrepareReply = null;
                    }
                    try {
                        DBDataFormat dataFormat;
                        int requestedORS = -1979711488;
                        boolean extendedMetaData = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm520 && (extendedMetaData = this.connection_.getProperties().getBoolean(48))) {
                            requestedORS += 131072;
                        }
                        request = DBDSPool.getDBSQLRequestDS(6147, this.id_, requestedORS, 0);
                        boolean extended = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            extended = true;
                        }
                        ((DBSQLRequestDS)request).setStatementText(sqlStatement.toString(), this.connection_.getPackageCCSID_Converter(), extended);
                        ((DBSQLRequestDS)request).setStatementType(sqlStatement.getNativeType());
                        if (this.packageManager_.isEnabled()) {
                            ConvTable converter = this.connection_.getConverter();
                            if (sqlStatement.isPackaged()) {
                                ((DBSQLRequestDS)request).setPrepareOption(1);
                                ((DBSQLRequestDS)request).setPackageName(this.packageManager_.getName(), converter);
                            } else {
                                ((DBSQLRequestDS)request).setPrepareOption(0);
                                ((DBSQLRequestDS)request).setPackageName(null, converter);
                            }
                        } else {
                            ((DBSQLRequestDS)request).setPrepareOption(0);
                        }
                        if (extendedMetaData) {
                            ((DBSQLRequestDS)request).setExtendedColumnDescriptorOption(-15);
                        }
                        this.commonPrepareBefore(sqlStatement, (DBSQLRequestDS)request);
                        if (this.execImmediateReply != null) {
                            this.execImmediateReply.returnToPool();
                            this.execImmediateReply = null;
                        }
                        if (this.connectReply != null) {
                            this.connectReply.returnToPool();
                            this.connectReply = null;
                        }
                        if (this.normalPrepareReply != null) {
                            this.normalPrepareReply.returnToPool();
                            this.normalPrepareReply = null;
                        }
                        this.normalPrepareReply = this.connection_.sendAndReceive(request, this.id_);
                        int errorClass = this.normalPrepareReply.getErrorClass();
                        int returnCode = this.normalPrepareReply.getReturnCode();
                        if (errorClass != 0) {
                            this.positionOfSyntaxError_ = this.normalPrepareReply.getSQLCA().getErrd(5);
                            if (returnCode < 0) {
                                JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                            } else {
                                this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                            }
                        }
                        resultRow = (dataFormat = this.normalPrepareReply.getDataFormat()) == null ? null : new JDServerRow(this.connection_, this.id_, dataFormat, this.settings_);
                        if (extendedMetaData) {
                            this.extendedColumnDescriptors_ = this.normalPrepareReply.getExtendedColumnDescriptors();
                        }
                        this.commonPrepareAfter(sqlStatement, this.normalPrepareReply);
                    }
                    catch (DBDataStreamException e) {
                        JDError.throwSQLException("HY000", e);
                    }
                    finally {
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (this.normalPrepareReply != null) {
                            this.normalPrepareReply.returnToPool();
                            this.normalPrepareReply = null;
                        }
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Prepared " + this.name_ + "*, SQL Statement -->[" + sqlStatement + "]");
                    }
                }
            }
            if (this.cancelled_) {
                JDError.throwSQLException("HY008");
            }
        }
        finally {
            if (this.connection_.isQueryTimeoutMechanismCancel()) {
                this.endCancelThread();
            }
        }
        return resultRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeConnectStatement(JDSQLStatement sqlStatement) throws SQLException {
        this.syncRPB();
        DBBaseRequestDS request = null;
        try {
            request = DBDSPool.getDBSQLRequestDS(6153, this.id_, -2113929216, 0);
            boolean extended = false;
            if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                extended = true;
            }
            ((DBSQLRequestDS)request).setStatementText(sqlStatement.toString(), this.connection_.getPackageCCSID_Converter(), extended);
            ((DBSQLRequestDS)request).setStatementType(sqlStatement.getNativeType());
            ConvTable converter = this.connection_.getConverter();
            if (this.packageManager_.isEnabled()) {
                if (sqlStatement.isPackaged()) {
                    ((DBSQLRequestDS)request).setPrepareOption(1);
                    ((DBSQLRequestDS)request).setPackageName(this.packageManager_.getName(), converter);
                } else {
                    ((DBSQLRequestDS)request).setPrepareOption(0);
                    ((DBSQLRequestDS)request).setPackageName(null, converter);
                }
            } else {
                ((DBSQLRequestDS)request).setPrepareOption(0);
            }
            this.commonPrepareBefore(sqlStatement, (DBSQLRequestDS)request);
            this.commonExecuteBefore(sqlStatement, (DBSQLRequestDS)request);
            if (this.execImmediateReply != null) {
                this.execImmediateReply.returnToPool();
                this.execImmediateReply = null;
            }
            if (this.normalPrepareReply != null) {
                this.normalPrepareReply.returnToPool();
                this.normalPrepareReply = null;
            }
            if (this.connectReply != null) {
                this.connectReply.returnToPool();
                this.connectReply = null;
            }
            this.connectReply = this.connection_.sendAndReceive(request, this.id_);
            int errorClass = this.connectReply.getErrorClass();
            int returnCode = this.connectReply.getReturnCode();
            if (errorClass != 0) {
                this.positionOfSyntaxError_ = this.connectReply.getSQLCA().getErrd(5);
                if (returnCode < 0) {
                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                } else {
                    this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                }
            }
            this.updateCount_ = 0;
            this.numberOfResults_ = 0;
            this.commonPrepareAfter(sqlStatement, this.connectReply);
            this.commonExecuteAfter(sqlStatement, this.connectReply);
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (this.connectReply != null) {
                this.connectReply.returnToPool();
                this.connectReply = null;
            }
        }
        this.transactionManager_.statementExecuted();
        if (this.connection_ instanceof AS400JDBCConnectionRedirect) {
            ((AS400JDBCConnectionRedirect)this.connection_).addSetCommand(sqlStatement.toString());
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Executed connect " + this.name_ + "*, SQL Statement -->[" + sqlStatement + "]");
        }
    }

    void commonPrepareAfter(JDSQLStatement sqlStatement, DBReplyRequestedDS reply) throws SQLException {
        this.currentJDSQLStatement_ = sqlStatement;
    }

    void commonPrepareBefore(JDSQLStatement sqlStatement, DBSQLRequestDS request) throws SQLException {
        this.closeResultSet(241);
        this.currentJDSQLStatement_ = sqlStatement;
    }

    void commonPrepareBypass(JDSQLStatement sqlStatement, int statementIndex) throws SQLException {
        this.currentJDSQLStatement_ = sqlStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            JDSQLStatement sqlStatement;
            this.checkOpen();
            this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing SQL Statement -->[" + sqlStatement + "]");
            }
            JDServerRow resultRow = this.commonPrepare(sqlStatement);
            this.commonExecute(sqlStatement, resultRow);
            return this.resultSet_ != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException("IM001");
        }
        AS400JDBCStatement.verifyGeneratedKeysParameter(autoGeneratedKeys);
        this.autoGeneratedKeys_ = autoGeneratedKeys;
        if (this.connection_.getVRM() >= JDUtilities.vrm610 && this.autoGeneratedKeys_ == 1) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql);
                    sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    sqlStatement.setSelectFromInsert(true);
                    this.currentJDSQLStatement_ = sqlStatement;
                }
                JDServerRow resultRow = this.commonPrepare(sqlStatement);
                this.commonExecute(sqlStatement, resultRow);
                return this.resultSet_ != null;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql, columnIndexes, null);
                    this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    this.autoGeneratedKeys_ = 1;
                    sqlStatement.setSelectFromInsert(true);
                }
                JDServerRow resultRow = this.commonPrepare(sqlStatement);
                this.commonExecute(sqlStatement, resultRow);
                return this.resultSet_ != null;
            }
        }
        JDError.throwSQLException("IM001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql, null, columnNames);
                    this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    sqlStatement.setSelectFromInsert(true);
                    this.autoGeneratedKeys_ = 1;
                }
                JDServerRow resultRow = this.commonPrepare(sqlStatement);
                this.commonExecute(sqlStatement, resultRow);
                return this.resultSet_ != null;
            }
        }
        JDError.throwSQLException("IM001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            int batchSize = this.batch_.size();
            int[] updateCounts = new int[batchSize];
            int i = 0;
            try {
                Enumeration list = this.batch_.elements();
                while (list.hasMoreElements()) {
                    JDServerRow resultRow;
                    JDSQLStatement sqlStatement;
                    this.currentJDSQLStatement_ = sqlStatement = (JDSQLStatement)list.nextElement();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Executing from batch SQL Statement -->[" + sqlStatement + "]");
                    }
                    if ((resultRow = this.commonPrepare(sqlStatement)) != null) {
                        JDError.throwSQLException("24000");
                    }
                    this.commonExecute(sqlStatement, resultRow);
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException("24000");
                    }
                    updateCounts[i++] = this.updateCount_;
                }
            }
            catch (SQLException e) {
                int[] updateCounts2 = new int[i];
                System.arraycopy(updateCounts, 0, updateCounts2, 0, i);
                this.batch_.removeAllElements();
                BatchUpdateException throwException = new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), updateCounts2);
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
            this.batch_.removeAllElements();
            return updateCounts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            JDSQLStatement sqlStatement;
            this.checkOpen();
            this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing query, SQL Statement -->[" + sqlStatement + "]");
            }
            JDServerRow resultRow = this.commonPrepare(sqlStatement);
            this.commonExecute(sqlStatement, resultRow);
            if ((this.behaviorOverride_ & 1) == 0 && this.resultSet_ == null) {
                JDError.throwSQLException("24000");
            }
            return this.resultSet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            JDServerRow resultRow;
            JDSQLStatement sqlStatement;
            this.checkOpen();
            this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing update, SQL Statement -->[" + sqlStatement + "]");
            }
            if ((resultRow = this.commonPrepare(sqlStatement)) != null) {
                JDError.throwSQLException("24000");
            }
            this.commonExecute(sqlStatement, resultRow);
            if (this.resultSet_ != null) {
                this.closeResultSet(241);
                JDError.throwSQLException("24000");
            }
            return this.updateCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException("IM001");
        }
        AS400JDBCStatement.verifyGeneratedKeysParameter(autoGeneratedKeys);
        this.autoGeneratedKeys_ = autoGeneratedKeys;
        if (this.connection_.getVRM() >= JDUtilities.vrm610 && this.autoGeneratedKeys_ == 1) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql);
                    sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    this.currentJDSQLStatement_ = sqlStatement;
                    sqlStatement.setSelectFromInsert(true);
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    this.commonExecute(sqlStatement, resultRow);
                } else {
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    if (resultRow != null) {
                        JDError.throwSQLException("24000");
                    }
                    this.commonExecute(sqlStatement, resultRow);
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException("24000");
                    }
                }
                return this.updateCount_;
            }
        }
        return this.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing update, SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql, columnIndexes, null);
                    this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    sqlStatement.setSelectFromInsert(true);
                    this.autoGeneratedKeys_ = 1;
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    this.commonExecute(sqlStatement, resultRow);
                } else {
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    if (resultRow != null) {
                        JDError.throwSQLException("24000");
                    }
                    this.commonExecute(sqlStatement, resultRow);
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException("24000");
                    }
                }
                return this.updateCount_;
            }
        }
        JDError.throwSQLException("IM001");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.connection_.getVRM() >= JDUtilities.vrm610) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                JDSQLStatement sqlStatement;
                this.checkOpen();
                this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(sql, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executing update, SQL Statement -->[" + sqlStatement + "]");
                }
                if (sqlStatement.isInsert_) {
                    String selectStatement = this.connection_.makeGeneratedKeySelectStatement(sql, null, columnNames);
                    this.currentJDSQLStatement_ = sqlStatement = new JDSQLStatement(selectStatement, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Generated keys, SQL Statement -->[" + sqlStatement + "]");
                    }
                    sqlStatement.setSelectFromInsert(true);
                    this.autoGeneratedKeys_ = 1;
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    this.commonExecute(sqlStatement, resultRow);
                } else {
                    JDServerRow resultRow = this.commonPrepare(sqlStatement);
                    if (resultRow != null) {
                        JDError.throwSQLException("24000");
                    }
                    this.commonExecute(sqlStatement, resultRow);
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException("24000");
                    }
                }
                return this.updateCount_;
            }
        }
        JDError.throwSQLException("IM001");
        return 0;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.connection_.setInFinalizer(true);
            try {
                JDTrace.logInformation(this, "WARNING: Finalizer thread closing statement object.");
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection_.setInFinalizer(false);
        }
        super.finalize();
    }

    int getBlockingFactor(String cursorSensitivityProperty, JDSQLStatement sqlStatement, int rowLength) {
        int blockingFactor;
        boolean block = false;
        boolean useFetchSize = false;
        this.currentJDSQLStatement_ = sqlStatement;
        int requestDSCursorType = AS400JDBCResultSet.getDBSQLRequestDSCursorType(cursorSensitivityProperty, this.resultSetType_, this.resultSetConcurrency_);
        if (this.cursor_.getConcurrency() != 1008 && requestDSCursorType != 3 && requestDSCursorType != 4) {
            if (this.blockCriteria_.equalsIgnoreCase("0")) {
                block = true;
                useFetchSize = true;
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "getBlockingFactor(): Blocking -- blockCriteria_=" + this.blockCriteria_);
                }
            } else if (this.fetchSize_ > 1 && this.blockSize_ == 0) {
                block = true;
                useFetchSize = true;
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "getBlockingFactor(): Blocking -- fetchSize=" + this.fetchSize_);
                }
            } else if (sqlStatement != null) {
                if (this.blockCriteria_.equalsIgnoreCase("1") && sqlStatement.isForFetchOnly()) {
                    block = true;
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "getBlockingFactor(): Blocking -- blockCriteria_=" + this.blockCriteria_ + " and isForFetchOnly");
                    }
                } else if (this.blockCriteria_.equalsIgnoreCase("2") && !sqlStatement.isForUpdate()) {
                    block = true;
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "getBlockingFactor(): Blocking -- blockCriteria_=" + this.blockCriteria_ + " and isForFetchOnly");
                    }
                } else if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "getBlockingFactor(): Blocking =" + block + " blockCriteria=" + this.blockCriteria_);
                }
            } else if (this.blockCriteria_.equalsIgnoreCase("2")) {
                block = true;
            } else if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "getBlockingFactor(): Blocking =" + block + " blockCriteria=" + this.blockCriteria_ + " sqlStatement is null");
            }
        } else if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlockingFactor(): Not blocking -- concurrency=" + this.cursor_.getConcurrency() + " requestCursorType=" + requestDSCursorType);
        }
        if (block) {
            if (useFetchSize) {
                blockingFactor = this.fetchSize_;
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "getBlockingFactor: blockFactor taken from fetchSize_");
                }
            } else if (rowLength <= 0) {
                blockingFactor = 1;
            } else {
                blockingFactor = this.blockSize_ * 1024 / rowLength;
                if (blockingFactor > Short.MAX_VALUE) {
                    blockingFactor = Short.MAX_VALUE;
                } else if (blockingFactor <= 1) {
                    blockingFactor = 1;
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "getBlockingFactor: blockFactor is 1: blockSize_=" + this.blockSize_ + " rowLength=" + rowLength);
                    }
                }
            }
        } else {
            blockingFactor = 1;
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "getBlockingFactor: block=false so blockFactor is 1");
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlockingFactor: blockFactor is " + blockingFactor);
        }
        return blockingFactor;
    }

    public Connection getConnection() throws SQLException {
        return this.connection_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCursorName() {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            return this.cursor_.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchDirection_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchSize_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getGeneratedKeys() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.connection_.getVRM() < JDUtilities.vrm520) {
                JDError.throwSQLException("IM001");
                return null;
            }
            this.checkOpen();
            return this.generatedKeys_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFieldSize() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.maxFieldSize_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRows() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.maxRows_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getMoreResults() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "getMoreResults() numberOfResults=" + this.numberOfResults_);
            }
            this.cancelled_ = false;
            this.checkOpen();
            this.closeResultSet(242);
            if (--this.numberOfResults_ > 0) {
                DBBaseRequestDS request = null;
                boolean extendedMetaData = false;
                try {
                    DBExtendedColumnDescriptors newDescriptors;
                    if (this.connection_.getVRM() >= JDUtilities.vrm610) {
                        int requestedORS = -1979678720;
                        extendedMetaData = this.connection_.getProperties().getBoolean(48);
                        if (extendedMetaData) {
                            requestedORS += 131072;
                        }
                        request = DBDSPool.getDBSQLRequestDS(6148, this.id_, requestedORS, 0);
                    } else {
                        request = DBDSPool.getDBSQLRequestDS(6148, this.id_, -1979711488, 0);
                    }
                    int openAttributes = this.cursor_.getOpenAttributes(null, this.blockCriteria_);
                    ((DBSQLRequestDS)request).setOpenAttributes(openAttributes);
                    if (this.connection_.getVRM() >= JDUtilities.vrm530) {
                        String cursorSensitivity = this.connection_.getProperties().getString(49);
                        ((DBSQLRequestDS)request).setScrollableCursorFlag(AS400JDBCResultSet.getDBSQLRequestDSCursorType(cursorSensitivity, this.resultSetType_, this.resultSetConcurrency_));
                    }
                    if (this.getMoreResultsReply != null) {
                        this.getMoreResultsReply.returnToPool();
                        this.getMoreResultsReply = null;
                    }
                    this.getMoreResultsReply = this.connection_.sendAndReceive(request, this.id_);
                    DBDataFormat dataFormat = this.getMoreResultsReply.getDataFormat();
                    this.extendedColumnDescriptors_ = extendedMetaData ? ((newDescriptors = this.getMoreResultsReply.getExtendedColumnDescriptors()) != null ? newDescriptors : null) : null;
                    int errorClass = this.getMoreResultsReply.getErrorClass();
                    int returnCode = this.getMoreResultsReply.getReturnCode();
                    if (errorClass != 0) {
                        if (returnCode < 0) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logException(this, "Creation location", this.creationLocation_);
                                this.connection_.dumpStatementCreationLocation();
                            }
                            JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                        } else {
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                        }
                    }
                    if (this instanceof AS400JDBCCallableStatement) {
                        if (dataFormat == null) {
                            JDError.throwSQLException("HY000", "null dataFormat");
                            boolean bl = false;
                            return bl;
                        }
                        dataFormat.setCSRSData(true);
                    }
                    this.cursor_.setExtendedColumnDescriptorsFromReply(this.getMoreResultsReply);
                    this.cursor_.processConcurrencyOverride(openAttributes, this.getMoreResultsReply);
                    this.cursor_.processCursorAttributes(this.getMoreResultsReply);
                    this.cursor_.setState(false);
                    JDServerRow row = new JDServerRow(this.connection_, this.id_, dataFormat, this.settings_);
                    String cursorSensitivity = this.connection_.getProperties().getString(49);
                    JDServerRowCache rowCache = new JDServerRowCache(row, this.connection_, this.id_, this.getBlockingFactor(cursorSensitivity, null, row.getRowLength()), false, this.resultSetType_, this.cursor_);
                    int actualConcurrency = this.resultSetConcurrency_ == 1008 ? this.cursor_.getConcurrency() : this.resultSetConcurrency_;
                    this.resultSet_ = new AS400JDBCResultSet(this, null, rowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, actualConcurrency, this.fetchDirection_, this.fetchSize_, this.extendedColumnDescriptors_);
                    if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                        this.postWarning(JDError.getSQLWarning("01S02"));
                    }
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException("HY000", e);
                }
                finally {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (this.getMoreResultsReply != null) {
                        this.getMoreResultsReply.returnToPool();
                        this.getMoreResultsReply = null;
                    }
                }
            }
            if (this.cancelled_) {
                JDError.throwSQLException("HY008");
            }
            this.updateCount_ = -1;
            if (this.resultSet_ == null) return false;
            return true;
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1) {
            return this.getMoreResults();
        }
        JDError.throwSQLException("IM001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPositionOfSyntaxError() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionOfSyntaxError_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryTimeout() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.queryTimeout_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.resultSet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetConcurrency() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.resultSetConcurrency_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetHoldability() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.resultSet_ != null && !this.resultSet_.isClosed()) {
                return this.resultSet_.getHoldability();
            }
            if (this.resultSetHoldability_ == 1 || this.resultSetHoldability_ == 2) {
                return this.resultSetHoldability_;
            }
            return this.connection_.getHoldability();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetType() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.resultSetType_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.resultSet_ != null ? -1 : this.updateCount_;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    void setHoldStatement(boolean hold) {
        this.holdStatement_ = hold;
    }

    boolean isHoldStatement() {
        return this.holdStatement_;
    }

    void setAssociatedWithLocators(boolean hasLocator) {
        this.associatedWithLocators_ = hasLocator;
    }

    boolean isAssociatedWithLocators() {
        return this.associatedWithLocators_;
    }

    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    private void makeGeneratedKeyResultSet(int returnCode, DBReplySQLCA sqlca) throws SQLException {
        if (this.generatedKeys_ != null) {
            this.generatedKeys_.close();
        }
        BigDecimal generatedKey = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "returnCode is: " + returnCode);
        }
        if (returnCode < 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "return code was not 0, generated key is null");
            }
        } else {
            generatedKey = sqlca.getGeneratedKey();
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "generated key from system is: " + generatedKey);
            }
        }
        String[] fieldNames = new String[]{""};
        SQLData[] sqlData = new SQLData[]{new SQLDecimal(30, 0, this.settings_, this.connection_.getVRM(), this.connection_.getProperties())};
        int[] fieldNullables = new int[]{0};
        JDSimpleRow formatRow = new JDSimpleRow(fieldNames, sqlData, fieldNullables);
        boolean[][] nulls = new boolean[][]{{false}};
        boolean[][] dataMappingErrors = new boolean[][]{{false}};
        JDSimpleRowCache rowCache = null;
        if (generatedKey == null) {
            rowCache = new JDSimpleRowCache(formatRow);
        } else {
            Object[][] data = new Object[][]{{generatedKey}};
            rowCache = new JDSimpleRowCache(formatRow, data, nulls, dataMappingErrors);
        }
        this.generatedKeys_ = new AS400JDBCResultSet(rowCache, "", "", this.connection_, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markCursorClosed(boolean isRollback) throws SQLException {
        boolean rollbackCursorHold = this.connection_.getProperties().getBoolean(64);
        if (rollbackCursorHold) {
            isRollback = false;
        }
        if ((this.getResultSetHoldability() == 2 || isRollback) && (this.connection_.getVRM() <= JDUtilities.vrm610 || this.connection_.getVRM() >= JDUtilities.vrm710 && this.cursor_.getCursorIsolationLevel() != 0)) {
            AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
            synchronized (aS400JDBCStatementLock) {
                if (this.resultSet_ != null) {
                    if (!this.resultSet_.isClosed()) {
                        this.resultSet_.close();
                    }
                    this.resultSet_ = null;
                }
            }
            this.updateCount_ = -1;
        }
    }

    void notifyClose() throws SQLException {
        if (!this.cursor_.isClosed()) {
            if (this.numberOfResults_ > 1) {
                this.cursor_.close(242);
            } else {
                this.cursor_.close(241);
            }
        }
        if (this.closeOnCompletion_ && this.numberOfResults_ <= 1) {
            this.close();
        }
    }

    void postWarning(SQLWarning sqlWarning) {
        if (this.connection_ != null && this.connection_.ignoreWarning(sqlWarning)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "postWarning(" + sqlWarning + ") -- ignored");
            }
        } else {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "postWarning(" + sqlWarning + ")");
            }
            if (this.sqlWarning_ == null) {
                this.sqlWarning_ = sqlWarning;
            } else {
                this.sqlWarning_.setNextWarning(sqlWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorName(String cursorName) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            int maxLength;
            this.checkOpen();
            if (this.resultSet_ != null) {
                if (!this.resultSet_.isClosed()) {
                    JDError.throwSQLException("24000");
                } else {
                    this.closeResultSet(241);
                }
            }
            if (cursorName == null) {
                cursorName = this.cursorDefaultName_;
            }
            int cursorNameLength = cursorName.length();
            int n = maxLength = this.connection_.getVRM() >= JDUtilities.vrm610 ? 128 : 18;
            if (cursorNameLength > maxLength || cursorNameLength == 0) {
                JDError.throwSQLException("34000");
            }
            if (!cursorName.equals(this.cursor_.getName())) {
                if (this.connection_.isCursorNameUsed(cursorName)) {
                    JDError.throwSQLException("3C000");
                }
                this.cursor_.setName(cursorName);
                this.rpbSyncNeeded_ = true;
                this.connectionReset_ = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.escapeProcessing_ = escapeProcessing;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Escape processing", this.escapeProcessing_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int fetchDirection) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (fetchDirection != 1000 && fetchDirection != 1001 && fetchDirection != 1002 || this.resultSetType_ == 1003 && fetchDirection != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = fetchDirection;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Fetch direction", this.fetchDirection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int fetchSize) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (fetchSize < 0 || fetchSize > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = fetchSize;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Fetch size", this.fetchSize_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (maxFieldSize < 0) {
                JDError.throwSQLException("HY024");
            }
            this.maxFieldSize_ = maxFieldSize;
            this.settings_ = SQLConversionSettings.getConversionSettingsWithMaxFieldSize(this.settings_, maxFieldSize);
            if (this.parameterRow_ != null) {
                this.parameterRow_.updateSettings(this.settings_);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Max field size", this.maxFieldSize_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int maxRows) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (maxRows < 0) {
                JDError.throwSQLException("HY024");
            }
            this.maxRows_ = maxRows;
            this.longMaxRows_ = maxRows;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Max rows", this.maxRows_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (queryTimeout < 0) {
                JDError.throwSQLException("HY024");
            }
            if (this.queryTimeout_ != queryTimeout || !this.queryTimeoutSet_) {
                this.queryTimeoutSet_ = true;
                this.queryTimeout_ = queryTimeout;
                this.rpbSyncNeeded_ = true;
                this.rpbQueryTimeoutChanged_ = true;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "set..", "Query timeout", this.queryTimeout_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRPB() throws SQLException {
        if (this.rpbSyncNeeded_) {
            int functionId = this.rpbCreated_ ? 7427 : 7424;
            DBBaseRequestDS request = null;
            try {
                String rpbDescOpt;
                ConvTable converter = this.connection_.getConverter();
                request = DBDSPool.getDBSQLRPBDS(functionId, this.id_, 0, 0);
                ((DBSQLRPBDS)request).setPrepareStatementName(this.name_, converter);
                ((DBSQLRPBDS)request).setCursorName(this.cursor_.getName(), converter);
                if (this.packageManager_.isEnabled()) {
                    ((DBSQLRPBDS)request).setLibraryName(this.packageManager_.getLibraryName(), converter);
                }
                if (this.rpbQueryTimeoutChanged_) {
                    if (this.queryTimeout_ > 0 && !this.connection_.isQueryTimeoutMechanismCancel()) {
                        ((DBSQLRPBDS)request).setQueryTimeout(this.queryTimeout_);
                    } else {
                        ((DBSQLRPBDS)request).setQueryTimeout(-1);
                    }
                }
                if (!this.connection_.getMustSpecifyForUpdate() && this.resultSetConcurrency_ == 1008) {
                    ((DBSQLRPBDS)request).setOpenAttributes(240);
                }
                if (null != (rpbDescOpt = this.connection_.getProperties().getString(85)) && rpbDescOpt.length() > 0) {
                    if (rpbDescOpt.equals("system names")) {
                        ((DBSQLRPBDS)request).setDescribeOption(226);
                    } else if (rpbDescOpt.equals("long names")) {
                        ((DBSQLRPBDS)request).setDescribeOption(213);
                    } else if (rpbDescOpt.equals("labels")) {
                        ((DBSQLRPBDS)request).setDescribeOption(211);
                    }
                }
                this.connection_.send(request, this.id_);
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
            finally {
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
            }
            this.rpbCreated_ = true;
            this.rpbSyncNeeded_ = false;
            this.connectionReset_ = false;
        }
    }

    public String toString() {
        return this.name_;
    }

    static final void verifyGeneratedKeysParameter(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            JDError.throwSQLException("HY024");
        }
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        this.isPoolable_ = poolable;
    }

    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return this.isPoolable_;
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCStatement", "java.sql.Statement"};
    }

    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion_ = true;
    }

    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion_;
    }

    protected void startCancelThread() {
        if (this.queryTimeoutSet_ && this.queryTimeout_ != 0) {
            this.queryRunning_ = true;
            this.cancelThread_ = new AS400JDBCQueryCancelThread(this);
            this.cancelThread_.setDaemon(true);
            this.cancelThread_.start();
        }
    }

    protected void endCancelThread() {
        if (this.queryTimeout_ != 0) {
            this.queryRunning_ = false;
            this.cancelThread_.statement_ = null;
            this.cancelThread_.interrupt();
        }
    }

    public long getLargeUpdateCount() throws SQLException {
        return this.getUpdateCount();
    }

    public void setLargeMaxRows(long max) throws SQLException {
        int intMax = (int)max;
        if (max > Integer.MAX_VALUE) {
            intMax = 0;
        }
        this.setMaxRows(intMax);
        this.longMaxRows_ = max;
    }

    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.longMaxRows_;
    }

    public long[] executeLargeBatch() throws SQLException {
        int[] results = this.executeBatch();
        long[] longResults = new long[results.length];
        for (int i = 0; i < results.length; ++i) {
            longResults[i] = results[i];
        }
        return longResults;
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql);
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql, autoGeneratedKeys);
    }

    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, columnIndexes);
    }

    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, columnNames);
    }

    JDSQLStatement getJDSQLStatement() {
        return this.currentJDSQLStatement_;
    }

    void setConnectionReset(boolean reset) {
        this.rpbSyncNeeded_ = true;
        this.rpbCreated_ = false;
        this.connectionReset_ = reset;
    }

    JDCursor getCursor() {
        return this.cursor_;
    }

    AS400JDBCStatementLock getInternalLock() {
        return this.internalLock_;
    }

    int getInternalResultSetHoldability() {
        return this.resultSetHoldability_;
    }

    boolean isQueryRunning() {
        return this.queryRunning_;
    }

    int getInternalQueryTimeout() {
        return this.queryTimeout_;
    }
}

