/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AS400Timestamp
extends AS400AbstractTime {
    private static final long serialVersionUID = 1L;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");
    private static final BigInteger ONE_MILLION = new BigInteger("1000000");
    private static final BigInteger DTS_CONVERSION_FACTOR = new BigInteger("946684800000000");
    private static final String PARSING_PATTERN = "yyyy-MM-dd-HH.mm.ss";
    private Timestamp defaultValue_;
    private transient SimpleDateFormat dateFormatterWithMillis_;
    public static final int FORMAT_DEFAULT = 0;
    static final int FORMAT_DTS = 1;

    public AS400Timestamp() {
        this.setFormat(0, HYPHEN);
    }

    public AS400Timestamp(TimeZone timeZone) {
        super(timeZone);
        this.setFormat(0, HYPHEN);
    }

    public AS400Timestamp(TimeZone timeZone, int dataLength) {
        super(timeZone);
        this.setFormat(0, HYPHEN);
        this.setDataLength(dataLength);
    }

    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new Timestamp(0L);
        }
        return this.defaultValue_;
    }

    public int getInstanceType() {
        return 19;
    }

    public Class getJavaType() {
        return Timestamp.class;
    }

    void setFormat(int format) {
        super.setFormat(format);
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        return super.toBytes(javaValue, as400Value, offset);
    }

    public Object toObject(byte[] as400Value, int offset) {
        if (as400Value == null) {
            throw new NullPointerException("as400Value");
        }
        Timestamp dateObj = null;
        switch (this.getFormat()) {
            case 0: {
                String timestampString = this.getCharConverter().byteArrayToString(as400Value, offset, this.getLength());
                dateObj = this.parse(timestampString);
                break;
            }
            case 1: {
                byte[] bytes9 = new byte[9];
                System.arraycopy(as400Value, offset, bytes9, 1, 8);
                BigInteger bits0to63 = new BigInteger(bytes9);
                byte[] dts2000 = new byte[]{0, -128, 0, 0, 0, 0, 0, 0, 0};
                BigInteger basedOn2000 = bits0to63.subtract(new BigInteger(dts2000));
                BigInteger microsElapsedSince2000 = basedOn2000.shiftRight(12);
                BigInteger microsElapsedSince1970 = microsElapsedSince2000.add(DTS_CONVERSION_FACTOR);
                long millisSince1970 = microsElapsedSince1970.divide(ONE_THOUSAND).longValue();
                dateObj = new Timestamp(millisSince1970);
                int microsIntoSecond = microsElapsedSince1970.mod(ONE_MILLION).intValue();
                dateObj.setNanos(1000 * microsIntoSecond);
                break;
            }
            default: {
                throw new InternalErrorException(6, "Unrecognized format: " + this.getFormat(), null);
            }
        }
        return dateObj;
    }

    public Timestamp toTimestamp(byte[] as400Value) {
        return (Timestamp)this.toObject(as400Value, 0);
    }

    public Timestamp toTimestamp(byte[] as400Value, int offset) {
        return (Timestamp)this.toObject(as400Value, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date toDate(Timestamp timestamp, TimeZone timezone) {
        Date dateObj;
        if (timestamp == null) {
            throw new NullPointerException("timestamp");
        }
        if (timezone == null) {
            throw new NullPointerException("timezone");
        }
        if (timezone.equals(AS400AbstractTime.TIMEZONE_GMT)) {
            return timestamp;
        }
        long millisSince1970 = timestamp.getTime();
        int nanosIntoSecond = timestamp.getNanos();
        int nanosIntoMillisecond = nanosIntoSecond % 1000000;
        if (nanosIntoMillisecond >= 500000) {
            ++millisSince1970;
        }
        AS400Timestamp aS400Timestamp = this;
        synchronized (aS400Timestamp) {
            this.getCalendar().setTimeInMillis(millisSince1970);
            dateObj = this.getCalendar().getTime();
        }
        String dateAsString = this.getDateFormatterWithMillis(AS400AbstractTime.TIMEZONE_GMT).format(dateObj);
        try {
            return this.getDateFormatterWithMillis(timezone).parse(dateAsString);
        }
        catch (ParseException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object javaValue) {
        int era;
        int year;
        Timestamp timestampObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timestampObj = (Timestamp)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        int nanosIntoSecond = timestampObj.getNanos();
        int microsIntoSecond = nanosIntoSecond / 1000;
        int nanosIntoMicrosecond = nanosIntoSecond % 1000;
        if (nanosIntoMicrosecond >= 500 && ++microsIntoSecond > 999999) {
            Timestamp newObj;
            timestampObj = newObj = new Timestamp(timestampObj.getTime() + 1000L);
            microsIntoSecond = 0;
        }
        AS400Timestamp aS400Timestamp = this;
        synchronized (aS400Timestamp) {
            GregorianCalendar cal = this.getCalendar(timestampObj);
            year = cal.get(1);
            era = cal.get(0);
        }
        if (year < 1 || year > 9999) {
            throw new ExtendedIllegalArgumentException("javaValue (year=" + year + ")", 4);
        }
        if (era == 0) {
            throw new ExtendedIllegalArgumentException("javaValue (era=0)", 4);
        }
        String micros = AS400Timestamp.to6Digits(microsIntoSecond);
        return this.getDateFormatter().format(timestampObj) + "." + micros;
    }

    public Timestamp parse(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (source.length() < 19) {
            Trace.log(2, "Timestamp string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()) + ".ssssss");
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2);
        }
        try {
            Date dateObjWithoutMicros = this.getDateFormatter().parse(source.substring(0, 19));
            Timestamp timestampObj = new Timestamp(dateObjWithoutMicros.getTime());
            if (source.length() > 19) {
                while (source.length() < 26) {
                    source = source + "0";
                }
                int microsIntoSecond = Integer.parseInt(source.substring(20));
                timestampObj.setNanos(1000 * microsIntoSecond);
            }
            return timestampObj;
        }
        catch (Exception e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Timestamp string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()) + ".ssssss");
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2, e);
        }
    }

    public static Timestamp parseXsdString(String source) {
        return AS400Timestamp.parseXsdString(source, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static Timestamp parseXsdString(String source, TimeZone timeZone) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            int nanos = 0;
            String withoutNanos = source.substring(0, 19);
            if (source.length() > 20) {
                StringBuffer fractionalSeconds = new StringBuffer(source.substring(20));
                int numZerosToAdd = 9 - fractionalSeconds.length();
                for (int i = 0; i < numZerosToAdd; ++i) {
                    fractionalSeconds.append('0');
                }
                nanos = Integer.parseInt(fractionalSeconds.toString());
            }
            Date simpleDateObj = AS400Timestamp.getTimestampFormatterXSD(timeZone).parse(withoutNanos);
            Timestamp timestampObj = new Timestamp(simpleDateObj.getTime());
            timestampObj.setNanos(nanos);
            return timestampObj;
        }
        catch (ParseException e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Timestamp string is expected to be in standard XML Schema 'timestamp' format: yyyy-MM-dd'T'HH:mm:ss.sssssssss");
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2, e);
        }
    }

    public static String toXsdString(Object javaValue) {
        return AS400Timestamp.toXsdString(javaValue, TIMEZONE_GMT);
    }

    public static String toXsdString(Object javaValue, TimeZone timeZone) {
        Timestamp timestampObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timestampObj = (Timestamp)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        StringBuffer timestampString = new StringBuffer(AS400Timestamp.getTimestampFormatterXSD(timeZone).format(timestampObj));
        timestampString.append('.');
        timestampString.append(AS400Timestamp.to9Digits(timestampObj.getNanos()));
        return timestampString.toString();
    }

    String patternFor(int format, Character separator) {
        return PARSING_PATTERN;
    }

    Character defaultSeparatorFor(int format) {
        return HYPHEN;
    }

    private synchronized SimpleDateFormat getDateFormatterWithMillis(TimeZone timezone) {
        if (this.dateFormatterWithMillis_ == null) {
            this.dateFormatterWithMillis_ = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss.SSS");
            this.dateFormatterWithMillis_.setTimeZone(timezone);
        } else if (!this.dateFormatterWithMillis_.getTimeZone().equals(timezone)) {
            this.dateFormatterWithMillis_.setTimeZone(timezone);
        }
        return this.dateFormatterWithMillis_;
    }

    boolean isValidFormat(int format) {
        return AS400Timestamp.validateFormat(format);
    }

    static boolean validateFormat(int format) {
        return format >= 0 && format <= 1;
    }

    static int getByteLength(int format) {
        switch (format) {
            case 1: {
                return 8;
            }
        }
        return 26;
    }

    int lengthFor(int format) {
        return AS400Timestamp.getByteLength(format);
    }

    static final String to6Digits(int value) {
        if (value < 0 || value > 999999) {
            throw new InternalErrorException(6, "to6Digits(" + value + ")", null);
        }
        StringBuffer buf = new StringBuffer(Integer.toString(value));
        int zerosToPrepend = 6 - buf.length();
        for (int i = 0; i < zerosToPrepend; ++i) {
            buf.insert(0, '0');
        }
        return buf.toString();
    }

    static final String to9Digits(int value) {
        if (value < 0 || value > 999999999) {
            throw new InternalErrorException(6, "to9Digits(" + value + ")", null);
        }
        StringBuffer buf = new StringBuffer(Integer.toString(value));
        int zerosToPrepend = 9 - buf.length();
        for (int i = 0; i < zerosToPrepend; ++i) {
            buf.insert(0, '0');
        }
        return buf.toString();
    }
}

