/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public class AS400Varchar
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length_;
    private int ccsid_ = 65535;
    private transient String encoding_ = null;
    private AS400 system_;
    transient ConverterImpl tableImpl_;
    private static final String defaultValue_ = "";
    private int varlensize_ = 2;

    public AS400Varchar(int varlensize, int length) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (varlensize < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", length);
            throw new ExtendedIllegalArgumentException("varlensize (" + varlensize + ")", 2);
        }
        this.varlensize_ = varlensize;
        this.length_ = length;
    }

    public AS400Varchar(int varlensize, int length, int ccsid) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (varlensize < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", length);
            throw new ExtendedIllegalArgumentException("varlensize (" + varlensize + ")", 2);
        }
        this.varlensize_ = varlensize;
        this.length_ = length;
        this.ccsid_ = ccsid;
    }

    public AS400Varchar(int varlensize, int length, String encoding) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (encoding == null) {
            Trace.log(2, "Parameter 'encoding' is null.");
            throw new NullPointerException("encoding");
        }
        if (varlensize < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", length);
            throw new ExtendedIllegalArgumentException("varlensize (" + varlensize + ")", 2);
        }
        this.varlensize_ = varlensize;
        this.length_ = length;
        this.encoding_ = encoding;
    }

    public AS400Varchar(int varlensize, int length, AS400 system) {
        this(varlensize, length, 65535, system);
    }

    public AS400Varchar(int varlensize, int length, int ccsid, AS400 system) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (varlensize < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", length);
            throw new ExtendedIllegalArgumentException("varlensize (" + varlensize + ")", 2);
        }
        this.varlensize_ = varlensize;
        this.length_ = length;
        this.ccsid_ = ccsid;
        this.system_ = system;
    }

    AS400Varchar(int length, int ccsid, AS400Impl system) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = length;
        this.ccsid_ = ccsid;
    }

    AS400Varchar(int varlensize, int length, int ccsid, AS400Impl system) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (varlensize < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", length);
            throw new ExtendedIllegalArgumentException("varlensize (" + varlensize + ")", 2);
        }
        this.varlensize_ = varlensize;
        this.length_ = length;
        this.ccsid_ = ccsid;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected CloneNotSupportedException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    public int getByteLength() {
        return this.length_ + this.varlensize_;
    }

    public int getVarLengthSize() {
        return this.varlensize_;
    }

    public int getCcsid() {
        if (this.ccsid_ == 65535) {
            this.setTable();
        }
        return this.ccsid_;
    }

    ConverterImpl getConverter() {
        this.setTable();
        return this.tableImpl_;
    }

    public Object getDefaultValue() {
        return defaultValue_;
    }

    public String getEncoding() {
        if (this.encoding_ == null) {
            this.setTable();
        }
        return this.encoding_;
    }

    public int getInstanceType() {
        return 20;
    }

    public Class getJavaType() {
        return String.class;
    }

    void setConverter(AS400 system) {
        this.system_ = system;
        this.setTable();
    }

    void setConverter(ConverterImpl converter) {
        this.tableImpl_ = converter;
        this.ccsid_ = this.tableImpl_.getCcsid();
    }

    private void setTable() {
        if (this.tableImpl_ == null) {
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Varchar object initializing, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_);
            }
            if (this.encoding_ != null) {
                try {
                    Converter table = new Converter(this.encoding_);
                    this.ccsid_ = table.getCcsid();
                    this.tableImpl_ = table.impl;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExtendedIllegalArgumentException("encoding (" + this.encoding_ + ")", 2);
                }
            }
            try {
                if (this.system_ == null) {
                    Converter table;
                    if (this.ccsid_ == 65535) {
                        table = new Converter();
                        this.ccsid_ = table.getCcsid();
                    } else {
                        table = new Converter(this.ccsid_);
                    }
                    this.tableImpl_ = table.impl;
                } else {
                    if (this.ccsid_ == 65535) {
                        this.ccsid_ = this.system_.getCcsid();
                    }
                    Converter table = new Converter(this.ccsid_, this.system_);
                    this.tableImpl_ = table.impl;
                }
                this.encoding_ = this.tableImpl_.getEncoding();
            }
            catch (UnsupportedEncodingException e) {
                Trace.log(2, "Value of parameter 'ccsid' is not valid:", this.ccsid_);
                throw new ExtendedIllegalArgumentException("ccsid (" + this.ccsid_ + ")", 2);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Varchar object initialized, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_ + ", table: " + this.tableImpl_);
            }
        }
    }

    public byte[] toBytes(Object javaValue) {
        byte[] serverValue = new byte[this.length_ + this.varlensize_];
        this.toBytes(javaValue, serverValue, 2);
        return serverValue;
    }

    public int toBytes(Object javaValue, byte[] serverValue) {
        return this.toBytes(javaValue, serverValue, 0);
    }

    public int toBytes(Object javaValue, byte[] serverValue, int offset) {
        if (this.system_ != null && !this.system_.bidiAS400Varchar) {
            return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(AS400BidiTransform.getStringType(this.system_.getCcsid())));
        }
        return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public int toBytes(Object javaValue, byte[] serverValue, int offset, int type) {
        return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(type));
    }

    public int toBytes(Object javaValue, byte[] serverValue, int offset, BidiConversionProperties properties) {
        int eValueLength;
        if (javaValue == null) {
            Trace.log(2, "Parameter 'javaValue' is null.");
            throw new NullPointerException("javaValue");
        }
        this.setTable();
        String toConvert = (String)javaValue;
        byte[] eValue = this.tableImpl_.stringToByteArray(toConvert, properties);
        int n = eValueLength = eValue != null ? eValue.length : 0;
        if (eValueLength > this.length_) {
            Trace.log(2, "Length of parameter 'javaValue' is not valid: '" + javaValue + "'");
            throw new ExtendedIllegalArgumentException("javaValue (" + toConvert + ")", 1);
        }
        int varOffset = offset + this.varlensize_;
        if (this.varlensize_ == 2) {
            BinaryConverter.shortToByteArray((short)eValueLength, serverValue, 0);
        } else {
            BinaryConverter.intToByteArray(eValueLength, serverValue, 0);
        }
        System.arraycopy(eValue, 0, serverValue, varOffset, eValue.length);
        if (Trace.traceOn_) {
            Trace.log(5, "AS400Varchar.toBytes(): Converted javaValue (" + toConvert + ") to:", serverValue, varOffset, this.length_);
        }
        return this.length_ + this.varlensize_;
    }

    public Object toObject(byte[] serverValue) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (serverValue.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + serverValue.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, this.varlensize_, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toObject(byte[] serverValue, int offset) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (serverValue.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + serverValue.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, offset + this.varlensize_, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toObject(byte[] serverValue, int offset, int type) {
        return this.toObject(serverValue, offset + this.varlensize_, new BidiConversionProperties(type));
    }

    public Object toObject(byte[] serverValue, int offset, BidiConversionProperties properties) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (serverValue.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + serverValue.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, offset + this.varlensize_, this.length_, properties);
    }

    private int getSystemBidiType() {
        if (this.system_ == null) {
            return 0;
        }
        return this.system_.getBidiStringType();
    }
}

