/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.BaseDataQueueImpl;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProxyClientConnection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class BaseDataQueueImplProxy
extends AbstractProxyImpl
implements BaseDataQueueImpl {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    BaseDataQueueImplProxy() {
        super("BaseDataQueue");
    }

    public void setSystemAndPath(AS400Impl system, String path, String name, String library) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "setSystemAndPath", new Class[]{AS400Impl.class, String.class, String.class, String.class}, new Object[]{system, path, name, library});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void clear(byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        try {
            this.connection_.callMethod(this.pxId_, "clear", new Class[]{byte[].class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IllegalObjectTypeException) {
                throw (IllegalObjectTypeException)target;
            }
            throw ProxyClientConnection.rethrow5(e);
        }
    }

    public void create(int maxEntryLength, String authority, boolean saveSenderInformation, boolean FIFO, int keyLength, boolean forceToAuxiliaryStorage, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        try {
            this.connection_.callMethod(this.pxId_, "create", new Class[]{Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, String.class}, new Object[]{new Integer(maxEntryLength), authority, new Boolean(saveSenderInformation), new Boolean(FIFO), new Integer(keyLength), new Boolean(forceToAuxiliaryStorage), description});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow6(e);
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        try {
            this.connection_.callMethod(this.pxId_, "delete");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow5(e);
        }
    }

    public DQReceiveRecord read(String search, int wait, boolean peek, byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        try {
            return (DQReceiveRecord)this.connection_.callMethod(this.pxId_, "read", new Class[]{String.class, Integer.TYPE, Boolean.TYPE, byte[].class}, new Object[]{search, new Integer(wait), new Boolean(peek), key}, true).getReturnValue();
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IllegalObjectTypeException) {
                throw (IllegalObjectTypeException)target;
            }
            throw ProxyClientConnection.rethrow5(e);
        }
    }

    public DQQueryRecord retrieveAttributes(boolean keyed) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        try {
            return (DQQueryRecord)this.connection_.callMethod(this.pxId_, "retrieveAttributes", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(keyed)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IllegalObjectTypeException) {
                throw (IllegalObjectTypeException)target;
            }
            throw ProxyClientConnection.rethrow5(e);
        }
    }

    public void write(byte[] key, byte[] data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        try {
            this.connection_.callMethod(this.pxId_, "write", new Class[]{byte[].class, byte[].class}, new Object[]{key, data});
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IllegalObjectTypeException) {
                throw (IllegalObjectTypeException)target;
            }
            throw ProxyClientConnection.rethrow5(e);
        }
    }
}

