/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DDMACCSECReplyDataStream;
import com.ibm.as400.access.DDMACCSECRequestDataStream;
import com.ibm.as400.access.DDMASPReplyDataStream;
import com.ibm.as400.access.DDMASPRequestDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMEXCSATReplyDataStream;
import com.ibm.as400.access.DDMEXCSATRequestDataStream;
import com.ibm.as400.access.DDMSECCHKReplyDataStream;
import com.ibm.as400.access.DDMSECCHKRequestDataStream;
import com.ibm.as400.access.DDMTerm;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.util.Hashtable;

public class ClassDecoupler {
    public static boolean forceENCUSRPWD = false;
    public static boolean forceAES = false;

    static void freeDBReplyStream(DataStream ds) {
        if (ds instanceof DBReplyRequestedDS) {
            ((DBReplyRequestedDS)ds).returnToPool();
        }
    }

    static Object[] connectDDMPhase1(OutputStream outStream, InputStream inStream, boolean aesEncryption, int byteType_, int connectionID) throws ServerStartupException, IOException {
        int requestByteType;
        KeyPair keyPair = null;
        String encryptUserId = null;
        DDMEXCSATRequestDataStream EXCSATRequest = new DDMEXCSATRequestDataStream();
        if (Trace.traceOn_) {
            EXCSATRequest.setConnectionID(connectionID);
        }
        EXCSATRequest.write(outStream);
        DDMEXCSATReplyDataStream EXCSATReply = new DDMEXCSATReplyDataStream();
        if (Trace.traceOn_) {
            EXCSATReply.setConnectionID(connectionID);
        }
        EXCSATReply.read(inStream);
        if (!EXCSATReply.checkReply()) {
            throw new ServerStartupException(1);
        }
        byte[] jobString = EXCSATReply.getEXTNAM();
        if (Trace.traceOn_) {
            Trace.log(1, "DDM EXCSAT successful.");
        }
        if (forceENCUSRPWD) {
            requestByteType = 4;
            encryptUserId = "TRUE";
            try {
                if (!forceAES) {
                    try {
                        keyPair = DDMTerm.getDESKeyPair();
                    }
                    catch (InvalidAlgorithmParameterException iape) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "ClassDecoupler: Upgrading to AES due to InvalidAlgorithmParameterException ", (Throwable)iape);
                        }
                        forceAES = true;
                        keyPair = DDMTerm.getAESKeyPair();
                    }
                }
                keyPair = DDMTerm.getAESKeyPair();
            }
            catch (GeneralSecurityException e) {
                ServerStartupException serverStartupException = new ServerStartupException(1);
                serverStartupException.initCause(e);
                throw serverStartupException;
            }
        } else {
            requestByteType = byteType_;
        }
        DDMACCSECRequestDataStream ACCSECReq = new DDMACCSECRequestDataStream(aesEncryption, requestByteType, null, keyPair, forceAES);
        if (Trace.traceOn_) {
            ACCSECReq.setConnectionID(connectionID);
        }
        ACCSECReq.write(outStream);
        DDMACCSECReplyDataStream ACCSECRep = new DDMACCSECReplyDataStream();
        if (Trace.traceOn_) {
            ACCSECRep.setConnectionID(connectionID);
        }
        ACCSECRep.read(inStream);
        if (!ACCSECRep.checkReply(requestByteType)) {
            requestByteType = 4;
            if (ACCSECRep.checkReplyForEUSRIDPWD(byteType_)) {
                try {
                    if (!forceAES) {
                        try {
                            keyPair = DDMTerm.getDESKeyPair();
                        }
                        catch (InvalidAlgorithmParameterException iape) {
                            if (Trace.traceOn_) {
                                Trace.log(1, "ClassDecoupler: Upgrading to AES due to InvalidAlgorithmParameterException ", (Throwable)iape);
                            }
                            forceAES = true;
                            keyPair = DDMTerm.getAESKeyPair();
                        }
                    } else {
                        keyPair = DDMTerm.getAESKeyPair();
                    }
                }
                catch (GeneralSecurityException e) {
                    ServerStartupException serverStartupException = new ServerStartupException(1);
                    serverStartupException.initCause(e);
                    throw serverStartupException;
                }
                ACCSECReq = new DDMACCSECRequestDataStream(aesEncryption, requestByteType, null, keyPair, forceAES);
                if (Trace.traceOn_) {
                    ACCSECReq.setConnectionID(connectionID);
                }
                ACCSECReq.write(outStream);
                ACCSECRep = new DDMACCSECReplyDataStream();
                if (Trace.traceOn_) {
                    ACCSECRep.setConnectionID(connectionID);
                }
                ACCSECRep.read(inStream);
                if (ACCSECRep.aesUpgrade()) {
                    try {
                        if (Trace.traceOn_) {
                            Trace.log(1, "ClassDecoupler: Upgrading to AES due to server negotiation");
                        }
                        keyPair = DDMTerm.getAESKeyPair();
                        forceAES = true;
                    }
                    catch (GeneralSecurityException e) {
                        ServerStartupException serverStartupException = new ServerStartupException(1);
                        serverStartupException.initCause(e);
                        throw serverStartupException;
                    }
                    ACCSECReq = new DDMACCSECRequestDataStream(aesEncryption, requestByteType, null, keyPair, forceAES);
                    if (Trace.traceOn_) {
                        ACCSECReq.setConnectionID(connectionID);
                    }
                    ACCSECReq.write(outStream);
                    ACCSECRep = new DDMACCSECReplyDataStream();
                    if (Trace.traceOn_) {
                        ACCSECRep.setConnectionID(connectionID);
                    }
                    ACCSECRep.read(inStream);
                }
                if (!ACCSECRep.checkReplyForEUSRIDPWD(byteType_)) {
                    throw new ServerStartupException(1);
                }
                encryptUserId = "TRUE";
            } else {
                throw new ServerStartupException(1);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM ACCSEC successful.");
        }
        byte[] clientSeed = null;
        byte[] serverSeed = null;
        if (encryptUserId != null) {
            serverSeed = ACCSECRep.getServerSeed();
        } else if (byteType_ == 0 || requestByteType == 4) {
            clientSeed = ACCSECReq.getClientSeed();
            serverSeed = ACCSECRep.getServerSeed();
        }
        return new Object[]{clientSeed, serverSeed, jobString, encryptUserId, keyPair};
    }

    static void connectDDMPhase2(OutputStream outStream, InputStream inStream, byte[] userIDbytes, byte[] ddmSubstitutePassword, byte[] iaspBytes, int byteType_, String ddmRDB_, String systemName_, int connectionID) throws ServerStartupException, IOException, AS400SecurityException {
        DDMSECCHKRequestDataStream SECCHKReq = new DDMSECCHKRequestDataStream(userIDbytes, ddmSubstitutePassword, iaspBytes, byteType_);
        if (Trace.traceOn_) {
            SECCHKReq.setConnectionID(connectionID);
        }
        SECCHKReq.write(outStream);
        DDMSECCHKReplyDataStream SECCHKRep = new DDMSECCHKReplyDataStream();
        if (Trace.traceOn_) {
            SECCHKRep.setConnectionID(connectionID);
        }
        SECCHKRep.read(inStream);
        if (!SECCHKRep.checkReply()) {
            int rc = SECCHKRep.getErrorCode();
            switch (rc) {
                case 14: {
                    throw new AS400SecurityException(7);
                }
                case 15: {
                    throw new AS400SecurityException(8);
                }
                case 16: {
                    throw new AS400SecurityException(22);
                }
                case 19: {
                    throw new AS400SecurityException(32);
                }
                case 18: {
                    throw new AS400SecurityException(30);
                }
                case 20: {
                    throw new AS400SecurityException(31);
                }
                case 21: {
                    throw new AS400SecurityException(13);
                }
                case 9: {
                    throw new AS400SecurityException(24);
                }
                case 10: {
                    throw new AS400SecurityException(24);
                }
            }
            throw new ServerStartupException(1);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM SECCHK successful.");
        }
        if (iaspBytes != null) {
            DDMASPRequestDataStream aspReq = new DDMASPRequestDataStream(iaspBytes);
            if (Trace.traceOn_) {
                aspReq.setConnectionID(connectionID);
            }
            aspReq.write(outStream);
            DDMASPReplyDataStream aspRep = new DDMASPReplyDataStream();
            if (Trace.traceOn_) {
                aspRep.setConnectionID(connectionID);
            }
            aspRep.read(inStream);
            if (!aspRep.checkReply()) {
                if (Trace.traceOn_) {
                    Trace.log(2, "RDB name '" + ddmRDB_ + "' is not a valid IASP name on system '" + systemName_ + "'.");
                }
                throw new ServerStartupException(1);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "DDM RDB name '" + ddmRDB_ + "' verified.");
            }
        }
    }

    static DataStream constructDDMDataStream(InputStream inStream, Hashtable replyStreams, AS400ImplRemote system, int connectionID) throws IOException {
        return DDMDataStream.construct(inStream, replyStreams, system, connectionID);
    }

    static {
        String property = System.getProperty("com.ibm.as400.access.DDMPWDRQD");
        if (property != null && (property = property.toUpperCase()).equals("ENCUSRPWD")) {
            forceENCUSRPWD = true;
        }
        if ((property = System.getProperty("com.ibm.as400.access.DDMENCALC")) != null && (property = property.toUpperCase()).equals("AES")) {
            forceAES = true;
        }
    }
}

