/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ClusteredHashTableEntry
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final int ENTRY_AUTHORITY_ANY_USER = 1;
    public static final int ENTRY_AUTHORITY_LAST_USER = 0;
    public static final int DUPLICATE_KEY_UPDATE = 1;
    public static final int DUPLICATE_KEY_FAIL = 0;
    public static final int ENTRY_STATUS_CONSISTENT = 0;
    public static final int ENTRY_STATUS_INCONSISTENT = 1;
    public static final int MAX_USER_DATA_LENGTH = 61000;
    private byte[] userData_ = null;
    private int entryAuthority_ = 0;
    private int entryStatus_ = 0;
    private int entryUpdateOption_ = 0;
    private byte[] key_ = null;
    private int timeToLive_ = 60;
    private String ownerProfile_ = null;
    private String modifyProfile_ = null;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public ClusteredHashTableEntry() {
    }

    public ClusteredHashTableEntry(byte[] key, byte[] userData, int timeToLive, int entryAuthority, int updateOption) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (userData == null) {
            throw new NullPointerException("userData");
        }
        if (userData.length < 1 || userData.length > 61000) {
            throw new ExtendedIllegalArgumentException("userData", 1);
        }
        if (timeToLive != -1 && timeToLive < 60 || timeToLive > 31536000) {
            throw new ExtendedIllegalArgumentException("timeToLive", 4);
        }
        if (entryAuthority != 0 && entryAuthority != 1) {
            throw new ExtendedIllegalArgumentException("entryAuthority", 2);
        }
        if (updateOption != 0 && updateOption != 1) {
            throw new ExtendedIllegalArgumentException("updateOption", 2);
        }
        this.key_ = new byte[key.length];
        System.arraycopy(key, 0, this.key_, 0, key.length);
        this.userData_ = new byte[userData.length];
        System.arraycopy(userData, 0, this.userData_, 0, userData.length);
        this.timeToLive_ = timeToLive;
        this.entryAuthority_ = entryAuthority;
        this.entryUpdateOption_ = updateOption;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public int getEntryStatus() {
        return this.entryStatus_;
    }

    public int getEntryAuthority() {
        return this.entryAuthority_;
    }

    public byte[] getKey() {
        if (this.key_ == null) {
            return null;
        }
        byte[] b = new byte[this.key_.length];
        System.arraycopy(this.key_, 0, b, 0, this.key_.length);
        return b;
    }

    public int getTimeToLive() {
        return this.timeToLive_;
    }

    public int getUpdateOption() {
        return this.entryUpdateOption_;
    }

    public byte[] getUserData() {
        if (this.userData_ == null) {
            return null;
        }
        byte[] b = new byte[this.userData_.length];
        System.arraycopy(this.userData_, 0, b, 0, this.userData_.length);
        return b;
    }

    public String getOwnerProfile() {
        if (this.ownerProfile_ == null) {
            return null;
        }
        return this.ownerProfile_;
    }

    protected void setOwnerProfile(String usr) {
        if (usr == null) {
            throw new NullPointerException("usr");
        }
        if (usr.length() == 0 || usr.length() > 10) {
            throw new ExtendedIllegalArgumentException("usr", 1);
        }
        this.ownerProfile_ = usr;
    }

    public String getModifiedProfile() {
        if (this.modifyProfile_ == null) {
            return null;
        }
        return this.modifyProfile_;
    }

    protected void setModifiedProfile(String usr) {
        if (usr == null) {
            throw new NullPointerException("usr");
        }
        if (usr.length() == 0 || usr.length() > 10) {
            throw new ExtendedIllegalArgumentException("usr", 1);
        }
        this.modifyProfile_ = usr;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void setEntryAuthority(int entryAuthority) {
        if (entryAuthority != 0 && entryAuthority != 1) {
            throw new ExtendedIllegalArgumentException("entryAuthority", 2);
        }
        int old = this.entryAuthority_;
        this.entryAuthority_ = entryAuthority;
        this.changes_.firePropertyChange("entryAuthority", new Integer(old), new Integer(this.entryAuthority_));
    }

    public void setKey(byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length != 16) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        byte[] old = this.key_;
        this.key_ = new byte[key.length];
        System.arraycopy(key, 0, this.key_, 0, key.length);
        this.changes_.firePropertyChange("key", old, this.key_);
    }

    protected void setEntryStatus(int entryStatus) {
        if (entryStatus != 0 && entryStatus != 1) {
            throw new ExtendedIllegalArgumentException("entryStatus", 4);
        }
        this.entryStatus_ = entryStatus;
    }

    public void setTimeToLive(int timeToLive) {
        if (timeToLive != -1 && timeToLive < 60 || timeToLive > 31536000) {
            throw new ExtendedIllegalArgumentException("timeToLive", 4);
        }
        int old = this.timeToLive_;
        this.timeToLive_ = timeToLive;
        this.changes_.firePropertyChange("timeToLive", new Integer(old), new Integer(this.timeToLive_));
    }

    public void setUpdateOption(int updateOption) {
        if (updateOption != 0 && updateOption != 1) {
            throw new ExtendedIllegalArgumentException("updateOption", 2);
        }
        int old = this.entryUpdateOption_;
        this.entryUpdateOption_ = updateOption;
        this.changes_.firePropertyChange("updateOption", new Integer(old), new Integer(this.entryUpdateOption_));
    }

    public void setUserData(byte[] userData) {
        if (userData == null) {
            throw new NullPointerException("userData");
        }
        if (userData.length < 1 || userData.length > 61000) {
            throw new ExtendedIllegalArgumentException("userData", 1);
        }
        byte[] old = this.userData_;
        this.userData_ = new byte[userData.length];
        System.arraycopy(userData, 0, this.userData_, 0, userData.length);
        this.changes_.firePropertyChange("userData", old, this.userData_);
    }
}

