/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTableJavaMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.NLS;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class ConvTable {
    static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final char cic_ = '\uffff';
    static final char ric_ = '\ufffe';
    static final char hbic_ = '\u0000';
    static final char pad_ = '\u0000';
    static final byte sbSubChar_ = 63;
    static final char dbSubChar_ = '\ufefe';
    static final char sbSubUnic_ = '\u001a';
    static final char dbSubUnic_ = '\ufffd';
    static final char euro_ = '\u20ac';
    String encoding_;
    int ccsid_ = -1;
    int bidiStringType_ = 0;
    int clientBidiStringType = 0;
    private static final int LARGEST_CCSID = 62251;
    private static final ConvTable[] ccsidPool_ = new ConvTable[62252];
    private static final ConvTable[] ccsidPool1_ = new ConvTable[62252];
    private static final ConvTable[] ccsidPool2_ = new ConvTable[62252];
    private static final Hashtable converterPool_ = new Hashtable();
    private static final String prefix_ = "com.ibm.as400.access.ConvTable";

    ConvTable(int ccsid) {
        this.ccsid_ = ccsid;
        this.encoding_ = ConversionMaps.ccsidToEncoding(this.ccsid_);
        if (this.encoding_ == null) {
            this.encoding_ = "" + this.ccsid_;
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Constructing conversion table for ccsid/encoding: " + this.ccsid_ + "/" + this.encoding_);
            if (this.ccsid_ == 0) {
                if (this instanceof ConvTableJavaMap) {
                    Trace.log(5, "This table is a wrapper around a Java table.");
                } else {
                    Trace.log(5, "Warning: 0 specified for CCSID when table is not a Java table.");
                }
            }
        }
    }

    public String byteArrayToString(byte[] source, int offset, int length, int type) {
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties(type));
    }

    abstract String byteArrayToString(byte[] var1, int var2, int var3, BidiConversionProperties var4);

    public String byteArrayToString(byte[] source, int offset, int length) {
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties(this.bidiStringType_));
    }

    byte[] decompressSB(char[] arr, byte subPad) {
        int i;
        byte[] buf = new byte[65536];
        int c = 0;
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] == '\uffff') {
                if (arr.length > i + 1 && arr[i + 1] == '\u0000') {
                    buf[c++] = (byte)(arr[i] / 256);
                    buf[c++] = (byte)(arr[i++] % 256);
                    continue;
                }
                long max = (0xFFFF & arr[i + 1] * 2) + (0xFFFF & c);
                char ch = arr[i + 2];
                while ((long)c < max) {
                    buf[c++] = (byte)(ch / 256);
                    buf[c++] = (byte)(ch % 256);
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\ufffe') {
                if (arr.length > i + 1 && arr[i + 1] == '\u0000') {
                    buf[c++] = (byte)(arr[i] / 256);
                    buf[c++] = (byte)(arr[i++] % 256);
                    continue;
                }
                int start = 0xFFFF & arr[i + 2];
                int num = 0xFFFF & arr[i + 1];
                for (int j = start; j < num + start; ++j) {
                    buf[c++] = (byte)(j / 256);
                    buf[c++] = (byte)(j % 256);
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\u0000') {
                if (arr.length > i + 1 && arr[i + 1] == '\u0000') {
                    buf[c++] = (byte)(arr[i] / 256);
                    buf[c++] = (byte)(arr[i++] % 256);
                    continue;
                }
                int hbNum = 0xFFFF & arr[++i];
                char firstChar = arr[++i];
                char highByteMask = (char)(0xFF00 & firstChar);
                buf[c++] = (byte)(firstChar / 256);
                buf[c++] = (byte)(firstChar % 256);
                ++i;
                for (int j = 0; j < hbNum; ++j) {
                    char both = arr[i + j];
                    char c1 = (char)(highByteMask + ((0xFF00 & both) >>> 8));
                    char c2 = (char)(highByteMask + (0xFF & both));
                    buf[c++] = (byte)(c1 / 256);
                    buf[c++] = (byte)(c1 % 256);
                    buf[c++] = (byte)(c2 / 256);
                    buf[c++] = (byte)(c2 % 256);
                }
                i = i + hbNum - 1;
                continue;
            }
            buf[c++] = (byte)(arr[i] / 256);
            buf[c++] = (byte)(arr[i] % 256);
        }
        for (i = c; i < buf.length; ++i) {
            buf[i] = subPad;
        }
        return buf;
    }

    static final byte[] dumpCharArray(char[] charArray, int offset, int length) {
        byte[] retData = new byte[length * 2];
        int inPos = offset;
        int outPos = 0;
        while (inPos < length) {
            retData[outPos++] = (byte)(charArray[inPos] >> 8);
            retData[outPos++] = (byte)charArray[inPos++];
        }
        return retData;
    }

    static final byte[] dumpCharArray(char[] charArray, int numChars) {
        return ConvTable.dumpCharArray(charArray, 0, numChars);
    }

    static final byte[] dumpCharArray(char[] charArray) {
        return ConvTable.dumpCharArray(charArray, charArray.length);
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public static final ConvTable getTable(String encoding) throws UnsupportedEncodingException {
        String className = NLS.forceJavaTables_ ? encoding : prefix_ + ConversionMaps.encodingToCcsidString(encoding);
        ConvTable newTable = (ConvTable)converterPool_.get(className);
        if (newTable != null) {
            if (Trace.traceOn_) {
                Trace.log(5, "Reusing previously loaded conversion table for encoding: " + encoding);
            }
            return newTable;
        }
        try {
            if (NLS.forceJavaTables_) {
                if (Trace.traceOn_) {
                    Trace.log(5, "User set to force loading Java tables.");
                }
                throw new CharConversionException();
            }
            newTable = (ConvTable)Class.forName(className).newInstance();
        }
        catch (Throwable e) {
            if (Trace.traceOn_) {
                Trace.log(5, "Could not load conversion table class for encoding: " + encoding + ". Will attempt to let Java do the conversion.", e);
            }
            if ((newTable = (ConvTable)converterPool_.get(className = encoding)) != null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Reusing previously loaded Java conversion table for encoding: " + encoding);
                }
                return newTable;
            }
            newTable = new ConvTableJavaMap(encoding);
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded conversion table for encoding: " + encoding);
        }
        converterPool_.put(className, newTable);
        return newTable;
    }

    public static final ConvTable getTable(int ccsid, AS400ImplRemote system) throws UnsupportedEncodingException {
        ConvTable newTable;
        ConvTable cachedTable;
        if (ccsid > 2000000 ? (cachedTable = ccsidPool2_[ccsid - 2000000]) != null : (ccsid > 1000000 ? (cachedTable = ccsidPool1_[ccsid - 1000000]) != null : (ccsid &= 0xFFFF) <= 62251 && (cachedTable = ccsidPool_[ccsid]) != null)) {
            return cachedTable;
        }
        String className = null;
        if (NLS.forceJavaTables_) {
            className = ConversionMaps.ccsidToEncoding(ccsid);
            if (className == null) {
                className = "";
            }
        } else {
            className = prefix_ + String.valueOf(ccsid);
        }
        if ((newTable = (ConvTable)converterPool_.get(className)) != null) {
            if (Trace.traceOn_) {
                Trace.log(5, "Reusing previously loaded conversion table for ccsid: " + ccsid);
            }
            if (ccsid > 2000000) {
                ConvTable.ccsidPool2_[ccsid - 2000000] = newTable;
            } else if (ccsid > 1000000) {
                ConvTable.ccsidPool1_[ccsid - 1000000] = newTable;
            } else if (ccsid <= 62251) {
                ConvTable.ccsidPool_[ccsid] = newTable;
            }
            return newTable;
        }
        try {
            if (NLS.forceJavaTables_) {
                if (Trace.traceOn_) {
                    Trace.log(5, "User set to force loading Java tables.");
                }
                throw new CharConversionException();
            }
            newTable = (ConvTable)Class.forName(className).newInstance();
        }
        catch (Throwable e) {
            if (Trace.traceOn_) {
                Trace.log(5, "Could not load conversion table class for ccsid: " + ccsid + ". Will attempt to let Java do the conversion.", e);
            }
            if ((className = ConversionMaps.ccsidToEncoding(ccsid)) == null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Could not find an encoding that matches ccsid: " + ccsid);
                }
                UnsupportedEncodingException uee = new UnsupportedEncodingException("CCSID " + ccsid);
                uee.initCause(e);
                throw uee;
            }
            newTable = (ConvTable)converterPool_.get(className);
            if (newTable != null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Reusing previously loaded Java conversion table for ccsid: " + ccsid);
                }
                if (ccsid <= 62251) {
                    ConvTable.ccsidPool_[ccsid] = newTable;
                }
                return newTable;
            }
            newTable = new ConvTableJavaMap(className);
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded conversion table for ccsid: " + ccsid);
        }
        converterPool_.put(className, newTable);
        if (ccsid <= 62251) {
            ConvTable.ccsidPool_[ccsid] = newTable;
        }
        if (system != null) {
            newTable.clientBidiStringType = system.getBidiStringType();
        }
        return newTable;
    }

    public byte[] stringToByteArray(String source, int type) {
        return this.stringToByteArray(source, new BidiConversionProperties(type));
    }

    abstract byte[] stringToByteArray(String var1, BidiConversionProperties var2);

    public byte[] stringToByteArray(String source) {
        return this.stringToByteArray(source, new BidiConversionProperties(this.bidiStringType_));
    }

    public byte[] stringToByteArray(char[] source, int offset, int length) {
        return this.stringToByteArray(new String(source, offset, length));
    }

    public void stringToByteArray(String source, byte[] buf, int offset) throws CharConversionException {
        byte[] b = this.stringToByteArray(source, new BidiConversionProperties(this.bidiStringType_));
        try {
            System.arraycopy(b, 0, buf, offset, b.length);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CharConversionException();
        }
    }

    public void stringToByteArray(String source, byte[] buf, int offset, int length) throws CharConversionException {
        this.stringToByteArray(source, buf, offset, length, new BidiConversionProperties(this.bidiStringType_));
    }

    public void stringToByteArray(String source, byte[] buf, int offset, int length, int type) throws CharConversionException {
        this.stringToByteArray(source, buf, offset, length, new BidiConversionProperties(type));
    }

    public int stringToByteArray(String source, byte[] buf, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        int truncated = 0;
        byte[] b = this.stringToByteArray(source, properties);
        if (length >= b.length) {
            length = b.length;
        } else if (length < this.stringToByteArray(source.trim(), properties).length) {
            truncated = b.length - length;
        }
        try {
            System.arraycopy(b, 0, buf, offset, length);
            return truncated;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Trace.log(5, "Source length: " + b.length + "; Source offset: 0; Destination length: " + buf.length + "; Destination offset: " + offset + "; Number of bytes to copy: " + length, (Throwable)aioobe);
            throw new CharConversionException();
        }
    }

    public int validateData(byte[] buf, int offset, int length) {
        return length;
    }

    public static boolean isMixedCCSID(int ccsid) {
        switch (ccsid) {
            case 930: 
            case 933: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 1208: 
            case 1364: 
            case 1371: 
            case 1377: 
            case 1379: 
            case 1388: 
            case 1390: 
            case 1399: 
            case 5026: 
            case 5035: 
            case 5473: 
            case 13676: {
                return true;
            }
        }
        return false;
    }
}

