/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

public abstract class ConvTableSingleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public char[] toUnicode_ = null;
    public byte[] fromUnicode_ = null;

    public ConvTableSingleMap(int ccsid, char[] toUnicode, char[] fromUnicode) {
        super(ccsid);
        this.ccsid_ = ccsid;
        this.toUnicode_ = toUnicode;
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing single-byte conversion table for ccsid: " + this.ccsid_, fromUnicode.length);
        }
        this.fromUnicode_ = this.decompressSB(fromUnicode, (byte)63);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded single-byte map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_ + " offset:" + offset + " len:" + length, buf, offset, length);
        }
        char[] dest = new char[length];
        int i = 0;
        while (i < length) {
            dest[i] = this.toUnicode_[0xFF & buf[offset + i++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest);
    }

    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        return this.stringToByteArray(src, 0, src.length);
    }

    public final byte[] stringToByteArray(char[] src, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src, offset, length));
        }
        byte[] dest = new byte[length];
        int i = offset;
        while (i < length) {
            dest[i] = this.fromUnicode_[src[i++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }

    public final void stringToByteArray(String source, byte[] buf, int offset) throws CharConversionException {
        char[] src = source.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        try {
            int i = 0;
            while (i < src.length) {
                buf[i + offset] = this.fromUnicode_[src[i++]];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, src.length);
        }
    }

    public final void stringToByteArray(String source, byte[] buf, int offset, int length) throws CharConversionException {
        char[] src = source.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        try {
            int i = 0;
            while (i < src.length && i < length) {
                buf[i + offset] = this.fromUnicode_[src[i++]];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, src.length);
        }
    }

    public void updateToUnicode(int ebcdic, char unicode) {
        char[] oldToUnicode = this.toUnicode_;
        this.toUnicode_ = new char[oldToUnicode.length];
        for (int i = 0; i < oldToUnicode.length; ++i) {
            this.toUnicode_[i] = oldToUnicode[i];
        }
        this.toUnicode_[ebcdic] = unicode;
    }
}

