/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.Trace;

class DBSuperExtendedDataFormat
implements DBDataFormat {
    private static final int FIXED_LENGTH_ = 16;
    private static final int REPEATED_FIXED_LENGTH_ = 48;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private boolean csRsData_ = false;

    public DBSuperExtendedDataFormat() {
    }

    public DBSuperExtendedDataFormat(int numberOfFields) {
        this.numberOfFields_ = numberOfFields;
    }

    public void overlay(byte[] rawBytes, int offset) {
        this.rawBytes_ = rawBytes;
        this.offset_ = offset;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToInt(this.rawBytes_, offset + 4);
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getDateFormat() {
        return new Byte(this.rawBytes_[this.offset_ + 8]).intValue();
    }

    public int getTimeFormat() {
        return new Byte(this.rawBytes_[this.offset_ + 9]).intValue();
    }

    public int getDateSeparator() {
        return new Byte(this.rawBytes_[this.offset_ + 10]).intValue();
    }

    public int getTimeSeparator() {
        return new Byte(this.rawBytes_[this.offset_ + 11]).intValue();
    }

    public int getRecordSize() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 12);
    }

    public int getFieldSQLType(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + fieldIndex * 48);
    }

    public int getFieldLength(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + fieldIndex * 48);
    }

    public int getArrayFieldLength(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + fieldIndex * 48);
    }

    public int getFieldScale(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 24 + fieldIndex * 48);
    }

    public int getFieldPrecision(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 26 + fieldIndex * 48);
    }

    public int getFieldCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 28 + fieldIndex * 48);
    }

    public int getFieldParameterType(int fieldIndex) {
        return this.rawBytes_[this.offset_ + 30 + fieldIndex * 48];
    }

    public int getFieldLOBLocator(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 33 + fieldIndex * 48);
    }

    public int getXMLCharType(int fieldIndex) {
        int flag = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 37 + fieldIndex * 48);
        int isDBChar = flag >> 27 & 1;
        return isDBChar;
    }

    public int getArrayType(int fieldIndex) {
        int flag = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 37 + fieldIndex * 48);
        int isArray = flag >> 30 & 1;
        return isArray;
    }

    public int getFieldLOBMaxSize(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 42 + fieldIndex * 48);
    }

    public int getFieldNameLength(int fieldIndex) {
        int offsetToVariableFieldInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 48 + fieldIndex * 48);
        int lengthOfVariableFieldInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + fieldIndex * 48 + offsetToVariableFieldInformation);
        int fieldLength = lengthOfVariableFieldInformation - 8;
        return fieldLength;
    }

    public int getFieldNameCCSID(int fieldIndex) {
        int length = this.findCodePoint(fieldIndex, 14400);
        if (length >= 0) {
            return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + length + 6 + fieldIndex * 48);
        }
        JDTrace.logInformation("Did not find the code point for the field name");
        return this.getFieldCCSID(fieldIndex);
    }

    public String getFieldName(int fieldIndex, ConvTable converter) {
        int length = this.findCodePoint(fieldIndex, 14400);
        if (length >= 0) {
            return converter.byteArrayToString(this.rawBytes_, this.offset_ + 16 + length + 8 + fieldIndex * 48, this.getFieldNameLength(fieldIndex));
        }
        JDTrace.logInformation("Did not find the code point for the field name.");
        return "";
    }

    public int getUDTNameCCSID(int fieldIndex) {
        int length = this.findCodePoint(fieldIndex, 14401);
        if (length >= 0) {
            return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + length + 6 + fieldIndex * 48);
        }
        return -1;
    }

    public String getUDTName(int fieldIndex, ConvTable converter) {
        int length = this.findCodePoint(fieldIndex, 14401);
        if (length >= 0) {
            int udtNameLength = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + length + fieldIndex * 48) - 8;
            return converter.byteArrayToString(this.rawBytes_, this.offset_ + 16 + length + 8 + fieldIndex * 48, udtNameLength);
        }
        JDTrace.logInformation("Did not find the code point for the field name.");
        return null;
    }

    private int findCodePoint(int fieldIndex, int cp) {
        int lengthOfVariableInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 52 + fieldIndex * 48);
        int length = 0;
        int offsetToVariableFieldInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 48 + fieldIndex * 48);
        int lengthOfVariableFieldInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + fieldIndex * 48 + offsetToVariableFieldInformation);
        short codePoint = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + fieldIndex * 48 + offsetToVariableFieldInformation + 4);
        while (codePoint != cp && length < lengthOfVariableInformation) {
            if ((length += lengthOfVariableFieldInformation) >= lengthOfVariableInformation) continue;
            lengthOfVariableFieldInformation = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + length + fieldIndex * 48 + offsetToVariableFieldInformation);
            codePoint = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + length + fieldIndex * 48 + offsetToVariableFieldInformation + 4);
        }
        if (codePoint != cp) {
            return -1;
        }
        return length + offsetToVariableFieldInformation;
    }

    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    public void setNumberOfFields(int numberOfFields) {
        BinaryConverter.intToByteArray(numberOfFields, this.rawBytes_, this.offset_ + 4);
    }

    public void setRecordSize(int recordSize) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setRecordSize()");
    }

    public void setFieldDescriptionLength(int fieldIndex) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldDescriptionLength()");
    }

    public void setFieldSQLType(int fieldIndex, int sqlType) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldSQLType()");
    }

    public void setFieldLength(int fieldIndex, int length) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldLength()");
    }

    public void setFieldScale(int fieldIndex, int scale) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldScale()");
    }

    public void setFieldPrecision(int fieldIndex, int precision) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldPrecision()");
    }

    public void setFieldCCSID(int fieldIndex, int ccsid) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldCCSID()");
    }

    public void setFieldParameterType(int fieldIndex, int parameterType) {
        this.rawBytes_[this.offset_ + fieldIndex * 48 + 30] = (byte)parameterType;
    }

    public void setFieldNameLength(int fieldIndex, int nameLength) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldNameLength()");
    }

    public void setFieldNameCCSID(int fieldIndex, int nameCCSID) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldNameCCSID()");
    }

    public void setFieldName(int fieldIndex, String name, ConvTable converter) throws DBDataStreamException {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldName()");
    }

    public int getLength() {
        return 0;
    }

    public boolean getCSRSData() {
        return this.csRsData_;
    }

    public void setCSRSData(boolean csRsData) {
        this.csRsData_ = csRsData;
    }
}

