/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.DataQueueAttributes;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class DataQueue
extends BaseDataQueue {
    static final long serialVersionUID = 4L;

    public DataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing DataQueue object.");
        }
    }

    public DataQueue(AS400 system, String path) {
        super(system, path);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing DataQueue object.");
        }
    }

    public void create(DataQueueAttributes attributes) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (attributes.getKeyLength() > 0) {
            Trace.log(2, "Using DataQueue for keyed data queue.");
            throw new IllegalObjectTypeException(1);
        }
        this.create(attributes.getEntryLength(), attributes.getAuthority(), attributes.isSaveSenderInfo(), attributes.isFIFO(), attributes.isForceToAuxiliaryStorage(), attributes.getDescription());
    }

    public void create(int maxEntryLength) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.create(maxEntryLength, "*LIBCRTAUT", false, true, false, "");
    }

    public void create(int maxEntryLength, String authority, boolean saveSenderInformation, boolean FIFO, boolean forceToAuxiliaryStorage, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating data queue.");
        }
        if (maxEntryLength < 1 || maxEntryLength > 64512) {
            Trace.log(2, "Value of parameter 'maxEntryLength' is not valid:", maxEntryLength);
            throw new ExtendedIllegalArgumentException("maxEntryLength (" + maxEntryLength + ")", 4);
        }
        if (authority == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((authority = authority.toUpperCase().trim()).equals("*LIBCRTAUT") || authority.equals("*ALL") || authority.equals("*CHANGE") || authority.equals("*EXCLUDE") || authority.equals("*USE"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + authority);
            throw new ExtendedIllegalArgumentException("authority (" + authority + ")", 2);
        }
        if (description == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (description.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + description);
            throw new ExtendedIllegalArgumentException("description (" + description + ")", 1);
        }
        this.chooseImpl();
        this.attributesRetrieved_ = false;
        this.maxEntryLength_ = maxEntryLength;
        this.saveSenderInformation_ = saveSenderInformation;
        this.FIFO_ = FIFO;
        this.forceToAuxiliaryStorage_ = forceToAuxiliaryStorage;
        this.description_ = description;
        this.impl_.create(maxEntryLength, authority, saveSenderInformation, FIFO, 0, forceToAuxiliaryStorage, description);
        if (this.objectListeners_ != null) {
            this.fireObjectEvent(1);
        }
        this.attributesRetrieved_ = true;
    }

    public DataQueueEntry peek() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(0);
    }

    public DataQueueEntry peek(int wait) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Peeking data queue.");
        }
        if (wait < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", wait);
            throw new ExtendedIllegalArgumentException("wait (" + wait + ")", 2);
        }
        this.open();
        DQReceiveRecord record = this.impl_.read(null, wait, true, null);
        if (record == null) {
            return null;
        }
        DataQueueEntry entry = new DataQueueEntry(this, record.data_, record.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(1);
        }
        return entry;
    }

    public DataQueueEntry read() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(0);
    }

    public DataQueueEntry read(int wait) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Reading data queue.");
        }
        if (wait < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", wait);
            throw new ExtendedIllegalArgumentException("wait (" + wait + ")", 2);
        }
        this.open();
        DQReceiveRecord record = this.impl_.read(null, wait, false, null);
        if (record == null) {
            return null;
        }
        DataQueueEntry entry = new DataQueueEntry(this, record.data_, record.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(2);
        }
        return entry;
    }

    void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving data queue attributes.");
        }
        DQQueryRecord record = this.impl_.retrieveAttributes(false);
        this.maxEntryLength_ = record.maxEntryLength_;
        this.saveSenderInformation_ = record.saveSenderInformation_;
        this.FIFO_ = record.FIFO_;
        this.forceToAuxiliaryStorage_ = record.forceToAuxiliaryStorage_;
        this.description_ = record.description_;
        this.attributesRetrieved_ = true;
    }

    public String toString() {
        return "DataQueue " + super.toString();
    }

    public void write(byte[] data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing data queue.");
        }
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (data.length > 64512) {
            Trace.log(2, "Length of parameter 'data' is not valid:", data.length);
            throw new ExtendedIllegalArgumentException("data.length (" + data.length + ")", 1);
        }
        this.open();
        this.impl_.write(null, data);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(3);
        }
    }

    public void write(String data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.write(this.stringToByteArray(data));
    }
}

