/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

class DataStreamCompression {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final byte DEFAULT_ESCAPE = 27;
    static final int ESCAPE_SIZE = 1;
    static final int REPEATER_SIZE = 2;
    static final int COUNT_SIZE = 2;
    static final int REPEATER_RECORD_SIZE = 5;
    static final int ESCAPE_RECORD_SIZE = 2;

    private DataStreamCompression() {
    }

    static byte[] compressRLE(byte[] source, int sourceOffset, int length, byte escape) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (sourceOffset >= source.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        boolean traceDiagnostic = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        byte[] destination = new byte[length];
        int compressedCount = DataStreamCompression.compressRLEInternal(source, sourceOffset, length, destination, 0, escape);
        if (compressedCount >= 0) {
            byte[] returnBytes = new byte[compressedCount];
            System.arraycopy(destination, 0, returnBytes, 0, compressedCount);
            return returnBytes;
        }
        return null;
    }

    static int compressRLE(byte[] source, int sourceOffset, int length, byte[] destination, int destinationOffset, byte escape) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (sourceOffset >= source.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (destination == null) {
            throw new NullPointerException("destinationOffset");
        }
        if (destinationOffset >= destination.length) {
            throw new ExtendedIllegalArgumentException("destinationOffset", 2);
        }
        return DataStreamCompression.compressRLEInternal(source, sourceOffset, length, destination, destinationOffset, escape);
    }

    private static int compressRLEInternal(byte[] source, int sourceOffset, int length, byte[] destination, int destinationOffset, byte escape) {
        boolean traceDiagnostic = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        int returnCount = -1;
        int i = sourceOffset;
        int j = destinationOffset;
        boolean overflow = false;
        int sourceLength = sourceOffset + length;
        int destinationLength = destination.length;
        if (traceDiagnostic) {
            Trace.log(1, "compressRLE() sourceLength: " + sourceLength);
        }
        while (i < sourceLength && !overflow) {
            if (source[i] == escape) {
                if (j + 2 <= destinationLength) {
                    destination[j++] = escape;
                    destination[j++] = escape;
                    ++i;
                    continue;
                }
                if (traceDiagnostic) {
                    Trace.log(1, "Overflow when writing out escape record starting at dest " + j + " ...");
                }
                overflow = true;
                continue;
            }
            if (i + 1 >= sourceLength) {
                if (j < destinationLength) {
                    destination[j++] = source[i++];
                    continue;
                }
                if (traceDiagnostic) {
                    Trace.log(1, "Overflow when writing out last byte before EOD to dest " + j + " ...");
                }
                overflow = true;
                continue;
            }
            if (source[i + 1] == escape) {
                if (j + 1 + 2 <= destinationLength) {
                    destination[j++] = source[i++];
                    destination[j++] = escape;
                    destination[j++] = escape;
                    ++i;
                    continue;
                }
                if (traceDiagnostic) {
                    Trace.log(1, "Overflow when writing out single byte and escape record starting at dest " + j + " ...");
                }
                overflow = true;
                continue;
            }
            int saveOffset = i;
            byte repeaterByte1 = source[i];
            byte repeaterByte2 = source[i + 1];
            int count = 1;
            i += 2;
            while (i + 1 < sourceLength && repeaterByte1 == source[i] && repeaterByte2 == source[i + 1] && count < 65535) {
                ++count;
                i += 2;
            }
            int repeatLength = count * 2;
            if (repeatLength >= 10) {
                if (j + 5 <= destinationLength) {
                    destination[j] = escape;
                    destination[++j] = repeaterByte1;
                    destination[++j] = repeaterByte2;
                    destination[++j] = (byte)(count >>> 8);
                    destination[++j] = (byte)count;
                    ++j;
                    continue;
                }
                if (traceDiagnostic) {
                    Trace.log(1, "Overflow when writing out RLE repeater record starting at dest " + j + " ...");
                }
                overflow = true;
                continue;
            }
            i = saveOffset;
            if (j + (repeatLength - 1) < destinationLength) {
                for (int n = 0; n < repeatLength; ++n) {
                    destination[j++] = source[i++];
                }
                continue;
            }
            if (traceDiagnostic) {
                Trace.log(1, "Overflow when writing out non-repeating bytes to dest " + j + " ...");
            }
            overflow = true;
        }
        returnCount = j - destinationOffset;
        if (!overflow && returnCount < length) {
            if (traceDiagnostic) {
                Trace.log(1, "compressRLE() length of compressed bytes returned: " + j);
            }
        } else {
            returnCount = -1;
            if (traceDiagnostic) {
                Trace.log(1, "compressRLE() returning null (compressed size >= decompressed size)");
            }
        }
        return returnCount;
    }

    static byte[] decompressRLE(byte[] source, int sourceOffset, int length, int decompressedLength, byte escape) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (sourceOffset >= source.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (decompressedLength < 0) {
            throw new ExtendedIllegalArgumentException("decompressedLength", 2);
        }
        byte[] destination = decompressedLength == 0 ? new byte[2048] : new byte[decompressedLength];
        return DataStreamCompression.decompressRLEInternal(source, sourceOffset, length, destination, 0, escape, true, true);
    }

    static void decompressRLE(byte[] source, int sourceOffset, int length, byte[] destination, int destinationOffset, byte escape, boolean emptyDestination) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (sourceOffset >= source.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        if (destinationOffset >= destination.length) {
            throw new ExtendedIllegalArgumentException("destinationOffset", 2);
        }
        DataStreamCompression.decompressRLEInternal(source, sourceOffset, length, destination, destinationOffset, escape, false, emptyDestination);
    }

    private static byte[] decompressRLEInternal(byte[] source, int sourceOffset, int length, byte[] destination, int destinationOffset, byte escape, boolean reallocate, boolean emptyDestination) {
        boolean traceDiagnostic = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        boolean traceError = Trace.isTraceOn() && Trace.isTraceErrorOn();
        int i = sourceOffset;
        int j = destinationOffset;
        int saveI = -1;
        int saveJ = -1;
        boolean overflow = false;
        int bytesNeeded = 0;
        int sourceLength = sourceOffset + length;
        int destinationLength = destination.length;
        if (traceDiagnostic) {
            Trace.log(1, "decompressRLE() sourceLength: " + sourceLength);
            Trace.log(1, "decompressRLE() destinationLength: " + destinationLength);
        }
        while (i < sourceLength) {
            if (source[i] == escape) {
                if (i + 1 < sourceLength) {
                    if (source[i + 1] == escape) {
                        if (j < destinationLength) {
                            destination[j] = escape;
                        } else {
                            if (traceDiagnostic) {
                                Trace.log(1, "Overflow while decompressing RLE escape record starting at " + j + " ...");
                            }
                            if (!overflow) {
                                saveI = i;
                                saveJ = j;
                            }
                            overflow = true;
                            ++bytesNeeded;
                        }
                        i += 2;
                        ++j;
                        continue;
                    }
                    if (i + 2 + 2 < sourceLength) {
                        byte repeatByte1 = source[i + 1];
                        byte repeatByte2 = source[i + 1 + 1];
                        int count = ((source[i + 1 + 2] & 0xFF) << 8) + (source[i + 1 + 2 + 1] & 0xFF);
                        if (j + count * 2 <= destinationLength) {
                            if (repeatByte1 == 0 && repeatByte2 == 0 && emptyDestination) {
                                j += count * 2;
                            } else {
                                for (int k = 1; k <= count; ++k) {
                                    destination[j] = repeatByte1;
                                    destination[j + 1] = repeatByte2;
                                    j += 2;
                                }
                            }
                        } else {
                            if (traceDiagnostic) {
                                Trace.log(1, "Overflow while decompressing RLE repeater record starting at dest " + j + " ...");
                            }
                            if (!overflow) {
                                saveI = i;
                                saveJ = j;
                            }
                            overflow = true;
                            bytesNeeded += count * 2;
                            j += count * 2;
                        }
                        i += 5;
                        continue;
                    }
                    if (traceError) {
                        Trace.log(2, "Don't have a complete RLE repeater record before EOD ...");
                    }
                    throw new InternalErrorException(5);
                }
                if (traceError) {
                    Trace.log(2, "Don't have a complete RLE escape record before EOD ...");
                }
                throw new InternalErrorException(5);
            }
            if (j < destinationLength) {
                destination[j++] = source[i++];
                continue;
            }
            if (traceDiagnostic) {
                Trace.log(1, "Overflow when writing out single bytes ...");
            }
            if (!overflow) {
                saveI = i;
                saveJ = j;
            }
            overflow = true;
            ++bytesNeeded;
            ++i;
            ++j;
        }
        if (overflow && reallocate) {
            j = saveJ;
            byte[] returnBytes = new byte[j + bytesNeeded];
            int returnBytesLength = returnBytes.length;
            if (traceDiagnostic) {
                Trace.log(1, "Overflow. Size updated to " + returnBytesLength + " bytes.");
            }
            System.arraycopy(destination, 0, returnBytes, 0, j);
            i = saveI;
            overflow = false;
            while (i < sourceLength) {
                if (source[i] == escape) {
                    if (i + 1 < sourceLength) {
                        if (source[i + 1] == escape) {
                            returnBytes[j++] = escape;
                            i += 2;
                            continue;
                        }
                        if (i + 2 + 2 < sourceLength) {
                            int repeater = ((source[i + 1] & 0xFF) << 8) + (source[i + 1 + 1] & 0xFF);
                            int count = ((source[i + 1 + 2] & 0xFF) << 8) + (source[i + 1 + 2 + 1] & 0xFF);
                            for (int k = 1; k <= count; ++k) {
                                returnBytes[j] = (byte)(repeater >>> 8);
                                returnBytes[j + 1] = (byte)repeater;
                                j += 2;
                            }
                            i += 5;
                            continue;
                        }
                        if (traceError) {
                            Trace.log(2, "Don't have a complete RLE repeater record before EOD ...");
                        }
                        throw new InternalErrorException(5);
                    }
                    if (traceError) {
                        Trace.log(2, "Don't have a complete RLE escape record before EOD ...");
                    }
                    throw new InternalErrorException(5);
                }
                returnBytes[j++] = source[i++];
            }
            return returnBytes;
        }
        if (destination.length > j && reallocate) {
            byte[] returnBytes = new byte[j];
            System.arraycopy(destination, destinationOffset, returnBytes, 0, returnBytes.length);
            return returnBytes;
        }
        return destination;
    }
}

