/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ReturnCodeException;

public class ExtendedIllegalArgumentException
extends IllegalArgumentException
implements ReturnCodeException {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int rc_;
    public static final int LENGTH_NOT_VALID = 1;
    public static final int PARAMETER_VALUE_NOT_VALID = 2;
    public static final int PATH_NOT_VALID = 3;
    public static final int RANGE_NOT_VALID = 4;
    public static final int FIELD_NOT_FOUND = 5;
    public static final int SIGNON_CHAR_NOT_VALID = 6;
    public static final int PARAMETER_VALUE_DATATYPE_NOT_VALID = 7;

    public ExtendedIllegalArgumentException(String argument, int returnCode) {
        super(argument + ": " + ResourceBundleLoader.getCoreText(ExtendedIllegalArgumentException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    public ExtendedIllegalArgumentException(String argument, int returnCode, Exception e) {
        super(argument + ": " + ResourceBundleLoader.getCoreText(ExtendedIllegalArgumentException.getMRIKey(returnCode)));
        try {
            this.initCause(e);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.rc_ = returnCode;
    }

    static String getMRIKey(int returnCode) {
        switch (returnCode) {
            case 1: {
                return "EXC_LENGTH_NOT_VALID";
            }
            case 2: {
                return "EXC_PARAMETER_VALUE_NOT_VALID";
            }
            case 3: {
                return "EXC_PATH_NOT_VALID";
            }
            case 4: {
                return "EXC_RANGE_NOT_VALID";
            }
            case 5: {
                return "EXC_FIELD_NOT_FOUND";
            }
            case 6: {
                return "EXC_SIGNON_CHAR_NOT_VALID";
            }
            case 7: {
                return "EXC_PARAMETER_VALUE_DATATYPE_NOT_VALID";
            }
        }
        return "EXC_UNKNOWN";
    }

    public int getReturnCode() {
        return this.rc_;
    }
}

