/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.FTP;
import com.ibm.as400.access.Trace;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;

class FTPOutputStream
extends FilterOutputStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private FTP client_;
    private Socket dataSocket_;
    private boolean open_ = false;

    FTPOutputStream(Socket dataSocket, FTP client) throws IOException {
        super(dataSocket.getOutputStream());
        this.dataSocket_ = dataSocket;
        this.client_ = client;
        this.open_ = true;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening the output stream");
        }
    }

    public void close() throws IOException {
        if (this.open_) {
            super.close();
            this.dataSocket_.close();
            this.client_.readReply();
            this.open_ = false;
            if (Trace.isTraceOn()) {
                Trace.log(1, "Closing the output stream");
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

