/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.FTP;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

class FTPThread
implements Runnable {
    static long threadCount = 0L;
    static Object threadCountLock = new Object();
    private FTP ftp_;
    private int port_;
    private Socket socket_;
    private boolean running_ = false;
    private final Object runLock_ = new Object();
    private InetAddress localAddress_;

    FTPThread(FTP ftp) {
        this.ftp_ = ftp;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress_ = localAddress;
        if (Trace.traceOn_) {
            Trace.log(1, "FTP thread's local address set to: " + this.localAddress_.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilStarted() {
        try {
            while (!this.running_) {
                Object object = this.runLock_;
                synchronized (object) {
                    if (!this.running_) {
                        this.runLock_.wait();
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            Trace.log(2, "Error while waiting for FTP thread to start.", (Throwable)e);
        }
    }

    public int getLocalPort() {
        return this.port_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket() {
        if (this.socket_ == null) {
            try {
                FTPThread fTPThread = this;
                synchronized (fTPThread) {
                    if (this.socket_ == null) {
                        this.wait(60000L);
                    }
                }
            }
            catch (Exception e) {
                Trace.log(2, "Error while getting socket from FTP thread.", (Throwable)e);
                return null;
            }
        }
        Socket s = this.socket_;
        this.socket_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "FTP thread returned previously accepted socket.");
            if (s == null) {
                Trace.log(1, "FTPThread.getSocket() is returning null.");
            }
        }
        return s;
    }

    public void issuePortCommand() throws IOException {
        String addr = this.localAddress_.getHostAddress();
        String response = this.ftp_.issueCommand("EPRT |" + (addr.indexOf(58) == -1 ? "1" : "2") + "|" + addr + "|" + this.port_ + "|");
        if (response.startsWith("200")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(addr, ".");
        StringBuffer cmd = new StringBuffer("PORT ");
        while (st.hasMoreTokens()) {
            cmd.append(st.nextToken());
            cmd.append(",");
        }
        cmd.append(this.port_ / 256);
        cmd.append(",");
        cmd.append(this.port_ % 256);
        response = this.ftp_.issueCommand(cmd.toString());
        if (!response.startsWith("200")) {
            Trace.log(2, "Unexpected response to " + cmd + ": " + response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = threadCountLock;
        synchronized (object) {
            try {
                Thread.currentThread().setName("FTPThread-" + threadCount);
                ++threadCount;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ServerSocket ss = null;
        try {
            try {
                if (this.ftp_.isReuseSocket()) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread will reuse socket if multiple transfers.");
                    }
                    ss = new ServerSocket(0, 50, this.localAddress_);
                    this.port_ = ss.getLocalPort();
                    while (true) {
                        Object e;
                        if (Trace.traceOn_) {
                            Trace.log(1, "FTP thread waiting for new active mode socket.");
                        }
                        if (!this.running_) {
                            this.running_ = true;
                            e = this.runLock_;
                            synchronized (e) {
                                this.runLock_.notifyAll();
                            }
                        }
                        this.socket_ = ss.accept();
                        if (Trace.traceOn_) {
                            Trace.log(1, "FTP thread accepted active mode socket: " + this.socket_);
                        }
                        e = this;
                        synchronized (e) {
                            this.notifyAll();
                        }
                    }
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "FTP thread create new socket if multiple transfers.");
                }
                while (true) {
                    Object e;
                    if (ss == null) {
                        ss = new ServerSocket(0, 1, this.localAddress_);
                        this.port_ = ss.getLocalPort();
                    }
                    if (!this.running_) {
                        this.running_ = true;
                        e = this.runLock_;
                        synchronized (e) {
                            this.runLock_.notifyAll();
                        }
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread waiting for new active mode socket.");
                    }
                    this.socket_ = ss.accept();
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread accepted active mode socket: " + this.socket_);
                    }
                    e = this;
                    synchronized (e) {
                        this.notifyAll();
                    }
                    ss.close();
                    ss = null;
                }
            }
            catch (Throwable e) {
                Throwable e222;
                Trace.log(2, "Exception in FTP thread.", e);
                Object var9_11 = null;
                if (this.socket_ != null) {
                    try {
                        this.socket_.close();
                    }
                    catch (Throwable e222) {
                        Trace.log(2, e222);
                    }
                }
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (Throwable e222) {
                        Trace.log(2, e222);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Throwable e222;
            Object var9_12 = null;
            if (this.socket_ != null) {
                try {
                    this.socket_.close();
                }
                catch (Throwable e222) {
                    Trace.log(2, e222);
                }
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Throwable e222) {
                    Trace.log(2, e222);
                }
            }
            throw throwable;
        }
    }
}

