/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCreateDirHandleRep;
import com.ibm.as400.access.IFSCreateDirHandleReq;
import com.ibm.as400.access.IFSCreateDirReq;
import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSDeleteDirReq;
import com.ibm.as400.access.IFSDeleteFileReq;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSGetFileSystemRep;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSLookupRep;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSQuerySpaceRep;
import com.ibm.as400.access.IFSQuerySpaceReq;
import com.ibm.as400.access.IFSRenameReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

class IFSFileImplRemote
implements IFSFileImpl {
    private static final boolean DEBUG = false;
    private static final boolean IS_RESTART_NAME = true;
    private static final boolean NO_RESTART_NAME = true;
    private static final boolean SORT_LIST = true;
    private static final int NO_MAX_GET_COUNT = -1;
    private static final int UNINITIALIZED = -1;
    private static final int ACCESS_MODE_EXECUTE = 1;
    private String ownerName_ = null;
    private int fileCcsid_ = -1;
    private transient IFSListAttrsRep attributesReply_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();
    private boolean isSymbolicLink_;
    private boolean determinedIsSymbolicLink_;
    private boolean sortLists_;
    private RemoteCommandImpl rmtCmd_;
    private byte[] qualifiedFileName_;
    private Integer databaseFileAttributes_;
    private static final boolean SPACE_AVAILABLE = true;
    private static final boolean SPACE_TOTAL = false;

    IFSFileImplRemote() {
    }

    public boolean canExecute() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.canAccess(1);
    }

    public boolean canRead() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int rc = this.fd_.checkAccess(1, 8);
        return rc == 0;
    }

    public boolean canWrite() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int rc = this.fd_.checkAccess(2, 8);
        return rc == 0;
    }

    private boolean canAccess(int accessMode) throws IOException, AS400SecurityException {
        boolean result;
        block18: {
            if (this.fd_.getSystemVRM() < 327936) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Server is pre-V5R1, so canAccess() is returning false.");
                }
                return false;
            }
            try {
                ProgramParameter[] parameters;
                byte[] returnedBytes;
                if (this.rmtCmd_ == null) {
                    this.setupRemoteCommand();
                }
                if ((returnedBytes = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgAccess", parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(1, BinaryConverter.intToByteArray(accessMode))})) == null) {
                    Trace.log(2, "Call to QlgAccess() returned null.");
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                int returnValue = BinaryConverter.byteArrayToInt(returnedBytes, 0);
                block1 : switch (returnValue) {
                    case -1: {
                        result = false;
                        int errno = BinaryConverter.byteArrayToInt(returnedBytes, 4);
                        switch (errno) {
                            case 3025: {
                                if (Trace.traceOn_) {
                                    Trace.log(1, "Received errno " + errno + " from QlgAccess() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                                    break block1;
                                }
                                break block18;
                            }
                            case 3401: {
                                if (Trace.traceOn_) {
                                    Trace.log(1, "Received errno " + errno + " from QlgAccess() for file " + this.fd_.path_ + ". Assuming that the user does not have the specified access.");
                                    break block1;
                                }
                                break block18;
                            }
                            default: {
                                Trace.log(2, "Received errno " + errno + " from QlgAccess() for file " + this.fd_.path_);
                                throw new ExtendedIOException(this.fd_.path_, 25, errno);
                            }
                        }
                    }
                    case 0: {
                        result = true;
                        break;
                    }
                    default: {
                        Trace.log(2, "Received unexpected return value " + returnValue + " from QlgAccess() for file " + this.fd_.path_);
                        throw new InternalErrorException(9, "QlgAccess()", returnValue);
                    }
                }
            }
            catch (AS400SecurityException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.log(2, "Error while determining accessibility of file.", (Throwable)e);
                throw new ExtendedIOException(this.fd_.path_, 25);
            }
        }
        return result;
    }

    public boolean setAccess(int accessType, boolean enableAccess, boolean ownerOnly) throws IOException, AS400SecurityException {
        if (this.fd_.getSystemVRM() < 327936) {
            if (Trace.traceOn_) {
                Trace.log(4, "Server is pre-V5R1, so setAccess() is not supported.");
            }
            return false;
        }
        try {
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int oldAccessMode = this.getAccess();
            int bitMask = accessType << 6;
            if (!ownerOnly) {
                bitMask = bitMask | accessType << 3 | accessType;
            }
            int newAccessMode = enableAccess ? oldAccessMode | bitMask : oldAccessMode & ~bitMask;
            ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(1, BinaryConverter.intToByteArray(newAccessMode &= 0xFFF))};
            byte[] returnedBytes = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgChmod", parameters);
            if (returnedBytes == null) {
                Trace.log(2, "Call to QlgChmod() returned null.");
                throw new AS400Exception(this.rmtCmd_.getMessageList());
            }
            int returnValue = BinaryConverter.byteArrayToInt(returnedBytes, 0);
            switch (returnValue) {
                case -1: {
                    int errno = BinaryConverter.byteArrayToInt(returnedBytes, 4);
                    Trace.log(2, "Received errno " + errno + " from QlgChmod() for file " + this.fd_.path_);
                    throw new ExtendedIOException(this.fd_.path_, 25, errno);
                }
                case 0: {
                    break;
                }
                default: {
                    Trace.log(2, "Received unexpected return value " + returnValue + " from QlgChmod() for file " + this.fd_.path_);
                    throw new InternalErrorException(9, "QlgChmod()", returnValue);
                }
            }
        }
        catch (AS400SecurityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.log(2, "Error while determining accessibility of file.", (Throwable)e);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return true;
    }

    private int getAccess() throws IOException, AS400SecurityException, ObjectDoesNotExistException {
        int statInfo = 0;
        try {
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int bufferSizeProvided = 128;
            ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, bufferSizeProvided)};
            byte[] returnedBytes = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgStat", parameters);
            if (returnedBytes == null) {
                Trace.log(2, "Call to QlgStat() returned null.");
                throw new AS400Exception(this.rmtCmd_.getMessageList());
            }
            int returnValue = BinaryConverter.byteArrayToInt(returnedBytes, 0);
            switch (returnValue) {
                case -1: {
                    int errno = BinaryConverter.byteArrayToInt(returnedBytes, 4);
                    switch (errno) {
                        case 3025: {
                            Trace.log(2, "Received errno " + errno + " from QlgStat() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                            throw new ObjectDoesNotExistException(this.fd_.path_, 2);
                        }
                        case 3401: {
                            Trace.log(2, "Received errno " + errno + " from QlgStat() for file " + this.fd_.path_ + ". Assuming that the user does not have permission to access the file.");
                            throw new AS400SecurityException(this.fd_.path_, 1);
                        }
                    }
                    Trace.log(2, "Received errno " + errno + " from QlgStat() for file " + this.fd_.path_);
                    throw new ExtendedIOException(this.fd_.path_, 25, errno);
                }
                case 0: {
                    statInfo = this.parseStatInfo(parameters[1].getOutputData());
                    break;
                }
                default: {
                    Trace.log(2, "Received unexpected return value " + returnValue + " from QlgStat() for file " + this.fd_.path_);
                    throw new InternalErrorException(9, "QlgStat()", returnValue);
                }
            }
        }
        catch (AS400SecurityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.log(2, "Error while determining accessibility of file.", (Throwable)e);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return statInfo;
    }

    public void clearCachedAttributes() {
        this.attributesReply_ = null;
        this.databaseFileAttributes_ = null;
    }

    public boolean copyTo(String destinationPath, boolean replace) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        this.fd_.connect();
        if (Trace.traceOn_ && !replace && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so the 'Do not replace' argument will be ignored.");
        }
        if (this.isDirectory() == 0 && this.exists(destinationPath) == 0) {
            throw new ObjectAlreadyExistsException(destinationPath, 1);
        }
        return this.fd_.copyTo(destinationPath, replace);
    }

    public long created() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long creationDate = 0L;
        IFSListAttrsRep attrs = this.getAttributeSetFromServer(this.fd_.path_);
        if (attrs != null) {
            this.attributesReply_ = attrs;
            creationDate = attrs.getCreationDate();
        }
        return creationDate;
    }

    public int createNewFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 4);
    }

    public int delete() throws IOException, AS400SecurityException {
        IFSDataStreamReq req;
        block15: {
            this.fd_.connect();
            byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            req = new IFSDeleteFileReq(pathname, this.fd_.preferredServerCCSID_);
            try {
                if (!this.isSymbolicLink() && this.isDirectory() == 0) {
                    req = new IFSDeleteDirReq(pathname, this.fd_.preferredServerCCSID_);
                }
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine if file or directory.\n" + e.toString());
                }
                if (this.fd_.server_ != null) break block15;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioEx = new IOException(e.toString());
                try {
                    ioEx.initCause(e);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                throw ioEx;
            }
        }
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        int rc = 0;
        if (ds instanceof IFSReturnCodeRep) {
            rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0 && Trace.traceOn_) {
                Trace.log(2, "IFSReturnCodeRep return code", rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        this.attributesReply_ = null;
        return rc;
    }

    private boolean determineIsDirectory(IFSListAttrsRep attributeList) {
        boolean answer = false;
        switch (attributeList.getObjectType()) {
            case 1: 
            case 2: {
                answer = (attributeList.getFixedAttributes() & 0x10) != 0;
                break;
            }
            default: {
                answer = false;
            }
        }
        return answer;
    }

    private boolean determineIsFile(IFSListAttrsRep attributeList) {
        boolean answer = false;
        switch (attributeList.getObjectType()) {
            case 1: 
            case 2: {
                answer = (attributeList.getFixedAttributes() & 0x10) == 0;
                break;
            }
            default: {
                answer = false;
            }
        }
        return answer;
    }

    public int exists() throws IOException, AS400SecurityException {
        return this.exists(this.fd_.path_);
    }

    private int exists(String name) throws IOException, AS400SecurityException {
        int returnCode = 0;
        this.fd_.connect();
        returnCode = 2;
        try {
            IFSListAttrsRep attrs = this.getAttributeSetFromServer(name);
            if (attrs != null) {
                returnCode = 0;
                this.attributesReply_ = attrs;
            }
        }
        catch (AS400SecurityException e) {
            returnCode = 5;
        }
        return returnCode;
    }

    String getAbsolutePath() {
        return this.fd_.path_;
    }

    private IFSListAttrsRep getAttributeSetFromServer(String filePath) throws IOException, AS400SecurityException {
        IFSListAttrsRep reply = null;
        Vector replys = this.listAttributes(filePath, -1, null, true, false);
        if (replys != null && replys.size() == 1) {
            reply = (IFSListAttrsRep)replys.elementAt(0);
        }
        return reply;
    }

    public int getCCSID(boolean retrieveAll) throws IOException, AS400SecurityException {
        return this.fd_.getCCSID(retrieveAll);
    }

    public int getCCSID() throws IOException, AS400SecurityException {
        return this.fd_.getCCSID();
    }

    public int getCCSIDByUserHandle() throws IOException, AS400SecurityException {
        return this.fd_.getCCSIDByUserHandle();
    }

    public long getAvailableSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        long spaceAvailable = this.getAmountOfSpace(forUserOnly, true);
        if (forUserOnly) {
            long spaceAvailableInFileSystem = this.getAmountOfSpace(false, true);
            spaceAvailable = Math.min(spaceAvailable, spaceAvailableInFileSystem);
        }
        return spaceAvailable;
    }

    public long getTotalSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        return this.getAmountOfSpace(forUserOnly, false);
    }

    private long getAmountOfSpace(boolean forUserOnly, boolean availableSpaceOnly) throws IOException, AS400SecurityException {
        int directoryHandle;
        this.fd_.connect();
        long amountOfSpace = 0L;
        ClientAccessDataStream ds = null;
        int rc = 0;
        if (forUserOnly) {
            directoryHandle = 0;
        } else {
            String path = this.fd_.path_;
            if (this.isDirectory() != 0) {
                path = IFSFile.getParent(this.fd_.path_);
            }
            byte[] pathname = this.fd_.getConverter().stringToByteArray(path);
            try {
                IFSCreateDirHandleReq req = new IFSCreateDirHandleReq(pathname, this.fd_.preferredServerCCSID_);
                ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted");
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
            rc = 0;
            if (ds instanceof IFSCreateDirHandleRep) {
                directoryHandle = ((IFSCreateDirHandleRep)ds).getHandle();
            } else {
                if (ds instanceof IFSReturnCodeRep) {
                    rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", rc);
                    }
                    throw new ExtendedIOException(this.fd_.path_, rc);
                }
                Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
        }
        ds = null;
        try {
            IFSQuerySpaceReq req = new IFSQuerySpaceReq(directoryHandle);
            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        rc = 0;
        if (ds instanceof IFSQuerySpaceRep) {
            amountOfSpace = availableSpaceOnly ? ((IFSQuerySpaceRep)ds).getSpaceAvailable() : ((IFSQuerySpaceRep)ds).getTotalSpace();
        } else {
            if (ds instanceof IFSReturnCodeRep) {
                rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                }
                throw new ExtendedIOException(this.fd_.path_, rc);
            }
            Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        return amountOfSpace;
    }

    public String getFileSystemType(boolean isDirectory) throws IOException, AS400SecurityException {
        return this.fd_.getFileSystemType(isDirectory);
    }

    public String getFileSystemType() throws IOException, AS400SecurityException {
        return this.fd_.getFileSystemType();
    }

    public String getOwnerName(boolean retrieveAll) throws IOException, AS400SecurityException {
        String ownerName = null;
        this.fd_.connect();
        try {
            IFSListAttrsRep reply = null;
            if (retrieveAll) {
                return this.fd_.getOwnerName();
            }
            reply = this.fd_.listObjAttrs1(2048, 0);
            if (reply != null) {
                ownerName = reply.getOwnerName(this.fd_.system_.getCcsid());
            } else {
                if (Trace.traceOn_) {
                    Trace.log(4, "getOwnerName: IFSReturnCodeRep return code", this.fd_.errorRC_);
                }
                if (this.fd_.errorRC_ == 2 || this.fd_.errorRC_ == 3) {
                    throw new ExtendedIOException(this.fd_.path_, 3);
                }
            }
        }
        catch (ExtendedIOException e) {
            if (e.getReturnCode() == 4) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine owner of directory.", (Throwable)e);
                }
            }
            throw e;
        }
        return ownerName == null ? "" : ownerName;
    }

    public String getOwnerName() throws IOException, AS400SecurityException {
        String ownerName = null;
        this.fd_.connect();
        try {
            IFSListAttrsRep reply = this.fd_.listObjAttrs1(2048, 0);
            if (reply != null) {
                ownerName = reply.getOwnerName(this.fd_.system_.getCcsid());
            } else {
                if (Trace.traceOn_) {
                    Trace.log(4, "getOwnerName: IFSReturnCodeRep return code", this.fd_.errorRC_);
                }
                if (this.fd_.errorRC_ == 2 || this.fd_.errorRC_ == 3) {
                    throw new ExtendedIOException(this.fd_.path_, 3);
                }
            }
        }
        catch (ExtendedIOException e) {
            if (e.getReturnCode() == 4) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine owner of directory.", (Throwable)e);
                }
            }
            throw e;
        }
        return ownerName == null ? "" : ownerName;
    }

    public String getOwnerNameByUserHandle() throws IOException, AS400SecurityException {
        return this.fd_.getOwnerNameByUserHandle();
    }

    public String getOwnerNameByUserHandle(boolean forceRetrieve) throws IOException, AS400SecurityException {
        return this.fd_.getOwnerNameByUserHandle(forceRetrieve);
    }

    public int getASP(boolean isDirectory) throws IOException, AS400SecurityException {
        return this.fd_.getASP(isDirectory);
    }

    public int getASP() throws IOException, AS400SecurityException {
        return this.fd_.getASP();
    }

    public long getOwnerUID() throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep reply = this.fd_.listObjAttrs2();
        if (reply != null) {
            return reply.getOwnerUID();
        }
        return -1L;
    }

    public String getPathPointedTo() throws IOException, AS400SecurityException {
        this.fd_.connect();
        String resolvedPathname = null;
        try {
            boolean repeatRun;
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int bufferSizeProvided = 1024;
            ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, bufferSizeProvided), new ProgramParameter(1, BinaryConverter.intToByteArray(bufferSizeProvided))};
            int HEADER_LENGTH = 32;
            block8: do {
                repeatRun = false;
                byte[] returnedBytes = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgReadlink", parameters);
                if (returnedBytes == null) {
                    Trace.log(2, "Call to QlgReadlink() returned null.");
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                int returnValue = BinaryConverter.byteArrayToInt(returnedBytes, 0);
                if (returnValue == -1) {
                    int errno = BinaryConverter.byteArrayToInt(returnedBytes, 4);
                    switch (errno) {
                        case 3021: {
                            if (!Trace.traceOn_) continue block8;
                            Trace.log(1, "Received errno " + errno + " from QlgReadlink() for file " + this.fd_.path_ + ". Assuming that the file is not a symbolic link.");
                            break;
                        }
                        case 3025: {
                            if (!Trace.traceOn_) continue block8;
                            Trace.log(1, "Received errno " + errno + " from QlgReadlink() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                            break;
                        }
                        default: {
                            Trace.log(2, "Received errno " + errno + " from QlgReadlink() for file " + this.fd_.path_);
                            throw new ExtendedIOException(this.fd_.path_, 25, errno);
                        }
                    }
                    continue;
                }
                if (returnValue + 32 > bufferSizeProvided) {
                    repeatRun = true;
                    int bufferSizeNeeded = returnValue + 32;
                    if (Trace.traceOn_) {
                        Trace.log(1, "QlgReadlink() buffer too small. Buffer size provided: " + bufferSizeProvided + ". Buffer size needed: " + bufferSizeNeeded + ". Calling QlgReadLink() with larger buffer.");
                    }
                    bufferSizeProvided = bufferSizeNeeded;
                    parameters[1].setOutputDataLength(bufferSizeProvided);
                    parameters[2].setInputData(BinaryConverter.intToByteArray(bufferSizeProvided));
                    continue;
                }
                resolvedPathname = this.parsePathName(parameters[1].getOutputData());
            } while (repeatRun);
        }
        catch (AS400SecurityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.log(2, "Error while resolving symbolic link.", (Throwable)e);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return resolvedPathname;
    }

    private byte[] createPathName() throws IOException {
        ConverterImplRemote conv = new ConverterImplRemote();
        conv.setCcsid(1200, this.fd_.system_);
        int pathLength = this.fd_.path_.length();
        byte[] buf = new byte[32 + pathLength * 2];
        BinaryConverter.intToByteArray(1200, buf, 0);
        BinaryConverter.intToByteArray(2, buf, 12);
        BinaryConverter.intToByteArray(pathLength * 2, buf, 16);
        conv.stringToByteArray("/", buf, 20, 2);
        conv.stringToByteArray(this.fd_.path_, buf, 32);
        return buf;
    }

    private String parsePathName(byte[] buf) throws IOException {
        ConverterImplRemote conv = new ConverterImplRemote();
        conv.setCcsid(1200, this.fd_.system_);
        int offset = 0;
        int nameLength = BinaryConverter.byteArrayToInt(buf, offset += 16);
        String pathname = conv.byteArrayToString(buf, offset += 16, nameLength);
        return pathname;
    }

    private int parseStatInfo(byte[] buf) throws IOException {
        ConverterImplRemote conv = new ConverterImplRemote();
        conv.setCcsid(37, this.fd_.system_);
        int fileMode = BinaryConverter.byteArrayToInt(buf, 0);
        return fileMode;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        byte[][] eaNamesList;
        int eaNameBytesLength;
        String subtype = "";
        this.fd_.connect();
        byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
        boolean needCodePage = this.fd_.getSystemVRM() >= 393472 && this.fd_.path_.indexOf("/QSYS.LIB") != -1;
        byte[] eaName_TYPE = this.fd_.converter_.stringToByteArray(".TYPE");
        if (needCodePage) {
            byte[] eaName_CODEPAGE = this.fd_.converter_.stringToByteArray(".CODEPAGE");
            eaNameBytesLength = eaName_TYPE.length + eaName_CODEPAGE.length;
            eaNamesList = new byte[][]{eaName_TYPE, eaName_CODEPAGE};
        } else {
            eaNameBytesLength = eaName_TYPE.length;
            eaNamesList = new byte[][]{eaName_TYPE};
        }
        IFSListAttrsReq req = new IFSListAttrsReq(pathname, this.fd_.preferredServerCCSID_, 0, -1, null, false, eaNamesList, eaNameBytesLength, false, this.fd_.patternMatching_);
        Vector replys = this.fd_.listAttributes(req);
        if (replys == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(req).");
            }
        } else if (replys.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(req).");
            }
        } else {
            IFSListAttrsRep reply;
            Hashtable extendedAttributes;
            byte[] subtypeAsBytes;
            if (replys.size() > 1 && Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(req) (" + replys.size() + ")");
            }
            if ((subtypeAsBytes = (byte[])(extendedAttributes = (reply = (IFSListAttrsRep)replys.elementAt(0)).getExtendedAttributeValues()).get(".TYPE")) != null) {
                int ccsid;
                if (!needCodePage) {
                    ccsid = 37;
                } else {
                    byte[] codepageAsBytes = (byte[])extendedAttributes.get(".CODEPAGE");
                    byte[] swappedBytes = new byte[]{codepageAsBytes[1], codepageAsBytes[0]};
                    ccsid = BinaryConverter.byteArrayToUnsignedShort(swappedBytes, 0);
                    if (ccsid == 1400) {
                        ccsid = 1200;
                    }
                }
                try {
                    subtype = new CharConverter(ccsid).byteArrayToString(subtypeAsBytes, 0).trim();
                }
                catch (UnsupportedEncodingException e) {
                    Trace.log(2, "Unrecognized codepage returned: " + ccsid, (Throwable)e);
                    subtype = "??";
                }
            }
        }
        return subtype;
    }

    public boolean isSourcePhysicalFile() throws IOException, AS400SecurityException, AS400Exception {
        int attributeFlags = this.retrieveDatabaseFileAttributes();
        return (attributeFlags & 0x800) != 0;
    }

    private int retrieveDatabaseFileAttributes() throws IOException, AS400SecurityException, AS400Exception {
        if (this.databaseFileAttributes_ == null) {
            try {
                int bufferSizeProvided = 400;
                ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(bufferSizeProvided), new ProgramParameter(BinaryConverter.intToByteArray(bufferSizeProvided)), new ProgramParameter(20), new ProgramParameter(new byte[]{-58, -55, -45, -60, -16, -15, -16, -16}), new ProgramParameter(this.composeQualifiedNameBytes()), new ProgramParameter(new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64}), new ProgramParameter(new byte[]{-16}), new ProgramParameter(new byte[]{92, -45, -61, -45, 64, 64, 64, 64, 64, 64}), new ProgramParameter(new byte[]{92, -55, -43, -29, 64, 64, 64, 64, 64, 64}), new ErrorCodeParameter()};
                if (this.rmtCmd_ == null) {
                    this.setupRemoteCommand();
                }
                if (!this.rmtCmd_.runProgram("QSYS", "QDBRTVFD", parameters)) {
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                byte[] outputData = parameters[0].getOutputData();
                int bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
                if (bytesReturned < 10) {
                    Trace.log(2, "Insufficient output bytes returned from QDBRTVFD: " + bytesReturned);
                    throw new InternalErrorException(this.fd_.path_, 6);
                }
                this.databaseFileAttributes_ = new Integer(BinaryConverter.byteArrayToUnsignedShort(outputData, 8));
            }
            catch (AS400Exception e) {
                throw e;
            }
            catch (AS400SecurityException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.log(2, "Error while retrieving database file attributes.", (Throwable)e);
                throw new ExtendedIOException(this.fd_.path_, 25);
            }
        }
        return this.databaseFileAttributes_;
    }

    private synchronized byte[] composeQualifiedNameBytes() throws IOException {
        if (this.qualifiedFileName_ == null) {
            CharConverter converter = new CharConverter(37);
            this.qualifiedFileName_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            QSYSObjectPathName qsysPath = new QSYSObjectPathName(this.fd_.path_);
            String libraryName = qsysPath.getLibraryName();
            String fileName = qsysPath.getObjectName();
            converter.stringToByteArray(fileName, this.qualifiedFileName_, 0);
            converter.stringToByteArray(libraryName, this.qualifiedFileName_, 10);
        }
        return this.qualifiedFileName_;
    }

    public int isDirectory() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int returnCode = 2;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null && this.determineIsDirectory(this.attributesReply_)) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int isFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int returnCode = 2;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null && this.determineIsFile(this.attributesReply_)) {
            returnCode = 0;
        }
        return returnCode;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean result = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            result = (this.attributesReply_.getFixedAttributes() & 2) != 0;
        }
        return result;
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean result = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            result = (this.attributesReply_.getFixedAttributes() & 1) != 0;
        }
        return result;
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        this.fd_.connect();
        if (this.fd_.getSystemVRM() < 328448) {
            if (Trace.traceOn_) {
                Trace.log(4, "Server is V5R2 or lower, so isSymbolicLink() will always report false.");
            }
            return false;
        }
        if (!this.determinedIsSymbolicLink_) {
            int pathLen = this.fd_.path_.length();
            if (pathLen <= 1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Path length is less than 2, so assuming not a symbolic link: " + this.fd_.path_);
                }
                this.isSymbolicLink_ = false;
                this.determinedIsSymbolicLink_ = true;
            } else {
                StringBuffer wildCardPatternBuf = new StringBuffer(this.fd_.path_);
                wildCardPatternBuf.setCharAt(pathLen - 1, '*');
                String wildCardPattern = wildCardPatternBuf.toString();
                String dirPath = wildCardPattern.substring(0, 1 + wildCardPattern.lastIndexOf(47));
                byte[] pathBytes = this.fd_.converter_.stringToByteArray(wildCardPattern);
                IFSCachedAttributes[] attrList = this.listDirectoryDetails(wildCardPattern, dirPath, -1, pathBytes, true, false);
                IFSCachedAttributes attrs = null;
                String filename = this.fd_.path_.substring(1 + this.fd_.path_.lastIndexOf(47));
                for (int i = 0; attrs == null && i < attrList.length; ++i) {
                    if (!attrList[i].name_.equals(filename)) continue;
                    attrs = attrList[i];
                }
                if (attrs != null) {
                    this.isSymbolicLink_ = attrs.isSymbolicLink_;
                    this.determinedIsSymbolicLink_ = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Received zero matches from listDirectoryDetails() against parent of " + wildCardPattern);
                    }
                    this.isSymbolicLink_ = false;
                    this.determinedIsSymbolicLink_ = true;
                }
            }
        }
        return this.isSymbolicLink_;
    }

    public long lastAccessed() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long accessDate = 0L;
        IFSListAttrsRep attrs = this.getAttributeSetFromServer(this.fd_.path_);
        if (attrs != null) {
            this.attributesReply_ = attrs;
            accessDate = attrs.getAccessDate();
        }
        return accessDate;
    }

    public long lastModified() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long modificationDate = 0L;
        IFSListAttrsRep attrs = this.getAttributeSetFromServer(this.fd_.path_);
        if (attrs != null) {
            this.attributesReply_ = attrs;
            modificationDate = attrs.getModificationDate();
        }
        return modificationDate;
    }

    public long length() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long size = 0L;
        if (this.fd_.getSystemVRM() >> 8 != 1282) {
            IFSListAttrsRep attrs = this.getAttributeSetFromServer(this.fd_.path_);
            if (attrs != null) {
                this.attributesReply_ = attrs;
                size = attrs.getSize(this.fd_.serverDatastreamLevel_);
            }
        } else {
            byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSListAttrsReq req = new IFSListAttrsReq(pathname, this.fd_.preferredServerCCSID_, 0, -1, null, true, null, 0, true, this.fd_.patternMatching_);
            Vector replys = this.fd_.listAttributes(req);
            if (replys == null) {
                if (this.fd_.errorRC_ != 0) {
                    throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
                }
                throw new InternalErrorException(6);
            }
            if (replys.size() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received no replies from listAttributes(req).");
                }
            } else {
                if (replys.size() > 1 && Trace.traceOn_) {
                    Trace.log(4, "Received multiple replies from listAttributes(req) (" + replys.size() + ")");
                }
                IFSListAttrsRep reply = (IFSListAttrsRep)replys.elementAt(0);
                size = reply.getSize8Bytes();
            }
        }
        return size;
    }

    private Vector listAttributes(String path, int maxGetCount, byte[] restartNameOrID, boolean isRestartName, boolean sortList) throws IOException, AS400SecurityException {
        byte[] pathname = this.fd_.converter_.stringToByteArray(path);
        IFSListAttrsReq req = new IFSListAttrsReq(pathname, this.fd_.preferredServerCCSID_, 0, maxGetCount, restartNameOrID, isRestartName, null, 0, false, this.fd_.patternMatching_);
        if (sortList) {
            req.setSorted(true);
        }
        return this.fd_.listAttributes(req);
    }

    public String[] listDirectoryContents(String directoryPath) throws IOException, AS400SecurityException {
        this.fd_.connect();
        Vector replys = this.listAttributes(directoryPath, -1, null, true, this.sortLists_);
        String[] names = null;
        if (replys != null) {
            names = new String[replys.size()];
            int j = 0;
            for (int i = 0; i < replys.size(); ++i) {
                IFSListAttrsRep reply = (IFSListAttrsRep)replys.elementAt(i);
                String name = this.fd_.converter_.byteArrayToString(reply.getName());
                if (name.equals(".") || name.equals("..")) continue;
                names[j++] = name;
            }
            if (j == 0) {
                names = new String[]{};
            } else if (names.length != j) {
                String[] newNames = new String[j];
                System.arraycopy(names, 0, newNames, 0, j);
                names = newNames;
            }
        }
        return names;
    }

    private IFSCachedAttributes[] listDirectoryDetails(String pathPattern, String directoryPath, int maxGetCount, byte[] restartNameOrID, boolean isRestartName, boolean sortList) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSCachedAttributes[] fileAttributes = null;
        try {
            Vector replys = this.listAttributes(pathPattern, maxGetCount, restartNameOrID, isRestartName, sortList);
            int j = 0;
            if (replys != null) {
                fileAttributes = new IFSCachedAttributes[replys.size()];
                int dsl = this.fd_.serverDatastreamLevel_;
                for (int i = 0; i < replys.size(); ++i) {
                    IFSListAttrsRep reply = (IFSListAttrsRep)replys.elementAt(i);
                    String name = this.fd_.converter_.byteArrayToString(reply.getName());
                    if (name.equals(".") || name.equals("..")) continue;
                    boolean isDirectory = this.determineIsDirectory(reply);
                    boolean isFile = this.determineIsFile(reply);
                    IFSCachedAttributes attributes = new IFSCachedAttributes(reply.getAccessDate(), reply.getCreationDate(), reply.getFixedAttributes(), reply.getModificationDate(), reply.getObjectType(), reply.getSize(dsl), name, directoryPath, isDirectory, isFile, reply.getRestartID(), reply.isSymbolicLink(dsl), reply.getFileSystemType(dsl));
                    fileAttributes[j++] = attributes;
                }
            }
            if (j == 0) {
                fileAttributes = new IFSCachedAttributes[]{};
            } else if (fileAttributes.length != j) {
                IFSCachedAttributes[] newFileAttributes = new IFSCachedAttributes[j];
                System.arraycopy(fileAttributes, 0, newFileAttributes, 0, j);
                fileAttributes = newFileAttributes;
            }
        }
        catch (AS400SecurityException e) {
            fileAttributes = null;
            throw e;
        }
        return fileAttributes;
    }

    public IFSCachedAttributes[] listDirectoryDetails(String pathPattern, String directoryPath, int maxGetCount, String restartName) throws IOException, AS400SecurityException {
        byte[] restartNameBytes = this.fd_.converter_.stringToByteArray(restartName);
        return this.listDirectoryDetails(pathPattern, directoryPath, maxGetCount, restartNameBytes, true, this.sortLists_);
    }

    public IFSCachedAttributes[] listDirectoryDetails(String pathPattern, String directoryPath, int maxGetCount, byte[] restartID, boolean allowSortedRequests) throws IOException, AS400SecurityException {
        boolean sortParameter = allowSortedRequests ? this.sortLists_ : false;
        return this.listDirectoryDetails(pathPattern, directoryPath, maxGetCount, restartID, false, sortParameter);
    }

    public int mkdir(String directory) throws IOException, AS400SecurityException {
        int returnCode;
        block7: {
            this.fd_.connect();
            returnCode = 2;
            try {
                byte[] pathname = this.fd_.converter_.stringToByteArray(directory);
                IFSCreateDirReq req = new IFSCreateDirReq(pathname, this.fd_.preferredServerCCSID_);
                ClientAccessDataStream ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
                if (ds instanceof IFSReturnCodeRep) {
                    returnCode = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (returnCode == 5 || returnCode == 13) {
                        throw new AS400SecurityException(directory, 1);
                    }
                    break block7;
                }
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted");
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        return returnCode;
    }

    public int mkdirs() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean success = false;
        Vector<String> nonexistentDirs = new Vector<String>();
        String directory = this.fd_.path_;
        int returnCode = 2;
        returnCode = this.exists(directory);
        if (returnCode != 0) {
            do {
                nonexistentDirs.addElement(directory);
            } while ((directory = IFSFile.getParent(directory)) != null && this.exists(directory) != 0);
        } else {
            returnCode = 4;
        }
        for (int i = nonexistentDirs.size(); i > 0 && (returnCode = this.mkdir(directory = (String)nonexistentDirs.elementAt(i - 1))) == 0; --i) {
        }
        return returnCode;
    }

    public int renameTo(IFSFileImpl file) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean success = false;
        ClientAccessDataStream ds = null;
        IFSFileImplRemote otherFile = (IFSFileImplRemote)file;
        try {
            byte[] oldName = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            byte[] newName = this.fd_.converter_.stringToByteArray(otherFile.getAbsolutePath());
            IFSRenameReq req = new IFSRenameReq(oldName, newName, this.fd_.preferredServerCCSID_, false);
            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        int returnCode = 2;
        if (ds instanceof IFSReturnCodeRep) {
            returnCode = ((IFSReturnCodeRep)ds).getReturnCode();
            if (returnCode == 0) {
                success = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error renaming file: IFSReturnCodeRep return code", returnCode);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        if (success) {
            this.fd_.path_ = otherFile.getAbsolutePath();
            this.attributesReply_ = null;
        }
        return returnCode;
    }

    public boolean setCCSID(int ccsid) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep reply = this.fd_.listObjAttrs2();
        if (reply == null) {
            if (this.fd_.errorRC_ != 0) {
                throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
            }
            throw new InternalErrorException(6);
        }
        boolean success = false;
        byte[] objAttrs2Null = new byte[reply.getObjAttrs2().getLength()];
        Arrays.fill(objAttrs2Null, (byte)-1);
        IFSObjAttrs2 objAttrs = new IFSObjAttrs2(objAttrs2Null);
        if (Trace.traceOn_) {
            Trace.log(1, "Length of returned OA2* structure (should be 144 or 160): " + objAttrs.length());
        }
        objAttrs.setCCSID(ccsid, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream ds = null;
        try {
            byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq req = new IFSChangeAttrsReq(pathname, this.fd_.preferredServerCCSID_, objAttrs, this.fd_.serverDatastreamLevel_);
            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc == 0) {
                success = true;
                this.fd_.setCCSID(ccsid);
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file data CCSID: IFSReturnCodeRep return code", rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        return success;
    }

    public boolean setFixedAttributes(int attributes) throws IOException, AS400SecurityException {
        this.fd_.connect();
        ClientAccessDataStream ds = null;
        try {
            byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq req = new IFSChangeAttrsReq(pathname, this.fd_.preferredServerCCSID_, attributes, true, this.fd_.serverDatastreamLevel_);
            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        boolean success = false;
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc == 0) {
                success = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file attributes: IFSReturnCodeRep return code", rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        this.attributesReply_ = null;
        return success;
    }

    public boolean setHidden(boolean attribute) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean success = false;
        IFSListAttrsRep attributes = this.getAttributeSetFromServer(this.fd_.path_);
        if (attributes != null) {
            boolean currentHiddenBit;
            int currentFixedAttributes = attributes.getFixedAttributes();
            boolean bl = currentHiddenBit = (currentFixedAttributes & 2) != 0;
            if (currentHiddenBit != attribute) {
                int newAttributes = attribute ? currentFixedAttributes + 2 : currentFixedAttributes & 0x7FFFFFFD;
                ClientAccessDataStream ds = null;
                try {
                    byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq req = new IFSChangeAttrsReq(pathname, this.fd_.preferredServerCCSID_, newAttributes, true, this.fd_.serverDatastreamLevel_);
                    ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
                }
                catch (ConnectionDroppedException e) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted");
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    try {
                        throwException.initCause(e);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwException;
                }
                if (ds instanceof IFSReturnCodeRep) {
                    int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc == 0) {
                        success = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting hidden attribute: IFSReturnCodeRep return code", rc);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream", ds.data_);
                    throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                success = true;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setLastModified(long time) throws IOException, AS400SecurityException {
        boolean success;
        int fileHandle;
        block20: {
            boolean bl;
            block18: {
                fileHandle = -1;
                success = false;
                try {
                    block19: {
                        block21: {
                            this.fd_.connect();
                            if (time != -1L) break block21;
                            fileHandle = this.fd_.createFileHandle(2, 8);
                            if (fileHandle == -1) {
                                bl = false;
                                Object var10_7 = null;
                                if (fileHandle == -1) return bl;
                                break block18;
                            }
                            this.fd_.setOpen(true, fileHandle);
                            byte[] buffer = new byte[1];
                            boolean fileIsEmpty = false;
                            if (time == -1L) {
                                boolean bl2 = fileIsEmpty = this.length() == 0L;
                            }
                            if (fileIsEmpty) {
                                this.fd_.writeBytes(buffer, 0, 1, true);
                                success = this.fd_.setLength(0L);
                                break block19;
                            } else if (1 == this.fd_.read(buffer, 0, 1)) {
                                this.fd_.setFileOffset(0L);
                                this.fd_.writeBytes(buffer, 0, 1, true);
                                success = true;
                                break block19;
                            } else {
                                if (Trace.traceOn_) {
                                    Trace.log(2, "Unable to read first byte of file.");
                                }
                                success = false;
                            }
                            break block19;
                        }
                        ClientAccessDataStream ds = null;
                        try {
                            byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                            IFSChangeAttrsReq req = new IFSChangeAttrsReq(pathname, this.fd_.preferredServerCCSID_, 0L, time, 0L, this.fd_.serverDatastreamLevel_);
                            ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
                        }
                        catch (ConnectionDroppedException e) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.fd_.connectionDropped(e);
                        }
                        catch (InterruptedException e) {
                            Trace.log(2, "Interrupted");
                            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                            try {
                                throwException.initCause(e);
                                throw throwException;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            throw throwException;
                        }
                        if (!(ds instanceof IFSReturnCodeRep)) {
                            Trace.log(2, "Unknown reply data stream", ds.data_);
                            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                        }
                        int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                        if (rc == 0) {
                            success = true;
                        } else if (Trace.traceOn_) {
                            Trace.log(2, "Error setting last-modified date: IFSReturnCodeRep return code", rc);
                        }
                    }
                    this.attributesReply_ = null;
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (fileHandle == -1) throw throwable;
                    this.fd_.close(fileHandle);
                    throw throwable;
                }
            }
            this.fd_.close(fileHandle);
            return bl;
        }
        Object var10_8 = null;
        if (fileHandle == -1) return success;
        this.fd_.close(fileHandle);
        return success;
    }

    public boolean setLength(int length) throws IOException, AS400SecurityException {
        this.fd_.connect();
        this.attributesReply_ = null;
        return this.fd_.setLength(length);
    }

    public void setPath(String path) {
        if (this.fd_.server_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String newPath = path.length() == 0 || path.charAt(0) != '/' ? "/" + path : path;
        this.fd_.path_ = newPath;
    }

    private static final void setPassByReference(ProgramParameter parm) {
        try {
            parm.setParameterType(2);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
    }

    public void setPatternMatching(int patternMatching) {
        this.fd_.patternMatching_ = patternMatching;
    }

    public boolean setReadOnly(boolean attribute) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean success = false;
        IFSListAttrsRep attributes = this.getAttributeSetFromServer(this.fd_.path_);
        if (attributes != null) {
            boolean currentReadOnlyBit;
            int currentFixedAttributes = attributes.getFixedAttributes();
            boolean bl = currentReadOnlyBit = (currentFixedAttributes & 1) != 0;
            if (currentReadOnlyBit != attribute) {
                int newAttributes = attribute ? currentFixedAttributes + 1 : currentFixedAttributes & 0x7FFFFFFE;
                ClientAccessDataStream ds = null;
                try {
                    byte[] pathname = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq req = new IFSChangeAttrsReq(pathname, this.fd_.preferredServerCCSID_, newAttributes, true, this.fd_.serverDatastreamLevel_);
                    ds = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(req);
                }
                catch (ConnectionDroppedException e) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted");
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    try {
                        throwException.initCause(e);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwException;
                }
                if (ds instanceof IFSReturnCodeRep) {
                    int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc == 0) {
                        success = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting read-only attribute: IFSReturnCodeRep return code", rc);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream", ds.data_);
                    throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                success = true;
            }
        }
        return success;
    }

    public void setSorted(boolean sort) {
        this.sortLists_ = sort;
    }

    public void setSystem(AS400Impl system) {
        this.fd_.system_ = (AS400ImplRemote)system;
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.rmtCmd_ == null) {
            if (this.fd_.system_.canUseNativeOptimizations()) {
                try {
                    this.rmtCmd_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                }
                catch (Throwable e) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", e);
                }
            }
            if (this.rmtCmd_ == null) {
                this.rmtCmd_ = new RemoteCommandImplRemote();
            }
            this.rmtCmd_.setSystem(this.fd_.system_);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateDirHandleRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSQuerySpaceRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLookupRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSGetFileSystemRep(), 0);
    }
}

