/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class IFSFileInputStream
extends InputStream
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    protected IFSFileDescriptor fd_;
    private transient PropertyChangeSupport changes_;
    private transient Vector fileListeners_;
    private transient VetoableChangeSupport vetos_;
    transient IFSFileInputStreamImpl impl_;

    public IFSFileInputStream() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSFileInputStream(AS400 system, String name) throws AS400SecurityException, IOException {
        this(system, name, -1);
    }

    public IFSFileInputStream(AS400 system, String name, int shareOption) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        IFSFileInputStream.validateShareOption(shareOption);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(system, name, shareOption, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initialize(file.getSystem(), file, -1);
    }

    public IFSFileInputStream(AS400 system, IFSFile file, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.initialize(system, file, shareOption);
    }

    private void initialize(AS400 system, IFSFile file, int shareOption) throws AS400SecurityException, IOException {
        IFSFileInputStream.validateShareOption(shareOption);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(system, file.getAbsolutePath(), shareOption, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSFile file, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initialize(file.getSystem(), file, shareOption);
    }

    public IFSFileInputStream(IFSFileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd");
        }
        IFSFileInputStream.validateShareOption(fd.getShareOption());
        this.initializeTransient();
        this.fd_ = fd;
    }

    public IFSFileInputStream(IFSJavaFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initialize(file.getSystem(), file, -1);
    }

    public IFSFileInputStream(AS400 system, IFSJavaFile file, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.initialize(system, file, shareOption);
    }

    private void initialize(AS400 system, IFSJavaFile file, int shareOption) throws AS400SecurityException, IOException {
        IFSFileInputStream.validateShareOption(shareOption);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(system, file.getAbsolutePath().replace(File.separatorChar, '/'), shareOption, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSJavaFile file, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initialize(file.getSystem(), file, shareOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public int available() throws IOException {
        this.open();
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.impl_ == null) {
            AS400 system = this.fd_.getSystem();
            if (system == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSFileInputStreamImpl)system.loadImpl2("com.ibm.as400.access.IFSFileInputStreamImplRemote", "com.ibm.as400.access.IFSFileInputStreamImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
        }
    }

    public void close() throws IOException {
        if (!this.fd_.isClosed() && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable e) {
            Trace.log(2, "Error during finalization.");
            throw new IOException(e.toString());
        }
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    IFSFileInputStreamImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.vetos_ = new VetoableChangeSupport(this);
        this.impl_ = null;
    }

    public IFSKey lock(int length) throws IOException {
        return this.lock((long)length);
    }

    public IFSKey lock(long length) throws IOException {
        if (length <= 0L) {
            throw new ExtendedIllegalArgumentException("length (" + Long.toString(length) + ")", 2);
        }
        this.open();
        return this.impl_.lock(length);
    }

    protected void open() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException e) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)e);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    public int read() throws IOException {
        int value;
        byte[] data = new byte[1];
        int rc = this.read(data, 0, 1);
        if (rc == 1) {
            value = data[0];
            value &= 0xFF;
        } else {
            value = -1;
        }
        return value;
    }

    public int read(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (length == 0) {
            return 0;
        }
        this.open();
        return this.impl_.read(data, dataOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public void reset() throws IOException {
        if (this.fd_.isClosed()) {
            Trace.log(2, "The stream has been closed.");
            throw new IOException();
        }
        this.rewind();
    }

    public void rewind() {
        if (this.fd_.isOpen()) {
            this.fd_.setFileOffset(0L);
        }
    }

    public void setFD(IFSFileDescriptor fd) throws PropertyVetoException {
        if (fd == null) {
            throw new NullPointerException("fd");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("FD", 5);
        }
        IFSFileDescriptor oldFD = this.fd_;
        this.vetos_.fireVetoableChange("FD", oldFD, fd);
        this.fd_ = fd;
        this.changes_.firePropertyChange("FD", oldFD, this.fd_);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String newPath = path.length() == 0 || path.charAt(0) != '/' ? "/" + path : path;
        String oldPath = this.fd_.getPath();
        this.vetos_.fireVetoableChange("path", oldPath, newPath);
        this.fd_.setPath(newPath);
        this.changes_.firePropertyChange("path", oldPath, newPath);
    }

    public void setShareOption(int shareOption) throws PropertyVetoException {
        IFSFileInputStream.validateShareOption(shareOption);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer oldShareOption = null;
        Integer newShareOption = null;
        oldShareOption = new Integer(this.fd_.getShareOption());
        newShareOption = new Integer(shareOption);
        this.vetos_.fireVetoableChange("shareOption", oldShareOption, newShareOption);
        this.fd_.setShareOption(shareOption);
        this.changes_.firePropertyChange("shareOption", oldShareOption, newShareOption);
    }

    static final void validateShareOption(int shareOption) {
        if (shareOption < -4 || shareOption > -1) {
            throw new ExtendedIllegalArgumentException("shareOption (" + Integer.toString(shareOption) + ")", 2);
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldSystem = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", oldSystem, system);
        this.fd_.setSystem(system);
        this.changes_.firePropertyChange("system", oldSystem, system);
    }

    public long skip(long bytesToSkip) throws IOException {
        if (bytesToSkip < 0L) {
            throw new ExtendedIllegalArgumentException("bytesToSkip (" + Long.toString(bytesToSkip) + ")", 2);
        }
        this.open();
        return this.impl_.skip(bytesToSkip);
    }

    public void unlock(IFSKey key) throws IOException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.open();
        this.impl_.unlock(key);
    }
}

