/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTableWriter;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IFSFileWriter
extends Writer {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    private transient ConvTableWriter writer_;
    private IFSFileOutputStream outputStream_;

    public IFSFileWriter(IFSFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        int ccsid = file.getCCSID();
        if (ccsid == -1) {
            IFSFileWriter.throwException(file.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(file);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public IFSFileWriter(IFSFile file, int ccsid) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(file);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public IFSFileWriter(IFSFile file, boolean append) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        int ccsid = file.getCCSID();
        if (ccsid == -1) {
            IFSFileWriter.throwException(file.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(file, -1, append);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public IFSFileWriter(IFSFile file, boolean append, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        int ccsid = file.getCCSID();
        if (ccsid == -1) {
            IFSFileWriter.throwException(file.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(file, shareOption, append);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public IFSFileWriter(IFSFile file, boolean append, int shareOption, int ccsid) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(file, shareOption, append);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public IFSFileWriter(IFSFileDescriptor fd) throws AS400SecurityException, IOException {
        int ccsid = fd.getCCSID();
        if (ccsid == -1) {
            IFSFileWriter.throwException(fd.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(fd);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, ccsid);
    }

    public void close() throws IOException {
        this.writer_.close();
    }

    public void flush() throws IOException {
        this.writer_.flush();
    }

    public int getCCSID() {
        return this.writer_.getCcsid();
    }

    public String getEncoding() {
        return this.writer_.getEncoding();
    }

    public IFSKey lockBytes(int length) throws IOException {
        return this.lockBytes((long)length);
    }

    public IFSKey lockBytes(long length) throws IOException {
        return this.outputStream_.lock(length);
    }

    public void unlockBytes(IFSKey key) throws IOException {
        this.outputStream_.unlock(key);
    }

    public void write(int c) throws IOException {
        this.writer_.write(c);
    }

    public void write(char[] buffer) throws IOException {
        this.writer_.write(buffer);
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        this.writer_.write(buffer, offset, length);
    }

    public void write(String data) throws IOException {
        this.writer_.write(data);
    }

    public void write(String data, int offset, int length) throws IOException {
        this.writer_.write(data, offset, length);
    }

    private static final void throwException(String path) throws ExtendedIOException {
        Trace.log(2, "File does not exist or is not writable.");
        throw new ExtendedIOException(path, 2);
    }
}

