/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSObjAttrs1;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

class IFSListAttrsRep
extends IFSDataStream {
    private static final boolean DEBUG = false;
    static final int FILE = 1;
    static final int DIRECTORY = 2;
    static final int SYMBOLIC_LINK = 3;
    static final int AS400_OBJECT = 4;
    static final int DEVICE_FIFO = 5;
    static final int DEVICE_CHAR = 6;
    static final int DEVICE_BLOCK = 7;
    static final int SOCKET = 8;
    static final int FA_READONLY = 1;
    static final int FA_HIDDEN = 2;
    static final int FA_SYSTEM = 4;
    static final int FA_DIRECTORY = 16;
    static final int FA_ARCHIVE = 32;
    static final int OA_NONE = 0;
    static final int OA1 = 1;
    static final int OA2 = 2;
    private static final int TEMPLATE_LENGTH_OFFSET = 16;
    private static final int HEADER_LENGTH = 20;
    private static final int LLCP_LENGTH = 6;
    private static final int CREATE_DATE_OFFSET = 22;
    private static final int MODIFY_DATE_OFFSET = 30;
    private static final int ACCESS_DATE_OFFSET = 38;
    private static final int FILE_SIZE_OFFSET = 46;
    private static final int FIXED_ATTRS_OFFSET = 50;
    private static final int OBJECT_TYPE_OFFSET = 54;
    private static final int NUM_EXT_ATTRS_OFFSET = 56;
    private static final int BYTES_EA_NAMES_OFFSET = 58;
    private static final int BYTES_EA_VALUES_OFFSET = 62;
    private static final int VERSION_NUMBER_OFFSET = 66;
    private static final int AMOUNT_ACCESSED_OFFSET = 70;
    private static final int ACCESS_HISTORY_OFFSET = 72;
    private static final int NAME_CCSID_OFFSET = 73;
    private static final int CHECKOUT_CCSID_OFFSET = 75;
    private static final int RESTART_ID_OFFSET = 77;
    private static final int LARGE_FILE_SIZE_OFFSET = 81;
    private static final int SYMBOLIC_LINK_OFFSET = 91;
    private static final int FILE_SYSTEM_TYPE_OFFSET = 89;
    private static final int UNINITIALIZED = -1;

    IFSListAttrsRep() {
    }

    public Object getNewDataStream() {
        return new IFSListAttrsRep();
    }

    long getAccessDate() {
        return this.getDate(38);
    }

    int getCCSID(int datastreamLevel) {
        return this.getObjAttrs2().getCCSID(datastreamLevel);
    }

    long getCreationDate() {
        return this.getDate(22);
    }

    Hashtable getExtendedAttributeValues() {
        int optionalSectionOffset;
        Hashtable<String, byte[]> results = new Hashtable<String, byte[]>();
        int curLL_offset = optionalSectionOffset = 20 + this.get16bit(16);
        int curLL = this.get32bit(curLL_offset);
        int curCP = this.get16bit(curLL_offset + 4);
        while (curCP != 9 && curLL_offset + curLL + 6 <= this.data_.length) {
            curLL = this.get32bit(curLL_offset += curLL);
            curCP = this.get16bit(curLL_offset + 4);
        }
        if (curCP != 9) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "No Extended Attributes were returned.");
            }
            return results;
        }
        int eaListOffset = curLL_offset;
        byte[] eaVal = null;
        int eaCount = this.get16bit(eaListOffset + 6);
        int offset = eaListOffset + 8;
        for (int i = 0; i < eaCount; ++i) {
            int eaCcsid = this.get16bit(offset);
            int eaNameLL = this.get16bit(offset + 2);
            int eaValLL = this.get32bit(offset + 6);
            byte[] eaName = new byte[eaNameLL];
            System.arraycopy(this.data_, offset + 10, eaName, 0, eaNameLL);
            if (eaValLL > 4) {
                eaVal = new byte[eaValLL - 4];
                System.arraycopy(this.data_, offset + 10 + eaNameLL + 4, eaVal, 0, eaValLL - 4);
                try {
                    String eaNameString = CharConverter.byteArrayToString(eaCcsid, eaName);
                    results.put(eaNameString, eaVal);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Extended Attribute returned: " + eaNameString, eaVal);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Trace.log(2, e);
                }
            }
            offset += 10 + eaNameLL + eaValLL;
        }
        return results;
    }

    int getFixedAttributes() {
        return this.get32bit(50);
    }

    long getModificationDate() {
        return this.getDate(30);
    }

    byte[] getName() {
        int file_name_LL_offset = 20 + this.get16bit(16);
        int length = this.get32bit(file_name_LL_offset) - 6;
        byte[] name = new byte[length];
        System.arraycopy(this.data_, 6 + file_name_LL_offset, name, 0, length);
        return name;
    }

    IFSObjAttrs1 getObjAttrs1() {
        return new IFSObjAttrs1(this.getObjAttrBytes(1));
    }

    IFSObjAttrs2 getObjAttrs2() {
        return new IFSObjAttrs2(this.getObjAttrBytes(2));
    }

    private final byte[] getObjAttrBytes(int type) {
        if (type == 0) {
            return null;
        }
        int offset = 20 + this.get16bit(16);
        short oaCodePoint = type == 1 ? (short)16 : 15;
        byte[] buf = null;
        while (buf == null && offset < this.data_.length) {
            int length = this.get32bit(offset);
            short codePoint = (short)this.get16bit(offset + 4);
            if (codePoint == oaCodePoint) {
                int OAlength = length - 6;
                buf = new byte[OAlength];
                System.arraycopy(this.data_, offset + 6, buf, 0, OAlength);
                continue;
            }
            offset += length;
        }
        if (buf == null) {
            Trace.log(2, "The reply does not contain an OA" + type + " structure.");
            throw new InternalErrorException(6);
        }
        return buf;
    }

    int getObjectType() {
        return this.get16bit(54);
    }

    String getOwnerName(int systemCcsid) throws UnsupportedEncodingException {
        return this.getObjAttrs1().getOwnerName(systemCcsid);
    }

    int getASP() throws UnsupportedEncodingException {
        return this.getObjAttrs1().getASP();
    }

    long getOwnerUID() {
        return this.getObjAttrs2().getOwnerUID();
    }

    byte[] getRestartID() {
        byte[] restartID = new byte[4];
        System.arraycopy(this.data_, 77, restartID, 0, restartID.length);
        return restartID;
    }

    long getSize(int datastreamLevel) {
        if (datastreamLevel < 8 || datastreamLevel == 62708) {
            int size = this.get32bit(46);
            return (long)size & 0xFFFFFFFFL;
        }
        return this.get64bit(81);
    }

    long getSize8Bytes() {
        int optionalSectionOffset;
        long fileSize = 0L;
        int curLL_offset = optionalSectionOffset = 20 + this.get16bit(16);
        int curLL = this.get32bit(curLL_offset);
        int curCP = this.get16bit(curLL_offset + 4);
        while (curCP != 20 && curLL_offset + curLL + 6 <= this.data_.length) {
            curLL = this.get32bit(curLL_offset += curLL);
            curCP = this.get16bit(curLL_offset + 4);
        }
        if (curCP != 20) {
            Trace.log(2, "Error getting 8-byte file size: Optional field was not returned.");
            throw new InternalErrorException(6);
        }
        fileSize = this.get64bit(curLL_offset + 6);
        return fileSize;
    }

    boolean isSymbolicLink(int datastreamLevel) {
        boolean result = false;
        if (datastreamLevel < 8 || datastreamLevel == 62708) {
            Trace.log(4, "Could not determine whether file is a symbolic link.");
        } else {
            byte fieldValue = this.data_[91];
            switch (fieldValue) {
                case 0: {
                    result = false;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                default: {
                    Trace.log(2, "Internal error, unexpected value in symbolic link field: ", fieldValue);
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return 32773;
    }

    int getFileSystemType(int datastreamLevel) {
        int fileSystemType = -1;
        if (datastreamLevel < 8 || datastreamLevel == 62708) {
            Trace.log(4, "Could not determine the file system type, This field is only returned for data stream levels 8 and later.");
        } else {
            fileSystemType = this.get16bit(89);
        }
        return fileSystemType;
    }
}

