/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSObjAttrs1;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

class IFSLookupRep
extends IFSDataStream {
    private static final String copyright = "Copyright (C) 2004-2004 International Business Machines Corporation and others.";
    private static final int LLCP_LENGTH = 6;
    private static final int TEMPLATE_LENGTH_OFFSET = 16;
    private static final int OBJECT_HANDLE_OFFSET = 22;
    static final int OA_NONE = 0;
    static final int OA1 = 1;
    static final int OA2 = 2;

    IFSLookupRep() {
    }

    int getHandle() {
        return this.get32bit(22);
    }

    int getASP() throws UnsupportedEncodingException {
        return new IFSObjAttrs1(this.getObjAttrBytes(1)).getASP();
    }

    int getCCSID(int datastreamLevel) {
        return new IFSObjAttrs2(this.getObjAttrBytes(2)).getCCSID(datastreamLevel);
    }

    String getOwnerName(int systemCcsid) throws UnsupportedEncodingException {
        return new IFSObjAttrs1(this.getObjAttrBytes(1)).getOwnerName(systemCcsid);
    }

    public Object getNewDataStream() {
        return new IFSLookupRep();
    }

    public int hashCode() {
        return 32780;
    }

    private final byte[] getObjAttrBytes(int type) {
        if (type == 0) {
            return null;
        }
        int offset = 20 + this.get16bit(16);
        short oaCodePoint = type == 1 ? (short)16 : 15;
        byte[] buf = null;
        while (buf == null && offset < this.data_.length) {
            int length = this.get32bit(offset);
            short codePoint = (short)this.get16bit(offset + 4);
            if (codePoint == oaCodePoint) {
                int OAlength = length - 6;
                buf = new byte[OAlength];
                System.arraycopy(this.data_, offset + 6, buf, 0, OAlength);
                continue;
            }
            offset += length;
        }
        if (buf == null) {
            Trace.log(2, "The reply does not contain an OA" + type + " structure.");
            throw new InternalErrorException(6);
        }
        return buf;
    }
}

