/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class IFSRandomAccessFile
implements DataInput,
DataOutput,
Serializable {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    public static final int FAIL_OR_CREATE = 2;
    public static final int OPEN_OR_CREATE = 0;
    public static final int OPEN_OR_FAIL = 3;
    public static final int REPLACE_OR_CREATE = 1;
    public static final int REPLACE_OR_FAIL = 4;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private int existenceOption_;
    private IFSFileDescriptor fd_;
    private transient Vector fileListeners_;
    private String mode_ = "";
    private boolean forceToStorage_ = false;
    private transient byte[] bytes1;
    private transient byte[] bytes2;
    private transient byte[] bytes4;
    private transient byte[] bytes8;
    private transient IFSRandomAccessFileImpl impl_;

    public IFSRandomAccessFile() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSRandomAccessFile(AS400 system, String name, String mode) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(mode);
        this.mode_ = mode;
        this.existenceOption_ = mode.equals("r") ? 3 : 0;
        this.fd_ = new IFSFileDescriptor(system, name, -1, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(AS400 system, String name, String mode, int shareOption, int existenceOption) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(mode);
        this.mode_ = mode;
        IFSRandomAccessFile.validateShareOption(shareOption);
        IFSRandomAccessFile.validateExistenceOption(existenceOption);
        this.existenceOption_ = existenceOption;
        this.fd_ = new IFSFileDescriptor(system, name, shareOption, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(AS400 system, IFSFile file, String mode, int shareOption, int existenceOption) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(mode);
        this.mode_ = mode;
        IFSRandomAccessFile.validateShareOption(shareOption);
        IFSRandomAccessFile.validateExistenceOption(existenceOption);
        this.existenceOption_ = existenceOption;
        this.fd_ = new IFSFileDescriptor(system, file.getAbsolutePath(), shareOption, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(IFSFile file, String mode, int shareOption, int existenceOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(mode);
        this.mode_ = mode;
        IFSRandomAccessFile.validateShareOption(shareOption);
        IFSRandomAccessFile.validateExistenceOption(existenceOption);
        this.existenceOption_ = existenceOption;
        this.fd_ = new IFSFileDescriptor(file.getSystem(), file.getAbsolutePath(), shareOption, this);
        this.connectAndOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    void chooseImpl() {
        if (this.impl_ == null) {
            AS400 system = this.fd_.getSystem();
            if (system == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSRandomAccessFileImpl)system.loadImpl2("com.ibm.as400.access.IFSRandomAccessFileImplRemote", "com.ibm.as400.access.IFSRandomAccessFileImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
            this.impl_.setExistenceOption(this.existenceOption_);
            this.impl_.setForceToStorage(this.forceToStorage_);
            this.impl_.setMode(this.mode_);
        }
    }

    public void close() throws IOException {
        if (this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable e) {
            throw new IOException(e.toString());
        }
    }

    public void flush() throws IOException {
        this.open();
        this.impl_.flush();
    }

    public int getExistenceOption() {
        return this.existenceOption_;
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    public long getFilePointer() throws IOException {
        this.open();
        return this.fd_.getFileOffset();
    }

    IFSRandomAccessFileImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.bytes1 = new byte[1];
        this.bytes2 = new byte[2];
        this.bytes4 = new byte[4];
        this.bytes8 = new byte[8];
        this.impl_ = null;
    }

    public long length() throws IOException {
        this.open();
        return this.impl_.length();
    }

    public IFSKey lock(int offset, int length) throws IOException {
        if (offset < 0) {
            throw new ExtendedIllegalArgumentException("offset (" + Integer.toString(offset) + ")", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(length) + ")", 2);
        }
        this.open();
        return this.impl_.lock(offset, length);
    }

    public IFSKey lock(long offset, long length) throws IOException {
        if (offset < 0L) {
            throw new ExtendedIllegalArgumentException("offset (" + Long.toString(offset) + ")", 2);
        }
        if (length <= 0L) {
            throw new ExtendedIllegalArgumentException("length (" + Long.toString(length) + ")", 2);
        }
        this.open();
        return this.impl_.lock(offset, length);
    }

    private void open() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException e) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)e);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    public int read() throws IOException {
        int value;
        int rc = this.read(this.bytes1, 0, 1);
        if (rc == 1) {
            value = this.bytes1[0];
            value &= 0xFF;
        } else {
            value = -1;
        }
        return value;
    }

    public int read(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (length == 0) {
            return 0;
        }
        this.open();
        return this.impl_.read(data, dataOffset, length, false);
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public final byte readByte() throws IOException {
        int bytesRead = this.read(this.bytes1, 0, 1);
        if (bytesRead != 1) {
            throw new EOFException();
        }
        return this.bytes1[0];
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final double readDouble() throws IOException {
        long value = this.readLong();
        return Double.longBitsToDouble(value);
    }

    public final float readFloat() throws IOException {
        int value = this.readInt();
        return Float.intBitsToFloat(value);
    }

    public final void readFully(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.readFully(data, 0, data.length);
    }

    public final void readFully(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open();
        this.impl_.read(data, dataOffset, length, true);
    }

    public final int readInt() throws IOException {
        int bytesRead = this.read(this.bytes4, 0, 4);
        if (bytesRead != 4) {
            throw new EOFException();
        }
        return (this.bytes4[0] & 0xFF) << 24 | (this.bytes4[1] & 0xFF) << 16 | (this.bytes4[2] & 0xFF) << 8 | this.bytes4[3] & 0xFF;
    }

    public final String readLine() throws IOException {
        this.open();
        return this.impl_.readLine();
    }

    public final long readLong() throws IOException {
        int bytesRead = this.read(this.bytes8, 0, 8);
        if (bytesRead != 8) {
            throw new EOFException();
        }
        return ((long)this.bytes8[0] & 0xFFL) << 56 | ((long)this.bytes8[1] & 0xFFL) << 48 | ((long)this.bytes8[2] & 0xFFL) << 40 | ((long)this.bytes8[3] & 0xFFL) << 32 | ((long)this.bytes8[4] & 0xFFL) << 24 | ((long)this.bytes8[5] & 0xFFL) << 16 | ((long)this.bytes8[6] & 0xFFL) << 8 | (long)this.bytes8[7] & 0xFFL;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    public final short readShort() throws IOException {
        int bytesRead = this.read(this.bytes2, 0, 2);
        if (bytesRead != 2) {
            throw new EOFException();
        }
        return (short)((this.bytes2[0] & 0xFF) << 8 | this.bytes2[1] & 0xFF);
    }

    public final int readUnsignedByte() throws IOException {
        int bytesRead = this.read(this.bytes1, 0, 1);
        if (bytesRead != 1) {
            throw new EOFException();
        }
        int i = this.bytes1[0];
        return i &= 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int bytesRead = this.read(this.bytes2, 0, 2);
        if (bytesRead != 2) {
            throw new EOFException();
        }
        int i = (this.bytes2[0] & 0xFF) << 8 | this.bytes2[1] & 0xFF;
        if (i < 0) {
            i += 65536;
        }
        return i;
    }

    public final String readUTF() throws IOException {
        this.open();
        return this.impl_.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new ExtendedIllegalArgumentException("position (" + Long.toString(position) + ")", 2);
        }
        this.open();
        this.fd_.setFileOffset(position);
    }

    public void setExistenceOption(int existenceOption) throws PropertyVetoException {
        IFSRandomAccessFile.validateExistenceOption(existenceOption);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("existenceOption", 5);
        }
        Integer oldExistenceOption = new Integer(this.existenceOption_);
        Integer newExistenceOption = new Integer(existenceOption);
        this.vetos_.fireVetoableChange("existenceOption", oldExistenceOption, newExistenceOption);
        this.existenceOption_ = existenceOption;
        this.changes_.firePropertyChange("existenceOption", oldExistenceOption, newExistenceOption);
    }

    void setForceToStorage(boolean forceToStorage) {
        this.forceToStorage_ = forceToStorage;
        if (this.impl_ != null) {
            this.impl_.setForceToStorage(forceToStorage);
        }
    }

    public void setLength(int length) throws IOException {
        this.setLength((long)length);
    }

    public void setLength(long length) throws IOException {
        if (length < 0L) {
            throw new ExtendedIllegalArgumentException("length + (" + Long.toString(length) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.setLength(length);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }

    public void setMode(String mode) throws PropertyVetoException {
        IFSRandomAccessFile.validateMode(mode);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("mode", 5);
        }
        String oldMode = this.mode_;
        this.vetos_.fireVetoableChange("mode", oldMode, mode);
        this.mode_ = mode;
        this.changes_.firePropertyChange("mode", oldMode, mode);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String oldPath = this.fd_.getPath();
        String newPath = path.length() == 0 || path.charAt(0) != '/' ? "/" + path : path;
        this.vetos_.fireVetoableChange("path", oldPath, newPath);
        this.fd_.setPath(newPath);
        this.changes_.firePropertyChange("path", oldPath, newPath);
    }

    public void setShareOption(int shareOption) throws PropertyVetoException {
        IFSRandomAccessFile.validateShareOption(shareOption);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer oldShareOption = new Integer(this.fd_.getShareOption());
        Integer newShareOption = new Integer(shareOption);
        this.vetos_.fireVetoableChange("shareOption", oldShareOption, newShareOption);
        this.fd_.setShareOption(shareOption);
        this.changes_.firePropertyChange("shareOption", oldShareOption, newShareOption);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldSystem = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", oldSystem, system);
        this.fd_.setSystem(system);
        this.changes_.firePropertyChange("system", oldSystem, system);
    }

    public int skipBytes(int bytesToSkip) throws IOException {
        long bytesSkipped = this.skipBytes((long)bytesToSkip);
        if (bytesSkipped > (long)bytesToSkip) {
            Trace.log(2, "Returned bytesSkipped value (" + bytesSkipped + ") exceeds requested number of bytes to skip (" + bytesToSkip + ").");
            throw new InternalErrorException(6);
        }
        return (int)bytesSkipped;
    }

    public long skipBytes(long bytesToSkip) throws IOException {
        if (bytesToSkip < 0L) {
            throw new ExtendedIllegalArgumentException("bytesToSkip (" + Long.toString(bytesToSkip) + ")", 2);
        }
        this.open();
        this.fd_.incrementFileOffset(bytesToSkip);
        return bytesToSkip;
    }

    public void unlock(IFSKey key) throws IOException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.open();
        this.impl_.unlock(key);
    }

    private static final void validateExistenceOption(int existenceOption) {
        if (existenceOption < 0 || existenceOption > 4) {
            throw new ExtendedIllegalArgumentException("existenceOption (" + Integer.toString(existenceOption) + ")", 2);
        }
    }

    private static final void validateMode(String mode) {
        if (mode == null) {
            throw new NullPointerException("mode");
        }
        if (!(mode.equals("r") || mode.equals("w") || mode.equals("rw"))) {
            throw new ExtendedIllegalArgumentException("mode (" + mode + ")", 2);
        }
    }

    private static final void validateShareOption(int shareOption) {
        if (shareOption < -4 || shareOption > -1) {
            throw new ExtendedIllegalArgumentException("shareOption (" + Integer.toString(shareOption) + ")", 2);
        }
    }

    public void write(int b) throws IOException {
        this.bytes1[0] = (byte)b;
        this.writeBytes(this.bytes1, 0, 1);
    }

    public void write(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.writeBytes(data, 0, data.length);
    }

    public void write(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.writeBytes(data, dataOffset, length);
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public final void writeByte(int value) throws IOException {
        this.bytes1[0] = (byte)value;
        this.writeBytes(this.bytes1, 0, 1);
    }

    private void writeBytes(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open();
        this.impl_.writeBytes(data, dataOffset, length);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }

    public final void writeBytes(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        byte[] data = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            data[i] = (byte)(c & 0xFF);
        }
        this.writeBytes(data, 0, data.length);
    }

    public final void writeChar(int value) throws IOException {
        char c = (char)value;
        this.bytes2[0] = (byte)(c >>> 8);
        this.bytes2[1] = (byte)(c & 0xFF);
        this.writeBytes(this.bytes2, 0, 2);
    }

    public final void writeChars(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        byte[] data = new byte[s.length() * 2];
        int i = 0;
        int j = 0;
        while (i < s.length()) {
            char character = s.charAt(i);
            data[j + 1] = (byte)(character & 0xFF);
            data[j] = (byte)(character >>> 8);
            ++i;
            j += 2;
        }
        this.writeBytes(data, 0, data.length);
    }

    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeInt(int value) throws IOException {
        int v = value;
        int i = 0;
        while (i < 4) {
            this.bytes4[3 - i] = (byte)v;
            ++i;
            v >>>= 8;
        }
        this.writeBytes(this.bytes4, 0, 4);
    }

    public final void writeLong(long value) throws IOException {
        long v = value;
        int i = 0;
        while (i < 8) {
            this.bytes8[7 - i] = (byte)v;
            ++i;
            v >>>= 8;
        }
        this.writeBytes(this.bytes8, 0, 8);
    }

    public final void writeShort(int value) throws IOException {
        this.bytes2[1] = (byte)value;
        this.bytes2[0] = (byte)(value >>> 8);
        this.writeBytes(this.bytes2, 0, 2);
    }

    public final void writeUTF(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        this.open();
        this.impl_.writeUTF(s);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }
}

