/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSRandomAccessFileImplProxy
extends AbstractProxyImpl
implements IFSRandomAccessFileImpl {
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false, false};

    IFSRandomAccessFileImplProxy() {
        super("IFSRandomAccessFile");
    }

    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void connectAndOpen() throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen");
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof AS400SecurityException) {
                throw (AS400SecurityException)e1;
            }
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void flush() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "flush");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public long length() throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "length").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public IFSKey lock(long offset, long length) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE, Long.TYPE}, new Object[]{new Long(offset), new Long(length)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void open() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public int read(byte[] data, int dataOffset, int length, boolean readFully) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{data, new Integer(dataOffset), new Integer(length), new Boolean(readFully)}, ARGS_TO_RETURN, readFully);
            byte[] returnDataBuffer = (byte[])rv.getArgument(0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = returnDataBuffer[i];
            }
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public String readLine() throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readLine").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public String readUTF() throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readUTF").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void setExistenceOption(int existenceOption) {
        try {
            this.connection_.callMethod(this.pxId_, "setExistenceOption", new Class[]{Integer.TYPE}, new Object[]{new Integer(existenceOption)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setFD(IFSFileDescriptorImpl fd) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{fd});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setForceToStorage(boolean forceToStorage) {
        try {
            this.connection_.callMethod(this.pxId_, "setForceToStorage", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(forceToStorage)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setLength(long length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "setLength", new Class[]{Long.TYPE}, new Object[]{new Long(length)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void setMode(String mode) {
        try {
            this.connection_.callMethod(this.pxId_, "setMode", new Class[]{String.class}, new Object[]{mode});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void unlock(IFSKey key) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void writeBytes(byte[] data, int dataOffset, int length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeBytes", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, new Integer(dataOffset), new Integer(length)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void writeUTF(String s) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeUTF", new Class[]{String.class}, new Object[]{s});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

