/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDCursor {
    private static final int OPEN_READONLY_ = 128;
    private static final int OPEN_ALL_ = 240;
    private static final int FULL_OPEN_ = 1;
    static final int REUSE_NO = 240;
    static final int REUSE_YES = 241;
    static final int REUSE_RESULT_SET = 242;
    private boolean closed_ = true;
    private AS400JDBCConnection connection_;
    private int id_;
    private boolean lazyClose_;
    private String name_;
    private int concurrency_;
    private int holdable_ = -1;
    private int scrollable_ = -1;
    private int updatable_ = -1;
    private int sensitive_ = -1;
    private int isolationLevel_ = -1;
    private boolean extendedMetaData_ = false;
    private DBReplyRequestedDS openReply = null;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_ = null;

    JDCursor(AS400JDBCConnection connection, int id, String name, int concurrency) throws SQLException {
        this.concurrency_ = concurrency;
        this.connection_ = connection;
        this.id_ = id;
        this.name_ = name;
        this.lazyClose_ = this.connection_.getProperties().getBoolean(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(int reuseFlag) throws SQLException {
        block11: {
            DBSQLRequestDS request = null;
            boolean keepDS = false;
            try {
                try {
                    request = DBDSPool.getDBSQLRequestDS(6154, this.id_, 0, 0);
                    request.setReuseIndicator(reuseFlag);
                    if (this.lazyClose_) {
                        keepDS = true;
                        this.connection_.sendAndHold(request, this.id_);
                    } else {
                        this.connection_.send(request, this.id_);
                    }
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException("HY000", e);
                    Object var6_5 = null;
                    if (request != null && !keepDS) {
                        request.returnToPool();
                        request = null;
                    }
                    break block11;
                }
                Object var6_4 = null;
                if (request == null || keepDS) break block11;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (request != null && !keepDS) {
                    request.returnToPool();
                    request = null;
                }
                throw throwable;
            }
            request.returnToPool();
            request = null;
        }
        if (this.openReply != null) {
            this.openReply.returnToPool();
            this.openReply = null;
        }
        this.closed_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Closing with reuse flag = " + reuseFlag);
            JDTrace.logClose(this);
        }
    }

    String getName() {
        return this.name_;
    }

    int getOpenAttributes(JDSQLStatement sqlStatement, String blockCriteria) throws SQLException {
        int returnValue = 240;
        if (sqlStatement == null) {
            returnValue = 128;
        } else if (sqlStatement.isProcedureCall()) {
            returnValue = 128;
        } else if (sqlStatement.isSelect() && !blockCriteria.equalsIgnoreCase("0") && (this.connection_.isReadOnly() || !sqlStatement.isForUpdate() && this.concurrency_ != 1008)) {
            returnValue = 128;
        }
        if (this.connection_.getProperties().getBoolean(45) && this.connection_.getServerFunctionalLevel() >= 9) {
            returnValue |= 1;
        }
        return returnValue;
    }

    int getConcurrency() {
        return this.concurrency_;
    }

    boolean isClosed() {
        return this.closed_;
    }

    void setExtendedColumnDescriptorsFromReply(DBReplyRequestedDS reply) {
        this.extendedColumnDescriptors_ = this.extendedMetaData_ ? reply.getExtendedColumnDescriptors() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DBDataFormat openDescribe(int openAttributes, int resultSetType) throws SQLException {
        DBDataFormat dataFormat;
        block11: {
            dataFormat = null;
            try {
                DBBaseRequestDS request = null;
                try {
                    int requestedORS = -1979711488;
                    if (this.extendedMetaData_) {
                        requestedORS += 131072;
                    }
                    request = DBDSPool.getDBSQLRequestDS(6148, this.id_, requestedORS, 0);
                    ((DBSQLRequestDS)request).setOpenAttributes(openAttributes);
                    String cursorSensitivity = this.connection_.getProperties().getString(49);
                    if (this.connection_.getVRM() <= JDUtilities.vrm520) {
                        ((DBSQLRequestDS)request).setScrollableCursorFlag(0);
                    } else {
                        ((DBSQLRequestDS)request).setScrollableCursorFlag(AS400JDBCResultSet.getDBSQLRequestDSCursorType(cursorSensitivity, resultSetType, 1007));
                    }
                    if (this.openReply != null) {
                        this.openReply.returnToPool();
                        this.openReply = null;
                    }
                    this.openReply = this.connection_.sendAndReceive(request, this.id_);
                    int errorClass = this.openReply.getErrorClass();
                    int returnCode = this.openReply.getReturnCode();
                    if (errorClass != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    }
                    this.processConcurrencyOverride(openAttributes, this.openReply);
                    dataFormat = this.openReply.getDataFormat();
                    this.setExtendedColumnDescriptorsFromReply(this.openReply);
                    dataFormat.setCSRSData(true);
                    Object var10_10 = null;
                    if (request == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
        }
        this.closed_ = false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, null);
        }
        return dataFormat;
    }

    void processConcurrencyOverride(int openAttributes, DBBaseReplyDS reply) throws DBDataStreamException {
        DBReplySQLCA sqlca = reply.getSQLCA();
        switch (sqlca.getWarn5()) {
            case -15: 
            case -14: {
                this.concurrency_ = 1007;
                break;
            }
            case -12: {
                this.concurrency_ = 1008;
            }
        }
    }

    void processCursorAttributes(DBBaseReplyDS reply) throws SQLException {
        this.holdable_ = reply.getCursorAttributeHoldable();
        this.scrollable_ = reply.getCursorAttributeScrollable();
        this.updatable_ = reply.getCursorAttributeUpdatable();
        this.sensitive_ = reply.getCursorAttributeSensitive();
        this.isolationLevel_ = reply.getCursorIsolationLevel();
    }

    public int getCursorAttributeHoldable() {
        return this.holdable_;
    }

    public int getCursorAttributeScrollable() {
        return this.scrollable_;
    }

    public int getCursorAttributeUpdatable() {
        return this.updatable_;
    }

    public int getCursorAttributeSensitive() {
        return this.sensitive_;
    }

    public int getCursorIsolationLevel() {
        return this.isolationLevel_;
    }

    void setExtendedMetaData(boolean extendedMetaData) {
        this.extendedMetaData_ = extendedMetaData;
    }

    void setName(String name) {
        this.name_ = name;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setName", "Name", this.name_);
        }
    }

    void setState(boolean closed) {
        this.closed_ = closed;
        if (JDTrace.isTraceOn()) {
            if (this.closed_) {
                JDTrace.logClose(this);
            } else {
                JDTrace.logOpen(this, null);
            }
        }
    }

    DBExtendedColumnDescriptors getExtendedColumnDescriptors() {
        return this.extendedColumnDescriptors_;
    }

    public String toString() {
        return this.name_;
    }
}

