/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyPackageInfo;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDPackageManager {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String SUFFIX_INVARIANT_ = "9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA";
    private boolean cache_;
    private DBReplyPackageInfo cachedPackage_;
    private ConvTable cachedPackageConverter_;
    private int cachedStatementCount_;
    private boolean clear_;
    private AS400JDBCConnection connection_;
    private boolean created_;
    private boolean enabled_;
    private String error_;
    private int id_;
    private String libraryName_;
    private String name_;
    private int threshold_;

    JDPackageManager(AS400JDBCConnection connection, int id, JDProperties properties, int commitMode) throws SQLException {
        this.enabled_ = properties.getBoolean(7);
        if (this.enabled_) {
            this.cache_ = properties.getBoolean(12);
            this.clear_ = properties.getBoolean(13);
            this.connection_ = connection;
            this.created_ = false;
            this.error_ = properties.getString(14);
            this.id_ = id;
            this.threshold_ = this.clear_ ? 512 : 0;
            String packageLibrary = properties.getString(15);
            this.libraryName_ = packageLibrary.length() > 0 ? packageLibrary.toUpperCase() : "QGPL";
            String packageName = properties.getString(10);
            if (packageName.length() > 0) {
                StringBuffer buffer = new StringBuffer(10);
                String normalizedName = packageName.length() >= 6 ? packageName.substring(0, 6) : packageName;
                buffer.append(normalizedName.toUpperCase().replace(' ', '_'));
                buffer.append(this.getSuffix(properties, commitMode));
                this.name_ = buffer.toString();
            } else {
                this.enabled_ = false;
                this.postError("01H11");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache() throws SQLException {
        if (this.enabled_) {
            try {
                DBReplyRequestedDS reply;
                block11: {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this.connection_, "Caching package [" + this.name_ + "]");
                    }
                    DBSQLRequestDS request = null;
                    reply = null;
                    try {
                        request = DBDSPool.getDBSQLRequestDS(6165, this.id_, -2146435072, 0);
                        request.setPackageName(this.name_, this.connection_.getConverter());
                        request.setLibraryName(this.libraryName_, this.connection_.getConverter());
                        request.setReturnSize(0);
                        reply = this.connection_.sendAndReceive(request, this.id_);
                        int errorClass = reply.getErrorClass();
                        if (errorClass != 0) {
                            this.cache_ = false;
                            this.postError("01H12");
                        } else {
                            this.cachedPackage_ = reply.getPackageInfo();
                            this.cachedPackageConverter_ = this.connection_.getConverter(this.cachedPackage_.getCCSID());
                            this.cachedStatementCount_ = this.cachedPackage_.getStatementCount();
                        }
                        Object var5_5 = null;
                        if (request == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (reply != null) {
                            reply.returnToPool();
                            reply = null;
                        }
                        throw throwable;
                    }
                    request.returnToPool();
                    request = null;
                }
                if (reply != null) {
                    reply.returnToPool();
                    reply = null;
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create() throws SQLException {
        if (this.enabled_) {
            try {
                DBReplyRequestedDS reply;
                block16: {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this.connection_, "Creating package [" + this.name_ + " in " + this.libraryName_ + "]");
                    }
                    DBSQLRequestDS request = null;
                    reply = null;
                    try {
                        request = DBDSPool.getDBSQLRequestDS(6159, this.id_, Integer.MIN_VALUE, 0);
                        request.setPackageName(this.name_, this.connection_.getConverter());
                        request.setLibraryName(this.libraryName_, this.connection_.getConverter());
                        reply = this.connection_.sendAndReceive(request, this.id_);
                        int errorClass = reply.getErrorClass();
                        int returnCode = reply.getReturnCode();
                        if (errorClass == 1 && returnCode == -601) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this.connection_, "Package [" + this.name_ + "] already exists");
                            }
                            if (this.cache_) {
                                this.cache();
                            }
                        } else if (returnCode == -999999) {
                            this.enabled_ = false;
                            this.postError("01H11");
                        } else if (errorClass != 0) {
                            this.enabled_ = false;
                            this.postError(this.connection_, this.id_, errorClass, returnCode);
                        }
                        Object var6_6 = null;
                        if (request == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (reply != null) {
                            reply.returnToPool();
                            reply = null;
                        }
                        throw throwable;
                    }
                    request.returnToPool();
                    request = null;
                }
                if (reply != null) {
                    reply.returnToPool();
                    reply = null;
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
        }
        this.created_ = true;
    }

    DBDataFormat getCachedDataFormat(int statementIndex) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getDataFormat(statementIndex);
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        return null;
    }

    DBDataFormat getCachedParameterMarkerFormat(int statementIndex) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getParameterMarkerFormat(statementIndex);
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        return null;
    }

    int getCachedStatementIndex(JDSQLStatement sqlStatement) throws SQLException {
        if (!this.isCached()) {
            return -1;
        }
        String statementText = sqlStatement.toString();
        int statementTextLength = statementText.length();
        if (this.connection_.getVRM() >= JDUtilities.vrm510) {
            statementTextLength *= 2;
        }
        for (int i = 0; i < this.cachedStatementCount_; ++i) {
            try {
                if (statementTextLength != this.cachedPackage_.getStatementTextLength(i) || !statementText.equals(this.cachedPackage_.getStatementText(i, this.cachedPackageConverter_))) continue;
                return i;
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
        }
        return -1;
    }

    String getCachedStatementName(int statementIndex) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getStatementName(statementIndex, null);
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        return null;
    }

    String getLibraryName() {
        return this.libraryName_;
    }

    String getName() {
        return this.name_;
    }

    private String getSuffix(JDProperties properties, int commitMode) {
        StringBuffer suffix = new StringBuffer(4);
        int index = properties.getIndex(55);
        suffix.append(SUFFIX_INVARIANT_.charAt(index));
        int dateSep = properties.getIndex(4);
        if (commitMode == 4) {
            switch (dateSep) {
                case 0: 
                case 1: 
                case 2: {
                    commitMode = dateSep;
                    dateSep = 6;
                    break;
                }
                case 3: 
                case 4: {
                    commitMode = dateSep - 2;
                    dateSep = 7;
                }
            }
        }
        index = commitMode << 3 | properties.getIndex(3);
        suffix.append(SUFFIX_INVARIANT_.charAt(index));
        index = properties.getIndex(5) << 4 | properties.getIndex(9) << 3 | dateSep;
        suffix.append(SUFFIX_INVARIANT_.charAt(index));
        index = properties.getIndex(24) << 2 | properties.getIndex(25);
        suffix.append(SUFFIX_INVARIANT_.charAt(index));
        return suffix.toString();
    }

    int getThreshold() {
        return this.threshold_;
    }

    boolean isCached() {
        return this.cachedPackage_ != null;
    }

    boolean isCreated() {
        return this.created_;
    }

    boolean isEnabled() {
        return this.enabled_;
    }

    private void postError(String sqlState) throws SQLException {
        if (this.error_.equalsIgnoreCase("exception")) {
            JDError.throwSQLException(sqlState);
        } else if (this.error_.equalsIgnoreCase("warning")) {
            this.connection_.postWarning(JDError.getSQLWarning(sqlState));
        }
    }

    private void postError(AS400JDBCConnection connection, int id, int errorClass, int returnCode) throws SQLException {
        if (this.error_.equalsIgnoreCase("exception")) {
            JDError.throwSQLException(this, connection, id, errorClass, returnCode);
        } else if (this.error_.equalsIgnoreCase("warning")) {
            this.connection_.postWarning(JDError.getSQLWarning(connection, id, errorClass, returnCode));
        }
    }
}

