/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSimpleRow;
import java.sql.SQLException;
import java.util.Vector;

class JDSimpleRowCache
implements JDRowCache {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int index_;
    private JDSimpleRow row_;
    private Object[][] data_;
    private boolean[][] nulls_;
    private boolean[][] dataMappingErrors_;
    private boolean valid_;

    JDSimpleRowCache(JDSimpleRow formatRow) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = formatRow;
        int fieldCount = this.row_.getFieldCount();
        this.data_ = new Object[0][fieldCount];
        this.nulls_ = new boolean[0][fieldCount];
        this.dataMappingErrors_ = new boolean[0][fieldCount];
    }

    JDSimpleRowCache(JDSimpleRow formatRow, Object[][] data, boolean[][] nulls, boolean[][] dataMappingErrors) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = formatRow;
        this.data_ = data;
        this.nulls_ = nulls;
        this.dataMappingErrors_ = dataMappingErrors;
    }

    JDSimpleRowCache(JDSimpleRow formatRow, Object[][] data) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = formatRow;
        this.data_ = data;
        this.nulls_ = new boolean[data.length][data[0].length];
        this.dataMappingErrors_ = new boolean[data.length][data[0].length];
    }

    JDSimpleRowCache(JDRowCache otherRowCache) throws SQLException {
        Vector<Object[]> tempData = new Vector<Object[]>();
        Vector<boolean[]> tempNulls = new Vector<boolean[]>();
        Vector<boolean[]> tempDataMappingErrors = new Vector<boolean[]>();
        JDRow otherRow = otherRowCache.getRow();
        int fieldCount = otherRow.getFieldCount();
        int rowCount = 0;
        this.row_ = new JDSimpleRow(otherRow, false);
        otherRowCache.open();
        otherRowCache.next();
        while (otherRowCache.isValid()) {
            Object[] rowOfData = new Object[fieldCount];
            boolean[] rowOfNulls = new boolean[fieldCount];
            boolean[] rowOfDataMappingErrors = new boolean[fieldCount];
            for (int i = 1; i <= fieldCount; ++i) {
                rowOfData[i - 1] = otherRow.getSQLData(i).getObject();
                rowOfNulls[i - 1] = otherRow.isNull(i);
                rowOfDataMappingErrors[i - 1] = otherRow.isDataMappingError(i);
            }
            tempData.addElement(rowOfData);
            tempNulls.addElement(rowOfNulls);
            tempDataMappingErrors.addElement(rowOfDataMappingErrors);
            ++rowCount;
            otherRowCache.next();
        }
        this.index_ = -1;
        this.data_ = new Object[rowCount][fieldCount];
        this.nulls_ = new boolean[rowCount][fieldCount];
        this.dataMappingErrors_ = new boolean[rowCount][fieldCount];
        this.valid_ = false;
        for (int i = 0; i < rowCount; ++i) {
            this.data_[i] = (Object[])tempData.elementAt(i);
            this.nulls_[i] = (boolean[])tempNulls.elementAt(i);
            this.dataMappingErrors_[i] = (boolean[])tempDataMappingErrors.elementAt(i);
        }
    }

    private void reposition(boolean valid) throws SQLException {
        this.valid_ = valid;
        if (this.valid_) {
            this.row_.setData(this.data_[this.index_]);
            this.row_.setNulls(this.nulls_[this.index_]);
            this.row_.setDataMappingErrors(this.dataMappingErrors_[this.index_]);
        }
    }

    public void open() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void flush() throws SQLException {
    }

    public JDRow getRow() {
        return this.row_;
    }

    public boolean isEmpty() throws SQLException {
        return this.data_.length == 0;
    }

    public boolean isValid() {
        return this.valid_;
    }

    public void absolute(int rowNumber) throws SQLException {
        if (rowNumber > 0) {
            if (rowNumber <= this.data_.length) {
                this.index_ = rowNumber - 1;
                this.reposition(true);
            } else {
                this.index_ = this.data_.length;
                this.reposition(false);
            }
        } else if (rowNumber < 0) {
            if (-rowNumber <= this.data_.length) {
                this.index_ = this.data_.length + rowNumber;
                this.reposition(true);
            } else {
                this.index_ = -1;
                this.reposition(false);
            }
        }
    }

    public void afterLast() throws SQLException {
        this.index_ = this.data_.length;
        this.reposition(false);
    }

    public void beforeFirst() throws SQLException {
        this.index_ = -1;
        this.reposition(false);
    }

    public void first() throws SQLException {
        this.index_ = 0;
        this.reposition(this.data_.length > 0);
    }

    public void last() throws SQLException {
        this.index_ = this.data_.length - 1;
        this.reposition(this.data_.length > 0);
    }

    public void next() throws SQLException {
        if (this.index_ < this.data_.length - 1) {
            ++this.index_;
            this.reposition(true);
        } else {
            this.index_ = this.data_.length;
            this.reposition(false);
        }
    }

    public void previous() throws SQLException {
        if (this.index_ > 0) {
            --this.index_;
            this.reposition(true);
        } else {
            this.index_ = -1;
            this.reposition(false);
        }
    }

    public void refreshRow() throws SQLException {
        this.reposition(this.valid_);
    }

    public void relative(int rowIndex) throws SQLException {
        int newIndex = this.index_ + rowIndex;
        if (newIndex >= 0 && newIndex < this.data_.length) {
            this.index_ = newIndex;
            this.reposition(true);
        } else {
            this.reposition(false);
        }
    }

    public void setResultSet(AS400JDBCResultSet resultSet) {
    }
}

