/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDResultSetProxy;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.ProxyReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class JDStatementProxy
extends AbstractProxyImpl
implements Statement {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected JDConnectionProxy jdConnection_;
    protected JDResultSetProxy cachedResultSet_;
    private static final String EXC_FUNCTION_NOT_SUPPORTED = "IM001";

    public JDStatementProxy(JDConnectionProxy jdConnection) {
        this.jdConnection_ = jdConnection;
    }

    public void addBatch(String sql) throws SQLException {
        this.callMethod("addBatch", new Class[]{String.class}, new Object[]{sql});
    }

    protected void callMethod(String methodName) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected void callMethod(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected boolean callMethodRtnBool(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected int callMethodRtnInt(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected long callMethodRtnLong(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsLong(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected Object callMethodRtnObj(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected ProxyReturnValue callMethodRtnRaw(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public void cancel() throws SQLException {
        this.cachedResultSet_ = null;
        this.callMethod("cancel");
    }

    public void clearBatch() throws SQLException {
        this.callMethod("clearBatch");
    }

    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    public void close() throws SQLException {
        block2: {
            this.cachedResultSet_ = null;
            try {
                this.callMethod("close");
            }
            catch (ProxyException pe) {
                String info = pe.toString();
                if (info.indexOf("dropped") >= 0) break block2;
                throw pe;
            }
        }
    }

    public boolean execute(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("execute", new Class[]{String.class}, new Object[]{sql}).getReturnValueBoolean();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("execute", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, new Integer(autoGeneratedKeys)}).getReturnValueBoolean();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public int[] executeBatch() throws SQLException {
        this.cachedResultSet_ = null;
        return (int[])this.callMethodRtnObj("executeBatch");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        try {
            JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
            this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "executeQuery", new Class[]{String.class}, new Object[]{sql}, newResultSet);
            return this.cachedResultSet_;
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeUpdate", new Class[]{String.class}, new Object[]{sql}).getReturnValueInt();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, new Integer(autoGeneratedKeys)}).getReturnValueInt();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public Connection getConnection() {
        return this.jdConnection_;
    }

    public int getFetchDirection() throws SQLException {
        return this.callMethodRtnInt("getFetchDirection");
    }

    public int getFetchSize() throws SQLException {
        return this.callMethodRtnInt("getFetchSize");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.cachedResultSet_ = null;
        try {
            JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
            this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "getGeneratedKeys", newResultSet);
            return this.cachedResultSet_;
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.callMethodRtnInt("getMaxFieldSize");
    }

    public int getMaxRows() throws SQLException {
        return this.callMethodRtnInt("getMaxRows");
    }

    public boolean getMoreResults() throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnBool("getMoreResults");
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public int getQueryTimeout() throws SQLException {
        return this.callMethodRtnInt("getQueryTimeout");
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.cachedResultSet_ == null) {
            try {
                JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
                this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "getResultSet", newResultSet);
            }
            catch (InvocationTargetException e) {
                throw JDConnectionProxy.rethrow1(e);
            }
        }
        return this.cachedResultSet_;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.callMethodRtnInt("getResultSetConcurrency");
    }

    public int getResultSetHoldability() throws SQLException {
        return this.callMethodRtnInt("getResultSetHoldability");
    }

    public int getResultSetType() throws SQLException {
        return this.callMethodRtnInt("getResultSetType");
    }

    public int getUpdateCount() throws SQLException {
        return this.callMethodRtnInt("getUpdateCount");
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    public void setCursorName(String cursorName) throws SQLException {
        this.cachedResultSet_ = null;
        this.callMethod("setCursorName", new Class[]{String.class}, new Object[]{cursorName});
    }

    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        this.callMethod("setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(escapeProcessing)});
    }

    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.callMethod("setFetchDirection", new Class[]{Integer.TYPE}, new Object[]{new Integer(fetchDirection)});
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        this.callMethod("setFetchSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(fetchSize)});
    }

    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this.callMethod("setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(maxFieldSize)});
    }

    public void setMaxRows(int maxRows) throws SQLException {
        this.callMethod("setMaxRows", new Class[]{Integer.TYPE}, new Object[]{new Integer(maxRows)});
    }

    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.callMethod("setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(queryTimeout)});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Statement"};
    }

    public boolean isClosed() throws SQLException {
        return this.callMethodRtnBool("isClosed");
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.callMethod("setPoolable", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(poolable)});
    }

    public boolean isPoolable() throws SQLException {
        return this.callMethodRtnBool("isPoolable");
    }

    public void closeOnCompletion() throws SQLException {
        this.callMethod("closeOnCompletion");
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.callMethodRtnBool("isCloseOnCompletion");
    }

    public long getLargeUpdateCount() throws SQLException {
        return this.callMethodRtnLong("getLargeUpdateCount");
    }

    public void setLargeMaxRows(long max) throws SQLException {
        this.callMethod("setLargeMaxRows", new Class[]{Long.TYPE}, new Object[]{new Long(max)});
    }

    public long getLargeMaxRows() throws SQLException {
        return this.callMethodRtnLong("getLargeMaxRows");
    }

    public long[] executeLargeBatch() throws SQLException {
        return (long[])this.callMethodRtnObj("executeLargeBatch");
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeLargeUpdate", new Class[]{String.class}, new Object[]{sql}).getReturnValueLong();
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeLargeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, new Integer(autoGeneratedKeys)}).getReturnValueLong();
    }

    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }
}

