/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReturnObjectInformationRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDFieldMap;
import com.ibm.as400.access.JDHardcodedFieldMap;
import com.ibm.as400.access.JDMappedRow;
import com.ibm.as400.access.JDMappedRowCache;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleFieldMap;
import com.ibm.as400.access.JDSimpleRowCache;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLVarchar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

class JDUtilities {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final byte escape = 27;
    static final int vrm740 = AS400.generateVRM(7, 4, 0);
    static final int vrm710 = AS400.generateVRM(7, 1, 0);
    static final int vrm610 = AS400.generateVRM(6, 1, 0);
    static final int vrm540 = AS400.generateVRM(5, 4, 0);
    static final int vrm530 = AS400.generateVRM(5, 3, 0);
    static final int vrm520 = AS400.generateVRM(5, 2, 0);
    static final int vrm510 = AS400.generateVRM(5, 1, 0);
    static final int vrm450 = AS400.generateVRM(4, 5, 0);
    static final int vrm440 = AS400.generateVRM(4, 4, 0);
    static final int vrm430 = AS400.generateVRM(4, 3, 0);
    static int JDBCLevel_ = 30;
    static int JVMLevel_ = 120;
    private static final Object bigDecimalLock_ = new Object();
    static Method toPlainStringMethod;
    static Object[] emptyArgs;
    static String[][] typeNameToTypeCode;
    static Hashtable typeNameHashtable;
    public static Hashtable instanceHashtable;

    JDUtilities() {
    }

    static final void decompress(byte[] source, int sourceOffset, int sourceLength, byte[] destination, int destinationOffset) {
        int i = sourceOffset;
        int j = destinationOffset;
        int sourceEnd = sourceOffset + sourceLength;
        while (i < sourceEnd) {
            if (source[i] == 27) {
                if (source[i + 1] == 27) {
                    destination[j++] = 27;
                    i += 2;
                    continue;
                }
                int repetitions = BinaryConverter.byteArrayToInt(source, i + 2);
                for (int k = 1; k <= repetitions; ++k) {
                    destination[j++] = source[i + 1];
                }
                i += 6;
                continue;
            }
            destination[j++] = source[i++];
        }
    }

    static final String padZeros(int value, int digits) {
        String temp = "000000000" + Integer.toString(value);
        return temp.substring(temp.length() - digits);
    }

    static final String padZeros(long value, int digits) {
        String temp = "000000000000" + Long.toString(value);
        return temp.substring(temp.length() - digits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ResultSet getLibraries(Object caller, AS400JDBCConnection connection, SQLConversionSettings settings, boolean libraryListOnly) throws SQLException {
        connection.checkOpen();
        JDMappedRowCache rowCache = null;
        if (settings == null) {
            settings = SQLConversionSettings.getConversionSettings(connection);
        }
        int id = connection.getID();
        DBReplyRequestedDS reply = null;
        try {
            DBReturnObjectInformationRequestDS request = null;
            try {
                request = DBDSPool.getDBReturnObjectInformationRequestDS(6144, id, -1946157056, 0);
                if (!libraryListOnly) {
                    request.setLibraryName("%", connection.getConverter());
                    request.setLibraryNameSearchPatternIndicator(241);
                } else {
                    request.setLibraryName("*LIBL", connection.getConverter());
                    request.setLibraryNameSearchPatternIndicator(240);
                }
                request.setLibraryReturnInfoBitmap(Integer.MIN_VALUE);
                reply = connection.sendAndReceive(request);
                int errorClass = reply.getErrorClass();
                if (errorClass != 0) {
                    int returnCode = reply.getReturnCode();
                    JDError.throwSQLException(caller, connection, id, errorClass, returnCode);
                }
                DBDataFormat dataFormat = reply.getDataFormat();
                DBData resultData = reply.getResultData();
                JDServerRow row = new JDServerRow(connection, id, dataFormat, settings);
                JDSimpleRowCache serverRowCache = new JDSimpleRowCache(new JDServerRowCache(row, connection, id, 1, resultData, true, 1004));
                boolean isJDBC3 = true;
                JDFieldMap[] maps = null;
                String[] fieldNames = null;
                SQLData[] sqlData = null;
                int[] fieldNullables = null;
                if (!isJDBC3) {
                    fieldNames = new String[]{"TABLE_SCHEM"};
                    sqlData = new SQLData[]{new SQLVarchar(128, settings)};
                    fieldNullables = new int[]{0};
                    maps = new JDFieldMap[1];
                } else {
                    fieldNames = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
                    sqlData = new SQLData[]{new SQLVarchar(128, settings), new SQLVarchar(128, settings)};
                    fieldNullables = new int[]{0, 1};
                    maps = new JDFieldMap[2];
                }
                maps[0] = new JDSimpleFieldMap(1);
                if (isJDBC3) {
                    maps[1] = new JDHardcodedFieldMap(connection.getCatalog());
                }
                JDMappedRow mappedRow = new JDMappedRow(fieldNames, sqlData, fieldNullables, maps);
                rowCache = new JDMappedRowCache(mappedRow, serverRowCache);
            }
            finally {
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException(caller, "HY000", e);
        }
        return new AS400JDBCResultSet(rowCache, connection.getCatalog(), "Schemas", connection, reply);
    }

    static final String stripOuterDoubleQuotes(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    static final String prepareForDoubleQuotes(String name) {
        if ((name = JDUtilities.stripOuterDoubleQuotes(name)).indexOf(34) == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name);
        for (int i = name.length() - 1; i >= 0; --i) {
            if (buf.charAt(i) != '\"') continue;
            buf.insert(i, '\"');
        }
        return buf.toString();
    }

    static final String prepareForSingleQuotes(String name, boolean uppercase) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        } else if (uppercase && name.indexOf(39) == -1) {
            name = name.toUpperCase();
        }
        if (name.indexOf(34) == -1 && name.indexOf(39) == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name);
        for (int i = name.length() - 1; i >= 0; --i) {
            char thisChar = buf.charAt(i);
            if (thisChar == '\"') {
                if (i <= 0 || buf.charAt(i - 1) != '\"') continue;
                buf.deleteCharAt(i);
                --i;
                continue;
            }
            if (thisChar != '\'') continue;
            buf.insert(i, '\'');
        }
        return buf.toString();
    }

    static final String stripOutDoubleEmbededQuotes(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.indexOf(34) == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name);
        for (int i = name.length() - 1; i >= 0; --i) {
            char thisChar = buf.charAt(i);
            if (thisChar != '\"' || i <= 0 || buf.charAt(i - 1) != '\"') continue;
            buf.deleteCharAt(i);
            --i;
        }
        return buf.toString();
    }

    static final String readerToString(Reader input, int length) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        try {
            int length2;
            char[] rawChars = new char[length == 0 ? 1 : length];
            int actualLength = 0;
            while (input.ready() && (length2 = input.read(rawChars)) >= 0) {
                buffer.append(rawChars, 0, length2);
                actualLength += length2;
            }
            if (actualLength != length) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        return buffer.toString();
    }

    static final String readerToString(Reader input) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        try {
            int length2;
            char[] rawChars = new char[32000];
            int actualLength = 0;
            while (input.ready() && (length2 = input.read(rawChars)) >= 0) {
                buffer.append(rawChars, 0, length2);
                actualLength += length2;
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runCommand(Connection connection, String command, boolean SQLNaming) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            String commandLength = "0000000000" + command.length();
            commandLength = commandLength.substring(commandLength.length() - 10) + ".00000";
            String commandPreface = SQLNaming ? "CALL QSYS.QCMDEXC('" : "CALL QSYS/QCMDEXC('";
            String SQLCommand = commandPreface + command + "', " + commandLength + ")";
            statement.executeUpdate(SQLCommand);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    static final byte[] streamToBytes(InputStream input, int length) throws SQLException {
        byte[] buffer = new byte[length];
        try {
            byte[] rawBytes = new byte[length == 0 ? 1 : length];
            int actualLength = 0;
            int length2 = input.read(rawBytes);
            while (length2 >= 0 && actualLength < length) {
                if (length2 > 0) {
                    if (actualLength + length2 <= length) {
                        System.arraycopy(rawBytes, 0, buffer, actualLength, length2);
                    } else {
                        System.arraycopy(rawBytes, 0, buffer, actualLength, length - actualLength);
                    }
                    actualLength += length2;
                }
                length2 = input.read(rawBytes);
            }
            if (actualLength < length) {
                JDError.throwSQLException("07006");
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        return buffer;
    }

    static final byte[] streamToBytes(InputStream input) throws SQLException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        int blocksize = 4096;
        byte[] buffer = new byte[blocksize];
        try {
            int length2 = input.read(buffer);
            while (length2 >= 0) {
                outBuffer.write(buffer, 0, length2);
                length2 = input.read(buffer);
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        return outBuffer.toByteArray();
    }

    static String streamToString(InputStream input, String encoding) throws SQLException {
        byte[] rawBytes = JDUtilities.streamToBytes(input);
        try {
            return new String(rawBytes, 0, rawBytes.length, encoding);
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
            return null;
        }
    }

    static final String streamToString(InputStream input, int length, String encoding) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        try {
            byte[] rawBytes = new byte[length == 0 ? 1 : length];
            int actualLength = 0;
            while (input.available() > 0) {
                int length2 = input.read(rawBytes);
                buffer.append(new String(rawBytes, 0, length2, encoding));
                actualLength += length2;
            }
            if (actualLength != length) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        return buffer.toString();
    }

    static final String upperCaseIfNotQuoted(String name) {
        if (name.startsWith("\"")) {
            return name;
        }
        return name.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bigDecimalToPlainString(BigDecimal bigDecimal) {
        if (JVMLevel_ >= 150) {
            String returnString;
            if (toPlainStringMethod == null) {
                Object object = bigDecimalLock_;
                synchronized (object) {
                    if (toPlainStringMethod == null) {
                        try {
                            Class<?> bigDecimalClass = Class.forName("java.math.BigDecimal");
                            Class[] parameterTypes = new Class[]{};
                            toPlainStringMethod = bigDecimalClass.getMethod("toPlainString", parameterTypes);
                            emptyArgs = new Object[0];
                        }
                        catch (Exception e) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", e);
                            }
                            toPlainStringMethod = null;
                            return bigDecimal.toString();
                        }
                    }
                }
            }
            try {
                returnString = (String)toPlainStringMethod.invoke((Object)bigDecimal, emptyArgs);
            }
            catch (Exception e) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", e);
                }
                returnString = bigDecimal.toString();
            }
            return returnString;
        }
        return bigDecimal.toString();
    }

    static final String stripXMLDeclaration(String s) throws SQLException {
        int i;
        int len = s.length();
        for (i = 0; i < len && (s.charAt(i) == '\ufeff' || Character.isWhitespace(s.charAt(i))); ++i) {
        }
        if (i + 1 < len && s.charAt(i) == '<' && s.charAt(i + 1) == '?') {
            i += 2;
            while (i + 1 < len && (s.charAt(i) != '?' || s.charAt(i + 1) != '>')) {
                ++i;
            }
            if (i + 1 < len && s.charAt(i) == '?' && s.charAt(i + 1) == '>') {
                return s.substring(i + 2);
            }
        }
        return s;
    }

    static final boolean hasXMLDeclaration(String xml) {
        if (xml.length() < 6) {
            return false;
        }
        return xml.substring(0, 7).indexOf("<?xml") != -1;
    }

    static final String handleXMLDeclarationEncoding(String xml) {
        if (xml.length() < 6) {
            return xml;
        }
        if (xml.substring(0, 7).indexOf("<?xml") != -1) {
            int end = xml.indexOf("?>");
            int encStart = xml.indexOf("encoding=");
            if (end != -1 && encStart != -1) {
                int encEnd = xml.indexOf(" ", encStart);
                if (encEnd == -1 || encEnd > end) {
                    encEnd = end;
                }
                return xml.substring(0, encStart) + xml.substring(encEnd);
            }
        }
        return xml;
    }

    public static String getTypeName(int typeNumber) {
        switch (typeNumber) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case -360: {
                return "DECFLOAT";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 70: {
                return "DATALINK";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case -16: {
                return "NVARCHAR";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTypeCode(String typeName) throws SQLException {
        String[][] stringArray = typeNameToTypeCode;
        synchronized (typeNameToTypeCode) {
            if (typeNameHashtable == null) {
                typeNameHashtable = new Hashtable();
                for (int i = 0; i < typeNameToTypeCode.length; ++i) {
                    typeNameHashtable.put(typeNameToTypeCode[i][0], new Integer(typeNameToTypeCode[i][1]));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Integer integer = (Integer)typeNameHashtable.get(typeName);
            if (integer == null) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Unable to get type from " + typeName);
                }
                JDError.throwSQLException("07006");
                return 0;
            }
            int typecode = integer;
            if (typecode != 0) {
                return typecode;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(null, "Unable to get type from " + typeName);
            }
            JDError.throwSQLException("HY004");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean classIsInstanceOf(Class thisClass, String interfaceName) {
        String[][] stringArray = typeNameToTypeCode;
        synchronized (typeNameToTypeCode) {
            Boolean answer;
            if (instanceHashtable == null) {
                instanceHashtable = new Hashtable();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Hashtable<String, Boolean> interfaceHash = (Hashtable<String, Boolean>)instanceHashtable.get(thisClass);
            if (interfaceHash == null) {
                interfaceHash = new Hashtable<String, Boolean>();
                instanceHashtable.put(thisClass, interfaceHash);
            }
            if ((answer = (Boolean)interfaceHash.get(interfaceName)) == null) {
                boolean booleanAnswer = false;
                Class lookClass = thisClass;
                while (lookClass != null && !booleanAnswer) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(null, "JDUtilities.classIsInstance checking " + lookClass.getName() + " of " + thisClass.getName() + " for " + interfaceName);
                    }
                    if (interfaceName.equals(lookClass.getName())) {
                        booleanAnswer = true;
                        continue;
                    }
                    Class<?>[] interfaces = lookClass.getInterfaces();
                    for (int i = 0; !booleanAnswer && i < interfaces.length; ++i) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(null, "DB2Utilities.classIsInstance checking " + interfaces[i].getName() + " of " + thisClass.getName() + " for " + interfaceName);
                        }
                        if (!interfaces[i].getName().equals(interfaceName)) continue;
                        booleanAnswer = true;
                    }
                    if (booleanAnswer) continue;
                    lookClass = lookClass.getSuperclass();
                }
                answer = new Boolean(booleanAnswer);
                interfaceHash.put(interfaceName, answer);
            }
            return answer;
        }
    }

    public static String trimTrailingSpace(String inString) {
        int lastCharacterIndex = inString.length() - 1;
        if (lastCharacterIndex >= 0 && inString.charAt(lastCharacterIndex) == ' ') {
            while (lastCharacterIndex >= 0 && inString.charAt(lastCharacterIndex) == ' ') {
                --lastCharacterIndex;
            }
            if (lastCharacterIndex >= 0) {
                return inString.substring(0, lastCharacterIndex + 1);
            }
            return "";
        }
        return inString;
    }

    static {
        try {
            Class.forName("java.util.concurrent.Semaphore");
            JVMLevel_ = 150;
            Class.forName("java.sql.SQLXML");
            JDBCLevel_ = 40;
            JVMLevel_ = 160;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        toPlainStringMethod = null;
        typeNameToTypeCode = new String[][]{{"ARRAY", "2003"}, {"BIGINT", "-5"}, {"BINARY", "-2"}, {"BIT", "-7"}, {"BLOB", "2004"}, {"BOOLEAN", "16"}, {"CHAR", "1"}, {"CLOB", "2005"}, {"DATALINK", "70"}, {"DATE", "91"}, {"DBCLOB", "2005"}, {"DECIMAL", "3"}, {"DISTINCT", "2001"}, {"DOUBLE", "8"}, {"FLOAT", "6"}, {"INTEGER", "4"}, {"JAVA_OBJECT", "2000"}, {"LONGNVARCHAR", "-16"}, {"LONGVARBINARY", "-4"}, {"LONGVARCHAR", "-1"}, {"NULL", "0"}, {"NUMERIC", "2"}, {"DECFLOAT", "-360"}, {"OTHER", "1111"}, {"REAL", "7"}, {"REF", "2006"}, {"ROWID", "-8"}, {"SMALLINT", "5"}, {"STRUCT", "2002"}, {"TIME", "92"}, {"TIMESTAMP", "93"}, {"TINYINT", "-6"}, {"VARBINARY", "-3"}, {"VARCHAR", "12"}, {"NCHAR", "-15"}, {"GRAPHIC", "-15"}, {"NCLOB", "2011"}, {"NVARCHAR", "-9"}, {"SQLXML", "2009"}, {"VARGRAPHIC", "-9"}};
        typeNameHashtable = null;
    }
}

