/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.io.Serializable;

class ManagedProfileTokenVault
extends ProfileTokenVault
implements Cloneable,
Serializable {
    private static final int REFRESH_TOKEN_EVERY_TIME = -1;
    private static final int MIN_TOKEN_REFRESH_TIME_INTERVAL = 30;
    private static final int MAX_TOKEN_REFRESH_TIME_INTERVAL = 3540;
    private ProfileTokenProvider tokenProvider_;
    private ProfileTokenCredential profileToken_;
    private int refreshThreshold_;

    protected ManagedProfileTokenVault(ProfileTokenProvider tokenProvider) {
        this(tokenProvider, -1);
    }

    protected ManagedProfileTokenVault(ProfileTokenProvider tokenProvider, int refreshThreshold) {
        try {
            this.profileToken_ = tokenProvider.create();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
            this.initRefreshThreshold(refreshThreshold == -1 ? this.profileToken_.getTimeoutInterval() / 2 : refreshThreshold);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, "Error while created ManagedProfileTokenVault.", (Throwable)e);
        }
        this.tokenProvider_ = tokenProvider;
    }

    private ManagedProfileTokenVault() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        ManagedProfileTokenVault vaultClone = (ManagedProfileTokenVault)super.clone();
        ManagedProfileTokenVault managedProfileTokenVault = this;
        synchronized (managedProfileTokenVault) {
            vaultClone.refreshThreshold_ = this.refreshThreshold_;
            vaultClone.tokenProvider_ = this.tokenProvider_;
            try {
                ProfileTokenCredential newToken;
                vaultClone.profileToken_ = newToken = this.tokenProvider_.create();
                vaultClone.encodedCredential_ = this.store(newToken.getToken());
            }
            catch (AS400SecurityException e) {
                Trace.log(2, "Error while cloning ManagedProfileTokenVault.", (Throwable)e);
            }
            return vaultClone;
        }
    }

    protected synchronized void empty() {
        super.empty();
        this.disposeOfToken();
    }

    protected synchronized byte[] getClearCredential() {
        if (this.isEmpty()) {
            this.buildToken();
            return this.resolve(this.encodedCredential_);
        }
        if (!this.profileToken_.isCurrent()) {
            this.buildToken();
            return this.resolve(this.encodedCredential_);
        }
        try {
            if (this.isTimeForRefresh() && this.profileToken_.isRenewable()) {
                this.profileToken_.refresh();
                this.encodedCredential_ = this.store(this.profileToken_.getToken());
            }
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while refreshing profile token.", (Throwable)e);
            }
            this.buildToken();
        }
        return this.resolve(this.encodedCredential_);
    }

    protected synchronized void forceRefresh() {
        if (this.isEmpty() || !this.profileToken_.isRenewable()) {
            this.buildToken();
            return;
        }
        try {
            this.profileToken_.refresh();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while forcefully refreshing profile token.", (Throwable)e);
            }
            this.buildToken();
        }
    }

    protected synchronized boolean isEmpty() {
        boolean empty = super.isEmpty();
        if (empty && this.profileToken_ != null) {
            throw new IllegalStateException("Credential vault is empty, but profile token is not null");
        }
        return empty;
    }

    private void initRefreshThreshold(int threshold) {
        if (threshold < 30 || threshold > 3540) {
            throw new IllegalArgumentException("Refresh threshold must between 30 and 3540 seconds");
        }
        this.refreshThreshold_ = threshold;
    }

    private void buildToken() {
        try {
            this.disposeOfToken();
            this.profileToken_ = this.tokenProvider_.create();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while building profile token.", (Throwable)e);
            }
            this.disposeOfToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeOfToken() {
        try {
            block4: {
                try {
                    if (this.profileToken_ == null) break block4;
                    this.profileToken_.destroy();
                }
                catch (Exception e) {
                    Trace.log(2, "Error while disposing of profile token.", (Throwable)e);
                    Object var3_2 = null;
                    this.profileToken_ = null;
                    this.encodedCredential_ = null;
                }
            }
            Object var3_1 = null;
            this.profileToken_ = null;
            this.encodedCredential_ = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.profileToken_ = null;
            this.encodedCredential_ = null;
            throw throwable;
        }
    }

    private boolean isTimeForRefresh() throws AS400SecurityException {
        if (this.refreshThreshold_ == -1) {
            return true;
        }
        if (this.profileToken_ == null) {
            return true;
        }
        return this.profileToken_.getTimeToExpiration() < this.refreshThreshold_;
    }
}

