/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.Trace;

public class NativeMethods {
    static boolean paseLibLoaded;
    static String nativeLibraryQyjspart;

    static void loadNativeLibraryQyjspart() {
        try {
            System.load(nativeLibraryQyjspart);
        }
        catch (Throwable e) {
            Trace.log(2, "Error loading QYJSPART service program from " + nativeLibraryQyjspart + ":", e);
        }
    }

    static void loadNativeLibraryQyjspartThrowsException() throws SecurityException, UnsatisfiedLinkError {
        System.load(nativeLibraryQyjspart);
    }

    static void load() {
    }

    static boolean loadSCK() {
        try {
            System.load("/QSYS.LIB/QYJSPSCK.SRVPGM");
            return true;
        }
        catch (Throwable e) {
            Trace.log(2, "Error loading QYJSPSCK service program:", e);
            return false;
        }
    }

    static native int socketAvailable(int var0) throws NativeException;

    static native int socketPaseAvailable(int var0, int var1) throws NativeException;

    static native int socketCreate(int var0) throws NativeException;

    static native int[] socketPaseCreate(int var0) throws NativeException;

    static native void socketClose(int var0) throws NativeException;

    static native void socketPaseClose(int var0, int var1) throws NativeException;

    static native int socketRead(int var0, byte[] var1, int var2, int var3) throws NativeException;

    static native int socketPaseRead(int var0, int var1, byte[] var2, int var3, int var4) throws NativeException;

    static native void socketWrite(int var0, byte[] var1, int var2, int var3) throws NativeException;

    static native void socketPaseWrite(int var0, int var1, byte[] var2, int var3, int var4) throws NativeException;

    static native byte[] getUserId() throws NativeException;

    static native byte[] getUserInfo(byte[] var0, byte[] var1) throws NativeException;

    static native byte[] runCommand(byte[] var0, int var1, int var2) throws NativeException;

    static native byte[] runProgram(byte[] var0, byte[] var1, int var2, byte[] var3, byte[] var4, int var5) throws NativeException;

    static {
        String alternateLibrary;
        block12: {
            paseLibLoaded = false;
            nativeLibraryQyjspart = "/QSYS.LIB/QYJSPART.SRVPGM";
            String osVersion = System.getProperty("os.version");
            if (System.getProperty("java.vm.name").indexOf("Classic VM") < 0 && osVersion.indexOf("V5") == -1) {
                try {
                    if (System.getProperty("java.home").indexOf("64bit") > 0) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "Loading Native PASE methods for 64bit libs if available");
                        }
                        System.load("/QIBM/ProdData/OS400/jt400/lib/qyjspase64.so");
                        paseLibLoaded = true;
                    } else {
                        if (Trace.traceOn_) {
                            Trace.log(1, "Loading Native PASE methods for 32bit libs if available");
                        }
                        System.load("/QIBM/ProdData/OS400/jt400/lib/qyjspase32.so");
                        paseLibLoaded = true;
                    }
                }
                catch (Throwable t) {
                    if (!Trace.traceOn_) break block12;
                    Trace.log(2, t);
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Loading Native non-PASE methods ");
        }
        if ((alternateLibrary = System.getProperty("com.ibm.as400.access.native.library")) != null) {
            nativeLibraryQyjspart = "/QSYS.LIB/" + alternateLibrary + ".LIB/QYJSPART.SRVPGM";
            if (Trace.traceOn_) {
                Trace.log(1, "QYJSPART as " + nativeLibraryQyjspart);
            }
        }
        try {
            System.load(nativeLibraryQyjspart);
        }
        catch (Throwable e) {
            Trace.log(2, "Error loading QYJSPART service program:", e);
        }
    }
}

