/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTF;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroup {
    static final String USERSPACE_NAME = "JT4PTF    QTEMP     ";
    static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC";
    private AS400 system_;
    private String PTFGroupName_;
    private boolean includeRelatedPTFGroups_ = false;
    private String PTFgroupDescription_;
    private int PTFGroupLevel_;
    private int PTFGroupStatus_;
    private String targetRelease_;
    public static final int PTF_GROUP_STATUS_UNKNOWN = 0;
    public static final int PTF_GROUP_STATUS_NOT_APPLICABLE = 1;
    public static final int PTF_GROUP_STATUS_SUPPORTED_ONLY = 2;
    public static final int PTF_GROUP_STATUS_NOT_INSTALLED = 3;
    public static final int PTF_GROUP_STATUS_INSTALLED = 4;
    public static final int PTF_GROUP_STATUS_ERROR = 5;
    public static final int PTF_GROUP_STATUS_NOT_FOUND = 6;
    public static final int PTF_GROUP_STATUS_APPLY_AT_NEXT_IPL = 7;
    public static final int PTF_GROUP_STATUS_RELATED_GROUP = 8;
    public static final int PTF_GROUP_STATUS_ON_ORDER = 9;

    PTFGroup(AS400 system, String ptfGroupName) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (ptfGroupName == null) {
            throw new NullPointerException("ptfGroupName");
        }
        this.system_ = system;
        this.PTFGroupName_ = ptfGroupName.trim();
    }

    PTFGroup(AS400 system, String ptfGroupName, String ptfDescription, int ptfLevel, int ptfStatus, String targetRelease) {
        this(system, ptfGroupName);
        this.PTFGroupLevel_ = ptfLevel;
        this.PTFgroupDescription_ = ptfDescription;
        this.PTFGroupStatus_ = ptfStatus;
        this.targetRelease_ = targetRelease.trim();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getRelatedPTFGroups() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            int len = 164;
            int ccsid = this.system_.getCcsid();
            ConvTable conv = ConvTable.getTable(ccsid, null);
            ProgramParameter[] parms = new ProgramParameter[5];
            parms[0] = new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME));
            parms[0].setParameterType(2);
            byte[] groupInfo = new byte[69];
            AS400Text text60 = new AS400Text(60, ccsid, this.system_);
            BinaryConverter.intToByteArray(69, groupInfo, 0);
            text60.toBytes(this.PTFGroupName_, groupInfo, 4);
            BinaryConverter.intToByteArray(ccsid, groupInfo, 64);
            groupInfo[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
            parms[1] = new ProgramParameter(groupInfo);
            parms[1].setParameterType(2);
            parms[2] = new ProgramParameter(conv.stringToByteArray("GRPR0500"));
            parms[2].setParameterType(2);
            parms[3] = new ProgramParameter(BinaryConverter.intToByteArray(ccsid));
            parms[3].setParameterType(2);
            parms[4] = new ProgramParameter(new byte[4]);
            parms[4].setParameterType(2);
            ServiceProgramCall pc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, parms);
            boolean willRunProgramsOnThread = pc.isStayOnThread();
            Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
            byte[] buf = null;
            Object object = lockObject;
            synchronized (object) {
                UserSpace us = new UserSpace(this.system_, USERSPACE_PATH);
                us.setMustUseProgramCall(true);
                if (!willRunProgramsOnThread) {
                    us.setMustUseSockets(true);
                }
                try {
                    us.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
                    if (!pc.run()) {
                        throw new AS400Exception(pc.getMessageList());
                    }
                    int size = us.getLength();
                    buf = new byte[size];
                    us.read(buf, 0);
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    try {
                        us.delete();
                    }
                    catch (Exception e) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
            int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
            int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
            int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
            int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
            conv = ConvTable.getTable(entryCCSID, null);
            PTFGroup[] ptfs = new PTFGroup[numEntries];
            int offset = 0;
            for (int i = 0; i < numEntries; ++i) {
                offset = startingOffset + i * entrySize;
                String relatedPTFGroupName = conv.byteArrayToString(buf, offset, 60);
                String relatedPTFgroupDescription = conv.byteArrayToString(buf, offset += 60, 100);
                int relatedPTFGroupLevel = BinaryConverter.byteArrayToInt(buf, offset += 100);
                int relatedPTFGroupStatus = BinaryConverter.byteArrayToInt(buf, offset += 4);
                offset += 4;
                ptfs[i] = new PTFGroup(this.system_, relatedPTFGroupName, relatedPTFgroupDescription, relatedPTFGroupLevel, relatedPTFGroupStatus, "");
            }
            return ptfs;
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
            throw new InternalErrorException(10, (Throwable)pve);
        }
    }

    public String getPTFGroupDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFgroupDescription_;
    }

    public String getPTFGroupName() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupName_;
    }

    public int getPTFGroupLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupLevel_;
    }

    public int getPTFGroupStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupStatus_;
    }

    public String getTargetRelease() {
        return this.targetRelease_;
    }

    public void includeRelatedPTFGroups(boolean value) {
        this.includeRelatedPTFGroups_ = value;
    }

    public boolean areRelatedPTFGroupsIncluded() {
        return this.includeRelatedPTFGroups_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTF[] getPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            int len = 73;
            int ccsid = this.system_.getCcsid();
            ConvTable conv = ConvTable.getTable(ccsid, null);
            ProgramParameter[] parms = new ProgramParameter[5];
            parms[0] = new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME));
            parms[0].setParameterType(2);
            int groupInfoLength = 69;
            byte[] groupInfo = new byte[69];
            if (this.PTFGroupLevel_ != 0) {
                groupInfo = new byte[76];
                groupInfoLength = 76;
            }
            AS400Text text60 = new AS400Text(60, ccsid, this.system_);
            BinaryConverter.intToByteArray(groupInfoLength, groupInfo, 0);
            text60.toBytes(this.PTFGroupName_, groupInfo, 4);
            BinaryConverter.intToByteArray(ccsid, groupInfo, 64);
            int n = groupInfo[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
            if (this.PTFGroupLevel_ != 0) {
                BinaryConverter.intToByteArray(this.PTFGroupLevel_, groupInfo, 72);
            }
            parms[1] = new ProgramParameter(groupInfo);
            parms[1].setParameterType(2);
            parms[2] = new ProgramParameter(conv.stringToByteArray("GRPR0300"));
            parms[2].setParameterType(2);
            parms[3] = new ProgramParameter(BinaryConverter.intToByteArray(ccsid));
            parms[3].setParameterType(2);
            parms[4] = new ProgramParameter(new byte[4]);
            parms[4].setParameterType(2);
            ServiceProgramCall pc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, parms);
            boolean willRunProgramsOnThread = pc.isStayOnThread();
            Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
            byte[] buf = null;
            Object object = lockObject;
            synchronized (object) {
                UserSpace us = new UserSpace(this.system_, USERSPACE_PATH);
                us.setMustUseProgramCall(true);
                if (!willRunProgramsOnThread) {
                    us.setMustUseSockets(true);
                }
                try {
                    us.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
                    if (!pc.run()) {
                        throw new AS400Exception(pc.getMessageList());
                    }
                    int size = us.getLength();
                    buf = new byte[size];
                    us.read(buf, 0);
                    Object var16_18 = null;
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    try {
                        us.delete();
                    }
                    catch (Exception e) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
            int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
            int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
            int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
            int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
            conv = ConvTable.getTable(entryCCSID, null);
            PTF[] ptfs = new PTF[numEntries];
            int offset = 0;
            for (int i = 0; i < numEntries; ++i) {
                offset = startingOffset + i * entrySize;
                String PTFId_ = conv.byteArrayToString(buf, offset, 7);
                String productId_ = conv.byteArrayToString(buf, offset += 7, 7);
                String release_ = conv.byteArrayToString(buf, offset += 7, 6);
                String productOption_ = conv.byteArrayToString(buf, offset += 6, 4);
                String productLoadId_ = conv.byteArrayToString(buf, offset += 4, 4);
                String minimumLevel_ = conv.byteArrayToString(buf, offset += 4, 2);
                String maximumLevel_ = conv.byteArrayToString(buf, offset += 2, 2);
                offset += 2;
                String loadedStatus_ = conv.byteArrayToString(buf, offset++, 1);
                int IPLaction_ = buf[offset++] & 0xF;
                String actionPending_ = conv.byteArrayToString(buf, offset++, 1);
                String actionRequired_ = conv.byteArrayToString(buf, offset++, 1);
                String coverLetterStatus_ = conv.byteArrayToString(buf, offset++, 1);
                String onOrderStatus_ = conv.byteArrayToString(buf, offset++, 1);
                String saveFileStatus_ = conv.byteArrayToString(buf, offset++, 1);
                String saveFileName_ = conv.byteArrayToString(buf, offset, 10);
                String saveFileLibraryName_ = conv.byteArrayToString(buf, offset += 10, 10);
                String supersededByPTFId_ = conv.byteArrayToString(buf, offset += 10, 7);
                String latestSupersedingPTFId_ = conv.byteArrayToString(buf, offset += 7, 7);
                offset += 7;
                String productStatus_ = conv.byteArrayToString(buf, offset++, 1);
                String omitStatus_ = conv.byteArrayToString(buf, offset++, 1);
                ptfs[i] = new PTF(this.system_, PTFId_, productId_, release_, productOption_, productLoadId_, minimumLevel_, maximumLevel_, loadedStatus_, IPLaction_, actionPending_, actionRequired_, coverLetterStatus_, onOrderStatus_, saveFileStatus_, saveFileName_, saveFileLibraryName_, supersededByPTFId_, latestSupersedingPTFId_, productStatus_, omitStatus_);
            }
            return ptfs;
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
            throw new InternalErrorException(10, (Throwable)pve);
        }
    }
}

