/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Vector;

abstract class PermissionAccess {
    AS400 as400_;
    private int ccsid_;
    private boolean gotCcsid_;
    private static final int DEFAULT_LENGTH = 600;
    protected boolean followSymbolicLinks_ = true;

    public PermissionAccess(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = system;
    }

    public abstract void addUser(String var1, UserPermission var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, PropertyVetoException, UnknownHostException;

    protected abstract String expandQuotes(String var1);

    public AS400 getSystem() {
        return this.as400_;
    }

    public Vector getAuthority(String objName) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException, PropertyVetoException {
        if (objName == null) {
            throw new NullPointerException("objName");
        }
        Vector<Object> vector = new Vector<Object>();
        QSYSObjectPathName prgName = new QSYSObjectPathName("QSYS", "QSYRTVUA", "PGM");
        int vrm = this.as400_.getVRM();
        ProgramParameter[] parmList = this.getParameters(600, objName, vrm >= 328448);
        ProgramCall rtvUsersAUT = new ProgramCall(this.as400_);
        rtvUsersAUT.setProgram(prgName.getPath(), parmList);
        if (!rtvUsersAUT.run()) {
            AS400Message[] msgList = rtvUsersAUT.getMessageList();
            throw new AS400Exception(msgList);
        }
        byte[] feedbackData = parmList[2].getOutputData();
        byte[] usersData = parmList[0].getOutputData();
        RecordFormat recordFormat = this.getFeedbackRecordFormat();
        Record record0 = new Record(recordFormat);
        record0.setContents(feedbackData);
        Integer bytesAvailable = (Integer)record0.getField("BytesAvailable");
        Integer bytesReturn = (Integer)record0.getField("BytesReturn");
        int requiredLength = bytesAvailable;
        int receiverLength = bytesReturn;
        if (requiredLength > receiverLength) {
            parmList = this.getParameters(requiredLength + 400, objName, vrm >= 328448);
            rtvUsersAUT.setProgram(prgName.getPath(), parmList);
            if (!rtvUsersAUT.run()) {
                AS400Message[] msgList = rtvUsersAUT.getMessageList();
                throw new AS400Exception(msgList);
            }
            feedbackData = parmList[2].getOutputData();
            usersData = parmList[0].getOutputData();
            record0.setContents(feedbackData);
        }
        String owner = ((String)record0.getField("owner")).trim();
        String primaryGroup = ((String)record0.getField("primaryGroup")).trim();
        String authorizationList = ((String)record0.getField("authorizationList")).trim();
        String sensitivityLev = ((String)record0.getField("sensitivityLevel")).trim();
        Integer sensitivityLevel = new Integer(this.getIntValue(sensitivityLev));
        vector.addElement(owner);
        vector.addElement(primaryGroup);
        vector.addElement(authorizationList);
        vector.addElement(sensitivityLevel);
        Integer usersNumber = (Integer)record0.getField("usersNumber");
        Integer userEntryLength = (Integer)record0.getField("userEntryLength");
        int totalUsers = usersNumber;
        int length = userEntryLength;
        RecordFormat userRecordFormat = this.getUserRecordFormat();
        for (int i = 0; i < totalUsers; ++i) {
            Record userRecord = userRecordFormat.getNewRecord(usersData, i * length);
            UserPermission permission = this.getUserPermission(userRecord);
            vector.addElement(permission);
        }
        return vector;
    }

    boolean getBooleanValue(String string) {
        return string.equals("1");
    }

    private int getCcsid() {
        if (!this.gotCcsid_) {
            this.ccsid_ = this.as400_.getCcsid();
            this.gotCcsid_ = true;
        }
        return this.ccsid_;
    }

    private RecordFormat getFeedbackRecordFormat() {
        int i;
        BinaryFieldDescription[] bfd = new BinaryFieldDescription[6];
        AS400Bin4 bin4 = new AS400Bin4();
        AS400Text text10 = new AS400Text(10, this.getCcsid(), this.as400_);
        bfd[0] = new BinaryFieldDescription(bin4, "fbBytesReturn");
        bfd[1] = new BinaryFieldDescription(bin4, "fbBytesAvailable");
        bfd[2] = new BinaryFieldDescription(bin4, "BytesReturn");
        bfd[3] = new BinaryFieldDescription(bin4, "BytesAvailable");
        bfd[4] = new BinaryFieldDescription(bin4, "usersNumber");
        bfd[5] = new BinaryFieldDescription(bin4, "userEntryLength");
        CharacterFieldDescription[] cfd = new CharacterFieldDescription[]{new CharacterFieldDescription(text10, "owner"), new CharacterFieldDescription(text10, "primaryGroup"), new CharacterFieldDescription(text10, "authorizationList"), new CharacterFieldDescription(new AS400Text(1, this.getCcsid(), this.as400_), "sensitivityLevel")};
        RecordFormat rf0 = new RecordFormat();
        for (i = 0; i < 6; ++i) {
            rf0.addFieldDescription(bfd[i]);
        }
        for (i = 0; i < 4; ++i) {
            rf0.addFieldDescription(cfd[i]);
        }
        return rf0;
    }

    int getIntValue(String string) {
        return Integer.parseInt(string);
    }

    ProgramParameter[] getParameters(int length, String objName, boolean useUnicode) throws UnsupportedEncodingException {
        int numParms = this.followSymbolicLinks_ ? 8 : 9;
        ProgramParameter[] parmList = new ProgramParameter[numParms];
        parmList[0] = new ProgramParameter(length);
        parmList[1] = new ProgramParameter(BinaryConverter.intToByteArray(length));
        parmList[2] = new ProgramParameter(55);
        parmList[3] = new ProgramParameter(BinaryConverter.intToByteArray(55));
        AS400Text text8 = new AS400Text(8, this.getCcsid(), this.as400_);
        parmList[4] = new ProgramParameter(text8.toBytes("RTUA0100"));
        if (!useUnicode) {
            block16: {
                if (Trace.traceOn_) {
                    Trace.log(1, "PermissionAccess creating QSYRTVUA parameters using job CCSID.");
                }
                if (objName.toUpperCase().startsWith("/QDLS/")) {
                    objName = PermissionAccess.toUpperCasePath(objName);
                    try {
                        objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
                    }
                    catch (Exception e) {
                        if (!Trace.traceOn_) break block16;
                        Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
                    }
                }
            }
            byte[] objnameBytes = CharConverter.stringToByteArray(this.getCcsid(), this.as400_, objName);
            parmList[5] = new ProgramParameter(objnameBytes);
            parmList[6] = new ProgramParameter(BinaryConverter.intToByteArray(objnameBytes.length));
        } else {
            block17: {
                if (Trace.traceOn_) {
                    Trace.log(1, "PermissionAccess creating QSYRTVUA parameters using UTF-16 (CCSID 1200).");
                }
                if (objName.toUpperCase().startsWith("/QDLS/")) {
                    objName = PermissionAccess.toUpperCasePath(objName);
                    try {
                        objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
                    }
                    catch (Exception e) {
                        if (!Trace.traceOn_) break block17;
                        Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
                    }
                }
            }
            byte[] pathNameBytes = null;
            try {
                pathNameBytes = CharConverter.stringToByteArray(1200, objName);
            }
            catch (UnsupportedEncodingException uee) {
                if (Trace.traceOn_) {
                    Trace.log(4, "PermissionAccess could not load converter table for CCSID 1200. Manually converting path name.");
                }
                int pathLen = objName.length();
                pathNameBytes = new byte[pathLen * 2];
                for (int bc = 0; bc < pathLen; ++bc) {
                    char pathChar = objName.charAt(bc);
                    pathNameBytes[bc * 2] = (byte)(pathChar >> 8);
                    pathNameBytes[bc * 2 + 1] = (byte)pathChar;
                }
            }
            byte[] qlgPathNameTStructure = new byte[32 + pathNameBytes.length];
            BinaryConverter.intToByteArray(1200, qlgPathNameTStructure, 0);
            BinaryConverter.intToByteArray(2, qlgPathNameTStructure, 12);
            BinaryConverter.intToByteArray(pathNameBytes.length, qlgPathNameTStructure, 16);
            int delimiter = 47;
            qlgPathNameTStructure[20] = (byte)(delimiter >> 8);
            qlgPathNameTStructure[21] = (byte)delimiter;
            System.arraycopy(pathNameBytes, 0, qlgPathNameTStructure, 32, pathNameBytes.length);
            parmList[5] = new ProgramParameter(qlgPathNameTStructure);
            parmList[6] = new ProgramParameter(BinaryConverter.intToByteArray(-1));
        }
        byte[] errorInfo = new byte[32];
        parmList[7] = new ProgramParameter(errorInfo, 0);
        if (!this.followSymbolicLinks_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Adding 'Symbolic link: *YES' parameter for QSYRTVUA.");
            }
            AS400Text text10 = new AS400Text(10, this.getCcsid(), this.as400_);
            parmList[8] = new ProgramParameter(text10.toBytes("*YES"));
        }
        return parmList;
    }

    RecordFormat getUserRecordFormat() {
        CharacterFieldDescription[] cfd = new CharacterFieldDescription[16];
        AS400Text text1 = new AS400Text(1, this.getCcsid(), this.as400_);
        AS400Text text10 = new AS400Text(10, this.getCcsid(), this.as400_);
        cfd[0] = new CharacterFieldDescription(text10, "profileName");
        cfd[1] = new CharacterFieldDescription(text1, "userOrGroup");
        cfd[2] = new CharacterFieldDescription(text10, "dataAuthority");
        cfd[3] = new CharacterFieldDescription(text1, "autListMgt");
        cfd[4] = new CharacterFieldDescription(text1, "objMgt");
        cfd[5] = new CharacterFieldDescription(text1, "objExistence");
        cfd[6] = new CharacterFieldDescription(text1, "objAlter");
        cfd[7] = new CharacterFieldDescription(text1, "objRef");
        cfd[8] = new CharacterFieldDescription(text10, "reserved1");
        cfd[9] = new CharacterFieldDescription(text1, "objOperational");
        cfd[10] = new CharacterFieldDescription(text1, "dataRead");
        cfd[11] = new CharacterFieldDescription(text1, "dataAdd");
        cfd[12] = new CharacterFieldDescription(text1, "dataUpdate");
        cfd[13] = new CharacterFieldDescription(text1, "dataDelete");
        cfd[14] = new CharacterFieldDescription(text1, "dataExecute");
        cfd[15] = new CharacterFieldDescription(text10, "reserved2");
        RecordFormat userrf = new RecordFormat();
        for (int i = 0; i < 16; ++i) {
            userrf.addFieldDescription(cfd[i]);
        }
        return userrf;
    }

    public abstract UserPermission getUserPermission(Record var1) throws UnsupportedEncodingException;

    public boolean isFollowSymbolicLinks() {
        return this.followSymbolicLinks_;
    }

    public abstract void removeUser(String var1, String var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setAuthority(String var1, UserPermission var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setAuthorizationList(String var1, String var2, String var3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setFromAuthorizationList(String var1, boolean var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public void setOwner(String objName, String owner, boolean revokeOldAuthority) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        if (objName == null) {
            throw new NullPointerException("objName");
        }
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        String upperCasePath = PermissionAccess.toUpperCasePath(objName).trim();
        if (upperCasePath.indexOf("/QOPENSYS/") != 0) {
            objName = PermissionAccess.toUpperCasePath(objName);
        }
        CommandCall cmd = new CommandCall(this.as400_);
        String revokeOldAut = revokeOldAuthority ? "*YES" : "*NO";
        String cmdString = "CHGOWN OBJ(" + this.expandQuotes(objName) + ") " + "NEWOWN(" + owner + ") " + "RVKOLDAUT(" + revokeOldAut + ")";
        if (!this.followSymbolicLinks_) {
            cmdString = cmdString + " SYMLNK(*YES)";
        }
        cmd.setCommand(cmdString);
        if (!cmd.run()) {
            AS400Message[] msgList = cmd.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    public void setPrimaryGroup(String objName, String primaryGroup, boolean revokeOldAuthority) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        if (objName == null) {
            throw new NullPointerException("objName");
        }
        if (primaryGroup == null) {
            throw new NullPointerException("primaryGroup");
        }
        String upperCasePath = PermissionAccess.toUpperCasePath(objName).trim();
        if (upperCasePath.indexOf("/QOPENSYS/") != 0) {
            objName = PermissionAccess.toUpperCasePath(objName);
        }
        CommandCall cmd = new CommandCall(this.as400_);
        String revokeOldAut = revokeOldAuthority ? "*YES" : "*NO";
        String cmdString = "CHGPGP OBJ(" + this.expandQuotes(objName) + ") " + "NEWPGP(" + primaryGroup + ") " + "RVKOLDAUT(" + revokeOldAut + ")";
        cmd.setCommand(cmdString);
        if (!cmd.run()) {
            AS400Message[] msgList = cmd.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    public void setFollowSymbolicLinks(boolean followLinks) {
        this.followSymbolicLinks_ = followLinks;
    }

    public abstract void setSensitivity(String var1, int var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = system;
    }

    static final String toUpperCasePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        return QSYSObjectPathName.toQSYSName(path);
    }
}

