/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400PortMapDS;
import com.ibm.as400.access.AS400PortMapReplyDS;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;

class PortMapper {
    private static Hashtable systemList = new Hashtable();
    static boolean unixSocketAvailable = true;

    private PortMapper() {
    }

    static void setServicePortsToDefault(String systemName) {
        int[] newPortList = new int[]{8473, 8474, 8475, 8472, 8471, 446, 8470, 8476, 9473, 9474, 9475, 9472, 9471, 448, 9470, 9476};
        systemList.put(systemName, newPortList);
    }

    static void setServicePort(String systemName, int service, int port, SSLOptions useSSL) {
        int[] portList;
        if (useSSL != null && useSSL.proxyEncryptionMode_ != 1) {
            service += 8;
        }
        if ((portList = (int[])systemList.get(systemName)) == null) {
            int[] newPortList = new int[]{-1, -1, -1, -1, -1, 446, -1, -1, -1, -1, -1, -1, -1, 448, -1, -1};
            newPortList[service] = port;
            systemList.put(systemName, newPortList);
        } else {
            portList[service] = port;
        }
    }

    static int getServicePort(String systemName, int service, SSLOptions useSSL) {
        int[] portList;
        if (useSSL != null && useSSL.proxyEncryptionMode_ != 1) {
            service += 8;
        }
        if ((portList = (int[])systemList.get(systemName)) == null) {
            if (service == 5) {
                return 446;
            }
            if (service == 13) {
                return 448;
            }
            return -1;
        }
        return portList[service];
    }

    private static boolean canUseUnixSocket(String systemName, int service, boolean mustUseNetSockets) {
        if (AS400.onAS400 && unixSocketAvailable && !mustUseNetSockets && service != 0 && (systemName.equalsIgnoreCase("localhost") || systemName.equalsIgnoreCase("ipv6-localhost"))) {
            return service != 4 || AS400.nativeVRM.vrm_ >= 393472;
        }
        return false;
    }

    static SocketContainer getServerSocket(String systemName, int service, SSLOptions useSSL, SocketProperties socketProperties, boolean mustUseNetSockets) throws IOException {
        return PortMapper.getServerSocket(systemName, service, -1, useSSL, socketProperties, mustUseNetSockets);
    }

    static SocketContainer getServerSocket(String systemName, int service, int overridePort, SSLOptions useSSL, SocketProperties socketProperties, boolean mustUseNetSockets) throws IOException {
        int srvPort;
        SocketContainer sc = null;
        String serviceName = AS400.getServerName(service);
        if (PortMapper.canUseUnixSocket(systemName, service, mustUseNetSockets)) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Starting a local socket to " + serviceName);
                }
                SocketContainer socketContainer = sc = AS400.nativeVRM.vrm_ < 328704 ? (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerUnix") : (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerUnix2");
                if (sc != null) {
                    sc.setProperties(null, serviceName, null, 0, null);
                    return sc;
                }
            }
            catch (IOException e) {
                Trace.log(2, "Error attempting to connect with Unix Socket:", (Throwable)e);
                sc = null;
            }
            unixSocketAvailable = false;
        }
        if (overridePort > 0) {
            srvPort = overridePort;
        } else {
            srvPort = PortMapper.getServicePort(systemName, service, useSSL);
            if (srvPort == -1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Connecting to port mapper...");
                }
                Socket pmSocket = PortMapper.getSocketConnection(systemName, 449, socketProperties);
                InputStream pmInstream = pmSocket.getInputStream();
                OutputStream pmOutstream = pmSocket.getOutputStream();
                String fullServiceName = useSSL != null && useSSL.proxyEncryptionMode_ != 1 ? serviceName + "-s" : serviceName;
                AS400PortMapDS pmreq = new AS400PortMapDS(fullServiceName);
                if (Trace.traceOn_) {
                    pmreq.setConnectionID(pmSocket.hashCode());
                }
                pmreq.write(pmOutstream);
                AS400PortMapReplyDS pmresp = new AS400PortMapReplyDS();
                if (Trace.traceOn_) {
                    pmresp.setConnectionID(pmSocket.hashCode());
                }
                pmresp.read(pmInstream);
                pmSocket.close();
                try {
                    srvPort = pmresp.getPort();
                }
                catch (ServerStartupException e) {
                    Trace.log(2, "Failed to map a port for " + fullServiceName, (Throwable)e);
                    throw e;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Adding entry to Service Port table: system " + systemName + ", service " + fullServiceName + ", port " + srvPort);
                }
                PortMapper.setServicePort(systemName, service, srvPort, useSSL);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Opening socket for service " + service + " to system..." + systemName + " port:" + srvPort);
        }
        Socket socket = PortMapper.getSocketConnection(systemName, srvPort, socketProperties);
        if (useSSL != null && useSSL.proxyEncryptionMode_ != 1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Starting a secure socket to " + serviceName);
            }
            sc = (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerJSSE");
            sc.setProperties(socket, null, systemName, srvPort, null);
        } else {
            if (Trace.traceOn_) {
                Trace.log(1, "Starting an inet socket to " + serviceName);
            }
            sc = (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerInet");
            sc.setProperties(socket, null, null, 0, null);
        }
        return sc;
    }

    /*
     * Exception decompiling
     */
    static Socket getSocketConnection(String systemName, int port, SocketProperties socketProperties) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void setSocketProperties(Socket socket, SocketProperties socketProperties) throws SocketException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket options...");
        }
        if (socketProperties.keepAliveSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting keep alive:", socketProperties.keepAlive_);
            }
            socket.setKeepAlive(socketProperties.keepAlive_);
        }
        if (socketProperties.receiveBufferSizeSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting receive buffer size:", socketProperties.receiveBufferSize_);
            }
            socket.setReceiveBufferSize(socketProperties.receiveBufferSize_);
        }
        if (socketProperties.sendBufferSizeSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting send buffer size:", socketProperties.sendBufferSize_);
            }
            socket.setSendBufferSize(socketProperties.sendBufferSize_);
        }
        if (socketProperties.soLingerSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting so linger:", socketProperties.soLinger_);
            }
            socket.setSoLinger(true, socketProperties.soLinger_);
        }
        if (socketProperties.soTimeoutSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting so timeout:", socketProperties.soTimeout_);
            }
            socket.setSoTimeout(socketProperties.soTimeout_);
        }
        if (socketProperties.tcpNoDelaySet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting TCP no delay:", socketProperties.tcpNoDelay_);
            }
            socket.setTcpNoDelay(socketProperties.tcpNoDelay_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Socket properties:");
            try {
                Trace.log(1, "    Remote address: " + socket.getInetAddress());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Remote port:", socket.getPort());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Local address: " + socket.getLocalAddress());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Local port:", socket.getLocalPort());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Keep alive:", socket.getKeepAlive());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Receive buffer size:", socket.getReceiveBufferSize());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Send buffer size:", socket.getSendBufferSize());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    So linger:", socket.getSoLinger());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    So timeout:", socket.getSoTimeout());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Trace.log(1, "    TCP no delay:", socket.getTcpNoDelay());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

