/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectPageInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectPageInputStreamImplRemote
implements PrintObjectPageInputStreamImpl {
    private NPConversation conversation_;
    private NPCPAttribute cpCPFMsg_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private int currentPage_ = 0;
    private int markLimit_ = 0;
    private boolean markSet_ = false;
    private int numberOfPages_ = 0;
    private boolean pagesEst_ = false;
    private int numBytes_ = 0;
    private NPSystem npSystem_;
    private int objectType_;
    private int offset_ = 0;
    private int offsetFromMark_ = 0;

    PrintObjectPageInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectPageInputStream(SpooledFileImpl spooledFile, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFile).getSystem());
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFile).getIDCodePoint();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjHndl_ = new NPCPSplFHandle();
        NPDataStream openReq = new NPDataStream(this.objectType_);
        openReq.setAction(26);
        openReq.addCodePoint(this.cpObjID_);
        NPCPSelection selectionCP = new NPCPSelection();
        if (openOptions != null) {
            selectionCP.addUpdateAttributes(openOptions.getAttrCodePoint());
        }
        selectionCP.setAttrValue(214, "*YES");
        openReq.addCodePoint(selectionCP);
        NPDataStream openRep = new NPDataStream(this.objectType_);
        openRep.addCodePoint(this.cpObjHndl_);
        openRep.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean fOpenOK = false;
        try {
            int rc = this.conversation_.makeRequest(openReq, openRep);
            if (rc != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + rc);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrievePageInformation();
            this.currentPage_ = 1;
            fOpenOK = true;
            Object var9_8 = null;
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
            throw throwable;
        }
    }

    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream closeReq = new NPDataStream(this.objectType_);
        closeReq.setAction(5);
        closeReq.addCodePoint(this.cpObjHndl_);
        NPDataStream closeRep = new NPDataStream(this.objectType_);
        closeRep.addCodePoint(this.cpCPFMsg_);
        try {
            block7: {
                try {
                    int rc = this.conversation_.makeRequest(closeReq, closeRep);
                    if (rc == 0) break block7;
                    Trace.log(2, "Error closing SpooledFile; rc = " + rc);
                    this.npSystem_.returnConversation(this.conversation_);
                }
                catch (Exception e) {
                    Trace.log(2, "Caught an Exception." + e.toString());
                    throw new IOException(e.toString());
                }
            }
            Object var5_5 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream closeReq = new NPDataStream(this.objectType_);
            closeReq.setAction(5);
            closeReq.addCodePoint(this.cpObjHndl_);
            AS400Server server = this.conversation_.getServer();
            if (server != null) {
                closeReq.setConverter(this.conversation_.getConverter());
                server.sendAndDiscardReply(closeReq);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    public int getCurrentPageNumber() {
        return this.currentPage_;
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    public boolean isPagesEstimated() {
        return this.pagesEst_;
    }

    public synchronized void mark(int readLimit) {
        this.offsetFromMark_ = 0;
        int maxReadLimit = this.numBytes_ - this.offset_;
        if (readLimit > maxReadLimit) {
            readLimit = maxReadLimit;
        }
        this.markLimit_ = readLimit;
        this.markSet_ = true;
    }

    public boolean nextPage() throws IOException {
        return this.selectPage(this.currentPage_ + 1);
    }

    public boolean previousPage() throws IOException {
        return this.selectPage(this.currentPage_ - 1);
    }

    public int read(byte[] data, int dataOffset, int length) throws IOException {
        int bytesRead = 0;
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(125, length);
        NPDataStream readReq = new NPDataStream(this.objectType_);
        readReq.setAction(3);
        readReq.addCodePoint(this.cpObjHndl_);
        readReq.addCodePoint(cpAttr);
        NPCPData cpData = new NPCPData();
        cpData.setDataBuffer(data, 0, dataOffset);
        NPDataStream readRep = new NPDataStream(this.objectType_);
        readRep.addCodePoint(cpData);
        readRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(readReq, readRep);
            switch (iRC) {
                case 0: 
                case 18: {
                    bytesRead = cpData.getDataLength();
                    this.offsetFromMark_ += bytesRead;
                    this.offset_ += bytesRead;
                    break;
                }
                case 32: {
                    bytesRead = -1;
                    break;
                }
                case 19: {
                    bytesRead = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        return bytesRead;
    }

    public synchronized void reset() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (!this.markSet_) {
            Trace.log(2, "Mark not set.");
            throw new IOException();
        }
        if (this.markLimit_ == 0 || this.offsetFromMark_ > this.markLimit_) {
            Trace.log(4, "Stream has not been marked or mark has been invalidated.");
            throw new IOException();
        }
        if (this.offsetFromMark_ != 0) {
            this.seekFromCur(-this.offsetFromMark_);
        }
    }

    private void retrieveNumberOfPageBytes() throws IOException, RequestNotSupportedException {
        NPCPAttributeIDList cpAttrsToRetrieve = new NPCPAttributeIDList();
        cpAttrsToRetrieve.addAttrID(125);
        NPDataStream tellReq = new NPDataStream(this.objectType_);
        tellReq.addCodePoint(this.cpObjHndl_);
        tellReq.addCodePoint(cpAttrsToRetrieve);
        tellReq.setAction(24);
        NPDataStream tellRep = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttrs = new NPCPAttribute();
        tellRep.addCodePoint(cpAttrs);
        try {
            Integer numBytes;
            int rc = this.conversation_.makeRequest(tellReq, tellRep);
            if (rc == 0) {
                numBytes = cpAttrs.getIntValue(125);
                if (numBytes == null) {
                    Trace.log(2, "Network Print Server does not support retrieving spooled file page length.");
                    throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                }
            } else {
                Trace.log(2, "Network Print Server error retrieving spooled file page length. RC =" + rc);
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
            this.numBytes_ = numBytes;
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    private void retrievePageInformation() throws IOException {
        block5: {
            if (this.conversation_ == null) {
                Trace.log(2, "Conversation is null.");
                throw new IOException();
            }
            NPCPAttributeIDList cpAttrIDs = new NPCPAttributeIDList();
            cpAttrIDs.addAttrID(111);
            cpAttrIDs.addAttrID(218);
            cpAttrIDs.addAttrID(125);
            NPDataStream tellReq = new NPDataStream(this.objectType_);
            tellReq.setAction(24);
            tellReq.addCodePoint(this.cpObjHndl_);
            tellReq.addCodePoint(cpAttrIDs);
            NPDataStream tellRep = new NPDataStream(this.objectType_);
            NPCPAttribute cpAttr = new NPCPAttribute();
            tellRep.addCodePoint(cpAttr);
            try {
                int rc = this.conversation_.makeRequest(tellReq, tellRep);
                if (rc == 0) {
                    Integer pages = cpAttr.getIntValue(111);
                    String estimated = cpAttr.getStringValue(218);
                    Integer bytes = cpAttr.getIntValue(125);
                    if (pages == null || estimated == null || bytes == null) {
                        Trace.log(2, "NPServer.TELL returned null page information!");
                        throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                    }
                    this.numberOfPages_ = pages;
                    this.numBytes_ = bytes;
                    this.pagesEst_ = estimated.equals("*YES");
                    break block5;
                }
                Trace.log(2, "Error received retrieving page information : " + Integer.toString(rc));
                throw new IOException(Integer.toString(rc));
            }
            catch (Exception e) {
                Trace.log(2, "Caught an Exception." + e.toString());
                throw new IOException(e.toString());
            }
        }
    }

    public boolean selectPage(int page) throws IOException, IllegalArgumentException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.currentPage_ == page && this.offset_ == 0) {
            return true;
        }
        if (page < 0) {
            Trace.log(2, "NPServer.SELECT_PAGE error: Page number negative");
            throw new IllegalArgumentException();
        }
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(215, page);
        NPDataStream pageReq = new NPDataStream(this.objectType_);
        pageReq.setAction(25);
        pageReq.addCodePoint(this.cpObjHndl_);
        pageReq.addCodePoint(cpAttr);
        NPDataStream pageRep = new NPDataStream(this.objectType_);
        pageRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(pageReq, pageRep);
            switch (iRC) {
                case 0: {
                    this.currentPage_ = page;
                    this.markSet_ = false;
                    this.markLimit_ = 0;
                    this.offset_ = 0;
                    this.offsetFromMark_ = 0;
                    this.retrieveNumberOfPageBytes();
                    return true;
                }
                case 33: {
                    Trace.log(2, "NPServer.SELECT_PAGE error: Page out of range");
                    return false;
                }
            }
            Trace.log(2, "NPServer.SELECT_PAGE error: " + Integer.toString(iRC));
            throw new IOException(Integer.toString(iRC));
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    private void seekFromCur(int offset) throws IOException {
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(127, 2);
        cpAttr.setAttrValue(126, offset);
        NPDataStream seekReq = new NPDataStream(this.objectType_);
        seekReq.setAction(23);
        seekReq.addCodePoint(this.cpObjHndl_);
        seekReq.addCodePoint(cpAttr);
        NPDataStream seekRep = new NPDataStream(this.objectType_);
        seekRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(seekReq, seekRep);
            switch (iRC) {
                case 0: {
                    this.offsetFromMark_ += offset;
                    this.offset_ += offset;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    public long skip(long bytesToSkip) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int maxSkip = this.numBytes_ - this.offset_;
        if (bytesToSkip > (long)maxSkip) {
            bytesToSkip = maxSkip;
        }
        this.seekFromCur((int)bytesToSkip);
        return bytesToSkip;
    }
}

