/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class ProductList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400 system_;
    private String[] productIDs_ = new String[1];
    private String[] productOptions_ = new String[1];
    private String[] releaseLevels_ = new String[1];
    private int currentProduct_ = 0;
    private String filter_ = "*ALL";
    private String option_ = "*ALL";
    private int chunkSize_ = 1000;
    public static final String PRODUCT_FILTER_ALL = "*ALL";
    public static final String PRODUCT_FILTER_INSTALLED = "*INSTLD";
    public static final String PRODUCT_FILTER_INSTALLED_OR_SUPPORTED = "*INSSPT";
    public static final String PRODUCT_FILTER_LIST = "*LIST";
    public static final String PRODUCT_FILTER_SUPPORTED = "*SUPPTD";
    public static final String PRODUCT_OPTION_ALL = "*ALL";
    public static final String PRODUCT_OPTION_BASE = "*BASE";

    public ProductList() {
    }

    public ProductList(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public void addProductToRetrieve(String productID, String productOption, String releaseLevel) {
        if (productID == null) {
            throw new NullPointerException("productID");
        }
        if (productOption == null) {
            throw new NullPointerException("productOption");
        }
        if (releaseLevel == null) {
            throw new NullPointerException("releaseLevel");
        }
        String id = productID.toUpperCase().trim();
        if (id.length() != 7) {
            throw new ExtendedIllegalArgumentException("productID", 1);
        }
        String option = productOption.toUpperCase().trim();
        if (!option.equals(PRODUCT_OPTION_BASE) && !option.equals("*ALL")) {
            while (option.length() < 5) {
                option = "0" + option;
            }
        }
        if (option.length() > 5) {
            throw new ExtendedIllegalArgumentException("productOption", 1);
        }
        String level = releaseLevel.toUpperCase().trim();
        if (level.length() != 6) {
            throw new ExtendedIllegalArgumentException("releaseLevel", 1);
        }
        if (this.currentProduct_ >= this.productIDs_.length) {
            String[] temp = this.productIDs_;
            int len = temp.length;
            int len2 = temp.length * 2;
            this.productIDs_ = new String[len2];
            System.arraycopy(temp, 0, this.productIDs_, 0, len);
            temp = this.productOptions_;
            this.productOptions_ = new String[len2];
            System.arraycopy(temp, 0, this.productOptions_, 0, len);
            temp = this.releaseLevels_;
            this.releaseLevels_ = new String[len2];
            System.arraycopy(temp, 0, this.releaseLevels_, 0, len);
        }
        this.productIDs_[this.currentProduct_] = id;
        this.productOptions_[this.currentProduct_] = option;
        this.releaseLevels_[this.currentProduct_++] = level;
    }

    public void clearProductsToRetrieve() {
        this.productIDs_ = new String[1];
        this.productOptions_ = new String[1];
        this.releaseLevels_ = new String[1];
        this.currentProduct_ = 0;
        this.filter_ = "*ALL";
    }

    public Product[] getProducts() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.filter_.equals(PRODUCT_FILTER_LIST) && this.currentProduct_ == 0) {
            if (Trace.traceOn_) {
                Trace.log(2, "ProductList filter is set to PRODUCT_FILTER_LIST but no products have been added.");
            }
            throw new ExtendedIllegalArgumentException("filter", 2);
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        ProgramParameter[] parms = new ProgramParameter[6];
        parms[0] = new ProgramParameter(197 * this.chunkSize_);
        byte[] inputInformation = new byte[40];
        BinaryConverter.intToByteArray(this.chunkSize_, inputInformation, 0);
        AS400Text text10 = new AS400Text(10, ccsid, this.system_);
        text10.toBytes("*ALL", inputInformation, 4);
        inputInformation[14] = -15;
        inputInformation[15] = -15;
        text10.toBytes(this.option_, inputInformation, 16);
        text10.toBytes(this.filter_, inputInformation, 26);
        if (this.currentProduct_ > 0 && this.filter_.equals(PRODUCT_FILTER_LIST)) {
            BinaryConverter.intToByteArray(this.currentProduct_, inputInformation, 36);
        }
        parms[1] = new ProgramParameter(inputInformation);
        parms[2] = new ProgramParameter(conv.stringToByteArray("PRDS0200"));
        byte[] inputList = null;
        if (this.currentProduct_ > 0 && this.filter_.equals(PRODUCT_FILTER_LIST)) {
            inputList = new byte[18 * this.currentProduct_];
            AS400Text text5 = new AS400Text(5, ccsid, this.system_);
            AS400Text text6 = new AS400Text(6, ccsid, this.system_);
            AS400Text text7 = new AS400Text(7, ccsid, this.system_);
            int offset = 0;
            for (int i = 0; i < this.currentProduct_; ++i) {
                text7.toBytes(this.productIDs_[i], inputList, offset);
                text5.toBytes(this.productOptions_[i], inputList, offset += 7);
                text6.toBytes(this.releaseLevels_[i], inputList, offset += 5);
                offset += 6;
            }
        } else {
            inputList = new byte[18];
        }
        parms[3] = new ProgramParameter(inputList);
        parms[4] = new ProgramParameter(12);
        parms[5] = new ProgramParameter(new byte[4]);
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSZSLTPR.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] outputInformation = parms[4].getOutputData();
        int recordSize = BinaryConverter.byteArrayToInt(outputInformation, 0);
        int numRecords = BinaryConverter.byteArrayToInt(outputInformation, 4);
        if (numRecords > this.chunkSize_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Increasing ProductList chunk size from " + this.chunkSize_ + " to " + numRecords + " and re-retrieving.");
            }
            this.chunkSize_ = numRecords;
            return this.getProducts();
        }
        byte[] outputList = parms[0].getOutputData();
        int offset = 0;
        Product[] products = new Product[numRecords];
        for (int i = 0; i < numRecords && offset < outputList.length; ++i) {
            offset = i * recordSize;
            String productID = conv.byteArrayToString(outputList, offset, 7);
            String productOption = conv.byteArrayToString(outputList, offset += 7, 5);
            String releaseLevel = conv.byteArrayToString(outputList, offset += 5, 6);
            String descriptionID = conv.byteArrayToString(outputList, offset += 8, 7);
            String descriptionObject = conv.byteArrayToString(outputList, offset += 7, 10);
            String descriptionLibrary = conv.byteArrayToString(outputList, offset += 10, 10);
            String messageFile = QSYSObjectPathName.toPath(descriptionLibrary, descriptionObject, "MSGF");
            boolean installed = conv.byteArrayToString(outputList, offset += 10, 1).equals("1");
            boolean supported = conv.byteArrayToString(outputList, ++offset, 1).equals("1");
            String registrationType = conv.byteArrayToString(outputList, ++offset, 2);
            String registrationValue = conv.byteArrayToString(outputList, offset += 2, 14);
            String descriptionText = conv.byteArrayToString(outputList, offset += 14, 132);
            products[i] = new Product(this.system_, productID, productOption, releaseLevel, descriptionID, descriptionText, messageFile, installed, supported, registrationType, registrationValue);
        }
        return products;
    }

    public void setProductFilter(String filter) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (!(filter.equals(PRODUCT_FILTER_INSTALLED) || filter.equals(PRODUCT_FILTER_SUPPORTED) || filter.equals(PRODUCT_FILTER_INSTALLED_OR_SUPPORTED) || filter.equals("*ALL") || filter.equals(PRODUCT_FILTER_LIST))) {
            throw new ExtendedIllegalArgumentException("filter", 2);
        }
        this.filter_ = filter;
    }

    public void setProductOption(String option) {
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (!option.equals("*ALL") && !option.equals(PRODUCT_OPTION_BASE)) {
            throw new ExtendedIllegalArgumentException("option", 2);
        }
        this.option_ = option;
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }
}

