/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProxyFactoryImpl;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.PxAcceptRepCV;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxClassParm;
import com.ibm.as400.access.PxClientConnectionAdapter;
import com.ibm.as400.access.PxConnectReqCV;
import com.ibm.as400.access.PxConstructorReqCV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxEventRepCV;
import com.ibm.as400.access.PxEventSupport;
import com.ibm.as400.access.PxExceptionRepCV;
import com.ibm.as400.access.PxFinalizeReqCV;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxListenerReqCV;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxMethodReqCV;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxRejectRepCV;
import com.ibm.as400.access.PxReqCV;
import com.ibm.as400.access.PxReturnRepCV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxToolboxObjectParm;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;

class ProxyClientConnection
extends PxClientConnectionAdapter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String locale_ = Locale.getDefault().toString();
    private static final Class[] noArgumentClasses_ = new Class[0];
    private static final Object[] noArguments_ = new Object[0];
    private int connectAttempts_ = 0;
    private PxEventSupport eventSupport_;
    private Vector pxList_ = new Vector();
    private SecondaryFinalizerThread_ secondaryFinalizerThread_;

    public ProxyClientConnection(String proxyServer, SSLOptions secure) {
        super(proxyServer, secure);
        this.connect();
    }

    public void addListener(long proxyId, EventListener listener, String eventName) {
        if (this.eventSupport_.addListener(proxyId, listener)) {
            PxListenerReqCV request = new PxListenerReqCV(proxyId, 1, eventName);
            this.send(request);
        }
    }

    public long callConstructor(String className) throws InvocationTargetException {
        return this.callConstructor(className, true);
    }

    public long callConstructor(String className, boolean flag) throws InvocationTargetException {
        PxConstructorReqCV request = new PxConstructorReqCV(className, flag);
        long pxId = ((ProxyReturnValue)this.sendAndReceive(request)).getReturnValuePxId();
        this.pxList_.addElement(new Long(pxId));
        return pxId;
    }

    public ProxyFactoryImpl callFactoryMethod(long proxyId, String methodName, ProxyFactoryImpl proxyImpl) throws InvocationTargetException {
        return this.callFactoryMethod(proxyId, methodName, noArgumentClasses_, noArguments_, proxyImpl);
    }

    public ProxyFactoryImpl callFactoryMethod(long proxyId, String methodName, Class[] argumentClasses, Object[] arguments, ProxyFactoryImpl proxyImpl) throws InvocationTargetException {
        PxMethodReqCV request = new PxMethodReqCV(proxyId, methodName, argumentClasses, arguments, null, false, true);
        long proxyId2 = ((ProxyReturnValue)this.sendAndReceive(request)).getReturnValuePxId();
        if (proxyId2 >= 0L) {
            proxyImpl.initialize(proxyId2, this);
            this.pxList_.addElement(new Long(proxyId2));
            return proxyImpl;
        }
        return null;
    }

    public void callFinalize(long proxyId) throws InvocationTargetException {
        Long pxId2 = new Long(proxyId);
        if (this.pxList_.contains(pxId2)) {
            this.eventSupport_.removeAll(proxyId);
            PxFinalizeReqCV request = new PxFinalizeReqCV(proxyId);
            this.secondaryFinalizerThread_.addRequest(request);
            this.pxList_.removeElement(pxId2);
        }
    }

    public ProxyReturnValue callMethod(long proxyId, String methodName) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, noArgumentClasses_, noArguments_, false);
    }

    public ProxyReturnValue callMethod(long proxyId, String methodName, Class[] argumentClasses, Object[] arguments) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, argumentClasses, arguments, false);
    }

    public ProxyReturnValue callMethod(long proxyId, String methodName, Class[] argumentClasses, Object[] arguments, boolean asynchronous) throws InvocationTargetException {
        PxMethodReqCV request = new PxMethodReqCV(proxyId, methodName, argumentClasses, arguments, null, asynchronous, false);
        return (ProxyReturnValue)this.sendAndReceive(request);
    }

    public ProxyReturnValue callMethod(long proxyId, String methodName, Class[] argumentClasses, Object[] arguments, boolean[] returnArguments, boolean asynchronous) throws InvocationTargetException {
        PxMethodReqCV request = new PxMethodReqCV(proxyId, methodName, argumentClasses, arguments, returnArguments, asynchronous, false);
        return (ProxyReturnValue)this.sendAndReceive(request);
    }

    public boolean callMethodReturnsBoolean(long proxyId, String methodName) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, noArgumentClasses_, noArguments_, false).getReturnValueBoolean();
    }

    public int callMethodReturnsInt(long proxyId, String methodName) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, noArgumentClasses_, noArguments_, false).getReturnValueInt();
    }

    public long callMethodReturnsLong(long proxyId, String methodName) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, noArgumentClasses_, noArguments_, false).getReturnValueLong();
    }

    public Object callMethodReturnsObject(long proxyId, String methodName) throws InvocationTargetException {
        return this.callMethod(proxyId, methodName, noArgumentClasses_, noArguments_, false).getReturnValue();
    }

    public void close() {
        super.close();
        this.secondaryFinalizerThread_.stopSafely();
    }

    public void connect() {
        PxConnectReqCV request = this.tunnel_ ? new PxConnectReqCV("mod4", this.connectAttempts_++, locale_, 11015) : new PxConnectReqCV("mod4", this.connectAttempts_++, locale_, 11010);
        try {
            this.sendAndReceive(request);
        }
        catch (InvocationTargetException e) {
            ProxyClientConnection.rethrow(e);
        }
    }

    protected void finalize() throws Throwable {
        Object[] pxList = new Long[this.pxList_.size()];
        this.pxList_.copyInto(pxList);
        for (int i = 0; i < pxList.length; ++i) {
            long pxId = (Long)pxList[i];
            this.callFinalize(pxId);
        }
        super.finalize();
    }

    public void open(String proxyServer) {
        super.open(proxyServer);
        PxDSFactory factory = this.getFactory();
        factory.register(new PxByteParm());
        factory.register(new PxShortParm());
        factory.register(new PxIntParm());
        factory.register(new PxLongParm());
        factory.register(new PxFloatParm());
        factory.register(new PxDoubleParm());
        factory.register(new PxBooleanParm());
        factory.register(new PxCharParm());
        factory.register(new PxStringParm());
        factory.register(new PxPxObjectParm());
        factory.register(new PxSerializedObjectParm());
        factory.register(new PxToolboxObjectParm());
        factory.register(new PxNullParm());
        factory.register(new PxClassParm());
        factory.register(new PxAcceptRepCV());
        factory.register(new PxRejectRepCV(this));
        factory.register(new PxReturnRepCV());
        factory.register(new PxExceptionRepCV());
        this.eventSupport_ = new PxEventSupport();
        factory.register(new PxEventRepCV(this.eventSupport_));
        this.secondaryFinalizerThread_ = new SecondaryFinalizerThread_();
        this.secondaryFinalizerThread_.start();
    }

    public void removeListener(long proxyId, EventListener listener, String eventName) {
        if (this.eventSupport_.removeListener(proxyId, listener)) {
            PxListenerReqCV request = new PxListenerReqCV(proxyId, 2, eventName);
            this.send(request);
            this.eventSupport_.removeAll(proxyId);
        }
    }

    public static InternalErrorException rethrow(InvocationTargetException e) {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof RuntimeException) {
            throw (RuntimeException)e2;
        }
        if (e2 instanceof Error) {
            throw (Error)e2;
        }
        InternalErrorException ex = new InternalErrorException(10);
        ex.initCause(e2);
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, "rethrow @", (Throwable)ex);
        }
        return ex;
    }

    public static InternalErrorException rethrow1(InvocationTargetException e) throws IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        return ProxyClientConnection.rethrow(e);
    }

    public static InternalErrorException rethrow2(InvocationTargetException e) throws AS400SecurityException, IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof AS400SecurityException) {
            throw (AS400SecurityException)e2;
        }
        return ProxyClientConnection.rethrow1(e);
    }

    public static InternalErrorException rethrow3(InvocationTargetException e) throws AS400SecurityException, InterruptedException, IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof InterruptedException) {
            throw (InterruptedException)e2;
        }
        return ProxyClientConnection.rethrow2(e);
    }

    public static InternalErrorException rethrow4(InvocationTargetException e) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)e2;
        }
        return ProxyClientConnection.rethrow3(e);
    }

    public static InternalErrorException rethrow4a(InvocationTargetException e) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof AS400Exception) {
            throw (AS400Exception)e2;
        }
        return ProxyClientConnection.rethrow3(e);
    }

    public static InternalErrorException rethrow5(InvocationTargetException e) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof ObjectDoesNotExistException) {
            throw (ObjectDoesNotExistException)e2;
        }
        return ProxyClientConnection.rethrow4(e);
    }

    public static InternalErrorException rethrow6(InvocationTargetException e) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof ObjectAlreadyExistsException) {
            throw (ObjectAlreadyExistsException)e2;
        }
        return ProxyClientConnection.rethrow5(e);
    }

    public static InternalErrorException rethrow6a(InvocationTargetException e) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof RequestNotSupportedException) {
            throw (RequestNotSupportedException)e2;
        }
        return ProxyClientConnection.rethrow4(e);
    }

    private class SecondaryFinalizerThread_
    extends StoppableThread {
        private Vector requests_;

        public SecondaryFinalizerThread_() {
            super("Proxy client secondary finalizer thread-" + SecondaryFinalizerThread_.newId());
            this.requests_ = new Vector();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(PxReqCV request) {
            Vector vector = this.requests_;
            synchronized (vector) {
                this.requests_.addElement(request);
                this.requests_.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.canContinue()) {
                Vector vector = this.requests_;
                synchronized (vector) {
                    try {
                        this.requests_.wait();
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    Enumeration list = this.requests_.elements();
                    while (list.hasMoreElements()) {
                        PxReqCV request = (PxReqCV)list.nextElement();
                        ProxyClientConnection.this.send(request);
                    }
                    this.requests_.removeAllElements();
                }
            }
        }
    }
}

