/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PSConfig;
import com.ibm.as400.access.PSController;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PSServerSocketContainer;
import com.ibm.as400.access.PxPeerConnection;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyServer {
    private static final PrintStream errors_ = System.err;
    private PSConfig configuration_;
    private PSLoad load_ = new PSLoad();
    private PSLoadBalancer loadBalancer_ = new PSLoadBalancer(this.load_);
    private int port_ = 3470;
    private int securePort_ = 3471;
    private Vector threadGroup_ = null;

    public ProxyServer() {
        this.configuration_ = new PSConfig(this.load_, this.loadBalancer_);
    }

    public int getActiveConnections() {
        return this.load_.getActiveConnections();
    }

    public int getBalanceThreshold() {
        return this.load_.getBalanceThreshold();
    }

    public String getConfiguration() {
        return this.configuration_.getName();
    }

    public String getKeyring() {
        return null;
    }

    String getKeyringPassword() {
        return null;
    }

    public int getMaxConnections() {
        return this.load_.getMaxConnections();
    }

    public String[] getPeers() {
        return this.loadBalancer_.getPeers();
    }

    public int getPort() {
        return this.port_;
    }

    public int getSecurePort() {
        return this.securePort_;
    }

    public boolean isStarted() {
        return this.threadGroup_ != null;
    }

    public boolean isVerbose() {
        return Verbose.isVerbose();
    }

    public static void main(String[] args) {
        ProxyServer proxyServer = new ProxyServer();
        if (proxyServer.parseArgs(args)) {
            Verbose.forcePrintln(ResourceBundleLoader.getText("PROXY_SERVER_STARTED"));
            proxyServer.start();
        } else {
            PSConfig.usage(System.err);
        }
    }

    private boolean parseArgs(String[] args) {
        String securePortOptionValue;
        CommandLineArguments cla = new CommandLineArguments(args, PSConfig.expectedOptions_, PSConfig.shortcuts_);
        if (cla.getOptionValue("-help") != null) {
            return false;
        }
        try {
            this.configuration_.apply(cla);
        }
        catch (Exception e) {
            errors_.println(e.getMessage());
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Exception while parsing command line arguments", (Throwable)e);
            }
            return false;
        }
        String portOptionValue = cla.getOptionValue("-port");
        if (portOptionValue != null && portOptionValue.length() > 0) {
            this.setPort(Integer.parseInt(portOptionValue));
        }
        if ((securePortOptionValue = cla.getOptionValue("-securePort")) != null && securePortOptionValue.length() > 0) {
            this.setSecurePort(Integer.parseInt(securePortOptionValue));
        }
        Enumeration list = cla.getExtraOptions();
        while (list.hasMoreElements()) {
            String extraOption = list.nextElement().toString();
            errors_.println(ResourceBundleLoader.getText("PROXY_OPTION_NOT_VALID", extraOption));
        }
        String noOptionValues = cla.getOptionValue("-");
        if (noOptionValues != null && noOptionValues.length() > 0) {
            errors_.println(ResourceBundleLoader.getText("PROXY_VALUE_NO_OPTION", noOptionValues));
        }
        return true;
    }

    public void setBalanceThreshold(int balanceThreshold) {
        this.load_.setBalanceThreshold(balanceThreshold);
    }

    public void setConfiguration(String configuration) throws IOException {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        if (configuration.length() == 0) {
            throw new ExtendedIllegalArgumentException("configuration", 2);
        }
        this.configuration_.setName(configuration);
        this.configuration_.load();
    }

    public void setKeyringName(String keyringName) {
        throw new ExtendedIllegalArgumentException("keyringName", 2);
    }

    public void setKeyringPassword(String keyringPassword) {
        throw new ExtendedIllegalArgumentException("keyringPassword", 2);
    }

    public void setMaxConnections(int maxConnections) {
        this.load_.setMaxConnections(maxConnections);
    }

    public void setPeers(String[] peers) {
        if (peers == null) {
            throw new NullPointerException("peers");
        }
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null) {
                throw new NullPointerException("peers[" + i + "]");
            }
            if (peers[i].length() != 0) continue;
            throw new ExtendedIllegalArgumentException("peers[" + i + "]", 2);
        }
        this.loadBalancer_.setPeers(peers);
    }

    public void setPort(int port) {
        if (this.isStarted()) {
            throw new ExtendedIllegalStateException("port", 5);
        }
        if (port < 0 || port > 65535) {
            throw new ExtendedIllegalArgumentException("port", 4);
        }
        this.port_ = port;
    }

    public void setSecurePort(int securePort) {
        throw new ExtendedIllegalArgumentException("setSecurePort", 2);
    }

    public void setVerbose(boolean verbose) {
        Verbose.setVerbose(verbose);
    }

    public void start() {
        if (this.threadGroup_ != null) {
            throw new ExtendedIllegalStateException(7);
        }
        this.threadGroup_ = new Vector();
        try {
            PSServerSocketContainer serverSocket = new PSServerSocketContainer(this.port_);
            this.port_ = serverSocket.getLocalPort();
            PSController controller = new PSController(this.threadGroup_, this, this.load_, this.loadBalancer_, this.configuration_, serverSocket);
            controller.start();
            this.threadGroup_.addElement(controller);
            Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_LISTENING", serverSocket, Integer.toString(this.port_)));
        }
        catch (BindException e) {
            Verbose.println(ResourceBundleLoader.getText("PROXY_ALREADY_LISTENING", Integer.toString(this.port_)));
            try {
                PxPeerConnection peerConnection = new PxPeerConnection(InetAddress.getLocalHost().getHostName() + ":" + this.port_);
                peerConnection.configure(this.configuration_);
                peerConnection.close();
                return;
            }
            catch (UnknownHostException e1) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Peer host is unknown.", (Throwable)e);
                }
                errors_.println(e.getMessage());
            }
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error opening server socket.", (Throwable)e);
            }
            errors_.println(e.getMessage());
        }
    }

    public void stop() {
        if (this.threadGroup_ == null) {
            throw new ExtendedIllegalStateException(8);
        }
        this.load_.allConnectionsClosed();
        Enumeration list = this.threadGroup_.elements();
        while (list.hasMoreElements()) {
            ((StoppableThread)list.nextElement()).stopSafely();
        }
        this.threadGroup_ = null;
    }

    static {
        SystemProperties.ignoreProperty("com.ibm.as400.access.AS400.proxyServer");
    }
}

