/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxDS;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxTable;
import com.ibm.as400.access.PxToolboxObjectParm;
import com.ibm.as400.access.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

abstract class PxCompDS
extends PxDS {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Vector parameters_ = new Vector();

    public PxCompDS(short type) {
        super(type);
    }

    public void addObjectParm(Object object) {
        this.addObjectParm(null, object);
    }

    public void addObjectParm(PxTable pxTable, Object object) {
        PxDS parameter;
        if (object == null) {
            parameter = new PxNullParm();
        } else if (object instanceof Byte) {
            parameter = new PxByteParm((Byte)object);
        } else if (object instanceof Short) {
            parameter = new PxShortParm((Short)object);
        } else if (object instanceof Integer) {
            parameter = new PxIntParm((Integer)object);
        } else if (object instanceof Long) {
            parameter = new PxLongParm((Long)object);
        } else if (object instanceof Float) {
            parameter = new PxFloatParm((Float)object);
        } else if (object instanceof Double) {
            parameter = new PxDoubleParm((Double)object);
        } else if (object instanceof Character) {
            parameter = new PxCharParm((Character)object);
        } else if (object instanceof Boolean) {
            parameter = new PxBooleanParm((Boolean)object);
        } else if (object instanceof String) {
            parameter = new PxStringParm((String)object);
        } else {
            long proxyId = -1L;
            if (object instanceof ProxyImpl) {
                proxyId = ((ProxyImpl)object).getPxId();
            } else if (pxTable != null) {
                proxyId = pxTable.get(object);
            }
            parameter = proxyId >= 0L ? new PxPxObjectParm(proxyId) : (object.getClass().getName().startsWith("com.ibm.as400.access") ? new PxToolboxObjectParm(object) : new PxSerializedObjectParm(object));
        }
        this.addParm((PxParm)((Object)parameter));
    }

    public void addParm(PxParm parameter) {
        this.parameters_.addElement(parameter);
    }

    public void clearParms() {
        this.parameters_.removeAllElements();
    }

    public Object clone() throws CloneNotSupportedException {
        PxCompDS clone = (PxCompDS)super.clone();
        clone.parameters_ = (Vector)this.parameters_.clone();
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.dump(output);
            int numberOfParms = this.parameters_.size();
            for (int j = 0; j < numberOfParms; ++j) {
                output.println("   " + this.parameters_.elementAt(j).toString());
            }
        }
    }

    public PxParm getParm(int i) {
        return (PxParm)this.parameters_.elementAt(i);
    }

    public int getParmCount() {
        return this.parameters_.size();
    }

    public void readFrom(InputStream input, PxDSFactory factory) throws IOException {
        super.readFrom(input, factory);
        DataInputStream dataInput = new DataInputStream(input);
        this.clearParms();
        int numberOfParms = dataInput.readInt();
        for (int i = 0; i < numberOfParms; ++i) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, ".readFrom parm (" + i + "/" + numberOfParms + ") calling factory_.getNextDS");
            }
            PxParm parameter = (PxParm)factory.getNextDS(input);
            this.addParm(parameter);
        }
    }

    public void writeTo(OutputStream output) throws IOException {
        super.writeTo(output);
        DataOutputStream dataOutput = new DataOutputStream(output);
        int numberOfParms = this.getParmCount();
        dataOutput.writeInt(numberOfParms);
        for (int i = 0; i < numberOfParms; ++i) {
            this.getParm(i).writeTo(output);
        }
    }
}

