/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxDSRV;
import com.ibm.as400.access.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class PxDSFactory {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable factory_ = new Hashtable();

    PxDSFactory() {
    }

    public PxDSRV getNextDS(InputStream input) throws IOException {
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "getNextDS");
        }
        try {
            DataInputStream dataInput = new DataInputStream(input);
            Short type = new Short(dataInput.readShort());
            if (this.factory_.containsKey(type)) {
                PxDSRV datastream;
                block11: {
                    PxDSRV template = (PxDSRV)this.factory_.get(type);
                    if (Trace.isTraceProxyOn()) {
                        Trace.log(6, "getNextDS. Factory read ds type " + type + " (" + template + ").");
                    }
                    datastream = null;
                    try {
                        datastream = (PxDSRV)template.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        if (!Trace.isTraceErrorOn()) break block11;
                        Trace.log(2, "Clone error in ds factory", (Throwable)e);
                    }
                }
                datastream.readFrom(input, this);
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, "getNextDS. returning " + datastream);
                }
                return datastream;
            }
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Factory read ds type " + type + ".");
            }
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ds type " + type + " not registered in factory.");
            }
            throw new InternalErrorException(2);
        }
        catch (IOException e) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "exception thrown from getNextDS " + e);
            }
            throw e;
        }
    }

    public void register(PxDSRV datastream) {
        Short key = new Short(datastream.getType());
        if (this.factory_.contains(key)) {
            throw new InternalErrorException(4);
        }
        this.factory_.put(key, datastream);
    }
}

