/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5256Writer;
import com.ibm.as400.access.SCSFontData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5224Writer
extends SCS5256Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] SCGL = new byte[]{43, -47, 3, -127, -1};
    private static final byte[] SLD = new byte[]{43, -58, 2, 0};
    private byte LPI = (byte)6;
    static final boolean FONT_ = false;
    static final boolean CPI_ = true;
    boolean fontOrCPI = true;
    byte CPI = (byte)10;

    public SCS5224Writer(OutputStream out) {
        super(out);
    }

    public SCS5224Writer(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out, ccsid);
    }

    public SCS5224Writer(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        super(out, ccsid, system);
    }

    public SCS5224Writer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
    }

    void initPage() throws IOException {
        super.initPage();
        if (this.fontOrCPI) {
            this.setCPI(this.CPI);
        }
        this.setLPI(this.LPI);
        this.setCodePage();
    }

    void setCodePage() throws IOException {
        byte[] cmd = SCGL;
        int ccsid = this.getCcsid();
        int[] codePage = SCSFontData.codePage;
        int length = codePage.length;
        for (int i = 0; i < length; ++i) {
            if (ccsid != codePage[i]) continue;
            cmd[cmd.length - 1] = SCSFontData.codePageID[i];
            break;
        }
        this.addToBuffer(cmd);
    }

    public void setCPI(int cpi) throws IOException {
        switch (cpi) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            default: {
                String arg = "CPI (" + String.valueOf(cpi) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        } else {
            byte[] cmd = SCD;
            cmd[cmd.length - 1] = this.CPI;
            this.addToBuffer(cmd);
        }
    }

    public void setLPI(int lpi) throws IOException {
        int LPI1440;
        switch (lpi) {
            case 4: {
                this.LPI = (byte)4;
                LPI1440 = 18;
                break;
            }
            case 6: {
                this.LPI = (byte)6;
                LPI1440 = 12;
                break;
            }
            case 8: {
                this.LPI = (byte)8;
                LPI1440 = 9;
                break;
            }
            case 9: {
                this.LPI = (byte)9;
                LPI1440 = 8;
                break;
            }
            case 12: {
                this.LPI = (byte)12;
                LPI1440 = 6;
                break;
            }
            default: {
                String arg = "LPI (" + String.valueOf(lpi) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
        if (!this.pageStarted_) {
            this.initPage();
        } else {
            byte[] cmd = SLD;
            cmd[cmd.length - 1] = LPI1440;
            this.addToBuffer(cmd);
        }
    }
}

