/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5224Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5553Writer
extends SCS5224Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int CHARACTER_NORMAL = 0;
    public static final int CHARACTER_ROTATED = 1;
    public static final int SCALE_DOUBLE_HORIZONTAL = 32;
    public static final int SCALE_REGULAR = 16;
    public static final int SETCCP_NO_PRINT = 0;
    public static final int SETCCP_BLANK_CODE = 1;
    public static final int SETCCP_SI_BLANK = 2;
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] DGL = new byte[]{43, -3, 0, 0, 0, 0};
    private static final byte[] SFSS = new byte[]{43, -3, 4, 2, 0, 0};
    private static final byte[] STO = new byte[]{43, -45, 4, -10, 0, 0};
    private static final byte[] SPPC = new byte[]{43, -3, 4, 3, 0, 0};
    private int setCCP = 1;

    public SCS5553Writer(OutputStream out) {
        super(out);
    }

    public SCS5553Writer(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out, ccsid);
    }

    public SCS5553Writer(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        super(out, ccsid, system);
    }

    public SCS5553Writer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
    }

    void initPage() throws IOException {
        super.initPage();
        this.setControlCharPresentation(this.setCCP);
    }

    public void setCPI(int cpi) throws IOException {
        switch (cpi) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 12: {
                this.CPI = (byte)12;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            case 18: {
                this.CPI = (byte)18;
                break;
            }
            case 20: {
                this.CPI = (byte)20;
                break;
            }
            default: {
                String arg = "CPI (" + String.valueOf(cpi) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] cmd = SCD;
        cmd[cmd.length - 1] = this.CPI;
        this.addToBuffer(cmd);
    }

    public void printHorizontalGridLine(double start, double stop) throws IOException {
        byte[] positions = new byte[4];
        byte[] cmd = DGL;
        cmd[2] = 8;
        cmd[cmd.length - 1] = -128;
        this.addToBuffer(cmd);
        int iStart = (int)(start * 1440.0);
        int iStop = (int)(stop * 1440.0);
        positions[0] = (byte)(iStart >> 8);
        positions[1] = (byte)iStart;
        positions[2] = (byte)(iStop >> 8);
        positions[3] = (byte)iStop;
        this.addToBuffer(positions);
    }

    public void setCharacterRotation(int rotation) throws IOException {
        byte[] cmd = STO;
        switch (rotation) {
            case 0: {
                cmd[cmd.length - 2] = 0;
                cmd[cmd.length - 1] = 0;
                this.addToBuffer(cmd);
                break;
            }
            case 1: {
                cmd[cmd.length - 2] = -121;
                cmd[cmd.length - 1] = 0;
                this.addToBuffer(cmd);
                break;
            }
            default: {
                String arg = "Rotation (" + String.valueOf(rotation) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }

    public void setControlCharPresentation(int set) throws IOException {
        byte[] cmd = SPPC;
        switch (set) {
            case 0: 
            case 1: 
            case 2: {
                this.setCCP = set;
                cmd[4] = (byte)(set >> 8);
                cmd[5] = (byte)set;
                this.addToBuffer(cmd);
                break;
            }
            default: {
                String arg = "set (" + String.valueOf(set) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }

    public void setFontScaling(int scale) throws IOException {
        byte[] cmd = SFSS;
        switch (scale) {
            case 16: {
                cmd[cmd.length - 2] = 16;
                this.addToBuffer(cmd);
                break;
            }
            case 32: {
                cmd[cmd.length - 2] = 32;
                this.addToBuffer(cmd);
                break;
            }
            default: {
                String arg = "Scale (" + String.valueOf(scale) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }

    public void startVerticalGridLines(double[] positions) throws IOException {
        byte[] cmd = DGL;
        int len = positions.length;
        byte[] iPositions = new byte[2 * len];
        cmd[2] = (byte)(4 + 2 * len);
        cmd[5] = 64;
        this.addToBuffer(cmd);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int iPos = (int)(positions[i] * 1440.0);
            iPositions[j] = (byte)(iPos >> 8);
            iPositions[++j] = (byte)iPos;
            ++j;
        }
        this.addToBuffer(iPositions);
    }

    public void stopVerticalGridLines() throws IOException {
        byte[] cmd = DGL;
        cmd[2] = 4;
        cmd[5] = 0;
        this.addToBuffer(cmd);
    }
}

