/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBoolean
extends SQLDataBase {
    static final String copyright = "Copyright (C) 2020-2020 International Business Machines Corporation and others.";
    private boolean value_ = false;
    private int vrm_;

    SQLBoolean(int vrm, SQLConversionSettings settings) {
        this(0, vrm, settings);
    }

    SQLBoolean(int scale, int vrm, SQLConversionSettings settings) {
        super(settings);
        this.vrm_ = vrm;
    }

    public Object clone() {
        return new SQLBoolean(this.vrm_, this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        byte binaryValue = rawBytes[offset];
        this.value_ = binaryValue != -16;
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        rawBytes[offset] = this.value_ ? -15 : -16;
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        block20: {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (object instanceof String) {
                String string = (String)object;
                if ("TRUE".equals(string = string.toUpperCase().trim()) || "T".equals(string) || "Y".equals(string) || "YES".equals(string) || "ON".equals(string)) {
                    this.value_ = true;
                } else if ("FALSE".equals(string) || "F".equals(string) || "N".equals(string) || "NO".equals(string) || "OFF".equals(string)) {
                    this.value_ = false;
                } else {
                    try {
                        long longValue = Long.parseLong(string);
                        if (longValue == 0L) {
                            if (string.charAt(0) == '0') {
                                this.value_ = false;
                            } else {
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "Unable to assign string (" + string + ")");
                                }
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block20;
                        }
                        this.value_ = true;
                    }
                    catch (NumberFormatException nfe) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Unable to assign string (" + string + ")");
                        }
                        JDError.throwSQLException((Object)this, "07006", nfe);
                    }
                }
            } else if (object instanceof Number) {
                long longValue = ((Number)object).longValue();
                this.value_ = longValue != 0L;
            } else if (object instanceof Boolean) {
                this.value_ = (Boolean)object;
            } else {
                if (JDTrace.isTraceOn()) {
                    if (object == null) {
                        JDTrace.logInformation(this, "Unable to assign null object");
                    } else {
                        JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                    }
                }
                JDError.throwSQLException((Object)this, "07006");
            }
        }
    }

    public void set(int value) {
        this.value_ = value == 0;
    }

    public int getSQLType() {
        return 41;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 1;
    }

    public String getJavaClassName() {
        return "java.lang.Boolean";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "BOOLEAN";
    }

    public int getMaximumPrecision() {
        return 1;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 2436;
    }

    public int getPrecision() {
        return 1;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 16;
    }

    public String getTypeName() {
        return "BOOLEAN";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 1;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        BigDecimal bigDecimalValue = this.value_ ? new BigDecimal(1) : new BigDecimal(0);
        if (scale > 0) {
            bigDecimalValue = bigDecimalValue.setScale(scale);
        }
        return bigDecimalValue;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        return this.value_;
    }

    public byte getByte() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        if (this.value_) {
            return 1.0;
        }
        return 0.0;
    }

    public float getFloat() throws SQLException {
        if (this.value_) {
            return 1.0f;
        }
        return 0.0f;
    }

    public int getInt() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    public long getLong() throws SQLException {
        if (this.value_) {
            return 1L;
        }
        return 0L;
    }

    public Object getObject() throws SQLException {
        return new Boolean(this.value_);
    }

    public short getShort() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    public String getString() throws SQLException {
        if (this.value_) {
            return "1";
        }
        return "0";
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        return this.getString();
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = new Boolean(this.value_);
    }
}

