/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClobLocator
implements SQLLocator {
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLNClobLocator(AS400JDBCConnection connection, int id, int maxLength, SQLConversionSettings settings, ConvTable converter, int columnIndex) {
        this.connection_ = connection;
        this.id_ = id;
        this.locator_ = new JDLobLocator(connection, id, maxLength, true);
        this.maxLength_ = maxLength;
        this.settings_ = settings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = converter;
        this.columnIndex_ = columnIndex;
    }

    public Object clone() {
        return new SQLNClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int handle) {
        this.locator_.setHandle(handle);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int locatorHandle = BinaryConverter.byteArrayToInt(rawBytes, offset);
        this.locator_.setHandle(locatorHandle);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), rawBytes, offset);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            String s = (String)object;
            int length = s.length();
            this.truncated_ = length > this.maxLength_ ? length - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof NClob || object instanceof SQLXML)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (scale != -1) {
            this.scale_ = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        int length_ = this.scale_;
        if (length_ == -1) {
            try {
                length_ = (int)this.locator_.getLength();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object object = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object, length_, this);
            this.savedObject_ = this.value_;
        } else if (object instanceof Clob) {
            Clob clob;
            if (object instanceof AS400JDBCClobLocator) {
                Clob clob2 = clob = (AS400JDBCClobLocator)object;
                synchronized (clob2) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            clob = (Clob)object;
            this.value_ = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            this.value_ = xml.getString();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int valueLength = this.value_.length();
        if (valueLength > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToServer() throws SQLException {
        block58: {
            try {
                Object object = this.savedObject_;
                if (object instanceof String) {
                    String string = (String)object;
                    byte[] bytes = this.converter_.stringToByteArray(string);
                    this.locator_.writeData(0L, bytes, true);
                    break block58;
                }
                if (object instanceof Reader) {
                    int length = this.scale_ * 2;
                    if (length == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block58;
                    }
                    if (length > 0) {
                        try {
                            int blockSize = length < 1000000 ? length : 1000000;
                            int bidiStringType = this.settings_.getBidiStringType();
                            if (bidiStringType == -1) {
                                bidiStringType = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream stream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, blockSize);
                            try {
                                byte[] byteBuffer = new byte[blockSize];
                                int totalBytesRead = 0;
                                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                                while (bytesRead > -1 && totalBytesRead < length) {
                                    this.locator_.writeData(totalBytesRead / 2, byteBuffer, 0, bytesRead, true);
                                    int bytesRemaining = length - (totalBytesRead += bytesRead);
                                    if (bytesRemaining < blockSize) {
                                        blockSize = bytesRemaining;
                                        if (stream.available() == 0 && blockSize != 0) {
                                            stream.close();
                                            stream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, blockSize);
                                        }
                                    }
                                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                                }
                                if (totalBytesRead < length) {
                                    JDError.throwSQLException((Object)this, "07006");
                                }
                                break block58;
                            }
                            finally {
                                try {
                                    stream.close();
                                }
                                catch (Exception e) {
                                    JDTrace.logException(this, "writeToServer stream.close()", e);
                                }
                            }
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                        }
                        break block58;
                    }
                    if (length == -2) {
                        try {
                            int blockSize = 1000000;
                            int bidiStringType = this.settings_.getBidiStringType();
                            if (bidiStringType == -1) {
                                bidiStringType = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream stream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, blockSize);
                            try {
                                byte[] byteBuffer = new byte[blockSize];
                                int totalBytesRead = 0;
                                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                                while (bytesRead > -1) {
                                    this.locator_.writeData(totalBytesRead / 2, byteBuffer, 0, bytesRead, true);
                                    totalBytesRead += bytesRead;
                                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                                }
                                break block58;
                            }
                            finally {
                                try {
                                    stream.close();
                                }
                                catch (Exception e) {
                                    JDTrace.logException(this, "writeToServer stream2.close()", e);
                                }
                            }
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                        }
                        break block58;
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block58;
                }
                if (object instanceof InputStream) {
                    int length = this.scale_ * 2;
                    if (length == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block58;
                    }
                    if (length > 0) {
                        InputStream stream = (InputStream)this.savedObject_;
                        int blockSize = length < 1000000 ? length : 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1 && totalBytesRead < length) {
                                this.locator_.writeData((long)totalBytesRead / 2L, byteBuffer, 0, bytesRead, true);
                                int bytesRemaining = length - (totalBytesRead += bytesRead);
                                if (bytesRemaining < blockSize) {
                                    blockSize = bytesRemaining;
                                }
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                            if (totalBytesRead < length) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block58;
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                        }
                        break block58;
                    }
                    if (length == -2) {
                        InputStream stream = (InputStream)this.savedObject_;
                        int blockSize = 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1) {
                                this.locator_.writeData((long)totalBytesRead / 2L, byteBuffer, 0, bytesRead, true);
                                totalBytesRead += bytesRead;
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                            break block58;
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                            break block58;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block58;
                }
                if (object instanceof Clob) {
                    Clob clob;
                    boolean set = false;
                    if (object instanceof AS400JDBCClobLocator) {
                        clob = (AS400JDBCClobLocator)object;
                        AS400JDBCClobLocator blockSize = clob;
                        synchronized (blockSize) {
                            if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                                this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                                this.savedObjectWrittenToServer_ = false;
                                this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                                ((AS400JDBCClobLocator)clob).savedObject_ = null;
                                this.writeToServer();
                                this.savedObjectWrittenToServer_ = false;
                                return;
                            }
                        }
                    }
                    if (!set) {
                        int blockSize;
                        clob = (Clob)object;
                        int length = (int)clob.length();
                        if (length < (blockSize = 1000000)) {
                            blockSize = length;
                        }
                        int position = 1;
                        AS400JDBCClobLocator thisClob = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
                        while (position <= length) {
                            String substring = clob.getSubString(position, blockSize);
                            thisClob.setString(position, substring);
                            if (length - (position += blockSize) >= blockSize) continue;
                            blockSize = length - position + 1;
                        }
                        set = true;
                        break block58;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block58;
                }
                if (object instanceof SQLXML) {
                    SQLXML xml = (SQLXML)object;
                    String stringVal = xml.getString();
                    byte[] outByteArray = this.converter_.stringToByteArray(stringVal);
                    this.locator_.writeData(0L, outByteArray, 0, outByteArray.length, true);
                } else {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
            finally {
                this.savedObjectWrittenToServer_ = true;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 34;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "NCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 968;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2011;
    }

    public String getTypeName() {
        return "NCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
            }
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return value;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        return value;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, this.maxLength_);
        }
        return new AS400JDBCSQLXML(this.getString());
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings settings) {
        this.settings_ = settings;
    }

    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

