/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable1208;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import com.ibm.as400.access.SQLVariableCompressible;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

abstract class SQLVarcharBase
extends SQLDataBase
implements SQLVariableCompressible {
    static final String copyright = "Copyright (C) 1997-2013 International Business Machines Corporation and others.";
    protected int length_;
    protected int maxLength_;
    protected String value_;
    protected String untruncatedValue_;
    protected int bytesPerCharacter_;
    protected int sizeAfterTruncation_ = 0;

    SQLVarcharBase(SQLConversionSettings settings, int length, int maxLength, String value) {
        super(settings);
        this.length_ = length;
        this.maxLength_ = maxLength;
        this.value_ = value;
        this.untruncatedValue_ = value;
        this.bytesPerCharacter_ = 1;
    }

    SQLVarcharBase(SQLConversionSettings settings, int length, int maxLength, String value, int bytesPerCharacter) {
        super(settings);
        this.length_ = length;
        this.maxLength_ = maxLength;
        this.value_ = value;
        this.untruncatedValue_ = value;
        this.bytesPerCharacter_ = bytesPerCharacter;
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(rawBytes, offset);
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.sizeAfterTruncation_ = this.length_ * this.bytesPerCharacter_;
            this.untruncatedValue_ = this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset + 2, this.length_ * this.bytesPerCharacter_, bidiConversionProperties);
        }
        catch (Exception e) {
            JDError.throwSQLException("22524", e);
        }
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        try {
            int bidiStringType = this.settings_.getBidiStringType();
            if (bidiStringType == -1) {
                bidiStringType = ccsidConverter.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            String value = this.value_;
            if (ccsidConverter.getCcsid() == 1208) {
                value = this.untruncatedValue_;
            }
            byte[] temp = ccsidConverter.stringToByteArray(value, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(temp.length / this.bytesPerCharacter_, rawBytes, offset);
            this.sizeAfterTruncation_ = temp.length;
            if (temp.length > this.maxLength_) {
                BinaryConverter.unsignedShortToByteArray(this.maxLength_ / this.bytesPerCharacter_, rawBytes, offset);
                this.sizeAfterTruncation_ = this.maxLength_;
                this.truncated_ = temp.length - this.maxLength_;
                System.arraycopy(temp, 0, rawBytes, offset + 2, this.maxLength_);
            } else {
                System.arraycopy(temp, 0, rawBytes, offset + 2, temp.length);
            }
            if (this.maxLength_ - temp.length > 16) {
                int stopHere = offset + 2 + this.maxLength_;
                for (int i = offset + 2 + temp.length; i < stopHere; ++i) {
                    rawBytes[i] = 0;
                }
            }
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
        int newLength;
        if ((ccsidConverter instanceof ConvTableMixedMap || ccsidConverter instanceof ConvTable1208) && (newLength = ccsidConverter.validateData(rawBytes, offset + 2, this.maxLength_)) < this.maxLength_) {
            BinaryConverter.unsignedShortToByteArray(newLength, rawBytes, offset);
            this.sizeAfterTruncation_ = newLength;
        }
    }

    public int convertToCompressedBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        int bytesWritten = 0;
        try {
            int bidiStringType = this.settings_.getBidiStringType();
            if (bidiStringType == -1) {
                bidiStringType = ccsidConverter.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            String value = this.value_;
            if (ccsidConverter.getCcsid() == 1208) {
                value = this.untruncatedValue_;
            }
            byte[] temp = ccsidConverter.stringToByteArray(value, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(temp.length / this.bytesPerCharacter_, rawBytes, offset);
            bytesWritten += 2;
            if (temp.length > this.maxLength_) {
                this.truncated_ = temp.length - this.maxLength_;
                System.arraycopy(temp, 0, rawBytes, offset + 2, this.maxLength_);
                bytesWritten += this.maxLength_;
            } else if (temp.length > 0) {
                System.arraycopy(temp, 0, rawBytes, offset + 2, temp.length);
                bytesWritten += temp.length;
            }
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        return bytesWritten;
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        int truncLimit;
        String value = null;
        if (object instanceof String) {
            value = (String)object;
        } else if (object instanceof Number) {
            value = object.toString();
        } else if (object instanceof Boolean) {
            value = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            value = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            value = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar, this.settings_);
        } else if (object instanceof Date) {
            value = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            value = object.toString();
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            value = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof Reader) {
            value = SQLVarcharBase.getStringFromReader((Reader)object, -2, this);
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            value = xml.getString();
        }
        if (value == null) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.untruncatedValue_ = this.value_ = value;
        int valueLength = this.value_.length();
        if (valueLength > (truncLimit = this.maxLength_ / this.bytesPerCharacter_)) {
            this.value_ = this.value_.substring(0, truncLimit);
            this.truncated_ = valueLength - truncLimit;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length();
    }

    public int getSQLType() {
        return 30;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "VARCHAR";
    }

    public int getMaximumPrecision() {
        return 32739;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 448;
    }

    public int getPrecision() {
        return this.maxLength_ / this.bytesPerCharacter_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 12;
    }

    public String getTypeName() {
        return "VARCHAR";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        if (this.sizeAfterTruncation_ != 0) {
            return this.sizeAfterTruncation_;
        }
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] bytes = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(bytes, bytes.length);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getString();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public String getNString() throws SQLException {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.getString());
    }

    public void saveValue() {
        this.savedValue_ = this.untruncatedValue_;
    }
}

