/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileRecordDescriptionImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SaveFileEntry;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.TimeZone;

public class SaveFile
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    public static final String CURRENT_RELEASE = "*CURRENT";
    public static final String PREVIOUS_RELEASE = "*PRV";
    public static final long NO_MAX = 0L;
    public static final int IMMED = -1;
    public static final int CLS = 0;
    public static final int DEFAULT = -99;
    private static final int EXISTENCE_UNKNOWN = 0;
    private static final int EXISTENCE_YES = 1;
    private static final int EXISTENCE_NO = 2;
    private static final String USERSPACE_NAME = "JT4USRSPC QTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4USRSPC.USRSPC";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String path_;
    private String library_;
    private String name_;
    private String targetRelease_ = "*CURRENT";
    private String saveOutput_ = "*NONE";
    private transient int systemVRM_;
    private transient boolean gotSystemVRM_;
    private transient ObjectDescription objectDescription_;
    private transient Record fileAttributes_;
    private transient String savefileNameAndLib_;
    private transient int existence_ = 0;
    private transient AS400Timestamp timestampConverter_;
    private static final int FORMAT_DTS = 1;

    public SaveFile(AS400 system, String library, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.system_ = system;
        this.library_ = library;
        this.name_ = name;
        this.path_ = QSYSObjectPathName.toPath(library, name, "FILE");
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.checkExistence();
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CLRSAVF FILE(" + this.library_ + "/" + this.name_ + ")");
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void copyTo(String library, String name) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.checkExistence();
        String targetPath = QSYSObjectPathName.toPath(library, name, "FILE");
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CPY OBJ('" + this.path_ + "') TOOBJ('" + targetPath + "') REPLACE(*YES)");
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        this.create(-99L, -99, -99, false, null, null);
    }

    public void create(long maxRecords, int asp, int waitTime, boolean shared, String authority, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        CommandCall cmd;
        if (this.exists()) {
            throw new ObjectAlreadyExistsException(this.path_, 1);
        }
        StringBuffer cmdBuf = new StringBuffer("QSYS/CRTSAVF FILE(" + this.library_ + "/" + this.name_ + ") ");
        if (maxRecords != -99L) {
            if (maxRecords == 0L) {
                cmdBuf.append("MAXRCDS(*NOMAX) ");
            } else {
                cmdBuf.append("MAXRCDS(" + maxRecords + ") ");
            }
        }
        if (asp != -99) {
            cmdBuf.append("ASP(" + asp + ") ");
        }
        switch (waitTime) {
            case -99: {
                break;
            }
            case 0: {
                cmdBuf.append("WAITFILE(*CLS) ");
                break;
            }
            case -1: {
                cmdBuf.append("WAITFILE(*IMMED) ");
                break;
            }
            default: {
                cmdBuf.append("WAITFILE(" + Integer.toString(waitTime) + ") ");
            }
        }
        if (shared) {
            cmdBuf.append("SHARE(*YES) ");
        }
        if (authority != null) {
            cmdBuf.append("AUT(" + authority + ") ");
        }
        if (description != null) {
            cmdBuf.append("TEXT('" + description + "') ");
        }
        if (!(cmd = new CommandCall(this.system_, cmdBuf.toString())).run()) {
            this.existence_ = 0;
            throw new AS400Exception(cmd.getMessageList());
        }
        this.existence_ = 1;
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        CommandCall cmd = new CommandCall(this.system_, "QSYS/DLTF FILE(" + this.library_ + "/" + this.name_ + ")");
        if (!cmd.run()) {
            this.existence_ = 0;
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                if (msgs[0].getID() != null && !msgs[0].getID().equals("CPF2105") && !msgs[0].getID().equals("CPF2110")) {
                    throw new AS400Exception(msgs);
                }
            } else {
                throw new InternalErrorException("No messages returned from failed delete.", 6);
            }
        }
        this.existence_ = 2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            SaveFile other = (SaveFile)obj;
            if (!this.system_.equals(other.getSystem())) {
                return false;
            }
            if (!this.library_.equals(other.getLibrary())) {
                return false;
            }
            return this.name_.equals(other.getName());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return this.system_.hashCode() + this.library_.hashCode() + this.name_.hashCode();
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        this.existence_ = this.objectDescription_.exists() ? 1 : 2;
        return this.existence_ == 1;
    }

    public int getASP() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal decVal = (BigDecimal)this.fileAttributes_.getField("SAASP");
        int value = decVal.intValue();
        return value;
    }

    public long getCurrentNumberOfRecords() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        BigDecimal decVal;
        long value;
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        if ((value = (decVal = (BigDecimal)this.fileAttributes_.getField("SACNRC")).longValue()) == 99999L) {
            decVal = (BigDecimal)this.fileAttributes_.getField("SACNR2");
            value = decVal.longValue();
        }
        return value;
    }

    public String getDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        return (String)this.objectDescription_.getValue(203);
    }

    public long getLength() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        long value = (Long)this.objectDescription_.getValue(701);
        return value;
    }

    public String getLibrary() {
        return this.library_;
    }

    public long getMaximumNumberOfRecords() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal decVal = (BigDecimal)this.fileAttributes_.getField("SASIZE");
        return decVal.longValue();
    }

    public String getName() {
        return this.name_;
    }

    public ObjectDescription getObjectDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        return this.objectDescription_;
    }

    public String getPath() {
        return this.path_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getTargetRelease() {
        return this.targetRelease_;
    }

    private synchronized AS400Timestamp getTimestampConverter(int format) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(format);
        } else if (format != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(format);
        }
        return this.timestampConverter_;
    }

    public int getWaitTime() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal val = (BigDecimal)this.fileAttributes_.getField("SAWAIT");
        return val.intValue();
    }

    public boolean isSaveOutput() {
        return this.saveOutput_.equals("*PRINT");
    }

    public boolean isShared() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String val;
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        return (val = (String)this.fileAttributes_.getField("SASHAR")).equals("Y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveFileEntry[] listEntries() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this.checkExistence();
        int systemCCSID = this.system_.getCcsid();
        CharConverter conv = new CharConverter(systemCCSID);
        AS400Text text36 = new AS400Text(36, systemCCSID);
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME)), new ProgramParameter(conv.stringToByteArray("SAVF0200")), new ProgramParameter(conv.stringToByteArray(this.getNameAndLib())), new ProgramParameter(conv.stringToByteArray("*ALL      ")), new ProgramParameter(conv.stringToByteArray("*ALL      ")), new ProgramParameter(text36.toBytes(" ")), errorCode_};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSRLSAVF.PGM", parms);
        boolean willRunProgramsOnThread = pc.isStayOnThread();
        Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        byte[] buf = null;
        Object object = lockObject;
        synchronized (object) {
            UserSpace space = new UserSpace(this.system_, USERSPACE_PATH);
            space.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                space.setMustUseSockets(true);
            }
            try {
                space.create(262144, true, "", (byte)0, "User space for SaveFile", "*EXCLUDE");
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                int size = space.getLength();
                buf = new byte[size];
                space.read(buf, 0);
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    space.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
                throw throwable;
            }
            try {
                space.delete();
            }
            catch (Exception e) {
                Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
            }
        }
        int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
        int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
        int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
        int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
        if (entryCCSID == 0) {
            entryCCSID = systemCCSID;
        }
        conv = new CharConverter(entryCCSID);
        byte[] saveDateTimeBytes = new byte[8];
        SaveFileEntry[] entries = new SaveFileEntry[numEntries];
        int offset = 0;
        for (int i = 0; i < numEntries; ++i) {
            offset = startingOffset + i * entrySize;
            String objName = conv.byteArrayToString(buf, offset, 10).trim();
            String libSaved = conv.byteArrayToString(buf, offset += 10, 10).trim();
            String objType = conv.byteArrayToString(buf, offset += 10, 10).trim();
            String extObjAttr = conv.byteArrayToString(buf, offset += 10, 10).trim();
            System.arraycopy(buf, offset += 10, saveDateTimeBytes, 0, 8);
            Date saveDateTime = this.getAsSystemDate(saveDateTimeBytes);
            int objSize = BinaryConverter.byteArrayToInt(buf, offset += 8);
            int objSizeMult = BinaryConverter.byteArrayToInt(buf, offset += 4);
            int asp = BinaryConverter.byteArrayToInt(buf, offset += 4);
            String dataSaved = conv.byteArrayToString(buf, offset += 4, 1);
            String objOwner = conv.byteArrayToString(buf, ++offset, 10).trim();
            String dloName = conv.byteArrayToString(buf, offset += 10, 20).trim();
            String folder = conv.byteArrayToString(buf, offset += 20, 63).trim();
            String desc = conv.byteArrayToString(buf, offset += 63, 50).trim();
            String aspDevName = this.getSystemVRM() >= 328192 ? conv.byteArrayToString(buf, offset += 50, 10).trim() : "";
            entries[i] = new SaveFileEntry(objName, libSaved, objType, extObjAttr, saveDateTime, objSize, objSizeMult, asp, dataSaved, objOwner, dloName, folder, desc, aspDevName);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Product[] listProducts() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        int systemCCSID = this.system_.getCcsid();
        CharConverter conv = new CharConverter(systemCCSID);
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME)), new ProgramParameter(conv.stringToByteArray("PRDL0100")), new ProgramParameter(conv.stringToByteArray(this.getNameAndLib())), errorCode_};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QLPLPRDS.PGM", parms);
        boolean willRunProgramsOnThread = pc.isStayOnThread();
        Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        byte[] buf = null;
        String string = USERSPACE_NAME;
        synchronized (USERSPACE_NAME) {
            block15: {
                UserSpace space = new UserSpace(this.system_, USERSPACE_PATH);
                space.setMustUseProgramCall(true);
                if (!willRunProgramsOnThread) {
                    space.setMustUseSockets(true);
                }
                space.create(262144, true, "", (byte)0, "User space for SaveFile", "*EXCLUDE");
                if (pc.run()) break block13;
                AS400Message[] messageList = pc.getMessageList();
                String id = messageList[0].getID();
                if (!id.equalsIgnoreCase("CPF3D94")) break block14;
                if (Trace.isTraceOn()) {
                    Trace.log(3, "No product found in save file");
                }
                Product[] productArray = new Product[]{};
                Object var14_18 = null;
                try {
                    space.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
                {
                    block13: {
                        block14: {
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            return productArray;
                        }
                        throw new AS400Exception(messageList);
                    }
                    int size = space.getLength();
                    buf = new byte[size];
                    space.read(buf, 0);
                }
                Object var14_19 = null;
                try {
                    space.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
                break block15;
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    try {
                        space.delete();
                    }
                    catch (Exception e) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                    }
                    throw throwable;
                }
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
            int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
            int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
            int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
            if (entryCCSID == 0) {
                entryCCSID = systemCCSID;
            }
            conv = new CharConverter(entryCCSID);
            Product[] entries = new Product[numEntries];
            int offset = 0;
            for (int i = 0; i < numEntries; ++i) {
                offset = startingOffset + i * entrySize;
                String prodID = conv.byteArrayToString(buf, offset, 7).trim();
                String releaseLevel = conv.byteArrayToString(buf, offset += 7, 6).trim();
                String prodOption = conv.byteArrayToString(buf, offset += 6, 4).trim();
                String loadType = conv.byteArrayToString(buf, offset += 4, 10).trim();
                String langID = conv.byteArrayToString(buf, offset += 10, 4).trim();
                entries[i] = new Product(this.system_, prodID, prodOption, releaseLevel, loadType, langID);
            }
            return entries;
        }
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.existence_ = 0;
        this.objectDescription_ = this.checkExistence();
        this.fileAttributes_ = this.getFileAttributes();
    }

    public void renameTo(String name) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.checkExistence();
        CommandCall cmd = new CommandCall(this.system_, "QSYS/RNM OBJ('" + this.path_ + "') NEWOBJ(" + name + ".FILE)");
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.name_ = name;
        this.path_ = QSYSObjectPathName.toPath(this.library_, this.name_, "FILE");
        this.fileAttributes_ = null;
        this.objectDescription_ = null;
    }

    public void restore(String libraryName) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (libraryName == null) {
            throw new NullPointerException("libraryName");
        }
        this.checkExistence();
        String cmdString = "QSYS/RSTLIB SAVLIB(" + libraryName + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void restore(String libraryName, String[] objectList, String toLibraryName) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (libraryName == null) {
            throw new NullPointerException("libraryName");
        }
        if (objectList == null) {
            throw new NullPointerException("objectList");
        }
        this.checkExistence();
        StringBuffer objects = new StringBuffer();
        for (int i = 0; i < objectList.length; ++i) {
            objects.append(objectList[i] + " ");
        }
        StringBuffer cmdBuf = new StringBuffer("QSYS/RSTOBJ OBJ(" + objects.toString() + ") " + "SAVLIB(" + libraryName + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OUTPUT(" + this.saveOutput_ + ") ");
        if (toLibraryName != null) {
            cmdBuf.append("RSTLIB(" + toLibraryName + ") ");
        }
        CommandCall cmd = new CommandCall(this.system_);
        try {
            if (cmd.run(cmdBuf.toString())) {
                return;
            }
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs[0].getID().equals("CPF3781")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Attempting to create library " + libraryName);
                }
                if (!cmd.run("QSYS/CRTLIB LIB(" + (toLibraryName == null ? libraryName : toLibraryName) + ")")) {
                    Trace.log(2, new AS400Exception(cmd.getMessageList()));
                }
                if (cmd.run(cmdBuf.toString())) {
                    return;
                }
            }
            throw new AS400Exception(cmd.getMessageList());
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            return;
        }
    }

    public void restore(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd;
        if (product == null) {
            throw new NullPointerException("product");
        }
        this.checkExistence();
        StringBuffer cmdBuf = new StringBuffer("QSYS/RSTLICPGM LICPGM(" + product.getProductID() + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OPTION(" + SaveFile.getProductOption(product) + ") " + "RSTOBJ(" + SaveFile.getObjectType(product) + ") " + "RLS(" + product.getReleaseLevel() + ") " + "OUTPUT(" + this.saveOutput_ + ") ");
        String lang = product.getPrimaryLanguageFeatureID();
        if (lang != null && lang.length() != 0) {
            cmdBuf.append("LNG(" + lang + ") ");
        }
        if (!(cmd = new CommandCall(this.system_, cmdBuf.toString())).run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void save(String libraryName) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (libraryName == null) {
            throw new NullPointerException("libraryName");
        }
        this.checkExistence();
        String cmdString = "QSYS/SAVLIB LIB(" + libraryName + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void save(String libraryName, String[] objectList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (libraryName == null) {
            throw new NullPointerException("libraryName");
        }
        if (objectList == null) {
            throw new NullPointerException("objectList");
        }
        this.checkExistence();
        StringBuffer objects = new StringBuffer();
        for (int i = 0; i < objectList.length; ++i) {
            objects.append(objectList[i] + " ");
        }
        String cmdString = "QSYS/SAVOBJ OBJ(" + objects.toString() + ") " + "LIB(" + libraryName + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void save(String[] pathList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (pathList == null) {
            throw new NullPointerException("pathList");
        }
        this.checkExistence();
        StringBuffer paths = new StringBuffer();
        for (int i = 0; i < pathList.length; ++i) {
            paths.append("('" + pathList[i] + "') ");
        }
        String cmdString = "QSYS/SAV DEV('" + this.path_ + "') " + "OBJ(" + paths.toString() + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void save(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd;
        if (product == null) {
            throw new NullPointerException("product");
        }
        this.checkExistence();
        StringBuffer cmdBuf = new StringBuffer("QSYS/SAVLICPGM LICPGM(" + product.getProductID() + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OPTION(" + SaveFile.getProductOption(product) + ") " + "RLS(" + product.getReleaseLevel() + ") " + "OBJTYPE(" + SaveFile.getObjectType(product) + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) ");
        String lang = product.getPrimaryLanguageFeatureID();
        if (lang != null && lang.length() != 0) {
            cmdBuf.append("LNG(" + lang + ") ");
        }
        if (!(cmd = new CommandCall(this.system_, cmdBuf.toString())).run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void setDescription(String description) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (description == null) {
            throw new NullPointerException("description");
        }
        this.objectDescription_ = this.checkExistence();
        String cmdString = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") TEXT('" + description + "') ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.objectDescription_ = null;
    }

    public void setMaximumNumberOfRecords(long maximumNumberOfRecords) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        String value = maximumNumberOfRecords == 0L ? "*NOMAX" : Long.toString(maximumNumberOfRecords);
        String cmdString = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") MAXRCDS(" + value + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void setSaveOutput(boolean save) {
        this.saveOutput_ = save ? "*PRINT" : "*NONE";
    }

    public void setShared(boolean shared) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        String value = shared ? "*YES" : "*NO";
        String cmdString = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") SHARE(" + value + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void setTargetRelease(String targetRelease) {
        if (targetRelease == null) {
            throw new NullPointerException("targetRelease");
        }
        this.targetRelease_ = targetRelease;
    }

    public void setWaitTime(int seconds) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String value;
        this.checkExistence();
        switch (seconds) {
            case -99: 
            case -1: {
                value = "*IMMED";
                break;
            }
            case 0: {
                value = "*CLS";
                break;
            }
            default: {
                value = Integer.toString(seconds);
            }
        }
        String cmdString = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") WAITFILE(" + value + ") ";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public String toString() {
        return "SaveFile (system: " + this.system_.getSystemName() + "; path: " + this.path_ + "): " + super.toString();
    }

    private String getNameAndLib() {
        if (this.savefileNameAndLib_ == null) {
            StringBuffer buff = new StringBuffer("                    ");
            buff.replace(0, this.name_.length(), this.name_);
            buff.replace(10, 10 + this.library_.length(), this.library_);
            this.savefileNameAndLib_ = buff.toString();
        }
        return this.savefileNameAndLib_;
    }

    private Date getAsSystemDate(byte[] data) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        AS400Timestamp conv = this.getTimestampConverter(1);
        return conv.toDate(conv.toTimestamp(data), TimeZone.getDefault());
    }

    private Record getFileAttributes() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400FileRecordDescriptionImplRemote recDesc = new AS400FileRecordDescriptionImplRemote();
        recDesc.setSystem(this.system_.getImpl());
        recDesc.setPath(this.path_);
        return recDesc.getSavefileAttributes();
    }

    private int getSystemVRM() throws AS400SecurityException, IOException {
        if (!this.gotSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.gotSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "FILE");
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing SaveFile object.");
        }
        in.defaultReadObject();
    }

    private ObjectDescription checkExistence() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.existence_ == 1 && this.objectDescription_ != null) {
            return this.objectDescription_;
        }
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        if (this.objectDescription_.exists()) {
            return this.objectDescription_;
        }
        throw new ObjectDoesNotExistException(this.path_, 2);
    }

    private static String getObjectType(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String type = product.getLoadType();
        if (type == null || type.length() == 0) {
            type = "*ALL";
        } else if (type.equals("*CODE")) {
            type = "*PGM";
        } else if (type.equals("*LNG")) {
            type = "*LNG";
        } else {
            Trace.log(2, "Unrecognized load type in Product: " + type);
            type = "*ALL";
        }
        return type;
    }

    private static String getProductOption(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String option = product.getProductOption();
        if (option == null) {
            Trace.log(2, "Product.getProductOption() returned null.");
            return "";
        }
        for (int i = 0; i < option.length(); ++i) {
            if (option.charAt(i) == '0') continue;
            return option.substring(i);
        }
        return "0";
    }
}

