/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class SignonExchangeAttributeRep
extends ClientAccessDataStream {
    SignonExchangeAttributeRep() {
    }

    public Object getNewDataStream() {
        return new SignonExchangeAttributeRep();
    }

    int getRC() {
        return this.get32bit(20);
    }

    int getServerVersion() {
        return this.get32bit(30);
    }

    int getServerLevel() {
        return this.get16bit(40);
    }

    byte[] getServerSeed() {
        int offset = this.findCP(4355);
        if (offset == -1) {
            return null;
        }
        byte[] seed = new byte[8];
        System.arraycopy(this.data_, offset + 6, seed, 0, 8);
        return seed;
    }

    int getPasswordLevel() {
        int offset = this.findCP(4377);
        if (offset == -1) {
            return 0;
        }
        return this.data_[offset + 6];
    }

    byte[] getJobNameBytes() {
        int offset = this.findCP(4383);
        if (offset == -1) {
            return new byte[0];
        }
        byte[] jobNameBytes = new byte[this.get32bit(offset) - 10];
        System.arraycopy(this.data_, offset + 10, jobNameBytes, 0, jobNameBytes.length);
        return jobNameBytes;
    }

    int findCP(int cp) {
        for (int offset = 42; offset < this.data_.length - 1; offset += this.get32bit(offset)) {
            if (this.get16bit(offset + 4) != cp) continue;
            return offset;
        }
        return -1;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving signon server exchange client/server attributes reply...");
        }
        if (this.readFromStream(in, header = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the signon server exchange client/server attributes reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 20);
        this.readAfterHeader(in);
    }

    public int hashCode() {
        return 61443;
    }
}

