/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.Calendar;
import java.util.Date;

public class SpooledFileListItem {
    public static final String ASSIGNED_SPECIFIC = "1";
    public static final String ASSIGNED_MULTIPLE = "2";
    public static final String ASSIGNED_NONE = "3";
    public static final String DEVICE_TYPE_DISKETTE = "DISKETTE";
    public static final String DEVICE_TYPE_PRINTER = "PRINTER";
    public static final String SCHEDULE_IMMEDIATE = "1";
    public static final String SCHEDULE_FILE_END = "2";
    public static final String SCHEDULE_JOB_END = "3";
    public static final String STATUS_READY = "*READY";
    public static final String STATUS_OPEN = "*OPEN";
    public static final String STATUS_CLOSED = "*CLOSED";
    public static final String STATUS_SAVED = "*SAVED";
    public static final String STATUS_WRITING = "*WRITING";
    public static final String STATUS_HELD = "*HELD";
    public static final String STATUS_MESSAGE_WAIT = "*MESSAGE";
    public static final String STATUS_PENDING = "*PENDING";
    public static final String STATUS_PRINTING = "*PRINTER";
    public static final String STATUS_FINISHED = "*FINISHED";
    public static final String STATUS_SENDING = "*SENDING";
    public static final String STATUS_DEFERRED = "*DEFERRED";
    private String jobName_;
    private String jobUser_;
    private String jobNumber_;
    private String name_;
    private int number_;
    private String status_;
    private String dateOpened_;
    private String timeOpened_;
    private String schedule_;
    private String jobSystemName_;
    private String userData_;
    private String formType_;
    private String outputQueueName_;
    private String outputQueueLibrary_;
    private int asp_;
    private int size_;
    private int sizeMultiplier_;
    private int totalPages_;
    private int copiesLeftToPrint_;
    private String priority_;
    private int ippJobIdentifier_;
    private byte[] internalJobIdentifier_;
    private byte[] internalSpooledFileIdentifier_;
    private int currentPage_;
    private String deviceType_;
    private String printerAssignment_;
    private String printerName_;
    private String format_;

    SpooledFileListItem(String name, String jobName, String jobUser, String jobNumber, int number, int totalPages, int currentPage, int copiesLeftToPrint, String outputQueueName, String outputQueueLibrary, String userData, String status, String formType, String priority, byte[] internalJobIdentifier, byte[] internalSpooledFileIdentifier, String deviceType, String jobSystemName, String dateOpened, String timeOpened) {
        this.name_ = name;
        this.jobName_ = jobName;
        this.jobUser_ = jobUser;
        this.jobNumber_ = jobNumber;
        this.number_ = number;
        this.totalPages_ = totalPages;
        this.currentPage_ = currentPage;
        this.copiesLeftToPrint_ = copiesLeftToPrint;
        this.outputQueueName_ = outputQueueName;
        this.outputQueueLibrary_ = outputQueueLibrary;
        this.userData_ = userData;
        this.status_ = status;
        this.formType_ = formType;
        this.priority_ = priority;
        this.internalJobIdentifier_ = internalJobIdentifier;
        this.internalSpooledFileIdentifier_ = internalSpooledFileIdentifier;
        this.deviceType_ = deviceType;
        this.jobSystemName_ = jobSystemName;
        this.dateOpened_ = dateOpened;
        this.timeOpened_ = timeOpened;
        this.format_ = "OSPL0100";
    }

    SpooledFileListItem(String name, String jobName, String jobUser, String jobNumber, int number, int totalPages, int currentPage, int copiesLeftToPrint, String outputQueueName, String outputQueueLibrary, String userData, String status, String formType, String priority, byte[] internalJobIdentifier, byte[] internalSpooledFileIdentifier, String deviceType, String jobSystemName, String dateOpened, String timeOpened, String printerAssignment, String printerName) {
        this(name, jobName, jobUser, jobNumber, number, totalPages, currentPage, copiesLeftToPrint, outputQueueName, outputQueueLibrary, userData, status, formType, priority, internalJobIdentifier, internalSpooledFileIdentifier, deviceType, jobSystemName, dateOpened, timeOpened);
        this.printerAssignment_ = printerAssignment;
        this.printerName_ = printerName;
        this.format_ = "OSPL0200";
    }

    SpooledFileListItem(String jobName, String jobUser, String jobNumber, String name, int number, int status, String dateOpened, String timeOpened, String schedule, String jobSystemName, String userData, String formType, String outputQueueName, String outputQueueLibrary, int asp, int size, int sizeMultiplier, int totalPages, int copiesLeftToPrint, String priority, int ippJobIdentifier) {
        this.jobName_ = jobName;
        this.jobUser_ = jobUser;
        this.jobNumber_ = jobNumber;
        this.name_ = name;
        this.number_ = number;
        this.status_ = SpooledFileListItem.mapStatus(status);
        this.dateOpened_ = dateOpened;
        this.timeOpened_ = timeOpened;
        this.schedule_ = schedule;
        this.jobSystemName_ = jobSystemName;
        this.userData_ = userData;
        this.formType_ = formType;
        this.outputQueueName_ = outputQueueName;
        this.outputQueueLibrary_ = outputQueueLibrary;
        this.asp_ = asp;
        this.size_ = size;
        this.sizeMultiplier_ = sizeMultiplier;
        this.totalPages_ = totalPages;
        this.copiesLeftToPrint_ = copiesLeftToPrint;
        this.priority_ = priority;
        this.ippJobIdentifier_ = ippJobIdentifier;
        this.format_ = "OSPL0300";
    }

    public int getASP() {
        return this.asp_;
    }

    public int getCopiesLeftToPrint() {
        return this.copiesLeftToPrint_;
    }

    public Date getCreationDate() {
        if (this.dateOpened_ == null) {
            return null;
        }
        Calendar c = AS400Calendar.getGregorianInstance();
        c.clear();
        c.set(Integer.parseInt(this.dateOpened_.substring(0, 3)) + 1900, Integer.parseInt(this.dateOpened_.substring(3, 5)) - 1, Integer.parseInt(this.dateOpened_.substring(5, 7)), Integer.parseInt(this.timeOpened_.substring(0, 2)), Integer.parseInt(this.timeOpened_.substring(2, 4)), Integer.parseInt(this.timeOpened_.substring(4, 6)));
        return c.getTime();
    }

    public int getCurrentPage() {
        return this.currentPage_;
    }

    public String getDateOpened() {
        return this.dateOpened_;
    }

    public String getDeviceType() {
        if (this.deviceType_ == null) {
            return null;
        }
        if (this.deviceType_.equals(DEVICE_TYPE_PRINTER)) {
            return DEVICE_TYPE_PRINTER;
        }
        if (this.deviceType_.equals(DEVICE_TYPE_DISKETTE)) {
            return DEVICE_TYPE_DISKETTE;
        }
        return this.deviceType_;
    }

    public String getFormat() {
        return this.format_;
    }

    public String getFormType() {
        return this.formType_;
    }

    public byte[] getInternalJobIdentifier() {
        return this.internalJobIdentifier_;
    }

    public byte[] getInternalSpooledFileIdentifier() {
        return this.internalSpooledFileIdentifier_;
    }

    public int getIPPJobIdentifier() {
        return this.ippJobIdentifier_;
    }

    public String getJobName() {
        return this.jobName_;
    }

    public String getJobNumber() {
        return this.jobNumber_;
    }

    public String getJobSystemName() {
        return this.jobSystemName_;
    }

    public String getJobUser() {
        return this.jobUser_;
    }

    public String getName() {
        return this.name_;
    }

    public int getNumber() {
        return this.number_;
    }

    public String getOutputQueue() {
        return QSYSObjectPathName.toPath(this.outputQueueLibrary_, this.outputQueueName_, "OUTQ");
    }

    public String getOutputQueueLibrary() {
        return this.outputQueueLibrary_;
    }

    public String getOutputQueueName() {
        return this.outputQueueName_;
    }

    public String getPrinterAssignment() {
        if (this.printerAssignment_ == null) {
            return null;
        }
        if (this.printerAssignment_.equals("1")) {
            return "1";
        }
        if (this.printerAssignment_.equals("2")) {
            return "2";
        }
        if (this.printerAssignment_.equals("3")) {
            return "3";
        }
        return this.printerAssignment_;
    }

    public String getPrinterName() {
        return this.printerName_;
    }

    public String getPriority() {
        return this.priority_;
    }

    public String getSchedule() {
        if (this.schedule_ == null) {
            return null;
        }
        if (this.schedule_.equals("1")) {
            return "1";
        }
        if (this.schedule_.equals("2")) {
            return "2";
        }
        if (this.schedule_.equals("3")) {
            return "3";
        }
        return this.schedule_;
    }

    public long getSize() {
        if (this.sizeMultiplier_ > 0) {
            return (long)this.size_ * (long)this.sizeMultiplier_;
        }
        return this.size_;
    }

    public String getStatus() {
        if (this.status_ == null) {
            return null;
        }
        if (this.status_.equals(STATUS_READY)) {
            return STATUS_READY;
        }
        if (this.status_.equals(STATUS_OPEN)) {
            return STATUS_OPEN;
        }
        if (this.status_.equals(STATUS_CLOSED)) {
            return STATUS_CLOSED;
        }
        if (this.status_.equals(STATUS_SAVED)) {
            return STATUS_SAVED;
        }
        if (this.status_.equals(STATUS_WRITING)) {
            return STATUS_WRITING;
        }
        if (this.status_.equals(STATUS_HELD)) {
            return STATUS_HELD;
        }
        if (this.status_.equals(STATUS_MESSAGE_WAIT)) {
            return STATUS_MESSAGE_WAIT;
        }
        if (this.status_.equals(STATUS_PENDING)) {
            return STATUS_PENDING;
        }
        if (this.status_.equals(STATUS_PRINTING)) {
            return STATUS_PRINTING;
        }
        if (this.status_.equals(STATUS_FINISHED)) {
            return STATUS_FINISHED;
        }
        if (this.status_.equals(STATUS_SENDING)) {
            return STATUS_SENDING;
        }
        if (this.status_.equals(STATUS_DEFERRED)) {
            return STATUS_DEFERRED;
        }
        return this.status_;
    }

    public String getTimeOpened() {
        return this.timeOpened_;
    }

    public int getTotalPages() {
        return this.totalPages_;
    }

    public String getUserData() {
        return this.userData_;
    }

    private static final String mapStatus(int status) {
        switch (status) {
            case 1: {
                return STATUS_READY;
            }
            case 2: {
                return STATUS_OPEN;
            }
            case 3: {
                return STATUS_CLOSED;
            }
            case 4: {
                return STATUS_SAVED;
            }
            case 5: {
                return STATUS_WRITING;
            }
            case 6: {
                return STATUS_HELD;
            }
            case 7: {
                return STATUS_MESSAGE_WAIT;
            }
            case 8: {
                return STATUS_PENDING;
            }
            case 9: {
                return STATUS_PRINTING;
            }
            case 10: {
                return STATUS_FINISHED;
            }
            case 11: {
                return STATUS_SENDING;
            }
            case 12: {
                return STATUS_DEFERRED;
            }
        }
        return "";
    }
}

